/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PluginConfigConsistencyValidator;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.impl.AdapterSelectorManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.AuthnAdapterInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AssertionAttributeContract;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class CreateAdapterContractState
extends CreateAttributeContractState {
    private static final long serialVersionUID = 20050515L;
    private ConfigurablePluginInstance adapterInstance;
    private AttributeContract parentContract = null;
    private boolean isInheritingContract = false;
    private String oldParentId = null;
    private boolean isDisplayingForFirstTime = true;

    public CreateAdapterContractState(Tasklet value) {
        super(value);
        this.setMenuName("Extended Contract");
        this.contract = null;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.isInheritingContract) {
            this.revertMutableAttributes();
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        PluginConfigConsistencyValidator consistencyValidator = new PluginConfigConsistencyValidator(this.getSelectedDescriptor().getGuiConfigDescriptor().getValidationChain(), this.getParent(PluginInstanceTasklet.class).getConfiguration(), "");
        consistencyValidator.validate();
        List<String> consistencyErrors = this.getErrorMsgs(consistencyValidator.getErrors());
        errorMessages.addAll(consistencyErrors);
        if (!errorMessages.isEmpty()) {
            for (String errorMessage : errorMessages) {
                delegate.setFormComponent(null);
                delegate.record(errorMessage, ValidationConstraint.CONSISTENCY);
            }
        }
    }

    private PluginDescriptor getSelectedDescriptor() {
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        return parentTasklet.getSelectedDescriptor();
    }

    protected List<String> getErrorMsgs(List<ValidationError> errors) {
        ArrayList<String> result = new ArrayList<String>();
        for (ValidationError error : errors) {
            result.add(error.getMessage());
        }
        return result;
    }

    @Override
    public String getHelpId() {
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        if (parentTasklet instanceof AdapterSelectorManagementTasklet) {
            return this.getTaskletStateId() + "_" + parentTasklet.getSelectedDescriptor().getPluginClassName();
        }
        return super.getHelpId();
    }

    @Override
    public void onStateActivated() {
        boolean addingParent;
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        boolean hasParent = this.hasParentInstance();
        String parentId = this.getParentInstanceId();
        boolean removingParent = !hasParent && this.oldParentId != null;
        boolean bl = addingParent = hasParent && this.oldParentId == null;
        if (hasParent) {
            this.initParentContract(parentId);
        }
        if (removingParent || hasParent) {
            if (removingParent) {
                this.parentContract = null;
                this.isInheritingContract = false;
            } else if (addingParent) {
                if (parentTasklet.isNewTasklet() && this.isDisplayingForFirstTime) {
                    this.isInheritingContract = true;
                    this.isDisplayingForFirstTime = false;
                } else {
                    this.isInheritingContract = false;
                }
            } else if (this.isInheritingContract) {
                this.revertMutableAttributes();
            }
        }
        this.oldParentId = parentId;
        if (this.contract == null) {
            Set<String> immutableAttrs = this.getImmutableAttrs(parentTasklet.getSelectedDescriptor());
            this.contract = new AssertionAttributeContract();
            this.contract.setImmutableAttributeNames(immutableAttrs);
            this.revertMutableAttributes();
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.setComponentState(null);
        this.adapterInstance = (ConfigurablePluginInstance)dataFromDisk;
        if (this.adapterInstance != null) {
            this.oldParentId = this.adapterInstance.getParentId();
            PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
            PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
            AttributeContract ac = this.getInstanceAttributeContract(this.adapterInstance);
            this.contract = new AssertionAttributeContract();
            this.contract.setImmutableAttributeNames(new HashSet(ac.getImmutableAttributeNames()));
            Set extendedContractAttribs = ac.getMutableAttributeNames();
            if (extendedContractAttribs != null) {
                this.contract.setMutableAttributeNames(extendedContractAttribs);
            }
            this.isInheritingContract = this.isInheritingExtAttrs(this.adapterInstance);
            if (this.isInheritingContract && this.adapterInstance instanceof IdpConfigurablePluginInstance) {
                this.isInheritingContract = ((IdpConfigurablePluginInstance)this.adapterInstance).isInheritingAttributeSettings();
            }
        }
    }

    private void initParentContract(String parentId) {
        PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
        PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
        ConfigurablePluginInstance instance = pluginMgr.getInstance(parentId);
        Set<String> immutableAttrs = this.getImmutableAttrs(instance.getDescriptor());
        this.parentContract = ConfigurationUtil.findEffectiveAttributeContract((ConfigurablePluginInstance)instance, immutableAttrs, pluginMgr, (ConfigurationUtil.ExtendedAttributesReader)this.createExtendedAttrsReader());
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConfigurablePluginInstance tempAdapterInstance = (ConfigurablePluginInstance)dataToDisk;
        this.saveInheritingExtAttrs(tempAdapterInstance, this.isInheritingContract);
        if (this.isInheritingContract) {
            this.saveExtendedContractAttrs(tempAdapterInstance, null);
        } else {
            HashSet<String> tempExtendedAttributes = new HashSet<String>();
            for (String item : this.contract.getMutableAttributeNames()) {
                tempExtendedAttributes.add(item);
            }
            this.saveExtendedContractAttrs(tempAdapterInstance, tempExtendedAttributes);
        }
        return true;
    }

    @Override
    public void reset() {
        this.adapterInstance = null;
        this.contract = new AssertionAttributeContract();
    }

    @Override
    public Boolean isIncludeAttributeNameFormat() {
        return false;
    }

    @Override
    public Boolean isIncludeSubjectNameFormat() {
        return false;
    }

    public boolean hasParentInstance() {
        return this.getParent(PluginInstanceApi.class).getParentPluginInstanceId() != null;
    }

    public String getParentInstanceId() {
        return this.getParent(PluginInstanceApi.class).getParentPluginInstanceId();
    }

    public boolean isInheritingContract() {
        return this.isInheritingContract;
    }

    public void setInheritingContract(boolean isInheritingContract) {
        PluginInstanceTasklet tasklet;
        this.isInheritingContract = isInheritingContract;
        if (this.hasParentInstance() && isInheritingContract) {
            this.revertMutableAttributes();
        }
        if ((tasklet = this.getParent(PluginInstanceTasklet.class)) instanceof AuthnAdapterInstanceTasklet) {
            ((AuthnAdapterInstanceTasklet)tasklet).setOverrideAttributeSettings(!isInheritingContract);
        } else if (tasklet.usingTokenProcessors()) {
            tasklet.setOverrideAttributeMaskSettings(!isInheritingContract);
        }
    }

    public AttributeContract getParentContract() {
        return this.parentContract;
    }

    private void revertMutableAttributes() {
        this.contract.getMutableAttributeNames().clear();
        if (this.hasParentInstance()) {
            this.initParentContract(this.getParentInstanceId());
        }
        if (this.parentContract != null) {
            for (String attrName : this.parentContract.getMutableAttributeNames()) {
                this.contract.addMutableAttributeName(attrName);
            }
        }
    }

    protected boolean isInheritingExtAttrs(ConfigurablePluginInstance instance) {
        return instance.isInheritingExtendedContractAttributes();
    }

    protected Set<String> getImmutableAttrs(PluginDescriptor pd) {
        return pd.getAttributeContractSet();
    }

    protected ConfigurationUtil.ExtendedAttributesReader createExtendedAttrsReader() {
        return new ConfigurationUtil.ExtendedAttributesReader();
    }

    protected void saveExtendedContractAttrs(ConfigurablePluginInstance instance, Set<String> extAttributes) {
        instance.setExtendedContractAttributes(extAttributes);
    }

    protected void saveInheritingExtAttrs(ConfigurablePluginInstance instance, boolean isInherit) {
        instance.setInheritingExtendedContractAttributes(isInherit);
    }

    protected AttributeContract getInstanceAttributeContract(ConfigurablePluginInstance instance) {
        return instance.getAttributeContract();
    }
}

