/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.DSignRotationSettingsValidator;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.KeyAlgorithmInfo;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.pingcommons.crypto.JavaAlgorithmNames;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DSignRotationState
extends TaskletState {
    private String validityPeriodDays;
    private String keySize;
    private String signatureAlgorithm;
    private String creationBufferDays;
    private String activationBufferDays;
    private Cert originalCert;
    private String keyAlgorithm;
    private StringPairPropertySelectionModel keyAlgList;
    private StringPairPropertySelectionModel keySizeList;
    private StringPairPropertySelectionModel signatureAlgorithmList;
    private boolean keyAlgorithmChanged = false;
    private boolean enableCertRotation = false;
    private String pendingCertAlias = null;
    private static final DSignRotationSettingsManager rotationManger = MgmtFactory.getDSignRotationSettingsManager();
    private static final CertificateService certService = (CertificateService)GlobalRegistry.getService(CertificateService.class);
    private static final long serialVersionUID = 1L;

    public DSignRotationState(Tasklet value) {
        super(value);
        this.setMenuName("Certificate Rotation");
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlg) {
        if (!Objects.equals(this.keyAlgorithm, keyAlg)) {
            this.keyAlgorithmChanged = true;
            this.keyAlgorithm = keyAlg;
        }
    }

    public String getValidityPeriodDays() {
        return this.validityPeriodDays;
    }

    public Cert getOriginalCert() {
        return this.originalCert;
    }

    public void setOriginalCert(Cert originalCert) {
        this.originalCert = originalCert;
    }

    public String getKeySize() {
        return this.keySize;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getCreationBufferDays() {
        return this.creationBufferDays;
    }

    public String getActivationBufferDays() {
        return this.activationBufferDays;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public void setValidityPeriodDays(String validityPeriodDays) {
        this.validityPeriodDays = validityPeriodDays;
    }

    public void setKeySize(String keySize) {
        this.keySize = keySize;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public void setCreationBufferDays(String generationBufferMins) {
        this.creationBufferDays = generationBufferMins;
    }

    public void setActivationBufferDays(String activationBufferMins) {
        this.activationBufferDays = activationBufferMins;
    }

    @Override
    public void onStateActivated() {
        Collection availableAlgorithms = certService.getAvailableKeyAlgorithms();
        if (!availableAlgorithms.isEmpty()) {
            if (StringUtils.isEmpty((String)this.activationBufferDays) && StringUtils.isEmpty((String)this.creationBufferDays) && this.originalCert != null) {
                this.initializeDefaultValues();
            }
            if (StringUtils.isEmpty((String)this.keyAlgorithm)) {
                this.keyAlgorithm = (String)availableAlgorithms.iterator().next();
            }
        }
        this.initializeKeySizeList();
    }

    private void initializeDefaultValues() {
        DSignRotationSetting dsRotationSettings = new DSignRotationSetting(null, false);
        dsRotationSettings.initializeDefaultFromOriginalCert(this.originalCert, true);
        this.signatureAlgorithm = dsRotationSettings.getSignatureAlgorithm();
        this.keyAlgorithm = dsRotationSettings.getKeyAlgorithm();
        this.validityPeriodDays = String.valueOf(dsRotationSettings.getValidityPeriodDays());
        this.setDefaultActnGenerationBuffer(this.validityPeriodDays);
        this.keySize = String.valueOf(dsRotationSettings.getKeySize());
    }

    private void setDefaultActnGenerationBuffer(String validityDays) {
        int validityInDays = Integer.parseInt(validityDays);
        Double rotationDays = (double)validityInDays * 0.25;
        Double activeRotnDays = (double)validityInDays * 0.1;
        this.activationBufferDays = String.valueOf(activeRotnDays.intValue());
        this.creationBufferDays = String.valueOf(rotationDays.intValue());
    }

    @Override
    public boolean save(Object dataToDisk) {
        String certAlias = this.originalCert.getAlias();
        if (StringUtils.isBlank((String)certAlias)) {
            return false;
        }
        if (this.enableCertRotation) {
            DSignRotationSetting rotationSetting = new DSignRotationSetting(certAlias, this.enableCertRotation);
            rotationSetting.setActivationBufferMins(Integer.parseInt(this.activationBufferDays) * 1440);
            rotationSetting.setKeySize(Integer.parseInt(this.keySize));
            rotationSetting.setRotationBufferMins(Integer.parseInt(this.creationBufferDays) * 1440);
            rotationSetting.setSignatureAlgorithm(this.signatureAlgorithm);
            rotationSetting.setValidityPeriodDays(Integer.parseInt(this.validityPeriodDays));
            rotationSetting.setKeyAlgorithm(this.keyAlgorithm);
            rotationSetting.setPendingCertAlias(this.pendingCertAlias);
            rotationManger.addRotationSetting(rotationSetting);
        } else {
            DSignRotationSetting existingRotationSetting = rotationManger.getRotationSetting(certAlias);
            if (existingRotationSetting != null) {
                existingRotationSetting.setEnableCertRotation(false);
                rotationManger.addRotationSetting(existingRotationSetting);
            }
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        DSignRotationSettingsValidator validator = new DSignRotationSettingsValidator(this.activationBufferDays, this.creationBufferDays, this.validityPeriodDays, this.keyAlgorithm, this.keySize, this.signatureAlgorithm, this.originalCert.getX509Certificate().getNotAfter());
        validator.validate();
        this.recordErrors(validator.getErrors(), delegate);
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        DSignRotationSetting rotationSetting = rotationManger.getRotationSetting(this.originalCert.getAlias());
        if (rotationSetting != null) {
            this.enableCertRotation = rotationSetting.isEnableCertRotation();
            this.activationBufferDays = String.valueOf(rotationSetting.getActivationBufferDays().intValue());
            this.keySize = String.valueOf(rotationSetting.getKeySize());
            this.keyAlgorithm = rotationSetting.getKeyAlgorithm();
            this.creationBufferDays = String.valueOf(rotationSetting.getRotationBufferDays().intValue());
            this.signatureAlgorithm = rotationSetting.getSignatureAlgorithm();
            this.validityPeriodDays = String.valueOf(rotationSetting.getValidityPeriodDays());
            this.pendingCertAlias = rotationSetting.getPendingCertAlias();
        }
    }

    private void initializeKeySizeList() {
        this.keySizeList = new StringPairPropertySelectionModel();
        this.signatureAlgorithmList = new StringPairPropertySelectionModel();
        if (this.keyAlgorithm != null) {
            KeyAlgorithmInfo info = certService.getKeyAlgorithmInfo(this.keyAlgorithm);
            for (Integer availableKeySize : info.getKeySizes()) {
                this.keySizeList.add(availableKeySize.toString(), availableKeySize.toString());
            }
            for (String sigAlgorithm : info.getSignatureAlgorithms()) {
                this.signatureAlgorithmList.add(JavaAlgorithmNames.SignatureName.getDisplayName((String)sigAlgorithm), sigAlgorithm);
            }
            if (StringUtils.isBlank((String)this.signatureAlgorithm)) {
                this.signatureAlgorithm = info.getDefaultSignatureAlgorithm();
            }
        }
    }

    public StringPairPropertySelectionModel getKeySizeList() {
        return this.keySizeList;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.keyAlgorithmChanged) {
            this.initializeKeySizeList();
            this.keyAlgorithmChanged = false;
        }
    }

    public StringPairPropertySelectionModel getKeyAlgList() {
        this.keyAlgList = new StringPairPropertySelectionModel();
        for (String keyAlg : certService.getAvailableKeyAlgorithms()) {
            this.keyAlgList.add(keyAlg, keyAlg);
        }
        return this.keyAlgList;
    }

    public StringPairPropertySelectionModel getSignatureAlgorithmList() {
        return this.signatureAlgorithmList;
    }

    public void setSignatureAlgorithmList(StringPairPropertySelectionModel signatureAlgorithmList) {
        this.signatureAlgorithmList = signatureAlgorithmList;
    }

    public boolean isEnableCertRotation() {
        return this.enableCertRotation;
    }

    public void setEnableCertRotation(boolean enableCertRotation) {
        this.enableCertRotation = enableCertRotation;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Creation Buffer (days)", this.creationBufferDays, this));
        summaryList.add(new SummaryInfo("Activation Buffer (days)", this.activationBufferDays, this));
        summaryList.add(new SummaryInfo("Validity Period (days)", this.validityPeriodDays, this));
        summaryList.add(new SummaryInfo("Key Algorithm", this.keyAlgorithm, this));
        summaryList.add(new SummaryInfo("Key Size (bits)", this.keySize, this));
        summaryList.add(new SummaryInfo("Signature Algorithm", this.signatureAlgorithm, this));
    }

    @Override
    public void reset() {
        this.enableCertRotation = false;
    }
}

