/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.SigningCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DynamicConnectionSigningCertState
extends SigningCertState {
    private static final long serialVersionUID = 20050515L;

    public DynamicConnectionSigningCertState(Tasklet value) {
        super(value);
        this.certType = CertificateTypes.ValidTypes.dsigSigningCert;
        this.setMenuName("Metadata Signing");
        this.setIncludeKeyInfoVisible(false);
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        if (localSettings != null && localSettings.getMetadataSigningKeyAlias() != null) {
            this.setRawSelectedCert((Cert)this.getCertManager().getPkCert(localSettings.getMetadataSigningKeyAlias()));
            String signingAlg = localSettings.getMetadataSigningAlgorithm();
            if (signingAlg != null) {
                this.setSelectedSigningAlgType(signingAlg);
            } else {
                this.setSelectedSigningAlgType(this.getDefaultSigningAlgorithm());
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalSettings localSettings = (LocalSettings)dataToDisk;
        if (this.getSelectedCert() != null) {
            localSettings.setMetadataSigningKeyAlias(this.getSelectedCert().getAlias());
            localSettings.setMetadataSigningAlgorithm(this.getSelectedSigningAlgType());
            localSettings.setMetadataSigningKeyMD5Fingerprint(this.getSelectedCert().getFingerPrint(HashAlgorithm.MD5));
        } else {
            localSettings.setMetadataSigningKeyAlias(null);
            localSettings.setMetadataSigningAlgorithm(null);
            localSettings.setMetadataSigningKeyMD5Fingerprint(null);
        }
        return true;
    }

    @Override
    public boolean isCertRequired() {
        return false;
    }

    @Override
    public boolean isShowSecondaryCertDropDown() {
        return false;
    }
}

