/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.EnableCertRotationValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.oauth20.domain.JWKSEndpointSetting;
import org.sourceid.oauth20.domain.JwksSigningInstanceSettings;
import org.sourceid.oauth20.domain.OidcJwksSet;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class EnableDSignRotationState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private static final DSignRotationSettingsManager rotationManger = MgmtFactory.getDSignRotationSettingsManager();
    private static final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private boolean enableCertRotation = false;
    private String originalCertAlias;

    public EnableDSignRotationState(Tasklet value) {
        super(value);
        this.setMenuName("Enable Certificate Rotation");
    }

    public boolean isEnableCertRotation() {
        return this.enableCertRotation;
    }

    public void setEnableCertRotation(boolean enableCertRotation) {
        this.enableCertRotation = enableCertRotation;
        this.getParent().reconfigureTransitions();
    }

    public String getOriginalCertAlias() {
        return this.originalCertAlias;
    }

    public void setOriginalCertAlias(String originalCertAlias) {
        this.originalCertAlias = originalCertAlias;
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        DSignRotationSetting rotationSetting = rotationManger.getRotationSetting(this.originalCertAlias);
        if (rotationSetting != null) {
            this.enableCertRotation = rotationSetting.isEnableCertRotation();
        }
        this.getParent().reconfigureTransitions();
    }

    @Override
    public boolean onStateExit() {
        this.getParent().reconfigureTransitions();
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.enableCertRotation) {
            EnableCertRotationValidator enableCertRotationValidator;
            JWKSEndpointSetting setting;
            PkCert cert = MgmtFactory.getDsigPkCertManager().getPkCert(this.originalCertAlias);
            if (this.isCertExpired(cert)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("cert_expired"), ValidationConstraint.REQUIRED);
            }
            if (this.isUsedByStaticKeys(this.originalCertAlias, (OidcJwksSet)(setting = MgmtFactory.getJWKSEndpointManager().getSetting())) || this.isKeyInAdditionalTokenSigningKeys()) {
                ValidationError error = ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.dsign_in_use_jwks_endpoint, null);
                String msg = error.getMessage();
                EnableDSignRotationState.recordErrorMsg(msg, delegate);
            }
            if (!(enableCertRotationValidator = new EnableCertRotationValidator(connectionManager, this.originalCertAlias, "", true)).validate()) {
                this.recordErrors(enableCertRotationValidator.getErrors(), delegate);
            }
        }
    }

    private boolean isKeyInAdditionalTokenSigningKeys() {
        for (JwksSigningInstanceSettings keySet : MgmtFactory.getJWKSSigningKeySetsManager().getAllKeySets()) {
            if (!this.isUsedByStaticKeys(this.originalCertAlias, keySet.getOidcJWKSSigningKeySet())) continue;
            return true;
        }
        return false;
    }

    private boolean isUsedByStaticKeys(String certAlias, OidcJwksSet setting) {
        boolean isInUse = false;
        if (setting != null) {
            Set activeIds = setting.getActiveIds();
            Set previousIds = setting.getPreviousIds();
            isInUse = activeIds.contains(certAlias) || previousIds.contains(certAlias);
        }
        return isInUse;
    }

    private boolean isCertExpired(PkCert cert) {
        Date date = new Date();
        return cert != null && date.after(cert.getX509Certificate().getNotAfter());
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Enable Certificate Rotation", Boolean.toString(this.enableCertRotation), this));
    }
}

