/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.ProtocolType;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ExportMetadataTasklet;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.MetaDataInfo;
import org.sourceid.websso.Protocol;

public class ExportProtocolState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private Protocol protocol;

    public ExportProtocolState(IWizard owner) {
        super(owner);
        this.setMenuName("Protocol");
    }

    @Override
    public void onStateActivated() {
        this.setProtocol(this.getLocalSettings().getDefaultProtocol(this.getConnectionType().equals(ConnectionType.SP.getName())));
    }

    @Override
    public boolean save(Object dataToDisk) {
        MetaDataInfo m = (MetaDataInfo)dataToDisk;
        m.setProtocol(this.protocol);
        if (this.exportIdP() && (this.protocol == Protocol.SAML10 || this.protocol == Protocol.SAML11)) {
            m.setSourceId(this.getLocalSettings().getSaml1xSrcId());
        } else {
            m.setSourceId("");
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.protocol == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Protocol_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Protocol", ProtocolType.getProtocolStringForType(this.protocol), this));
        if (this.exportIdP() && (this.protocol == Protocol.SAML10 || this.protocol == Protocol.SAML11)) {
            summaryList.add(new SummaryInfo("SourceID", this.getLocalSettings().getSaml1xSrcId(), this));
        }
    }

    protected boolean exportIdP() {
        ExportMetadataTasklet exportTasklet = this.getParent(ExportMetadataTasklet.class);
        return exportTasklet.exportIDP();
    }

    public LocalSettings getLocalSettings() {
        LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
        return localSettingsMgr.getLocalSettings();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol proc) {
        this.protocol = proc;
    }

    public String getConnectionType() {
        if (this.exportIdP()) {
            return ConnectionType.SP.getName();
        }
        return ConnectionType.IDP.getName();
    }
}

