/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.model.fieldpaths.ServerSettingsPaths;
import com.pingidentity.admin.api.validator.FederationInfoValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorManager;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ProtocolSettingsTasklet;
import com.pingidentity.module.connection.ConnectionModuleGlobalConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class FederationInfoState
extends TaskletListState {
    private static final long serialVersionUID = 20050515L;
    private String baseUrl;
    private String saml2EntityId;
    private String saml1xId;
    private String saml1xSourceId;
    private String wsfedRealm;
    private transient LocalSettings localSettings;

    public FederationInfoState(Tasklet value) {
        super(value);
        this.setMenuName("Federation Info");
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        this.saml2EntityId = this.localSettings.getEntityId();
        this.saml1xId = this.localSettings.getSaml1xId();
        this.wsfedRealm = this.localSettings.getWsfedRealm();
        this.saml1xSourceId = this.localSettings.getSaml1xSrcId();
        this.baseUrl = this.localSettings.getBaseUrl();
    }

    @Override
    public boolean save(Object dataFromDisk) {
        LocalSettings localSettings = (LocalSettings)dataFromDisk;
        localSettings.setEntityId(!StringUtils.isBlank((String)this.saml2EntityId) ? this.saml2EntityId : "");
        localSettings.setSaml1xId(!StringUtils.isBlank((String)this.saml1xId) ? this.saml1xId : "");
        localSettings.setWsfedRealm(!StringUtils.isBlank((String)this.wsfedRealm) ? this.wsfedRealm : "");
        localSettings.setBaseUrl(this.baseUrl);
        localSettings.setSaml1xSrcId(this.saml1xSourceId);
        List connectionModuleConfigurations = localSettings.getConnectionModuleGlobalConfigurations();
        for (ConnectionModuleGlobalConfiguration config : connectionModuleConfigurations) {
            config.setEnabledInGui(true);
        }
        DependencyErrorManager dependencyErrorManager = MgmtFactory.getDependencyErrorManager();
        dependencyErrorManager.remove(AffectedItemType.PROTOCOL_SETTINGS.getFriendlyName(), AffectedItemType.PROTOCOL_SETTINGS);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        FederationInfoValidator validator = new FederationInfoValidator.Builder().setBaseFieldPath(ServerSettingsPaths.getFederationInfo()).setBaseUrl(this.baseUrl).setSaml2EntityId(this.saml2EntityId).setSaml1xIssuerId(this.saml1xId).setSaml1xSourceId(this.saml1xSourceId).setWsfedRealm(this.wsfedRealm).build();
        validator.validate();
        delegate.clearErrors();
        this.recordErrors(validator.getErrors(), delegate);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("My_base_url"), this.getBaseUrl(), this));
        if (StringUtils.isNotBlank((String)this.getSaml2EntityId())) {
            summaryList.add(new SummaryInfo(this.getMessage("Saml_2_id_desc"), this.getSaml2EntityId(), this));
        }
        if (StringUtils.isNotBlank((String)this.getSaml1xId())) {
            summaryList.add(new SummaryInfo(this.getMessage("Saml_1.x_id_desc"), this.getSaml1xId(), this));
        }
        if (StringUtils.isNotBlank((String)this.getSaml1xSourceId())) {
            summaryList.add(new SummaryInfo(this.getMessage("Saml_1.x_src_id_desc"), this.getSaml1xSourceId(), this));
        }
        if (StringUtils.isNotBlank((String)this.getWsfedRealm())) {
            summaryList.add(new SummaryInfo(this.getMessage("Wsfed_realm_desc"), this.getWsfedRealm(), this));
        }
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        this.setDelegate(this.getParent().getDelegate(this.getParent().getCycle()));
        this.appendErrors((IValidationDelegate)this.getDelegate(), null, false);
    }

    @Override
    public void refreshState() {
        this.setDelegate(this.getParent().getDelegate(this.getParent().getCycle()));
        this.appendErrors((IValidationDelegate)this.getDelegate(), null, false);
    }

    @Override
    public String getNoteKey() {
        if (this.isSaml1xApAvailable()) {
            return super.getNoteKey() + "_1x";
        }
        return super.getNoteKey();
    }

    public boolean isSaml2Available() {
        ProtocolSettingsTasklet tasklet = this.getParent(ProtocolSettingsTasklet.class);
        return tasklet.isSaml2Enabled() || tasklet.isWsTrustStsEnabled();
    }

    public boolean isSaml1xAvailable() {
        ProtocolSettingsTasklet tasklet = this.getParent(ProtocolSettingsTasklet.class);
        return tasklet.isSaml1xEnabled() || tasklet.isWsTrustStsEnabled();
    }

    public boolean isSaml1xApAvailable() {
        return this.getParent(ProtocolSettingsTasklet.class).isSaml1xApEnabled();
    }

    public boolean isWsFedAvailable() {
        return this.getParent(ProtocolSettingsTasklet.class).isWsFedEnabled();
    }

    public boolean isProtocolRequiringBaseUrlEnabled() {
        return this.getParent(ProtocolSettingsTasklet.class).isProtocolRequiringBaseUrlEnabled();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getSaml1xId() {
        return this.saml1xId;
    }

    public void setSaml1xId(String saml1xId) {
        this.saml1xId = saml1xId;
    }

    public String getSaml1xSourceId() {
        return this.saml1xSourceId;
    }

    public void setSaml1xSourceId(String saml1xSourceId) {
        this.saml1xSourceId = saml1xSourceId;
    }

    public String getSaml2EntityId() {
        return this.saml2EntityId;
    }

    public void setSaml2EntityId(String saml2EntityId) {
        this.saml2EntityId = saml2EntityId;
    }

    public String getWsfedRealm() {
        return this.wsfedRealm;
    }

    public void setWsfedRealm(String wsfedRealm) {
        this.wsfedRealm = wsfedRealm;
    }
}

