/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.CertificateState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.InUseCertsApi;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.KeyAlgorithmFilter;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.StringPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.websso.Protocol;

public abstract class GenericDsigCertState
extends CertificateState
implements CertificateTypes,
TableEditor.TableEditorListener,
TableEditor.TableEditorRowOrdering {
    private static final long serialVersionUID = 20050515L;
    private boolean includeKeyInfo;
    private boolean includeKeyValue;
    private boolean includeKeyInfoVisible;
    protected Protocol protocol;
    protected String checkboxKey;
    protected boolean certRequired = true;
    private boolean showMultiCertSelection;
    protected ConnectionBase connection;
    protected IdpConnection idpConnection;
    protected SpConnection spConnection;
    protected String selectedSigningAlgType;
    protected List<TableRow> activeCertificatesTableRows = new ArrayList<TableRow>();
    protected final DropDownDescriptor ACTIVE_CERTIFICATE = new DropDownDescriptor("Certificate", 800, this);
    private transient Object componentState;

    public GenericDsigCertState(Tasklet value) {
        super(value, "genericDsigCert");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.connection = (ConnectionBase)dataFromDisk;
        if (this.connection instanceof IdpConnection) {
            this.idpConnection = (IdpConnection)this.connection;
        } else {
            this.spConnection = (SpConnection)this.connection;
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        super.doSummary(summaryList);
        if (this.isIncludeKeyInfoVisible()) {
            summaryList.add(new SummaryInfo(this.getMessage("IncludeKeyInfo"), Boolean.toString(this.includeKeyInfo), this));
        }
        if (this.isIncludeKeyValueVisible()) {
            summaryList.add(new SummaryInfo(this.getMessage("IncludeKeyValue"), Boolean.toString(this.includeKeyValue), this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.isCertRequired() && this.getSelectedCert() == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Cert_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if ("EC".equals(this.getPubKeyAlgType())) {
            this.includeKeyValue = false;
        }
    }

    public PkCertManager getCertManager() {
        return MgmtFactory.getDsigPkCertManager();
    }

    public String getCheckboxKey() {
        return this.checkboxKey;
    }

    public void setCheckboxKey(String checkboxKey) {
        this.checkboxKey = checkboxKey;
    }

    public ConnectionCerts getConnectionCerts() {
        return this.findParent(InUseCertsApi.class).getDsigConnectionCerts();
    }

    public boolean isIncludeKeyInfo() {
        return this.includeKeyInfo;
    }

    public void setIncludeKeyInfo(boolean includeKeyInfo) {
        this.includeKeyInfo = includeKeyInfo;
    }

    public boolean isIncludeKeyValue() {
        return this.includeKeyValue;
    }

    public void setIncludeKeyValue(boolean includeKeyValue) {
        this.includeKeyValue = this.includeKeyInfo ? includeKeyValue : false;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public boolean isConnectionProtocol1x() {
        return this.protocol != null && (this.protocol.equals((Object)Protocol.SAML10) || this.protocol.equals((Object)Protocol.SAML11));
    }

    @Override
    public String getNoteKey() {
        if (this.isConnectionProtocol1x()) {
            return super.getNoteKey() + "_1x";
        }
        return super.getNoteKey();
    }

    public String getKeyInfoText() {
        return "";
    }

    public String getKeyValueText() {
        return "";
    }

    public IPropertySelectionModel getRSASigningAlgTypeList() {
        return null;
    }

    public IPropertySelectionModel getDSASigningAlgTypeList() {
        return null;
    }

    public IPropertySelectionModel getECSigningAlgTypeList() {
        return null;
    }

    public boolean isCertRequired() {
        return this.certRequired;
    }

    public void setCertRequired(boolean certRequired) {
        this.certRequired = certRequired;
    }

    public boolean isIncludeKeyInfoVisible() {
        return this.includeKeyInfoVisible && this.protocol != Protocol.WSFED;
    }

    public void setIncludeKeyInfoVisible(boolean includeKeyInfoVisible) {
        this.includeKeyInfoVisible = includeKeyInfoVisible;
    }

    public boolean isIncludeKeyValueVisible() {
        return (this.includeKeyInfo || this.protocol == Protocol.WSFED) && !"EC".equals(this.getPubKeyAlgType());
    }

    public boolean isShowMultiCertSelection() {
        return this.showMultiCertSelection;
    }

    public boolean isShowSecondaryCertDropDown() {
        return false;
    }

    public void setShowMultiCertSelection(boolean showMultiCertSelection) {
        this.showMultiCertSelection = showMultiCertSelection;
    }

    public String getSelectedSigningAlgType() {
        return this.selectedSigningAlgType;
    }

    public void setSelectedSigningAlgType(String selectedSigningAlgType) {
        this.selectedSigningAlgType = selectedSigningAlgType;
    }

    public boolean isShowRSASigningAlgorithm() {
        return false;
    }

    public boolean isShowDSASigningAlgorithm() {
        return false;
    }

    public boolean isShowECSigningAlgorithm() {
        return false;
    }

    protected String getPubKeyAlgType() {
        Cert cert = this.getSelectedCert();
        String selectedCertPubKeyAlg = null;
        if (cert != null) {
            X509Certificate x509 = cert.getX509Certificate();
            selectedCertPubKeyAlg = x509.getPublicKey().getAlgorithm();
        }
        return selectedCertPubKeyAlg;
    }

    public Set<KeyAlgorithmFilter> getKeyAlgorithmFilter() {
        return null;
    }

    public List<SimpleFieldDescriptor> getActiveCertificatesDescriptors() {
        return Collections.singletonList(this.ACTIVE_CERTIFICATE);
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public List<TableRow> getActiveCertificatesTableRows() {
        return this.activeCertificatesTableRows;
    }

    public void setActiveCertificatesTableRows(List<TableRow> activeCertificatesTableRows) {
        this.activeCertificatesTableRows = activeCertificatesTableRows;
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> validationErrorMessages = new ArrayList<String>();
        if (this.containDuplicate(list, row, originalRow)) {
            validationErrorMessages.add("Duplicate certificates are not allowed.");
        }
        if (row.getFields().get(0).getValue().equals("- SELECT -")) {
            validationErrorMessages.add("Please select a certificate.");
        } else if (!this.isValidCert(row)) {
            validationErrorMessages.add(String.format("Certificate '%s' does not exist.", row.getFields().get(0).getLabel()));
        }
        return validationErrorMessages;
    }

    private boolean isValidCert(TableRow updatedRow) {
        return this.getConnectionCerts().getAllVerificationCerts().stream().anyMatch(cert -> cert.getDescriptionForDisplay(35).equals(updatedRow.getFields().get(0).getLabel()));
    }

    private boolean isSameCert(TableRow updatedRow, TableRow originalRow) {
        return updatedRow.getFields().get(0).getLabel().equals(originalRow.getFields().get(0).getLabel());
    }

    private boolean containDuplicate(List<TableRow> existingRows, TableRow updatedRow, TableRow originalRow) {
        return (updatedRow.isNewRow() || !this.isSameCert(updatedRow, originalRow)) && existingRows.stream().anyMatch(existingRow -> this.isSameCert(updatedRow, (TableRow)existingRow));
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
        newRow.getFields().set(0, new CertFieldItem((SimpleFieldDescriptor)this.ACTIVE_CERTIFICATE, newRow.getFields().get(0).getValue()));
        this.getInactiveCerts().removeIf(cert -> cert.getDescriptionForDisplay(35).equals(newRow.getFields().get(0).getValue()));
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void moveUp(int index) {
        if (index > 0) {
            TableRow item = this.activeCertificatesTableRows.get(index);
            this.activeCertificatesTableRows.set(index, this.activeCertificatesTableRows.get(index - 1));
            this.activeCertificatesTableRows.set(index - 1, item);
        }
    }

    @Override
    public void moveDown(int index) {
        if (index < this.activeCertificatesTableRows.size() - 1) {
            TableRow item = this.activeCertificatesTableRows.get(index);
            this.activeCertificatesTableRows.set(index, this.activeCertificatesTableRows.get(index + 1));
            this.activeCertificatesTableRows.set(index + 1, item);
        }
    }

    @Override
    public void reset() {
        this.includeKeyInfo = false;
        this.includeKeyValue = false;
        this.includeKeyInfoVisible = false;
        this.selectedSigningAlgType = null;
        super.reset();
    }

    protected static class CertFieldItem
    extends FieldItem {
        CertFieldItem(SimpleFieldDescriptor descriptor, String value) {
            super(descriptor, value);
        }

        @Override
        public String getLabel() {
            return this.getValue();
        }
    }

    protected static class DropDownDescriptor
    extends SimpleFieldDescriptor {
        private static final String DEFAULT_SELECT = "- SELECT -";
        private GenericDsigCertState state = null;

        DropDownDescriptor(String name, int width, GenericDsigCertState state) {
            super(SimpleFieldDescriptor.FieldType.DROPDOWN, name, width);
            this.state = state;
        }

        @Override
        public IPropertySelectionModel getModelValues() {
            ArrayList<String> selectionOption = new ArrayList<String>();
            selectionOption.add(DEFAULT_SELECT);
            if (this.state != null) {
                Set markedForDelete = this.state.getActiveCertificatesTableRows().stream().filter(TableRow::isMarkedForDelete).map(row -> row.getFields().get(0).getValue()).collect(Collectors.toSet());
                for (Cert cert : this.state.getInactiveCerts()) {
                    String displayName = cert.getDescriptionForDisplay(35);
                    if (markedForDelete.contains(displayName)) continue;
                    selectionOption.add(displayName);
                }
            }
            return new StringPropertySelectionModel(selectionOption.toArray(new String[selectionOption.size()]));
        }
    }
}

