/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.IdpC2cContractMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.UserSessionCreationTasklet;
import com.pingidentity.util.SAML2MappingModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpC2cContractFulfillmentState
extends MappingState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MODEL_TARGET_NAME = "Authentication Policy Contract";

    public IdpC2cContractFulfillmentState(Tasklet value) {
        super(value, "mapping");
        this.setMenuName("Contract Fulfillment");
        this.model.setTargetName(MODEL_TARGET_NAME);
    }

    @Override
    public void populate(Object dataFromDisk) {
        UserSessionCreationTasklet userSessionTasklet = this.findParent(UserSessionCreationTasklet.class);
        if (userSessionTasklet != null) {
            userSessionTasklet.refreshContract();
        }
        this.attributeMapping = (AttributeMapping)dataFromDisk;
        this.model = new SAML2MappingModel(MODEL_TARGET_NAME, this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping outmap = (AttributeMapping)dataToDisk;
        Map attrMap = this.model.getMapping().getAttributeMap();
        Collection targets = this.getTarget();
        HashSet<String> targetsToRemove = new HashSet<String>();
        for (Map.Entry e : attrMap.entrySet()) {
            String target = (String)e.getKey();
            if (targets.contains(target)) continue;
            targetsToRemove.add(target);
        }
        for (String ttm : targetsToRemove) {
            attrMap.remove(ttm);
        }
        outmap.setAttributeMap(attrMap);
        return true;
    }

    @Override
    public void onStateActivated() {
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        this.sources.addNoMappingSource("No Mapping");
        IdpC2cContractMappingTasklet c2cMappingTasklet = this.findParent(IdpC2cContractMappingTasklet.class);
        c2cMappingTasklet.addStandardSourcesToPropertySelectionSources(this.sources);
        this.sources.addTextSource("Text");
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            this.sources.addExpressionSource("Expression");
        }
        HashMap<String, String> additionalValidValues = new HashMap<String, String>();
        additionalValidValues.put("TargetResource", "TargetResource");
        this.sources.setAdditionalValidValues(additionalValidValues);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return !this.model.isTestingExpression();
    }

    @Override
    public void reset() {
        this.model = new SAML2MappingModel(this.getCurrentUser());
        this.model.setTargetName(MODEL_TARGET_NAME);
    }

    public Set<String> getTarget() {
        C2cContract contract;
        IdpC2cContractMappingTasklet c2cMappingTasklet = this.findParent(IdpC2cContractMappingTasklet.class);
        String contractId = c2cMappingTasklet.getContractId();
        if (contractId != null && (contract = MgmtFactory.getC2cContractManager().getContract(contractId)) != null) {
            return contract.getAllAttributeNames();
        }
        return new HashSet<String>();
    }

    @Override
    public String getNoteKey() {
        return this.getIsOidc() ? super.getNoteKey() + "_Oidc" : super.getNoteKey();
    }
}

