/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpProtocolSettingsTasklet;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.IdpConnection;

public class IdpProtocolSettingsState
extends SingleTaskletState
implements NeededCredentialsApi,
WebSsoApi {
    private static final long serialVersionUID = 20050515L;
    private IdpConnection idpConnection;
    private Object populateAllStatesData;

    public IdpProtocolSettingsState(Tasklet value) {
        super(value);
        this.setMenuName("Protocol Settings");
    }

    @Override
    public void onStateActivated() {
        this.populateTasklet();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.idpConnection = (IdpConnection)dataFromDisk;
        this.populateTasklet();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = data;
        this.populateTasklet();
        return true;
    }

    private void populateTasklet() {
        IdpProtocolSettingsTasklet tasklet = (IdpProtocolSettingsTasklet)this.getTaskletToEdit();
        if (tasklet == null) {
            tasklet = this.createTasklet(IdpProtocolSettingsTasklet.class);
            tasklet.configureTasklet();
            if (this.idpConnection != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.idpConnection);
            }
            if (this.populateAllStatesData != null) {
                tasklet.populateAllStates(this.populateAllStatesData);
            }
            this.setTasklet(tasklet);
        } else {
            Tasklet parentTasklet = this.getParent();
            if (!parentTasklet.isDraft()) {
                tasklet.configureTasklet();
            }
        }
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isBackChannelAuthenticationNeeded() : false;
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDigitalSignatureVerificationNeeded() : false;
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDigitalSignatureNeeded() : false;
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isEncryptionCertificateNeeded() : false;
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDecryptionKeyNeeded() : false;
    }

    @Override
    public boolean isInboundArtifact() {
        WebSsoApi wsa = this.getTaskletToEdit(WebSsoApi.class);
        return wsa != null ? wsa.isInboundArtifact() : false;
    }

    @Override
    public boolean isSoapSlo() {
        WebSsoApi wsa = this.getTaskletToEdit(WebSsoApi.class);
        return wsa != null ? wsa.isSoapSlo() : false;
    }

    @Override
    public boolean isArtifactSsoSlo() {
        WebSsoApi wsa = this.getTaskletToEdit(WebSsoApi.class);
        return wsa != null ? wsa.isArtifactSsoSlo() : false;
    }

    @Override
    public boolean isInboundSoap() {
        WebSsoApi wsa = this.getTaskletToEdit(WebSsoApi.class);
        return wsa != null ? wsa.isInboundSoap() : false;
    }

    @Override
    public boolean isAnyOutboundSoapNotUsingHttps() {
        WebSsoApi wsa = this.getTaskletToEdit(WebSsoApi.class);
        return wsa != null ? wsa.isAnyOutboundSoapNotUsingHttps() : false;
    }

    public boolean showEncriptionPolicy() {
        IdpConnectionConfigTasklet t = this.findParent(IdpConnectionConfigTasklet.class);
        return t.isConnectionProtocol20();
    }

    public boolean showOutboundSsoBinding() {
        IdpConnectionConfigTasklet t = this.findParent(IdpConnectionConfigTasklet.class);
        return t.isConnectionProtocol20() && t.isSpSSOSelected();
    }

    public boolean showOidcInfo() {
        IdpConnectionConfigTasklet t = this.findParent(IdpConnectionConfigTasklet.class);
        return t.isConnectionProtocolOIDC();
    }

    public boolean showOutboundSloBinding() {
        IdpConnectionConfigTasklet t = this.findParent(IdpConnectionConfigTasklet.class);
        return t.isAnySloSelected();
    }

    public boolean showArtifactLifetime() {
        IdpProtocolSettingsTasklet t = (IdpProtocolSettingsTasklet)this.getTaskletToEdit();
        return t.getOutboundSsoBindingList().contains("Artifact") || t.getOutboundSloBindingList().contains("Artifact");
    }

    public String getOutboundSsoBindingListAsString() {
        IdpProtocolSettingsTasklet t = (IdpProtocolSettingsTasklet)this.getTaskletToEdit();
        return Util.listToCommaDelimString(t.getOutboundSsoBindingList());
    }

    public String getOutboundSloBindingListAsString() {
        IdpProtocolSettingsTasklet t = (IdpProtocolSettingsTasklet)this.getTaskletToEdit();
        return Util.listToCommaDelimString(t.getOutboundSloBindingList());
    }

    public String getScopesList() {
        IdpProtocolSettingsTasklet t = (IdpProtocolSettingsTasklet)this.getTaskletToEdit();
        return t.getScopesList();
    }

    public String getOidcProfile() {
        IdpProtocolSettingsTasklet t = (IdpProtocolSettingsTasklet)this.getTaskletToEdit();
        return t.getOidcProfile();
    }

    public String getInboundBindingListAsString() {
        IdpProtocolSettingsTasklet t = (IdpProtocolSettingsTasklet)this.getTaskletToEdit();
        return Util.listToCommaDelimString(t.getInboundBindingList());
    }

    public String getSignaturePolicyAsString() {
        IdpProtocolSettingsTasklet t = (IdpProtocolSettingsTasklet)this.getTaskletToEdit();
        return Util.listToCommaDelimString(t.getSignaturePolicyList());
    }

    public String getEncryptionPolicyAsString() {
        IdpProtocolSettingsTasklet t = (IdpProtocolSettingsTasklet)this.getTaskletToEdit();
        return Util.listToCommaDelimString(t.getEncryptionPolicyList());
    }

    public String getArtifactLifetime() {
        IdpProtocolSettingsTasklet t = (IdpProtocolSettingsTasklet)this.getTaskletToEdit();
        return t.getArtifactLifetime();
    }
}

