/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.ManageAffiliationsTasklet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.util.MetadataImportException;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;

public class ImportAffiliationMetadataState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private IUploadFile importAffiliationFile;
    private Affiliation importedAffiliation;
    private String errorMessage;

    public ImportAffiliationMetadataState(IWizard owner) {
        super(owner);
        this.setMenuName("Import Metadata");
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        this.importedAffiliation = null;
        this.errorMessage = null;
        if (this.importAffiliationFile != null && !StringUtils.isBlank((String)this.importAffiliationFile.getFileName())) {
            if (this.importAffiliationFile.getSize() == 0L) {
                this.errorMessage = this.getMessage("no_file");
                return;
            }
            List affiliationImportList = null;
            try (InputStream inputStream = this.importAffiliationFile.getStream();){
                affiliationImportList = MetadataImportExportUtil.importAffiliation((InputStream)inputStream);
                Iterator iterator = affiliationImportList.iterator();
                if (iterator.hasNext()) {
                    Affiliation affiliation;
                    this.importedAffiliation = affiliation = (Affiliation)iterator.next();
                }
                if (this.importedAffiliation == null) {
                    this.errorMessage = this.getMessage("No_suitable_affiliations");
                }
            }
            catch (IOException | MetadataImportException e) {
                this.errorMessage = this.getMessage("Invalid_xml_file");
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!StringUtils.isBlank((String)this.errorMessage)) {
            delegate.setFormComponent(null);
            delegate.record(this.errorMessage, ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public boolean onStateExit() {
        if (this.importedAffiliation != null) {
            ManageAffiliationsTasklet parentTasklet = (ManageAffiliationsTasklet)this.getWizard();
            parentTasklet.populateAllStates(this.importedAffiliation);
        }
        return true;
    }

    public IUploadFile getImportAffiliationFile() {
        return this.importAffiliationFile;
    }

    public void setImportAffiliationFile(IUploadFile importAffiliationFile) {
        this.importAffiliationFile = importAffiliationFile;
    }

    public Affiliation getImportedAffiliation() {
        return this.importedAffiliation;
    }

    public void setImportedAffiliation(Affiliation importedAffiliation) {
        this.importedAffiliation = importedAffiliation;
    }
}

