/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.ConfigLdapFilterState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningTasklet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.GroupConstants;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.impl.LdapAttributeSource;

public class InboundGroupProvisioningConfigLdapFilterState
extends ConfigLdapFilterState {
    private static final long serialVersionUID = 20050515L;

    public InboundGroupProvisioningConfigLdapFilterState(Tasklet parent, String cardName) {
        super(parent, cardName);
        this.setMenuName("Unique Group ID");
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> scimAttrs = new ArrayList<String>();
        for (String id : GroupConstants.getAllIds()) {
            scimAttrs.add(id);
        }
        return scimAttrs;
    }

    @Override
    public void onStateActivated() {
        InboundProvisioningTasklet tasklet = this.findParent(InboundProvisioningTasklet.class);
        LdapDataSource tempDataSource = (LdapDataSource)tasklet.getSelectedDataSource();
        if (this.dataSource == null || tempDataSource != null && !tempDataSource.equals((Object)this.dataSource)) {
            this.dataSource = tempDataSource;
            this.origFilter = new String("");
            this.filter = new String("");
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        AttributeSource source = this.isInboundProvisioningTasklet() ? connection.getInboundProvisioning().getWriteGroupsAttributeMapping().getAttributeSource() : connection.getUserProvisioning().getAttributeSource();
        if (source != null) {
            this.dataSource = (LdapDataSource)source.getDataSource();
            this.filter = this.origFilter = source.getParameter("filter");
        } else {
            this.dataSource = null;
            this.filter = null;
            this.origFilter = null;
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        if (this.isInboundProvisioningTasklet()) {
            AttributeSource source = connection.getInboundProvisioning().getWriteGroupsAttributeMapping().getAttributeSource();
            LdapAttributeSource newSource = new LdapAttributeSource();
            newSource.setDataSource(source.getDataSource());
            newSource.setDataSourceId(source.getDataSourceId());
            newSource.setDescription(source.getDescription());
            HashMap clone = new HashMap();
            clone.putAll(source.getParameterMap());
            newSource.setParameterMap(clone);
            newSource.setParameter("filter", this.filter);
            connection.getInboundProvisioning().getWriteGroupsAttributeMapping().setAttributeSource((AttributeSource)newSource);
            connection.getInboundProvisioning().getReadGroupsAttributeMapping().setAttributeSource((AttributeSource)newSource);
        } else {
            connection.getUserProvisioning().getAttributeSource().setParameter("filter", this.filter);
        }
        return true;
    }

    private boolean isInboundProvisioningTasklet() {
        return this.findParent(InboundProvisioningTasklet.class) != null;
    }

    @Override
    public void reset() {
        this.filter = "";
        this.origFilter = "";
    }

    @Override
    public String getValueText() {
        return this.isInboundProvisioningTasklet() ? "SCIM Attributes" : "JIT Attributes";
    }
}

