/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.InboundProvisioningCustomScim2AttributeValidator;
import com.pingidentity.component.common.StringListEditor;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningCustomScim2SubAttributeTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.scim.model.Scim2SchemaAttribute;
import org.sourceid.saml20.domain.scim.model.Scim2SubAttribute;
import org.sourceid.saml20.domain.scim.model.ScimAttributeType;
import org.sourceid.saml20.domain.scim.model.ScimMutability;
import org.sourceid.saml20.domain.scim.model.ScimReturned;
import org.sourceid.saml20.domain.scim.model.ScimUniqueness;

public class InboundProvisioningCustomScim2AttributeState
extends TaskletListState {
    private static final long serialVersionUID = 1L;
    private static final String menuName = "Custom SCIM Attribute";
    protected String attributeName;
    protected String attributeDescription;
    protected boolean multiValued;
    protected boolean required;
    protected boolean caseExact;
    protected StringPairPropertySelectionModel attributeTypeList;
    protected String selectedAttributeType;
    protected StringPairPropertySelectionModel mutabilityList;
    protected String selectedMutability;
    protected StringPairPropertySelectionModel returnedList;
    protected String selectedReturned;
    protected StringPairPropertySelectionModel uniquenessList;
    protected String selectedUniqueness;
    protected List<String> subAttributesNamesList = new ArrayList<String>();
    protected List<String> canonicalValues = new ArrayList<String>();
    private transient Object subAttributesNamesState;
    private transient Object attributeTypesState;
    private String customSubAttributeToAdd = "";

    public InboundProvisioningCustomScim2AttributeState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName(menuName);
        this.createAttributeTypeList();
        this.createMutabilityList();
        this.createReturnedList();
        this.createUniquenessList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.deleteAllTasklets();
        if (dataFromDisk != null) {
            Scim2SchemaAttribute schemaAttribute = (Scim2SchemaAttribute)dataFromDisk;
            this.attributeName = schemaAttribute.getName();
            this.attributeDescription = schemaAttribute.getDescription();
            this.multiValued = schemaAttribute.getMultiValued();
            this.selectedMutability = schemaAttribute.getMutability();
            this.selectedReturned = schemaAttribute.getReturned();
            this.selectedUniqueness = schemaAttribute.getUniqueness();
            this.required = schemaAttribute.getRequired();
            this.caseExact = schemaAttribute.getCaseExact();
            this.selectedAttributeType = schemaAttribute.getType();
            this.setCanonicalValues(schemaAttribute.getCanonicalValues());
            ArrayList<String> names = new ArrayList<String>();
            if (schemaAttribute.getSubAttributes() != null) {
                for (Scim2SubAttribute schemaSubAttribute : schemaAttribute.getSubAttributes()) {
                    names.add(schemaSubAttribute.getName());
                    this.createTaskletForCustomSubAttribute(schemaSubAttribute);
                }
            }
            this.setSubAttributesNamesList(names);
        }
    }

    private void createTaskletForCustomSubAttribute(Scim2SubAttribute subAttribute) {
        InboundProvisioningCustomScim2SubAttributeTasklet subAttributeTasklet = this.createTasklet(InboundProvisioningCustomScim2SubAttributeTasklet.class);
        subAttributeTasklet.setMode(Mode.edit);
        subAttributeTasklet.populate(subAttribute);
        this.addTasklet(subAttributeTasklet);
    }

    @Override
    public void reset() {
        this.setSubAttributesNamesState(null);
        this.setAttributeTypesState(null);
        this.subAttributesNamesList.clear();
        this.canonicalValues.clear();
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk != null) {
            Scim2SchemaAttribute schemaAttribute = (Scim2SchemaAttribute)dataToDisk;
            schemaAttribute.setName(this.attributeName);
            schemaAttribute.setDescription(this.attributeDescription);
            schemaAttribute.setType(this.selectedAttributeType);
            schemaAttribute.setMutability(this.selectedMutability);
            schemaAttribute.setReturned(this.selectedReturned);
            schemaAttribute.setUniqueness(this.selectedUniqueness);
            schemaAttribute.setRequired(Boolean.valueOf(this.required));
            schemaAttribute.setCaseExact(Boolean.valueOf(this.caseExact));
            schemaAttribute.setMultiValued(Boolean.valueOf(this.multiValued));
            if (this.isComplexAttribute()) {
                ArrayList<Scim2SubAttribute> subAttributeList = new ArrayList<Scim2SubAttribute>();
                for (Tasklet tasklet : this.getTasklets()) {
                    InboundProvisioningCustomScim2SubAttributeTasklet subAttributeTasklet = (InboundProvisioningCustomScim2SubAttributeTasklet)tasklet;
                    if (subAttributeTasklet.isItDeleted()) continue;
                    Scim2SubAttribute subAttribute = new Scim2SubAttribute();
                    subAttribute.setName(subAttributeTasklet.getAttributeName());
                    subAttribute.setDescription(subAttributeTasklet.getAttributeDescription());
                    subAttribute.setType(subAttributeTasklet.getAttributeType());
                    subAttribute.setReturned(subAttributeTasklet.getReturned());
                    subAttribute.setUniqueness(subAttributeTasklet.getUniqueness());
                    subAttribute.setMutability(subAttributeTasklet.getMutability());
                    subAttribute.setCaseExact(Boolean.valueOf(subAttributeTasklet.isCaseExact()));
                    subAttribute.setRequired(Boolean.valueOf(subAttributeTasklet.getRequired()));
                    subAttributeTasklet.save(subAttribute);
                    subAttributeList.add(subAttribute);
                }
                schemaAttribute.setSubAttributes(subAttributeList);
            }
            this.subAttributesNamesState = null;
            this.attributeTypesState = null;
        }
        return true;
    }

    public Object getSubAttributesNamesState() {
        return this.subAttributesNamesState;
    }

    public void setSubAttributesNamesState(Object componentState) {
        this.subAttributesNamesState = componentState;
    }

    public Object getAttributeTypesState() {
        return this.attributeTypesState;
    }

    public void setAttributeTypesState(Object attributeTypesState) {
        this.attributeTypesState = attributeTypesState;
    }

    public boolean isComplexAttribute() {
        return ScimAttributeType.COMPLEX.name().equals(this.selectedAttributeType);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.validate(delegate);
        super.appendErrors(delegate, component, fastFail);
    }

    private void validate(IValidationDelegate delegate) {
        InboundProvisioningCustomScim2AttributeValidator validator = new InboundProvisioningCustomScim2AttributeValidator.Builder().setAttributeName(this.attributeName).setCanonicalValues(this.canonicalValues).setMultivalued(this.multiValued).setAttributeType(ScimAttributeType.fromString((String)this.selectedAttributeType)).setSubAttributeNames(this.subAttributesNamesList).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void cancel(Object newData) {
        super.cancel(newData);
        this.subAttributesNamesState = null;
        this.attributeTypesState = null;
    }

    @Override
    public boolean onStateExit() {
        this.updateTypes();
        return true;
    }

    public void addSubAttributeName() {
        Scim2SubAttribute subAttribute = new Scim2SubAttribute();
        subAttribute.setName(this.customSubAttributeToAdd);
        ArrayList<String> subAttributeNames = new ArrayList<String>(this.subAttributesNamesList);
        subAttributeNames.add(this.customSubAttributeToAdd);
        InboundProvisioningCustomScim2AttributeValidator validator = new InboundProvisioningCustomScim2AttributeValidator.Builder().setAttributeName(this.attributeName).setCanonicalValues(this.canonicalValues).setMultivalued(this.multiValued).setAttributeType(ScimAttributeType.fromString((String)this.selectedAttributeType)).setSubAttributeNames(subAttributeNames).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), (IValidationDelegate)this.delegate);
        }
        if (!validator.hasErrors()) {
            this.createTaskletForSubAttribute(subAttribute);
            this.subAttributesNamesList.add(this.customSubAttributeToAdd);
        }
        this.customSubAttributeToAdd = "";
    }

    private void createTaskletForSubAttribute(Scim2SubAttribute subAttribute) {
        InboundProvisioningCustomScim2SubAttributeTasklet subAttributeTasklet = this.createTasklet(InboundProvisioningCustomScim2SubAttributeTasklet.class);
        subAttributeTasklet.setMode(Mode.edit);
        subAttributeTasklet.populate(subAttribute);
        this.addTasklet(subAttributeTasklet);
    }

    public Tasklet getTaskletForSubAttributeName(String attributeName) {
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScim2SubAttributeTasklet t = (InboundProvisioningCustomScim2SubAttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(attributeName)) continue;
            tasklet.initialize();
            return tasklet;
        }
        return null;
    }

    public void updateTypes() {
        StringListEditor.State componentState;
        if (this.attributeTypesState != null) {
            componentState = (StringListEditor.State)this.attributeTypesState;
            if (!this.multiValued) {
                componentState.deleteAllStringListItems();
            }
        }
        if (this.subAttributesNamesState != null) {
            componentState = (StringListEditor.State)this.subAttributesNamesState;
            if (!this.isComplexAttribute()) {
                componentState.deleteAllStringListItems();
            }
        }
    }

    public List<String> getCanonicalValues() {
        return this.canonicalValues;
    }

    public void delete(String customAttributeToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScim2SubAttributeTasklet t = (InboundProvisioningCustomScim2SubAttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customAttributeToDelete)) continue;
            t.setItDeleted(true);
            this.subAttributesNamesList.remove(customAttributeToDelete);
            return;
        }
    }

    public void undelete(String customAttributeToUndelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScim2SubAttributeTasklet t = (InboundProvisioningCustomScim2SubAttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customAttributeToUndelete)) continue;
            t.setItDeleted(false);
            this.subAttributesNamesList.add(customAttributeToUndelete);
            return;
        }
    }

    public String getCustomSubAttributeToAdd() {
        return this.customSubAttributeToAdd;
    }

    public void setCustomSubAttributeToAdd(String customSubAttributeToAdd) {
        this.customSubAttributeToAdd = customSubAttributeToAdd;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(String attributeDescription) {
        this.attributeDescription = attributeDescription;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isCaseExact() {
        return this.caseExact;
    }

    public void setCaseExact(boolean caseExact) {
        this.caseExact = caseExact;
    }

    public StringPairPropertySelectionModel getAttributeTypeList() {
        return this.attributeTypeList;
    }

    protected void createAttributeTypeList() {
        this.attributeTypeList = new StringPairPropertySelectionModel(false);
        for (ScimAttributeType type : ScimAttributeType.values()) {
            this.attributeTypeList.add(type.getDisplayName(), type.name());
        }
    }

    public String getSelectedAttributeType() {
        return this.selectedAttributeType;
    }

    public void setSelectedAttributeType(String selectedAttributeType) {
        this.selectedAttributeType = selectedAttributeType;
    }

    public String getSelectedMutability() {
        return this.selectedMutability;
    }

    public void setSelectedMutability(String selectedMutability) {
        this.selectedMutability = selectedMutability;
    }

    public StringPairPropertySelectionModel getMutabilityList() {
        return this.mutabilityList;
    }

    private void createMutabilityList() {
        this.mutabilityList = new StringPairPropertySelectionModel(false);
        for (ScimMutability mutability : ScimMutability.values()) {
            this.mutabilityList.add(mutability.getDisplayName(), mutability.name());
        }
    }

    public String getSelectedReturned() {
        return this.selectedReturned;
    }

    public void setSelectedReturned(String selectedReturned) {
        this.selectedReturned = selectedReturned;
    }

    public StringPairPropertySelectionModel getReturnedList() {
        return this.returnedList;
    }

    private void createReturnedList() {
        this.returnedList = new StringPairPropertySelectionModel(false);
        for (ScimReturned returned : ScimReturned.values()) {
            this.returnedList.add(returned.getDisplayName(), returned.name());
        }
    }

    public String getSelectedUniqueness() {
        return this.selectedUniqueness;
    }

    public void setSelectedUniqueness(String selectedUniqueness) {
        this.selectedUniqueness = selectedUniqueness;
    }

    public StringPairPropertySelectionModel getUniquenessList() {
        return this.uniquenessList;
    }

    private void createUniquenessList() {
        this.uniquenessList = new StringPairPropertySelectionModel(false);
        for (ScimUniqueness uniqueness : ScimUniqueness.values()) {
            this.uniquenessList.add(uniqueness.getDisplayName(), uniqueness.name());
        }
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public void setCanonicalValues(List<String> canonicalValues) {
        this.canonicalValues = canonicalValues;
    }

    public List<String> getSubAttributesNamesList() {
        return this.subAttributesNamesList;
    }

    public void setSubAttributesNamesList(List<String> names) {
        this.subAttributesNamesList = names;
    }
}

