/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.InboundProvisioningCustomScim2AttributeValidator;
import com.pingidentity.fsm.state.impl.InboundProvisioningCustomScim2AttributeState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.scim.model.Scim2SubAttribute;
import org.sourceid.saml20.domain.scim.model.ScimAttributeType;

public class InboundProvisioningCustomScim2SubAttributeState
extends InboundProvisioningCustomScim2AttributeState {
    private String attributeName;
    private String attributeDescription;
    private boolean multiValued;
    private boolean required;
    private boolean caseExact;

    public InboundProvisioningCustomScim2SubAttributeState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Custom SCIM Sub Attribute Options");
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public String getAttributeDescription() {
        return this.attributeDescription;
    }

    @Override
    public void setAttributeDescription(String attributeDescription) {
        this.attributeDescription = attributeDescription;
    }

    @Override
    public boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean isCaseExact() {
        return this.caseExact;
    }

    @Override
    public void setCaseExact(boolean caseExact) {
        this.caseExact = caseExact;
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk != null) {
            Scim2SubAttribute subAttribute = (Scim2SubAttribute)dataFromDisk;
            this.attributeName = subAttribute.getName();
            this.attributeDescription = subAttribute.getDescription();
            this.selectedMutability = subAttribute.getMutability();
            this.selectedReturned = subAttribute.getReturned();
            this.selectedUniqueness = subAttribute.getUniqueness();
            this.required = subAttribute.getRequired();
            this.caseExact = subAttribute.getCaseExact();
            this.selectedAttributeType = subAttribute.getType();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk != null) {
            Scim2SubAttribute schemaAttribute = (Scim2SubAttribute)dataToDisk;
            schemaAttribute.setName(this.attributeName);
            schemaAttribute.setDescription(this.attributeDescription);
            schemaAttribute.setType(this.selectedAttributeType);
            schemaAttribute.setMutability(this.selectedMutability);
            schemaAttribute.setReturned(this.selectedReturned);
            schemaAttribute.setUniqueness(this.selectedUniqueness);
            schemaAttribute.setRequired(Boolean.valueOf(this.required));
            schemaAttribute.setCaseExact(Boolean.valueOf(this.caseExact));
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.validate(delegate);
    }

    private void validate(IValidationDelegate delegate) {
        InboundProvisioningCustomScim2AttributeValidator validator = new InboundProvisioningCustomScim2AttributeValidator.Builder().setAttributeName(this.attributeName).setAttributeType(ScimAttributeType.fromString((String)this.selectedAttributeType)).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    protected void createAttributeTypeList() {
        this.attributeTypeList = new StringPairPropertySelectionModel(false);
        for (ScimAttributeType type : ScimAttributeType.values()) {
            this.attributeTypeList.add(type.getDisplayName(), type.name());
        }
        this.attributeTypeList.remove(ScimAttributeType.COMPLEX.getDisplayName());
    }
}

