/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.InboundProvisioningCustomScimAttributesValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningCustomScimAttributeTasklet;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.scim.model.Schema;
import org.sourceid.saml20.domain.scim.model.SchemaAttribute;

public class InboundProvisioningCustomScimAttributesState
extends TaskletListState {
    private static final long serialVersionUID = 1L;
    protected String customScimAttributeNameToAdd = "";
    protected String namespace = "urn:scim:schemas:extension:custom:1.0";

    public InboundProvisioningCustomScimAttributesState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Custom SCIM Attributes");
    }

    private List<SchemaAttribute> getCustomScimAttributesFromDisk(Schema customScim) {
        ArrayList atts = customScim.getAttributes();
        if (atts == null) {
            atts = new ArrayList();
        }
        return atts;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.deleteAllTasklets();
        IdpConnection connection = null;
        connection = dataFromDisk == null ? MgmtFactory.getConnectionManager().getIdpConnection(this.getIdpConnId()) : (IdpConnection)dataFromDisk;
        if (connection.getInboundProvisioning() != null && connection.getInboundProvisioning().getCustomScim() != null) {
            List<SchemaAttribute> schemaAttributeList = this.getCustomScimAttributesFromDisk(connection.getInboundProvisioning().getCustomScim());
            for (SchemaAttribute customScimAttribute : schemaAttributeList) {
                this.createTaskletForCustomAttribute(customScimAttribute);
            }
            if (connection.getInboundProvisioning().getCustomScim().getSchemas() != null && connection.getInboundProvisioning().getCustomScim().getSchemas().size() > 0) {
                this.namespace = (String)connection.getInboundProvisioning().getCustomScim().getSchemas().iterator().next();
            }
        }
    }

    private void createTaskletForCustomAttribute(SchemaAttribute customScimAttribute) {
        InboundProvisioningCustomScimAttributeTasklet customScimAttributeTasklet = this.createTasklet(InboundProvisioningCustomScimAttributeTasklet.class);
        customScimAttributeTasklet.setMode(Mode.edit);
        customScimAttributeTasklet.populate(customScimAttribute);
        this.addTasklet(customScimAttributeTasklet);
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        ArrayList<SchemaAttribute> schemaAttributesList = new ArrayList<SchemaAttribute>();
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScimAttributeTasklet customScimAttributeTasklet = (InboundProvisioningCustomScimAttributeTasklet)tasklet;
            if (customScimAttributeTasklet.isItDeleted()) continue;
            SchemaAttribute schemaAttribute = new SchemaAttribute();
            schemaAttribute.setSchema(this.namespace);
            customScimAttributeTasklet.save(schemaAttribute);
            schemaAttributesList.add(schemaAttribute);
        }
        if (connection.getInboundProvisioning().getCustomScim() != null) {
            ArrayList atts = connection.getInboundProvisioning().getCustomScim().getAttributes();
            if (atts == null) {
                atts = new ArrayList();
            }
            atts.clear();
            atts.addAll(schemaAttributesList);
            connection.getInboundProvisioning().getCustomScim().setAttributes(atts);
            connection.getInboundProvisioning().getCustomScim().getSchemas().clear();
            connection.getInboundProvisioning().getCustomScim().getSchemas().add(this.namespace);
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.namespace.equals("") && !this.getAllUndeletedTasklets().isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("extension_namespace_cannot_be_blank"), ValidationConstraint.REQUIRED);
        }
    }

    public String getCustomScimAttributeNameToAdd() {
        return this.customScimAttributeNameToAdd;
    }

    public void setCustomScimAttributeNameToAdd(String customScimAttributeNameToAdd) {
        this.customScimAttributeNameToAdd = customScimAttributeNameToAdd;
    }

    public void addCustomAttributeName() {
        InboundProvisioningCustomScimAttributesValidator validator = new InboundProvisioningCustomScimAttributesValidator.AttributesBuilder().setIdpConnEntityId(this.getIdpConnId()).setAttributeName(this.customScimAttributeNameToAdd).setSchema(this.namespace).setTheOtherAttributeNames(this.getAllCustomAttributeNames()).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), (IValidationDelegate)this.delegate);
        }
        if (!validator.hasErrors()) {
            SchemaAttribute schemaAttributeToAdd = new SchemaAttribute();
            schemaAttributeToAdd.setName(this.customScimAttributeNameToAdd);
            schemaAttributeToAdd.setMultiValued(Boolean.valueOf(false));
            schemaAttributeToAdd.setDescription(this.customScimAttributeNameToAdd);
            schemaAttributeToAdd.setSubAttributes(null);
            this.createTaskletForCustomAttribute(schemaAttributeToAdd);
            this.customScimAttributeNameToAdd = "";
        }
    }

    public Tasklet getTaskletForCustomAttributeName(String customScimAttributeName) {
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScimAttributeTasklet t = (InboundProvisioningCustomScimAttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customScimAttributeName)) continue;
            tasklet.initialize();
            return tasklet;
        }
        return null;
    }

    public void delete(String customAttributeToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScimAttributeTasklet t = (InboundProvisioningCustomScimAttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customAttributeToDelete)) continue;
            t.setItDeleted(true);
            return;
        }
    }

    public void undelete(String customAttributeToUndelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScimAttributeTasklet t = (InboundProvisioningCustomScimAttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customAttributeToUndelete)) continue;
            t.setItDeleted(false);
            return;
        }
    }

    private List<String> getAttributeNamesListFromSchemaAttributesList(List<SchemaAttribute> schemaAttributes) {
        ArrayList<String> attrNames = new ArrayList<String>();
        for (SchemaAttribute schemaAttribute : schemaAttributes) {
            attrNames.add(schemaAttribute.getName());
        }
        return attrNames;
    }

    public List<String> getAttributeNamesNotIncludingTasklet(String excludedTaskletId) {
        ArrayList<String> attrNames = new ArrayList<String>();
        List<Tasklet> allTasklets = this.getTasklets();
        for (Tasklet tasklet : allTasklets) {
            if (tasklet.getTaskletId().equals(excludedTaskletId)) continue;
            attrNames.add(((InboundProvisioningCustomScimAttributeTasklet)tasklet).getAttributeName());
        }
        return attrNames;
    }

    public List<String> getAllCustomAttributeNames() {
        ArrayList<String> attrNames = new ArrayList<String>();
        for (Tasklet tasklet : this.getTasklets()) {
            attrNames.add(((InboundProvisioningCustomScimAttributeTasklet)tasklet).getAttributeName());
        }
        return attrNames;
    }

    private String getIdpConnId() {
        IdpConnectionConfigTasklet idpConnectionConfigTasklet = this.findParent(IdpConnectionConfigTasklet.class);
        return idpConnectionConfigTasklet.getConnId();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("extension_namespace"), this.namespace, this));
        for (Tasklet tasklet : this.getTasklets()) {
            summaryList.add(new SummaryInfo(this.getMessage("custom_attribute"), ((InboundProvisioningCustomScimAttributeTasklet)tasklet).getAttributeName(), this));
        }
    }

    private List<Tasklet> getAllUndeletedTasklets() {
        ArrayList<Tasklet> undeletedTaskletsList = new ArrayList<Tasklet>();
        for (Tasklet tasklet : this.getTasklets()) {
            if (tasklet.isDraft()) continue;
            undeletedTaskletsList.add(tasklet);
        }
        return undeletedTaskletsList;
    }
}

