/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;

public class InboundProvisioningDeleteUsersOptionsState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    public static final String DELETE_USER = "Permanently Delete User";
    public static final String DISABLE_USER = "Disable User";
    private boolean permanentlyDeleteUsersOnDelete;

    public InboundProvisioningDeleteUsersOptionsState(IWizard owner) {
        super(owner);
        this.setMenuName("Delete/Disable Users");
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        ScimUserProvisioning scimUserProvisioning = connection.getInboundProvisioning();
        this.permanentlyDeleteUsersOnDelete = scimUserProvisioning.isPermanentlyDeleteUsersOnDelete();
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        ScimUserProvisioning scimUserProvisioning = connection.getInboundProvisioning();
        scimUserProvisioning.setPermanentlyDeleteUsersOnDelete(this.permanentlyDeleteUsersOnDelete);
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("SCIM DELETE message behavior", this.permanentlyDeleteUsersOnDelete ? DELETE_USER : DISABLE_USER, this));
    }

    public boolean isPermanentlyDeleteUsersOnDelete() {
        return this.permanentlyDeleteUsersOnDelete;
    }

    public void setPermanentlyDeleteUsersOnDelete(boolean permanentlyDeleteUsersOnDelete) {
        this.permanentlyDeleteUsersOnDelete = permanentlyDeleteUsersOnDelete;
    }
}

