/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.state.impl.InboundProvisioningOperationState;
import com.pingidentity.fsm.state.impl.UserProvisioningAdapterContractMappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.IdentityStoreProvisionerApi;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningOperationTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningTasklet;
import com.pingidentity.util.SAML2MappingModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.collections.ListUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.GroupConstants;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.InboundProvisioningUserRepositoryType;
import org.sourceid.saml20.domain.ScimUserConstants;
import org.sourceid.saml20.domain.ScimUserConstantsFactory;
import org.sourceid.saml20.domain.UserConstants;
import org.sourceid.saml20.domain.scim.ScimVersion;

public class InboundProvisioningMappingState
extends UserProvisioningAdapterContractMappingState {
    private static final long serialVersionUID = 1L;

    public InboundProvisioningMappingState(Tasklet value) {
        super(value);
    }

    public InboundProvisioningMappingState(Tasklet value, String name) {
        super(value, name);
    }

    public InboundProvisioningMappingState(Tasklet value, String name, String targetColumnHeaderName) {
        super(value, name, targetColumnHeaderName);
    }

    @Override
    public void onStateActivated() {
        this.resetTargetsOnChange();
        this.testInsertStatus = "";
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        this.sources.addNoMappingSource("No Mapping");
        InboundProvisioningOperationTasklet t = this.findParent(InboundProvisioningOperationTasklet.class);
        t.addStandardSourcesToPropertySelectionSources(this.sources);
        this.sources.addTextSource("Text");
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            this.sources.addExpressionSource("Expression");
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isViewOnly()) {
            this.onStateActivated();
            LinkedList<String> existingAttrNames = null;
            List attrNamesToRemove = null;
            switch (this.getOperationType()) {
                case READ_USERS: {
                    existingAttrNames = new LinkedList<String>(this.model.getTargets());
                    attrNamesToRemove = ListUtils.subtract(existingAttrNames, this.getReadUserTargets());
                    for (String attr : attrNamesToRemove) {
                        this.model.remove(attr);
                    }
                    break;
                }
                case READ_GROUPS: {
                    existingAttrNames = new LinkedList<String>(this.model.getTargets());
                    attrNamesToRemove = ListUtils.subtract(existingAttrNames, this.getReadGroupTargets());
                    for (String attr : attrNamesToRemove) {
                        this.model.remove(attr);
                    }
                    break;
                }
            }
            this.model.validate(delegate, this.getTarget(), this.getSources(), this);
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        switch (this.getOperationType()) {
            case WRITE_USERS: {
                this.attributeMapping = connection.getInboundProvisioning().getWriteUsersAttributeMapping();
                break;
            }
            case READ_USERS: {
                this.attributeMapping = connection.getInboundProvisioning().getReadUsersAttributeMapping();
                break;
            }
            case READ_GROUPS: {
                this.attributeMapping = connection.getInboundProvisioning().getReadGroupsAttributeMapping();
                break;
            }
            case WRITE_GROUPS: {
                this.attributeMapping = connection.getInboundProvisioning().getWriteGroupsAttributeMapping();
            }
        }
        this.model = new SAML2MappingModel(this.getTargetColumnHeaderName(), this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        AttributeMapping outmap = null;
        switch (this.getOperationType()) {
            case WRITE_USERS: {
                outmap = connection.getInboundProvisioning().getWriteUsersAttributeMapping();
                break;
            }
            case READ_USERS: {
                outmap = connection.getInboundProvisioning().getReadUsersAttributeMapping();
                break;
            }
            case WRITE_GROUPS: {
                outmap = connection.getInboundProvisioning().getWriteGroupsAttributeMapping();
                break;
            }
            case READ_GROUPS: {
                outmap = connection.getInboundProvisioning().getReadGroupsAttributeMapping();
            }
        }
        if (outmap != null) {
            outmap.setAttributeMap2(this.model.getMapping().getAttributeMapping());
        }
        return true;
    }

    @Override
    public String getNoteKey() {
        Object noteKey = super.getNoteKey();
        switch (this.getOperationType()) {
            case WRITE_USERS: {
                noteKey = (String)noteKey + "_WriteUsers";
                break;
            }
            case READ_USERS: {
                noteKey = (String)noteKey + "_ReadUsers";
                break;
            }
            case WRITE_GROUPS: {
                noteKey = (String)noteKey + "_WriteGroups";
                break;
            }
            case READ_GROUPS: {
                noteKey = (String)noteKey + "_ReadGroups";
            }
        }
        return noteKey;
    }

    public Set<String> getWriteContractAttributeFulfillmentValues() {
        if (this.getRepositoryType() == InboundProvisioningUserRepositoryType.IDENTITY_STORE) {
            List attrNamesToRemove;
            LinkedList<String> existingAttrNames = new LinkedList<String>(this.model.getTargets());
            switch (this.getOperationType()) {
                case WRITE_USERS: {
                    attrNamesToRemove = ListUtils.subtract(existingAttrNames, this.getIdentityStoreProvisionerContractAttributes());
                    break;
                }
                case WRITE_GROUPS: {
                    attrNamesToRemove = ListUtils.subtract(existingAttrNames, this.getIdentityStoreProvisionerGroupContractAttributes());
                    break;
                }
                default: {
                    attrNamesToRemove = new ArrayList();
                }
            }
            for (String attr : attrNamesToRemove) {
                this.model.remove(attr);
            }
        }
        ScimUserConstants scimUserConstants = ScimUserConstantsFactory.getScimUserConstants((ScimVersion)this.getInboundProvisioningScimVersion());
        HashSet<String> values = new HashSet<String>();
        block15: for (Map.Entry e : this.model.getMapping().getAttributeMapping().entrySet()) {
            AttrMappingValue v = (AttrMappingValue)((List)e.getValue()).get(0);
            if (v.getType() == null) continue;
            switch (v.getType()) {
                case SCIM_USER: 
                case SCIM_GROUP: {
                    values.add(v.getValue());
                    break;
                }
                case EXPRESSION: {
                    try {
                        ArrayList supportedScimAttrs;
                        Object parsedExpression = Ognl.parseExpression((String)v.getValue());
                        OgnlHelper ognlHelper = new OgnlHelper();
                        ognlHelper.searchForAllVariableNames(parsedExpression);
                        switch (this.getOperationType()) {
                            case WRITE_USERS: {
                                supportedScimAttrs = scimUserConstants.getAllIdsForReadUsers();
                                break;
                            }
                            case WRITE_GROUPS: {
                                supportedScimAttrs = GroupConstants.getAllIdsForReadGroups();
                                break;
                            }
                            default: {
                                supportedScimAttrs = new ArrayList();
                            }
                        }
                        for (String ognlAttr : ognlHelper.getList()) {
                            if (!supportedScimAttrs.contains(ognlAttr)) continue;
                            values.add(ognlAttr);
                        }
                        continue block15;
                    }
                    catch (OgnlException e1) {
                        this.log.warn((Object)"Unable to parse OGNL Expression to retrieve SCIM attributes");
                    }
                }
            }
        }
        return values;
    }

    @Override
    public List<String> getTarget() {
        Collection<String> targets = new ArrayList<String>();
        switch (this.getOperationType()) {
            case WRITE_USERS: {
                switch (this.getRepositoryType()) {
                    case ACTIVE_DIRECTORY: {
                        targets = super.getTarget();
                        break;
                    }
                    case IDENTITY_STORE: {
                        targets.addAll(this.getIdentityStoreProvisionerContractAttributes());
                    }
                }
                break;
            }
            case READ_USERS: {
                targets = this.getReadUserTargets();
                break;
            }
            case WRITE_GROUPS: {
                switch (this.getRepositoryType()) {
                    case ACTIVE_DIRECTORY: {
                        targets = super.getTarget();
                        break;
                    }
                    case IDENTITY_STORE: {
                        targets.addAll(this.getIdentityStoreProvisionerGroupContractAttributes());
                    }
                }
                break;
            }
            case READ_GROUPS: {
                targets = this.getReadGroupTargets();
            }
        }
        return targets;
    }

    private List<String> getReadUserTargets() {
        LinkedList<String> targets = new LinkedList<String>();
        HashSet<String> contractAttributes = new HashSet<String>();
        InboundProvisioningTasklet inboundProvisioningTasklet = this.findParent(InboundProvisioningTasklet.class);
        contractAttributes.addAll(inboundProvisioningTasklet.getUserWriteContractAttributeFulfillmentValues());
        InboundProvisioningOperationTasklet inboundProvisioningOperationTasklet = this.findParent(InboundProvisioningOperationTasklet.class);
        contractAttributes.addAll(inboundProvisioningOperationTasklet.getContract().getMutableAttributeNames());
        targets.addAll(contractAttributes);
        targets.remove(UserConstants.PASSWORD.toString());
        Collections.sort(targets, String.CASE_INSENSITIVE_ORDER);
        return targets;
    }

    private List<String> getReadGroupTargets() {
        LinkedList<String> targets = new LinkedList<String>();
        HashSet<String> contractAttributes = new HashSet<String>();
        InboundProvisioningTasklet inboundProvisioningTasklet = this.findParent(InboundProvisioningTasklet.class);
        contractAttributes.addAll(inboundProvisioningTasklet.getGroupWriteContractAttributeFulfillmentValues());
        InboundProvisioningOperationTasklet inboundProvisioningOperationTasklet = this.findParent(InboundProvisioningOperationTasklet.class);
        contractAttributes.addAll(inboundProvisioningOperationTasklet.getContract().getMutableAttributeNames());
        targets.addAll(contractAttributes);
        Collections.sort(targets, String.CASE_INSENSITIVE_ORDER);
        return targets;
    }

    private InboundProvisioningUserRepositoryType getRepositoryType() {
        InboundProvisioningOperationTasklet inboundProvisioningOperationTasklet = this.findParent(InboundProvisioningOperationTasklet.class);
        return inboundProvisioningOperationTasklet.getUserRepositoryType();
    }

    private InboundProvisioningOperationState.OperationType getOperationType() {
        InboundProvisioningOperationTasklet inboundProvisioningOperationTasklet = this.findParent(InboundProvisioningOperationTasklet.class);
        return inboundProvisioningOperationTasklet.getOperationType();
    }

    private ScimVersion getInboundProvisioningScimVersion() {
        InboundProvisioningOperationTasklet inboundProvisioningOperationTasklet = this.findParent(InboundProvisioningOperationTasklet.class);
        return inboundProvisioningOperationTasklet.getScimVersion();
    }

    @Override
    public IPropertySelectionModel getAttrQueryAttrValues() {
        return null;
    }

    @Override
    public boolean showNullableColumn() {
        return false;
    }

    @Override
    public boolean isTableSqlMethod() {
        return false;
    }

    @Override
    public List<String> getDataMapListOrder() {
        return null;
    }

    @Override
    public boolean isJdbcProvisioning() {
        return false;
    }

    @Override
    public List<String> getDatetimeColumns() {
        return Collections.emptyList();
    }

    private List<String> getIdentityStoreProvisionerContractAttributes() {
        return this.findParent(IdentityStoreProvisionerApi.class).getContractAttributes();
    }

    private List<String> getIdentityStoreProvisionerGroupContractAttributes() {
        return this.findParent(IdentityStoreProvisionerApi.class).getGroupContractAttributes();
    }
}

