/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningTasklet;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.InboundProvisioningUserRepositoryType;

public class InboundProvisioningState
extends SingleTaskletState {
    private static final long serialVersionUID = 20050515L;
    private IdpConnection idpConnection;
    private Object populateAllStatesData;
    private static final String NOT_CONFIGURED = "Not Configured";

    public InboundProvisioningState(Tasklet value) {
        super(value);
        this.setMenuName("Inbound Provisioning");
    }

    @Override
    public void onStateActivated() {
        this.populateTasklet();
    }

    @Override
    public void onResumeDraft() {
        super.onResumeDraft();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.idpConnection = (IdpConnection)dataFromDisk;
        this.populateTasklet();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = data;
        this.populateTasklet();
        return true;
    }

    private void populateTasklet() {
        InboundProvisioningTasklet tasklet = this.getTaskletToEdit(InboundProvisioningTasklet.class);
        if (tasklet == null) {
            tasklet = this.createTasklet(InboundProvisioningTasklet.class);
            tasklet.configureTasklet();
            if (this.idpConnection != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.idpConnection);
            }
            if (this.populateAllStatesData != null) {
                tasklet.populateAllStates(this.populateAllStatesData);
            }
            this.setTasklet(tasklet);
        } else {
            ConnectionTasklet connTasklet = this.getParent(ConnectionTasklet.class);
            if (!connTasklet.isDraft()) {
                tasklet.configureTasklet();
            }
        }
    }

    public String getUserRepository() {
        InboundProvisioningTasklet tasklet = this.getTaskletToEdit(InboundProvisioningTasklet.class);
        if (tasklet == null) {
            return NOT_CONFIGURED;
        }
        return tasklet.getUserRepository();
    }

    public boolean isActiveDirectory() {
        boolean activeDirectory = false;
        InboundProvisioningTasklet tasklet = this.getTaskletToEdit(InboundProvisioningTasklet.class);
        if (tasklet != null) {
            activeDirectory = tasklet.getUserRepositoryType() == InboundProvisioningUserRepositoryType.ACTIVE_DIRECTORY;
        }
        return activeDirectory;
    }

    public String getBaseDN() {
        InboundProvisioningTasklet tasklet = this.getTaskletToEdit(InboundProvisioningTasklet.class);
        if (tasklet == null) {
            return NOT_CONFIGURED;
        }
        return tasklet.getBaseDN();
    }

    public String getUserFilter() {
        InboundProvisioningTasklet tasklet = this.getTaskletToEdit(InboundProvisioningTasklet.class);
        if (tasklet == null) {
            return NOT_CONFIGURED;
        }
        return tasklet.getFilter();
    }

    public String getGroupFilter() {
        InboundProvisioningTasklet tasklet = this.getTaskletToEdit(InboundProvisioningTasklet.class);
        if (tasklet == null) {
            return NOT_CONFIGURED;
        }
        return tasklet.getGroupFilter();
    }

    public String getScimDeleteBehavior() {
        InboundProvisioningTasklet tasklet = this.getTaskletToEdit(InboundProvisioningTasklet.class);
        if (tasklet == null) {
            return NOT_CONFIGURED;
        }
        return tasklet.getScimDeleteBehavior();
    }

    public boolean isGroupsEnabled() {
        IdpConnectionConfigTasklet tasklet = this.findParent(IdpConnectionConfigTasklet.class);
        return tasklet != null && tasklet.isInboundProvisioningGroupsEnabled();
    }
}

