/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.fsm.state.impl.TargetApplicationInfoState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.impl.SessionCreationAdapterTasklet;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class InheritableTargetApplicationInfoState
extends TargetApplicationInfoState {
    private boolean overrideTargetApplicationInfo = false;
    private AuthnAdapterInstance adapterInstance;
    private String currentParentId;
    private boolean isDisplayingForFirstTime = true;
    private boolean isFormDirty = false;
    private String storedApplicationName = null;
    private String storedApplicationIconUrl = null;
    private boolean storedOverrideTargetApplicationInfo = false;

    public InheritableTargetApplicationInfoState(Tasklet parent) {
        super(parent);
    }

    @Override
    public void onStateActivated() {
        SessionCreationAdapterTasklet parentTasklet = this.findParent(SessionCreationAdapterTasklet.class);
        if (parentTasklet != null) {
            boolean hasParent = this.hasParentInstance();
            String parentId = this.getParentInstanceId();
            boolean removingParent = !hasParent && this.currentParentId != null;
            boolean addingParent = hasParent && this.currentParentId == null;
            PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
            if (this.adapterInstance == null || removingParent || hasParent) {
                if (removingParent) {
                    ConfigurablePluginInstance tmpInstance = pluginMgr.newInstance();
                    tmpInstance.setParentId(this.currentParentId);
                    this.save(tmpInstance);
                } else if (addingParent) {
                    if (parentTasklet.isNewTasklet() && this.isDisplayingForFirstTime) {
                        this.populateAllFieldsFromParent(parentId, pluginMgr);
                        this.isDisplayingForFirstTime = false;
                    } else {
                        AuthnAdapterInstance tmpInstance = (AuthnAdapterInstance)pluginMgr.newInstance();
                        tmpInstance.setParentId(parentId);
                        this.save(tmpInstance);
                        this.overrideTargetApplicationInfo = true;
                    }
                } else if (hasParent) {
                    if (this.adapterInstance == null) {
                        AuthnAdapterInstance tmpInstance = (AuthnAdapterInstance)pluginMgr.newInstance();
                        tmpInstance.setParentId(parentId);
                        this.save(tmpInstance);
                        this.populateAllFieldsFromParent(parentId, pluginMgr);
                    } else if (!this.overrideTargetApplicationInfo) {
                        this.populateAllFieldsFromParent(parentId, pluginMgr);
                    }
                }
                this.currentParentId = parentId;
            }
        }
    }

    private void populateAllFieldsFromParent(String parentId, PluginManager<?, ?> pluginMgr) {
        AuthnAdapterInstance parentInstance = (AuthnAdapterInstance)pluginMgr.getInstance(parentId);
        String applicationName = ConfigurationUtil.findEffectiveApplicationName((AuthnAdapterInstance)parentInstance);
        this.setApplicationName(applicationName);
        String applicationIconUrlStr = ConfigurationUtil.findEffectiveApplicationIconUrlStr((AuthnAdapterInstance)parentInstance);
        this.setApplicationIconUrlStr(applicationIconUrlStr);
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof AuthnAdapterInstance) {
            this.adapterInstance = (AuthnAdapterInstance)dataFromDisk;
            if (this.hasParentInstance()) {
                this.currentParentId = this.adapterInstance.getParentId();
                this.storedOverrideTargetApplicationInfo = this.overrideTargetApplicationInfo = !this.adapterInstance.isInheritingTargetApplicationInfo();
                if (this.overrideTargetApplicationInfo) {
                    if (this.adapterInstance.getApplicationName() != null) {
                        this.setApplicationName(this.adapterInstance.getApplicationName());
                        this.storedApplicationName = this.adapterInstance.getApplicationName();
                    }
                    if (this.adapterInstance.getApplicationIconUrl() != null) {
                        String applicationIconUrlStr = this.adapterInstance.getApplicationIconUrl().toExternalForm();
                        this.setApplicationIconUrlStr(applicationIconUrlStr);
                        this.storedApplicationIconUrl = applicationIconUrlStr;
                    }
                }
            } else {
                this.overrideTargetApplicationInfo = false;
                if (this.adapterInstance.getApplicationName() != null) {
                    this.setApplicationName(this.adapterInstance.getApplicationName());
                }
                if (this.adapterInstance.getApplicationIconUrl() != null) {
                    this.setApplicationIconUrlStr(this.adapterInstance.getApplicationIconUrl().toExternalForm());
                }
            }
        }
    }

    @Override
    public boolean save(Object dataToSave) {
        if (dataToSave instanceof AuthnAdapterInstance) {
            AuthnAdapterInstance authnAdapterInstance = (AuthnAdapterInstance)dataToSave;
            if (this.hasParentInstance()) {
                if (this.overrideTargetApplicationInfo) {
                    this.saveWithoutInheritance(authnAdapterInstance);
                } else {
                    this.saveWithInheritance(authnAdapterInstance);
                }
            } else {
                this.saveWithoutInheritance(authnAdapterInstance);
            }
        }
        return true;
    }

    private void saveWithInheritance(AuthnAdapterInstance authnAdapterInstance) {
        authnAdapterInstance.setInheritingTargetApplicationInfo(true);
        authnAdapterInstance.setApplicationName(null);
        authnAdapterInstance.setApplicationIconUrl(null);
    }

    private void saveWithoutInheritance(AuthnAdapterInstance authnAdapterInstance) {
        authnAdapterInstance.setInheritingTargetApplicationInfo(false);
        String appName = StringUtils.isNotBlank((String)this.getApplicationName()) ? this.getApplicationName() : null;
        authnAdapterInstance.setApplicationName(appName);
        authnAdapterInstance.setApplicationIconUrl(this.getApplicationIconUrl());
    }

    @Override
    public void reset() {
        super.reset();
        this.overrideTargetApplicationInfo = false;
        this.adapterInstance = null;
        this.isFormDirty = false;
        this.storedApplicationName = null;
        this.storedApplicationIconUrl = null;
        this.storedOverrideTargetApplicationInfo = false;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.hasParentInstance() && this.isFormDirty) {
            if (this.overrideTargetApplicationInfo && this.storedOverrideTargetApplicationInfo) {
                this.setApplicationName(this.storedApplicationName);
                this.setApplicationIconUrlStr(this.storedApplicationIconUrl);
            } else {
                SessionCreationAdapterTasklet parentTasklet = this.findParent(SessionCreationAdapterTasklet.class);
                if (parentTasklet != null) {
                    PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
                    String parentId = this.getParentInstanceId();
                    this.populateAllFieldsFromParent(parentId, pluginMgr);
                }
            }
            this.isFormDirty = false;
        }
    }

    public boolean hasParentInstance() {
        return this.getParentInstanceId() != null;
    }

    private String getParentInstanceId() {
        Tasklet t = this.getParent();
        if (t instanceof PluginInstanceApi) {
            PluginInstanceApi parentTasklet = (PluginInstanceApi)((Object)t);
            return parentTasklet.getParentPluginInstanceId();
        }
        return null;
    }

    public boolean isOverrideTargetApplicationInfo() {
        return this.overrideTargetApplicationInfo;
    }

    public void setOverrideTargetApplicationInfo(boolean overrideTargetApplicationInfo) {
        this.isFormDirty = this.overrideTargetApplicationInfo != overrideTargetApplicationInfo;
        this.overrideTargetApplicationInfo = overrideTargetApplicationInfo;
    }
}

