/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.OAuthOidcDynamicKeysValidator;
import com.pingidentity.admin.api.validator.OAuthOidcKeysBaseValidator;
import com.pingidentity.admin.api.validator.OAuthOidcKeysValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.KeyAlgorithmFilter;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.domain.JWKSEndpointDynamicKeysSetting;
import org.sourceid.oauth20.domain.JWKSEndpointManager;
import org.sourceid.oauth20.domain.JWKSEndpointSetting;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class JWKSEndpointKeysState
extends TaskletState {
    private boolean staticJwksEnabled;
    private Cert p256ActiveCert;
    private Cert p256PreviousCert;
    private boolean p256PublishX5cParameter;
    private String p256ActiveKeyId;
    private String p256PreviousKeyId;
    private Cert p384ActiveCert;
    private Cert p384PreviousCert;
    private boolean p384PublishX5cParameter;
    private String p384ActiveKeyId;
    private String p384PreviousKeyId;
    private Cert p521ActiveCert;
    private Cert p521PreviousCert;
    private boolean p521PublishX5cParameter;
    private String p521ActiveKeyId;
    private String p521PreviousKeyId;
    private Cert rsaActiveCert;
    private Cert rsaPreviousCert;
    private boolean rsaPublishX5cParameter;
    private String rsaActiveKeyId;
    private String rsaPreviousKeyId;
    private Cert p256DecryptionActiveCert;
    private Cert p256DecryptionPreviousCert;
    private boolean p256DecryptionPublishX5cParameter;
    private String p256DecryptionActiveKeyId;
    private String p256DecryptionPreviousKeyId;
    private Cert p384DecryptionActiveCert;
    private Cert p384DecryptionPreviousCert;
    private boolean p384DecryptionPublishX5cParameter;
    private String p384DecryptionActiveKeyId;
    private String p384DecryptionPreviousKeyId;
    private Cert p521DecryptionActiveCert;
    private Cert p521DecryptionPreviousCert;
    private boolean p521DecryptionPublishX5cParameter;
    private String p521DecryptionActiveKeyId;
    private String p521DecryptionPreviousKeyId;
    private Cert rsaDecryptionActiveCert;
    private Cert rsaDecryptionPreviousCert;
    private boolean rsaDecryptionPublishX5cParameter;
    private String rsaDecryptionActiveKeyId;
    private String rsaDecryptionPreviousKeyId;
    private Map<String, String> rsaAlgTypeToActiveKeyIds = null;
    private Map<String, String> rsaAlgTypeToPreviousKeyIds = null;
    private boolean publishCertificates;
    private String certOrgName;
    private String certOrgUnitName;
    private String certCountry;
    private String certState;
    private String certCity;
    private static final Set<KeyAlgorithmFilter> EC_P256_FILTER;
    private static final Set<KeyAlgorithmFilter> EC_P384_FILTER;
    private static final Set<KeyAlgorithmFilter> EC_P521_FILTER;
    private static final Set<KeyAlgorithmFilter> RSA_FILTER;
    private final JWKSEndpointManager jwksEndpointMgr;
    private final PkCertManager pkCertMgr;
    private final BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginMgr;

    public JWKSEndpointKeysState(Tasklet owner) {
        this(owner, MgmtFactory.getJWKSEndpointManager(), MgmtFactory.getDsigPkCertManager(), MgmtFactory.getBearerAccessTokenMgmtPluginMgr());
    }

    public JWKSEndpointKeysState(Tasklet owner, JWKSEndpointManager jwksEndpointMgr, PkCertManager pkCertMgr, BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginMgr) {
        super(owner);
        this.jwksEndpointMgr = jwksEndpointMgr;
        this.pkCertMgr = pkCertMgr;
        this.bearerAccessTokenMgmtPluginMgr = bearerAccessTokenMgmtPluginMgr;
        this.setMenuName("OAuth & OpenID Connect Keys");
    }

    public boolean isP256ActiveCertRequired() {
        return this.isECActiveCertRequired("ES256");
    }

    public boolean isP384ActiveCertRequired() {
        return this.isECActiveCertRequired("ES384");
    }

    public boolean isP521ActiveCertRequired() {
        return this.isECActiveCertRequired("ES512");
    }

    private boolean isECActiveCertRequired(String algorithmName) {
        HashSet<String> algoInUse = new HashSet<String>();
        Iterator iterator = this.bearerAccessTokenMgmtPluginMgr.getInstances().iterator();
        while (iterator.hasNext()) {
            Field jwsAlgorithm;
            Field useCentralizedSigningKey;
            String pluginClassName = "com.pingidentity.pf.access.token.management.plugins.JwtBearerAccessTokenManagementPlugin";
            BearerAccessTokenMgmtPluginInstance instance = (BearerAccessTokenMgmtPluginInstance)iterator.next();
            if (!pluginClassName.equals(instance.getDescriptor().getPluginClassName()) || (useCentralizedSigningKey = instance.getAdminCompositeConfiguration().getField("Use Centralized Signing Key")) == null || !useCentralizedSigningKey.getValueAsBoolean() || (jwsAlgorithm = instance.getConfiguration().getField("JWS Algorithm")) == null) continue;
            algoInUse.add(jwsAlgorithm.getValue());
        }
        return algoInUse.contains(algorithmName);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        OAuthOidcDynamicKeysValidator oAuthOidcDynamicKeysValidator;
        OAuthOidcKeysBaseValidator oauthEncryptionOidcKeysBaseValidator;
        OAuthOidcKeysBaseValidator oauthOidcKeysBaseValidator = new OAuthOidcKeysBaseValidator.Builder(OAuthOidcKeysValidator.StaticKeyType.SIGNING).setStaticJwksEnabled(this.staticJwksEnabled).setP256ActiveCertId(this.p256ActiveCert != null && StringUtils.isNotEmpty((String)this.p256ActiveCert.getId()) ? this.p256ActiveCert.getId() : null).setP256PreviousCertId(this.p256PreviousCert != null && StringUtils.isNotEmpty((String)this.p256PreviousCert.getId()) ? this.p256PreviousCert.getId() : null).setP256PublishX5cParameter(this.p256PublishX5cParameter).setP384ActiveCertId(this.p384ActiveCert != null && StringUtils.isNotEmpty((String)this.p384ActiveCert.getId()) ? this.p384ActiveCert.getId() : null).setP384PreviousCertId(this.p384PreviousCert != null && StringUtils.isNotEmpty((String)this.p384PreviousCert.getId()) ? this.p384PreviousCert.getId() : null).setP384PublishX5cParameter(this.p384PublishX5cParameter).setP521ActiveCertId(this.p521ActiveCert != null && StringUtils.isNotEmpty((String)this.p521ActiveCert.getId()) ? this.p521ActiveCert.getId() : null).setP521PreviousCertId(this.p521PreviousCert != null && StringUtils.isNotEmpty((String)this.p521PreviousCert.getId()) ? this.p521PreviousCert.getId() : null).setP521PublishX5cParameter(this.p521PublishX5cParameter).setRsaActiveCertId(this.rsaActiveCert != null && StringUtils.isNotEmpty((String)this.rsaActiveCert.getId()) ? this.rsaActiveCert.getId() : null).setRsaPreviousCertId(this.rsaPreviousCert != null && StringUtils.isNotEmpty((String)this.rsaPreviousCert.getId()) ? this.rsaPreviousCert.getId() : null).setRsaPublishX5cParameter(this.rsaPublishX5cParameter).setKeysRequiredByJwtAtm(this.bearerAccessTokenMgmtPluginMgr).setP256ActiveKeyId(this.p256ActiveKeyId).setP384ActiveKeyId(this.p384ActiveKeyId).setP521ActiveKeyId(this.p521ActiveKeyId).setRsaActiveKeyId(this.rsaActiveKeyId).setP256PreviousKeyId(this.p256PreviousKeyId).setP384PreviousKeyId(this.p384PreviousKeyId).setP521PreviousKeyId(this.p521PreviousKeyId).setRsaPreviousKeyId(this.rsaPreviousKeyId).setRsaAlgTypesActiveCustomKeyIds(this.rsaAlgTypeToActiveKeyIds).setRsaAlgTypesPreviousCustomKeyIds(this.rsaAlgTypeToPreviousKeyIds).build();
        if (!oauthOidcKeysBaseValidator.validate()) {
            this.recordErrors(oauthOidcKeysBaseValidator.getErrors(), delegate);
        }
        if (!(oauthEncryptionOidcKeysBaseValidator = new OAuthOidcKeysBaseValidator.Builder(OAuthOidcKeysValidator.StaticKeyType.DECRYPTION).setStaticJwksEnabled(this.staticJwksEnabled).setP256ActiveCertId(this.p256DecryptionActiveCert != null && StringUtils.isNotEmpty((String)this.p256DecryptionActiveCert.getId()) ? this.p256DecryptionActiveCert.getId() : null).setP256PreviousCertId(this.p256DecryptionPreviousCert != null && StringUtils.isNotEmpty((String)this.p256DecryptionPreviousCert.getId()) ? this.p256DecryptionPreviousCert.getId() : null).setP256PublishX5cParameter(this.p256DecryptionPublishX5cParameter).setP384ActiveCertId(this.p384DecryptionActiveCert != null && StringUtils.isNotEmpty((String)this.p384DecryptionActiveCert.getId()) ? this.p384DecryptionActiveCert.getId() : null).setP384PreviousCertId(this.p384DecryptionPreviousCert != null && StringUtils.isNotEmpty((String)this.p384DecryptionPreviousCert.getId()) ? this.p384DecryptionPreviousCert.getId() : null).setP384PublishX5cParameter(this.p384DecryptionPublishX5cParameter).setP521ActiveCertId(this.p521DecryptionActiveCert != null && StringUtils.isNotEmpty((String)this.p521DecryptionActiveCert.getId()) ? this.p521DecryptionActiveCert.getId() : null).setP521PreviousCertId(this.p521DecryptionPreviousCert != null && StringUtils.isNotEmpty((String)this.p521DecryptionPreviousCert.getId()) ? this.p521DecryptionPreviousCert.getId() : null).setP521PublishX5cParameter(this.p521DecryptionPublishX5cParameter).setRsaActiveCertId(this.rsaDecryptionActiveCert != null && StringUtils.isNotEmpty((String)this.rsaDecryptionActiveCert.getId()) ? this.rsaDecryptionActiveCert.getId() : null).setRsaPreviousCertId(this.rsaDecryptionPreviousCert != null && StringUtils.isNotEmpty((String)this.rsaDecryptionPreviousCert.getId()) ? this.rsaDecryptionPreviousCert.getId() : null).setRsaPublishX5cParameter(this.rsaDecryptionPublishX5cParameter).setP256ActiveKeyId(this.p256DecryptionActiveKeyId).setP384ActiveKeyId(this.p384DecryptionActiveKeyId).setP521ActiveKeyId(this.p521DecryptionActiveKeyId).setRsaActiveKeyId(this.rsaDecryptionActiveKeyId).setP256PreviousKeyId(this.p256DecryptionPreviousKeyId).setP384PreviousKeyId(this.p384DecryptionPreviousKeyId).setP521PreviousKeyId(this.p521DecryptionPreviousKeyId).setRsaPreviousKeyId(this.rsaDecryptionPreviousKeyId).setSkipRsaValidation(true).build()).validate()) {
            this.recordErrors(oauthEncryptionOidcKeysBaseValidator.getErrors(), delegate);
        }
        if (!(oAuthOidcDynamicKeysValidator = new OAuthOidcDynamicKeysValidator.Builder((com.pingidentity.pf.common.api.validator.error.ValidationErrorFactory)ValidationErrorFactory.getInstance(), this.publishCertificates).certOrgName(this.certOrgName).certCountry(this.certCountry).build()).validate()) {
            this.recordErrors(oAuthOidcDynamicKeysValidator.getErrors(), delegate);
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        JWKSEndpointSetting setting = this.jwksEndpointMgr.getSetting();
        this.staticJwksEnabled = setting.isEnableStaticKeys();
        this.p256ActiveCert = this.pkCertMgr.getPkCert(setting.getP256ActiveId());
        this.p256PreviousCert = this.pkCertMgr.getPkCert(setting.getP256PreviousId());
        this.p256PublishX5cParameter = setting.isP256PublishX5cParameter();
        this.p384ActiveCert = this.pkCertMgr.getPkCert(setting.getP384ActiveId());
        this.p384PreviousCert = this.pkCertMgr.getPkCert(setting.getP384PreviousId());
        this.p384PublishX5cParameter = setting.isP384PublishX5cParameter();
        this.p521ActiveCert = this.pkCertMgr.getPkCert(setting.getP521ActiveId());
        this.p521PreviousCert = this.pkCertMgr.getPkCert(setting.getP521PreviousId());
        this.p521PublishX5cParameter = setting.isP521PublishX5cParameter();
        this.rsaActiveCert = this.pkCertMgr.getPkCert(setting.getRsaActiveId());
        this.rsaPreviousCert = this.pkCertMgr.getPkCert(setting.getRsaPreviousId());
        this.rsaPublishX5cParameter = setting.isRsaPublishX5cParameter();
        this.p256DecryptionActiveCert = this.pkCertMgr.getPkCert(setting.getP256DecryptionActiveId());
        this.p256DecryptionPreviousCert = this.pkCertMgr.getPkCert(setting.getP256DecryptionPreviousId());
        this.p256DecryptionPublishX5cParameter = setting.isP256DecryptionPublishX5cParameter();
        this.p384DecryptionActiveCert = this.pkCertMgr.getPkCert(setting.getP384DecryptionActiveId());
        this.p384DecryptionPreviousCert = this.pkCertMgr.getPkCert(setting.getP384DecryptionPreviousId());
        this.p384DecryptionPublishX5cParameter = setting.isP384DecryptionPublishX5cParameter();
        this.p521DecryptionActiveCert = this.pkCertMgr.getPkCert(setting.getP521DecryptionActiveId());
        this.p521DecryptionPreviousCert = this.pkCertMgr.getPkCert(setting.getP521DecryptionPreviousId());
        this.p521DecryptionPublishX5cParameter = setting.isP521DecryptionPublishX5cParameter();
        this.rsaDecryptionActiveCert = this.pkCertMgr.getPkCert(setting.getRsaDecryptionActiveId());
        this.rsaDecryptionPreviousCert = this.pkCertMgr.getPkCert(setting.getRsaDecryptionPreviousId());
        this.rsaDecryptionPublishX5cParameter = setting.isRsaDecryptionPublishX5cParameter();
        this.p256ActiveKeyId = setting.getP256ActiveKeyId();
        this.p256PreviousKeyId = setting.getP256PreviousKeyId();
        this.p384ActiveKeyId = setting.getP384ActiveKeyId();
        this.p384PreviousKeyId = setting.getP384PreviousKeyId();
        this.p521ActiveKeyId = setting.getP521ActiveKeyId();
        this.p521PreviousKeyId = setting.getP521PreviousKeyId();
        this.rsaActiveKeyId = setting.getRsaActiveKeyId();
        this.rsaPreviousKeyId = setting.getRsaPreviousKeyId();
        this.p256DecryptionActiveKeyId = setting.getP256DecryptionActiveKeyId();
        this.p256DecryptionPreviousKeyId = setting.getP256DecryptionPreviousKeyId();
        this.p384DecryptionActiveKeyId = setting.getP384DecryptionActiveKeyId();
        this.p384DecryptionPreviousKeyId = setting.getP384DecryptionPreviousKeyId();
        this.p521DecryptionActiveKeyId = setting.getP521DecryptionActiveKeyId();
        this.p521DecryptionPreviousKeyId = setting.getP521DecryptionPreviousKeyId();
        this.rsaDecryptionActiveKeyId = setting.getRsaDecryptionActiveKeyId();
        this.rsaDecryptionPreviousKeyId = setting.getRsaDecryptionPreviousKeyId();
        this.rsaAlgTypeToActiveKeyIds = setting.getRsaAlgTypesActiveCustomKeyIds();
        this.rsaAlgTypeToPreviousKeyIds = setting.getRsaAlgTypesPreviousCustomKeyIds();
        this.publishCertificates = setting.getDynamicKeys().isPublishCertificates();
        this.certOrgName = setting.getDynamicKeys().getCertOrgName();
        this.certOrgUnitName = setting.getDynamicKeys().getCertOrgUnitName();
        this.certCountry = setting.getDynamicKeys().getCertCountry();
        this.certState = setting.getDynamicKeys().getCertState();
        this.certCity = setting.getDynamicKeys().getCertCity();
    }

    @Override
    public boolean save(Object dataToDisk) {
        JWKSEndpointSetting setting = new JWKSEndpointSetting();
        if (this.staticJwksEnabled) {
            setting.setEnableStaticKeys(this.staticJwksEnabled);
            if (this.p256ActiveCert != null) {
                setting.setP256ActiveId(this.p256ActiveCert.getId());
            }
            if (this.p256PreviousCert != null) {
                setting.setP256PreviousId(this.p256PreviousCert.getId());
            }
            setting.setP256PublishX5cParameter(this.p256PublishX5cParameter);
            if (this.p384ActiveCert != null) {
                setting.setP384ActiveId(this.p384ActiveCert.getId());
            }
            if (this.p384PreviousCert != null) {
                setting.setP384PreviousId(this.p384PreviousCert.getId());
            }
            setting.setP384PublishX5cParameter(this.p384PublishX5cParameter);
            if (this.p521ActiveCert != null) {
                setting.setP521ActiveId(this.p521ActiveCert.getId());
            }
            if (this.p521PreviousCert != null) {
                setting.setP521PreviousId(this.p521PreviousCert.getId());
            }
            setting.setP521PublishX5cParameter(this.p521PublishX5cParameter);
            if (this.rsaActiveCert != null) {
                setting.setRsaActiveId(this.rsaActiveCert.getId());
                setting.setRsaAlgTypesActiveCustomKeyIds(this.rsaAlgTypeToActiveKeyIds);
            }
            if (this.rsaPreviousCert != null) {
                setting.setRsaPreviousId(this.rsaPreviousCert.getId());
                setting.setRsaAlgTypesPreviousCustomKeyIds(this.rsaAlgTypeToPreviousKeyIds);
            }
            setting.setRsaPublishX5cParameter(this.rsaPublishX5cParameter);
            if (this.p256DecryptionActiveCert != null) {
                setting.setP256DecryptionActiveId(this.p256DecryptionActiveCert.getId());
            }
            if (this.p256DecryptionPreviousCert != null) {
                setting.setP256DecryptionPreviousId(this.p256DecryptionPreviousCert.getId());
            }
            setting.setP256DecryptionPublishX5cParameter(this.p256DecryptionPublishX5cParameter);
            if (this.p384DecryptionActiveCert != null) {
                setting.setP384DecryptionActiveId(this.p384DecryptionActiveCert.getId());
            }
            if (this.p384DecryptionPreviousCert != null) {
                setting.setP384DecryptionPreviousId(this.p384DecryptionPreviousCert.getId());
            }
            setting.setP384DecryptionPublishX5cParameter(this.p384DecryptionPublishX5cParameter);
            if (this.p521DecryptionActiveCert != null) {
                setting.setP521DecryptionActiveId(this.p521DecryptionActiveCert.getId());
            }
            if (this.p521DecryptionPreviousCert != null) {
                setting.setP521DecryptionPreviousId(this.p521DecryptionPreviousCert.getId());
            }
            setting.setP521DecryptionPublishX5cParameter(this.p521DecryptionPublishX5cParameter);
            if (this.rsaDecryptionActiveCert != null) {
                setting.setRsaDecryptionActiveId(this.rsaDecryptionActiveCert.getId());
            }
            if (this.rsaDecryptionPreviousCert != null) {
                setting.setRsaDecryptionPreviousId(this.rsaDecryptionPreviousCert.getId());
            }
            setting.setRsaDecryptionPublishX5cParameter(this.rsaDecryptionPublishX5cParameter);
            setting.setP256ActiveKeyId(this.p256ActiveKeyId);
            setting.setP256PreviousKeyId(this.p256PreviousKeyId);
            setting.setP384ActiveKeyId(this.p384ActiveKeyId);
            setting.setP384PreviousKeyId(this.p384PreviousKeyId);
            setting.setP521ActiveKeyId(this.p521ActiveKeyId);
            setting.setP521PreviousKeyId(this.p521PreviousKeyId);
            setting.setRsaActiveKeyId(this.rsaActiveKeyId);
            setting.setRsaPreviousKeyId(this.rsaPreviousKeyId);
            setting.setP256DecryptionActiveKeyId(this.p256DecryptionActiveKeyId);
            setting.setP256DecryptionPreviousKeyId(this.p256DecryptionPreviousKeyId);
            setting.setP384DecryptionActiveKeyId(this.p384DecryptionActiveKeyId);
            setting.setP384DecryptionPreviousKeyId(this.p384DecryptionPreviousKeyId);
            setting.setP521DecryptionActiveKeyId(this.p521DecryptionActiveKeyId);
            setting.setP521DecryptionPreviousKeyId(this.p521DecryptionPreviousKeyId);
            setting.setRsaDecryptionActiveKeyId(this.rsaDecryptionActiveKeyId);
            setting.setRsaDecryptionPreviousKeyId(this.rsaDecryptionPreviousKeyId);
        } else {
            this.disableStaticJWKSAndClearSettings(setting);
        }
        JWKSEndpointDynamicKeysSetting.Builder builder = new JWKSEndpointDynamicKeysSetting.Builder(this.publishCertificates);
        if (this.publishCertificates) {
            builder = builder.certOrgName(this.certOrgName).certOrgUnitName(this.certOrgUnitName).certCountry(this.certCountry).certState(this.certState).certCity(this.certCity);
        }
        setting.setDynamicKeys(builder.build());
        this.jwksEndpointMgr.save(setting);
        return true;
    }

    @Override
    public void loadTaskletToEdit() {
        CertManagementTasklet tasklet = this.createTasklet(CertManagementTasklet.class);
        tasklet.setCertType(this.getCertType());
        tasklet.setGlobalEditing(true);
        tasklet.setMode(Mode.edit);
        tasklet.populate(null);
        this.loadTasklet(tasklet);
    }

    private void disableStaticJWKSAndClearSettings(JWKSEndpointSetting jwksEndpointSetting) {
        jwksEndpointSetting.setEnableStaticKeys(false);
        jwksEndpointSetting.setP256ActiveId(null);
        jwksEndpointSetting.setP256PreviousId(null);
        jwksEndpointSetting.setP256PublishX5cParameter(false);
        jwksEndpointSetting.setP384ActiveId(null);
        jwksEndpointSetting.setP384PreviousId(null);
        jwksEndpointSetting.setP384PublishX5cParameter(false);
        jwksEndpointSetting.setP521ActiveId(null);
        jwksEndpointSetting.setP521PreviousId(null);
        jwksEndpointSetting.setP521PublishX5cParameter(false);
        jwksEndpointSetting.setRsaActiveId(null);
        jwksEndpointSetting.setRsaPreviousId(null);
        jwksEndpointSetting.setRsaPublishX5cParameter(false);
        jwksEndpointSetting.setP256DecryptionActiveId(null);
        jwksEndpointSetting.setP256DecryptionPreviousId(null);
        jwksEndpointSetting.setP256DecryptionPublishX5cParameter(false);
        jwksEndpointSetting.setP384DecryptionActiveId(null);
        jwksEndpointSetting.setP384DecryptionPreviousId(null);
        jwksEndpointSetting.setP384DecryptionPublishX5cParameter(false);
        jwksEndpointSetting.setP521DecryptionActiveId(null);
        jwksEndpointSetting.setP521DecryptionPreviousId(null);
        jwksEndpointSetting.setP521DecryptionPublishX5cParameter(false);
        jwksEndpointSetting.setRsaDecryptionActiveId(null);
        jwksEndpointSetting.setRsaDecryptionPreviousId(null);
        jwksEndpointSetting.setRsaDecryptionPublishX5cParameter(false);
        jwksEndpointSetting.setRsaAlgTypesActiveCustomKeyIds(null);
        jwksEndpointSetting.setRsaAlgTypesPreviousCustomKeyIds(null);
    }

    public CertificateTypes.ValidTypes getCertType() {
        return CertificateTypes.ValidTypes.dsigSigningCert;
    }

    public PkCertManager getCertManager() {
        return this.pkCertMgr;
    }

    public boolean isStaticJwksEnabled() {
        return this.staticJwksEnabled;
    }

    public void setStaticJwksEnabled(boolean staticJwksEnabled) {
        this.staticJwksEnabled = staticJwksEnabled;
    }

    public Cert getP256ActiveCert() {
        return this.p256ActiveCert;
    }

    public void setP256ActiveCert(Cert selectedCert) {
        this.p256ActiveCert = selectedCert;
        this.p256ActiveKeyId = this.refreshKeyId(this.p256ActiveKeyId, this.p256ActiveCert);
    }

    public Cert getP256PreviousCert() {
        return this.p256PreviousCert;
    }

    public void setP256PreviousCert(Cert selectedCert) {
        this.p256PreviousCert = selectedCert;
        this.p256PreviousKeyId = this.refreshKeyId(this.p256PreviousKeyId, this.p256PreviousCert);
    }

    public boolean isP256PublishX5cParameter() {
        return this.p256PublishX5cParameter;
    }

    public Cert getP384ActiveCert() {
        return this.p384ActiveCert;
    }

    public void setP384ActiveCert(Cert selectedCert) {
        this.p384ActiveCert = selectedCert;
        this.p384ActiveKeyId = this.refreshKeyId(this.p384ActiveKeyId, this.p384ActiveCert);
    }

    public Cert getP384PreviousCert() {
        return this.p384PreviousCert;
    }

    public void setP384PreviousCert(Cert selectedCert) {
        this.p384PreviousCert = selectedCert;
        this.p384PreviousKeyId = this.refreshKeyId(this.p384PreviousKeyId, this.p384PreviousCert);
    }

    public boolean isP384PublishX5cParameter() {
        return this.p384PublishX5cParameter;
    }

    public void setP384PublishX5cParameter(boolean p384PublishX5cParameter) {
        this.p384PublishX5cParameter = p384PublishX5cParameter;
    }

    public void setP256PublishX5cParameter(boolean p256PublishX5cParameter) {
        this.p256PublishX5cParameter = p256PublishX5cParameter;
    }

    public Cert getP521ActiveCert() {
        return this.p521ActiveCert;
    }

    public void setP521ActiveCert(Cert selectedCert) {
        this.p521ActiveCert = selectedCert;
        this.p521ActiveKeyId = this.refreshKeyId(this.p521ActiveKeyId, this.p521ActiveCert);
    }

    public Cert getP521PreviousCert() {
        return this.p521PreviousCert;
    }

    public void setP521PreviousCert(Cert selectedCert) {
        this.p521PreviousCert = selectedCert;
        this.p521PreviousKeyId = this.refreshKeyId(this.p521PreviousKeyId, this.p521PreviousCert);
    }

    public boolean isP521PublishX5cParameter() {
        return this.p521PublishX5cParameter;
    }

    public void setP521PublishX5cParameter(boolean p521PublishX5cParameter) {
        this.p521PublishX5cParameter = p521PublishX5cParameter;
    }

    public Cert getRsaActiveCert() {
        return this.rsaActiveCert;
    }

    public void setRsaActiveCert(Cert selectedCert) {
        this.rsaActiveCert = selectedCert;
        this.rsaActiveKeyId = this.refreshKeyId(this.rsaActiveKeyId, this.rsaActiveCert);
    }

    public Cert getRsaPreviousCert() {
        return this.rsaPreviousCert;
    }

    public void setRsaPreviousCert(Cert selectedCert) {
        this.rsaPreviousCert = selectedCert;
        this.rsaPreviousKeyId = this.refreshKeyId(this.rsaPreviousKeyId, this.rsaPreviousCert);
        if (this.rsaPreviousCert == null) {
            this.rsaAlgTypeToPreviousKeyIds = null;
        }
    }

    public boolean isRsaPublishX5cParameter() {
        return this.rsaPublishX5cParameter;
    }

    public void setRsaPublishX5cParameter(boolean rsaPublishX5cParameter) {
        this.rsaPublishX5cParameter = rsaPublishX5cParameter;
    }

    public Cert getP256DecryptionActiveCert() {
        return this.p256DecryptionActiveCert;
    }

    public void setP256DecryptionActiveCert(Cert p256DecryptionActiveCert) {
        this.p256DecryptionActiveCert = p256DecryptionActiveCert;
        this.p256DecryptionActiveKeyId = this.refreshKeyId(this.p256DecryptionActiveKeyId, this.p256DecryptionActiveCert);
    }

    public Cert getP256DecryptionPreviousCert() {
        return this.p256DecryptionPreviousCert;
    }

    public void setP256DecryptionPreviousCert(Cert p256DecryptionPreviousCert) {
        this.p256DecryptionPreviousCert = p256DecryptionPreviousCert;
        this.p256DecryptionPreviousKeyId = this.refreshKeyId(this.p256DecryptionPreviousKeyId, this.p256DecryptionPreviousCert);
    }

    public boolean isP256DecryptionPublishX5cParameter() {
        return this.p256DecryptionPublishX5cParameter;
    }

    public void setP256DecryptionPublishX5cParameter(boolean p256DecryptionPublishX5cParameter) {
        this.p256DecryptionPublishX5cParameter = p256DecryptionPublishX5cParameter;
    }

    public Cert getP384DecryptionActiveCert() {
        return this.p384DecryptionActiveCert;
    }

    public void setP384DecryptionActiveCert(Cert p384DecryptionActiveCert) {
        this.p384DecryptionActiveCert = p384DecryptionActiveCert;
        this.p384DecryptionActiveKeyId = this.refreshKeyId(this.p384DecryptionActiveKeyId, this.p384DecryptionActiveCert);
    }

    public Cert getP384DecryptionPreviousCert() {
        return this.p384DecryptionPreviousCert;
    }

    public void setP384DecryptionPreviousCert(Cert p384DecryptionPreviousCert) {
        this.p384DecryptionPreviousCert = p384DecryptionPreviousCert;
        this.p384DecryptionPreviousKeyId = this.refreshKeyId(this.p384DecryptionPreviousKeyId, this.p384DecryptionPreviousCert);
    }

    public boolean isP384DecryptionPublishX5cParameter() {
        return this.p384DecryptionPublishX5cParameter;
    }

    public void setP384DecryptionPublishX5cParameter(boolean p384DecryptionPublishX5cParameter) {
        this.p384DecryptionPublishX5cParameter = p384DecryptionPublishX5cParameter;
    }

    public Cert getP521DecryptionActiveCert() {
        return this.p521DecryptionActiveCert;
    }

    public void setP521DecryptionActiveCert(Cert p521DecryptionActiveCert) {
        this.p521DecryptionActiveCert = p521DecryptionActiveCert;
        this.p521DecryptionActiveKeyId = this.refreshKeyId(this.p521DecryptionActiveKeyId, this.p521DecryptionActiveCert);
    }

    public Cert getP521DecryptionPreviousCert() {
        return this.p521DecryptionPreviousCert;
    }

    public void setP521DecryptionPreviousCert(Cert p521DecryptionPreviousCert) {
        this.p521DecryptionPreviousCert = p521DecryptionPreviousCert;
        this.p521DecryptionPreviousKeyId = this.refreshKeyId(this.p521DecryptionPreviousKeyId, this.p521DecryptionPreviousCert);
    }

    public boolean isP521DecryptionPublishX5cParameter() {
        return this.p521DecryptionPublishX5cParameter;
    }

    public void setP521DecryptionPublishX5cParameter(boolean p521DecryptionPublishX5cParameter) {
        this.p521DecryptionPublishX5cParameter = p521DecryptionPublishX5cParameter;
    }

    public Cert getRsaDecryptionActiveCert() {
        return this.rsaDecryptionActiveCert;
    }

    public void setRsaDecryptionActiveCert(Cert rsaDecryptionActiveCert) {
        this.rsaDecryptionActiveCert = rsaDecryptionActiveCert;
        this.rsaDecryptionActiveKeyId = this.refreshKeyId(this.rsaDecryptionActiveKeyId, this.rsaDecryptionActiveCert);
    }

    public Cert getRsaDecryptionPreviousCert() {
        return this.rsaDecryptionPreviousCert;
    }

    public void setRsaDecryptionPreviousCert(Cert rsaDecryptionPreviousCert) {
        this.rsaDecryptionPreviousCert = rsaDecryptionPreviousCert;
        this.rsaDecryptionPreviousKeyId = this.refreshKeyId(this.rsaDecryptionPreviousKeyId, this.rsaDecryptionPreviousCert);
    }

    public boolean isRsaDecryptionPublishX5cParameter() {
        return this.rsaDecryptionPublishX5cParameter;
    }

    public void setRsaDecryptionPublishX5cParameter(boolean rsaDecryptionPublishX5cParameter) {
        this.rsaDecryptionPublishX5cParameter = rsaDecryptionPublishX5cParameter;
    }

    public Set<KeyAlgorithmFilter> getEcP256Filter() {
        return EC_P256_FILTER;
    }

    public Set<KeyAlgorithmFilter> getEcP384Filter() {
        return EC_P384_FILTER;
    }

    public Set<KeyAlgorithmFilter> getEcP521Filter() {
        return EC_P521_FILTER;
    }

    public Set<KeyAlgorithmFilter> getRsaFilter() {
        return RSA_FILTER;
    }

    public String getP256ActiveKeyId() {
        return this.p256ActiveKeyId;
    }

    public void setP256ActiveKeyId(String p256ActiveKeyId) {
        this.p256ActiveKeyId = this.handleEmptyKeyId(p256ActiveKeyId);
    }

    public String getP256PreviousKeyId() {
        return this.p256PreviousKeyId;
    }

    public void setP256PreviousKeyId(String p256PreviousKeyId) {
        this.p256PreviousKeyId = this.handleEmptyKeyId(p256PreviousKeyId);
    }

    public String getP384ActiveKeyId() {
        return this.p384ActiveKeyId;
    }

    public void setP384ActiveKeyId(String p384ActiveKeyId) {
        this.p384ActiveKeyId = this.handleEmptyKeyId(p384ActiveKeyId);
    }

    public String getP384PreviousKeyId() {
        return this.p384PreviousKeyId;
    }

    public void setP384PreviousKeyId(String p384PreviousKeyId) {
        this.p384PreviousKeyId = this.handleEmptyKeyId(p384PreviousKeyId);
    }

    public String getP521ActiveKeyId() {
        return this.p521ActiveKeyId;
    }

    public void setP521ActiveKeyId(String p521ActiveKeyId) {
        this.p521ActiveKeyId = this.handleEmptyKeyId(p521ActiveKeyId);
    }

    public String getP521PreviousKeyId() {
        return this.p521PreviousKeyId;
    }

    public void setP521PreviousKeyId(String p521PreviousKeyId) {
        this.p521PreviousKeyId = this.handleEmptyKeyId(p521PreviousKeyId);
    }

    public String getRsaActiveKeyId() {
        return this.rsaActiveKeyId;
    }

    public void setRsaActiveKeyId(String rsaActiveKeyId) {
        this.rsaActiveKeyId = this.handleEmptyKeyId(rsaActiveKeyId);
    }

    public String getRsaPreviousKeyId() {
        return this.rsaPreviousKeyId;
    }

    public void setRsaPreviousKeyId(String rsaPreviousKeyId) {
        this.rsaPreviousKeyId = this.handleEmptyKeyId(rsaPreviousKeyId);
    }

    public String getP256DecryptionActiveKeyId() {
        return this.p256DecryptionActiveKeyId;
    }

    public void setP256DecryptionActiveKeyId(String p256DecryptionActiveKeyId) {
        this.p256DecryptionActiveKeyId = this.handleEmptyKeyId(p256DecryptionActiveKeyId);
    }

    public String getP256DecryptionPreviousKeyId() {
        return this.p256DecryptionPreviousKeyId;
    }

    public void setP256DecryptionPreviousKeyId(String p256DecryptionPreviousKeyId) {
        this.p256DecryptionPreviousKeyId = this.handleEmptyKeyId(p256DecryptionPreviousKeyId);
    }

    public String getP384DecryptionActiveKeyId() {
        return this.p384DecryptionActiveKeyId;
    }

    public void setP384DecryptionActiveKeyId(String p384DecryptionActiveKeyId) {
        this.p384DecryptionActiveKeyId = this.handleEmptyKeyId(p384DecryptionActiveKeyId);
    }

    public String getP384DecryptionPreviousKeyId() {
        return this.p384DecryptionPreviousKeyId;
    }

    public void setP384DecryptionPreviousKeyId(String p384DecryptionPreviousKeyId) {
        this.p384DecryptionPreviousKeyId = this.handleEmptyKeyId(p384DecryptionPreviousKeyId);
    }

    public String getP521DecryptionActiveKeyId() {
        return this.p521DecryptionActiveKeyId;
    }

    public void setP521DecryptionActiveKeyId(String p521DecryptionActiveKeyId) {
        this.p521DecryptionActiveKeyId = this.handleEmptyKeyId(p521DecryptionActiveKeyId);
    }

    public String getP521DecryptionPreviousKeyId() {
        return this.p521DecryptionPreviousKeyId;
    }

    public void setP521DecryptionPreviousKeyId(String p521DecryptionPreviousKeyId) {
        this.p521DecryptionPreviousKeyId = this.handleEmptyKeyId(p521DecryptionPreviousKeyId);
    }

    public String getRsaDecryptionActiveKeyId() {
        return this.rsaDecryptionActiveKeyId;
    }

    public void setRsaDecryptionActiveKeyId(String rsaDecryptionActiveKeyId) {
        this.rsaDecryptionActiveKeyId = this.handleEmptyKeyId(rsaDecryptionActiveKeyId);
    }

    public String getRsaDecryptionPreviousKeyId() {
        return this.rsaDecryptionPreviousKeyId;
    }

    public void setRsaDecryptionPreviousKeyId(String rsaDecryptionPreviousKeyId) {
        this.rsaDecryptionPreviousKeyId = this.handleEmptyKeyId(rsaDecryptionPreviousKeyId);
    }

    private String refreshKeyId(String keyId, Cert associatedCert) {
        if (associatedCert == null) {
            return null;
        }
        return keyId;
    }

    private String handleEmptyKeyId(String keyId) {
        if (StringUtils.isEmpty((String)keyId)) {
            return null;
        }
        return keyId;
    }

    public boolean isPublishCertificates() {
        return this.publishCertificates;
    }

    public void setPublishCertificates(boolean publishCertificates) {
        this.publishCertificates = publishCertificates;
    }

    public String getCertOrgName() {
        return this.certOrgName;
    }

    public void setCertOrgName(String certOrgName) {
        this.certOrgName = certOrgName;
    }

    public String getCertOrgUnitName() {
        return this.certOrgUnitName;
    }

    public void setCertOrgUnitName(String certOrgUnitName) {
        this.certOrgUnitName = certOrgUnitName;
    }

    public String getCertCountry() {
        return this.certCountry;
    }

    public void setCertCountry(String certCountry) {
        this.certCountry = certCountry;
    }

    public String getCertState() {
        return this.certState;
    }

    public void setCertState(String certState) {
        this.certState = certState;
    }

    public String getCertCity() {
        return this.certCity;
    }

    public void setCertCity(String certCity) {
        this.certCity = certCity;
    }

    static {
        HashSet<KeyAlgorithmFilter> algFilters = new HashSet<KeyAlgorithmFilter>();
        algFilters.add(new KeyAlgorithmFilter.KeyAlgorithmFilterBuilder(CertificateTypes.KeyAlgorithms.EC).setKeySize(256).setRemoveRotatingCerts(true).build());
        EC_P256_FILTER = algFilters;
        algFilters = new HashSet();
        algFilters.add(new KeyAlgorithmFilter.KeyAlgorithmFilterBuilder(CertificateTypes.KeyAlgorithms.EC).setKeySize(384).setRemoveRotatingCerts(true).build());
        EC_P384_FILTER = algFilters;
        algFilters = new HashSet();
        algFilters.add(new KeyAlgorithmFilter.KeyAlgorithmFilterBuilder(CertificateTypes.KeyAlgorithms.EC).setKeySize(521).setRemoveRotatingCerts(true).build());
        EC_P521_FILTER = algFilters;
        algFilters = new HashSet();
        algFilters.add(new KeyAlgorithmFilter.KeyAlgorithmFilterBuilder(CertificateTypes.KeyAlgorithms.RSA).setMinPublicKeySize(2048).setRemoveRotatingCerts(true).build());
        RSA_FILTER = algFilters;
    }
}

