/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.KerberosRealmValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.security.KerberosException;
import com.pingidentity.common.util.KerberosConfigUtil;
import com.pingidentity.common.util.KerberosUtil;
import com.pingidentity.common.util.KerberosUtilFactory;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.KerberosRealmsTasklet;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.KerberosConnectionType;
import org.sourceid.saml20.domain.KerberosKeySet;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class KerberosRealmState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 5L;
    private String id;
    private String kerberosRealmName;
    private String kerberosUsername;
    private String kerberosPassword;
    private boolean retainPreviousKeysOnPasswordChange = true;
    private boolean defaultRealm;
    private boolean successfulKerberosRealmTest;
    private List<String> keyDistributionCenters = new ArrayList<String>();
    private List<KerberosKeySet> kerberosKeySets = new ArrayList<KerberosKeySet>();
    private transient Object componentState;
    private KerberosConnectionType connectionType = KerberosConnectionType.DIRECT;
    private KerberosConnectionType existingConnectionType;
    private StringPairPropertySelectionModel gatewayList = new StringPairPropertySelectionModel();
    private String ldapGatewayDataStoreId = "";
    private boolean suppressDomainNameConcatenation = false;

    public KerberosRealmState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Domain/Realm");
    }

    public KerberosRealmState(IWizard owner, String cardName) {
        super(owner, cardName);
        this.setMenuName("Manage Domain/Realm");
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk != null) {
            KerberosRealm kerberosRealm = (KerberosRealm)dataFromDisk;
            this.id = kerberosRealm.getId();
            this.kerberosRealmName = kerberosRealm.getKerberosRealmName();
            this.kerberosUsername = kerberosRealm.getKerberosUsername();
            this.kerberosPassword = kerberosRealm.getKerberosPassword();
            this.retainPreviousKeysOnPasswordChange = kerberosRealm.isRetainPreviousKeysOnPasswordChange();
            this.keyDistributionCenters = new ArrayList<String>(kerberosRealm.getKeyDistributionCenters());
            this.suppressDomainNameConcatenation = kerberosRealm.isSuppressDomainNameConcatenation();
            this.kerberosKeySets = kerberosRealm.getKeySets();
            this.existingConnectionType = this.connectionType = kerberosRealm.getConnectionType() == null ? KerberosConnectionType.DIRECT : kerberosRealm.getConnectionType();
            this.ldapGatewayDataStoreId = kerberosRealm.getLdapGatewayDatastoreId();
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.validate(delegate, true);
    }

    @Override
    public void onStateActivated() {
        this.successfulKerberosRealmTest = false;
        this.initializeGatewayList();
    }

    public boolean successfulKerberosRealmTest() {
        return this.successfulKerberosRealmTest;
    }

    private void initializeGatewayList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        if (KerberosConnectionType.LDAP_GATEWAY.equals((Object)this.connectionType)) {
            List<StringPairPropertySelectionModel.SPair> pairs = MgmtFactory.getDataSourceManager().getLdapDataSources().stream().filter(LdapDataSource::isGatewayEnabled).map(ds -> new StringPairPropertySelectionModel.SPair(ds.getDsName(), ds.getId())).collect(Collectors.toList());
            model.addAll(pairs);
            model.sort();
        }
        this.gatewayList = model;
    }

    public void testKerberosRealm() {
        this.validate((IValidationDelegate)this.delegate, false);
        if (!this.delegate.getHasErrors()) {
            try {
                KerberosUtil kerberosUtil = KerberosUtilFactory.getKerberosUtil((KerberosRealm)this.getKerberosRealm(), (boolean)false);
                kerberosUtil.testKerberosRealm(this.findParent(KerberosRealmsTasklet.class).getKerberosRealmsSettings(), true);
                this.successfulKerberosRealmTest = true;
            }
            catch (KerberosException ex) {
                this.delegate.setFormComponent(null);
                Object message = ex.getCause() != null && ex.getCause().getMessage() != null ? (ex.getCause().getCause() instanceof UnknownHostException ? "Unknown hostname " + ex.getCause().getMessage().split("\\r?\\n")[0] : ex.getCause().getMessage().split("\\r?\\n")[0]) : ex.getMessage();
                this.log.error(message);
                this.log.debug((Object)ex);
                Object[] params = new String[]{message};
                this.delegate.record(this.getMessage("Error_testing_kerberos_realm", params), ValidationConstraint.REQUIRED);
                this.successfulKerberosRealmTest = false;
            }
        }
    }

    private void validate(IValidationDelegate delegate, boolean updateKeySets) {
        KerberosRealm realm = this.getKerberosRealm();
        KerberosRealmValidator validator = new KerberosRealmValidator.Builder().setKerberosRealmId(realm.getId()).setConnectionType(realm.getConnectionType()).setKerberosRealmName(realm.getKerberosRealmName()).setKerberosUsername(realm.getKerberosUsername()).setKerberosPassword(realm.getKerberosPassword()).setKeyDistributionCenters(KerberosConnectionType.DIRECT.equals((Object)this.connectionType) ? realm.getKeyDistributionCenters() : null).setLdapGatewayDataStoreId(realm.getLdapGatewayDatastoreId()).setRetainPreviousKeysOnPasswordChange(KerberosConnectionType.DIRECT.equals((Object)this.connectionType) || KerberosConnectionType.LOCAL_VALIDATION.equals((Object)this.connectionType) ? Boolean.valueOf(realm.isRetainPreviousKeysOnPasswordChange()) : null).setSuppressDomainNameConcatenation(KerberosConnectionType.DIRECT.equals((Object)this.connectionType) ? Boolean.valueOf(realm.isSuppressDomainNameConcatenation()) : null).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        } else if (this.retainPreviousKeysOnPasswordChange && updateKeySets && (KerberosConnectionType.DIRECT.equals((Object)this.connectionType) || KerberosConnectionType.LOCAL_VALIDATION.equals((Object)this.connectionType))) {
            try {
                MgmtFactory.getKerberosRealmManager().updateKeySets(realm);
                this.kerberosKeySets = realm.getKeySets();
            }
            catch (KerberosException e) {
                this.log.warn((Object)"Failed to retrieve encryption keys for current domain/realm password", (Throwable)e);
                delegate.setFormComponent(null);
                ValidationError error = ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.kerberos_realm_failed_to_save_keys, null);
                delegate.record(error.getMessage(), ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk != null) {
            KerberosRealm kerberosRealm = (KerberosRealm)dataToDisk;
            this.fillKerberosRealm(kerberosRealm);
            if (!this.retainPreviousKeysOnPasswordChange) {
                this.kerberosKeySets = Collections.emptyList();
            }
            this.componentState = null;
        }
        return true;
    }

    void fillKerberosRealm(KerberosRealm kerberosRealm) {
        kerberosRealm.setId(this.id);
        kerberosRealm.setConnectType(this.connectionType);
        kerberosRealm.setKerberosRealmName(this.kerberosRealmName);
        if (KerberosConnectionType.DIRECT.equals((Object)this.connectionType) || KerberosConnectionType.LOCAL_VALIDATION.equals((Object)this.connectionType)) {
            kerberosRealm.setKerberosUsername(this.kerberosUsername);
            kerberosRealm.setKerberosPassword(this.kerberosPassword);
            kerberosRealm.setRetainPreviousKeysOnPasswordChange(this.retainPreviousKeysOnPasswordChange);
            if (this.retainPreviousKeysOnPasswordChange) {
                if (this.connectionType.equals((Object)this.existingConnectionType)) {
                    kerberosRealm.setKeySets(this.kerberosKeySets);
                } else if (this.kerberosKeySets != null && !this.kerberosKeySets.isEmpty()) {
                    this.kerberosKeySets.stream().filter(k -> k.getDeactivatedAt() == null).findFirst().ifPresent(k -> kerberosRealm.setKeySets(Collections.singletonList(k)));
                }
            } else {
                kerberosRealm.setKeySets(new ArrayList());
            }
            if (KerberosConnectionType.DIRECT.equals((Object)this.connectionType)) {
                ArrayList<String> keyDistributionCenters = new ArrayList<String>(this.keyDistributionCenters);
                kerberosRealm.setKeyDistributionCenters(keyDistributionCenters);
                kerberosRealm.setSuppressDomainNameConcatenation(this.suppressDomainNameConcatenation);
            } else {
                kerberosRealm.setKeyDistributionCenters(new ArrayList());
                kerberosRealm.setSuppressDomainNameConcatenation(false);
            }
            kerberosRealm.setLdapGatewayDatastoreId("");
        } else {
            kerberosRealm.setLdapGatewayDatastoreId(this.ldapGatewayDataStoreId);
            kerberosRealm.setKerberosUsername("");
            kerberosRealm.setKerberosPassword("");
            kerberosRealm.setRetainPreviousKeysOnPasswordChange(false);
            kerberosRealm.setKeySets(new ArrayList());
            kerberosRealm.setKeyDistributionCenters(new ArrayList());
            kerberosRealm.setSuppressDomainNameConcatenation(false);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKerberosRealmName() {
        return this.kerberosRealmName;
    }

    public void setKerberosRealmName(String kerberosRealmName) {
        this.kerberosRealmName = StringUtils.trim((String)kerberosRealmName);
    }

    public String getKerberosUsername() {
        return this.kerberosUsername;
    }

    public void setKerberosUsername(String kerberosUsername) {
        this.kerberosUsername = StringUtils.trim((String)kerberosUsername);
    }

    public String getKerberosPassword() {
        return this.kerberosPassword;
    }

    public void setKerberosPassword(String kerberosPassword) {
        this.kerberosPassword = kerberosPassword;
    }

    public boolean isRetainPreviousKeysOnPasswordChange() {
        return this.retainPreviousKeysOnPasswordChange;
    }

    public void setRetainPreviousKeysOnPasswordChange(boolean retainPreviousKeysOnPasswordChange) {
        this.retainPreviousKeysOnPasswordChange = retainPreviousKeysOnPasswordChange;
    }

    public boolean isDefaultRealm() {
        return this.defaultRealm;
    }

    public void setDefaultRealm(boolean defaultRealm) {
        this.defaultRealm = defaultRealm;
    }

    public List<String> getKeyDistributionCenters() {
        return this.keyDistributionCenters;
    }

    public void setKeyDistributionCenters(List<String> keyDistributionCenters) {
        this.keyDistributionCenters = keyDistributionCenters;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public KerberosRealm getKerberosRealm() {
        KerberosRealm kerberosRealm = new KerberosRealm();
        this.fillKerberosRealm(kerberosRealm);
        return kerberosRealm;
    }

    public boolean isAutoGenerateKrb5Conf() {
        return KerberosConfigUtil.isAutoGenerateKrb5ConfFile();
    }

    public void setSuppressDomainNameConcatenation(boolean suppressDomainNameConcatenation) {
        this.suppressDomainNameConcatenation = suppressDomainNameConcatenation;
    }

    public boolean isSuppressDomainNameConcatenation() {
        return this.suppressDomainNameConcatenation;
    }

    public KerberosConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(KerberosConnectionType connectionType) {
        this.connectionType = connectionType;
        if (KerberosConnectionType.LDAP_GATEWAY.equals((Object)connectionType)) {
            this.initializeGatewayList();
        }
    }

    public String getLdapGatewayDataStoreId() {
        return this.ldapGatewayDataStoreId;
    }

    public void setLdapGatewayDataStoreId(String ldapGatewayDataStoreId) {
        this.ldapGatewayDataStoreId = ldapGatewayDataStoreId;
    }

    public StringPairPropertySelectionModel getGatewayList() {
        return this.gatewayList;
    }

    public void setGatewayList(StringPairPropertySelectionModel gatewayList) {
        this.gatewayList = gatewayList;
    }
}

