/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.KerberosRealmState;
import com.pingidentity.fsm.tasklet.Tasklet;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class KerberosRealmTasklet
extends Tasklet {
    private static final long serialVersionUID = 5L;
    KerberosRealmState kerberosRealmState;

    public KerberosRealmTasklet(Visit visit) {
        super("KerberosRealmTasklet", "Manage Domain/Realm");
        this.setSystemVisit(visit);
        this.kerberosRealmState = new KerberosRealmState(this);
        this.setInitialState(this.kerberosRealmState);
        this.setCancelAvailable(true);
        this.setFinishLabel("Save");
    }

    public boolean isInUse() {
        KerberosRealm kerberosRealm = this.kerberosRealmState.getKerberosRealm();
        if (kerberosRealm.getId() != null) {
            KerberosRealmManager kerberosRealmManager = MgmtFactory.getKerberosRealmManager();
            return kerberosRealmManager.isInUse(kerberosRealm);
        }
        return false;
    }

    public KerberosRealm getKerberosRealm() {
        return this.kerberosRealmState.getKerberosRealm();
    }

    public String getDescription() {
        return this.kerberosRealmState.getKerberosRealmName();
    }

    @Override
    public void finish() {
        KerberosRealm kerberosRealm = new KerberosRealm();
        this.save(kerberosRealm);
        MgmtFactory.getKerberosRealmManager().saveKerberosRealm(kerberosRealm);
        this.populate(kerberosRealm);
        super.finish();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }
}

