/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.KerberosRealmTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class KerberosRealmsState
extends TaskletListState
implements Serializable {
    private static final long serialVersionUID = 5L;

    public KerberosRealmsState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Domains/Realms");
    }

    public KerberosRealmsState(IWizard owner, String cardName) {
        super(owner, cardName);
        this.setMenuName("Manage Domains/Realms");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.deleteAllTasklets();
        KerberosRealmManager kerberosRealmManager = MgmtFactory.getKerberosRealmManager();
        for (KerberosRealm kerberosRealm : kerberosRealmManager.getKerberosRealms()) {
            KerberosRealmTasklet kerberosRealmTasklet = this.createTasklet(KerberosRealmTasklet.class);
            kerberosRealmTasklet.setMode(Mode.edit);
            kerberosRealmTasklet.populate(kerberosRealm);
            this.addTasklet(kerberosRealmTasklet);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        for (Tasklet tasklet : this.getTasklets()) {
            KerberosRealmTasklet t = (KerberosRealmTasklet)tasklet;
            if (!t.isItDeleted()) continue;
            MgmtFactory.getKerberosRealmManager().deleteKerberosRealmAndSave(t.getKerberosRealm().getId());
        }
        return super.save(dataToDisk);
    }

    public void delete(String kerberosRealmsToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            KerberosRealmTasklet t = (KerberosRealmTasklet)tasklet;
            if (!t.getDescription().equals(kerberosRealmsToDelete)) continue;
            tasklet.setItDeleted(true);
            return;
        }
    }

    public void undelete(String kerberosRealmsToUndelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            KerberosRealmTasklet t = (KerberosRealmTasklet)tasklet;
            if (!t.getDescription().equals(kerberosRealmsToUndelete)) continue;
            t.setItDeleted(false);
            return;
        }
    }

    public Collection<KerberosRealm> getKerberosRealms() {
        ArrayList<KerberosRealm> kerberosRealms = new ArrayList<KerberosRealm>();
        for (Tasklet tasklet : this.getTasklets()) {
            KerberosRealmTasklet kerberosRealmTasklet = (KerberosRealmTasklet)tasklet;
            kerberosRealms.add(kerberosRealmTasklet.getKerberosRealm());
        }
        return kerberosRealms;
    }

    public boolean kerberosRealmNameExists(String kerberosRealmName, String taskletId) {
        for (Tasklet tasklet : this.getTasklets()) {
            KerberosRealmTasklet t = (KerberosRealmTasklet)tasklet;
            if (!t.getDescription().equals(kerberosRealmName) || t.getTaskletId().equals(taskletId)) continue;
            return true;
        }
        return false;
    }

    public Tasklet getTaskletFromList(String identifier) {
        for (Tasklet tasklet : this.getTasklets()) {
            KerberosRealmTasklet t = (KerberosRealmTasklet)tasklet;
            if (!t.getDescription().equals(identifier)) continue;
            tasklet.initialize();
            return tasklet;
        }
        return null;
    }
}

