/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.PingOneLdapGatewayDataStorePaths;
import com.pingidentity.admin.api.validator.LdapGatewayDataStoreValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.timers.DSEventTimer;
import com.pingidentity.fsm.impl.Wizard;
import com.pingidentity.fsm.state.impl.AdvancedLdapOptionsBinaryAttrsState;
import com.pingidentity.fsm.state.impl.ManageDataSourcesState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.FieldItem;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.AdvancedLdapGatewayOptionsTasklet;
import com.pingidentity.fsm.tasklet.impl.DataSourceTasklet;
import com.pingidentity.lightning.rawldap.internal.ldapsdk.InvalidCredentialException;
import com.pingidentity.lightning.rawldap.internal.ldapsdk.PingOneTunneledLDAPInterface;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.pingonev2.InvalidGatewayCredentialException;
import com.pingidentity.pingonev2.PingOneEnvironment;
import com.pingidentity.pingonev2.PingOneGateway;
import com.pingidentity.templates.mgmt.SaaSLdapTemplateFileManager;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.datasource.info.LdapTypeNotFoundException;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PingOneConnectionsManager;

public class LdapGatewayConfigState
extends TaskletState {
    private static final long serialVersionUID = 20210816L;
    private static final PingOneConnectionsManager connectionsMgr = MgmtFactory.getPingOneConnectionsManager();
    private String id;
    private LdapDataSource ldapDS;
    private boolean maskAttributeValues;
    private Map<String, String> ldapNameToTypeMap;
    private Map<String, String> ldapGatewayToLdapTypeMap = Collections.emptyMap();
    private Map<String, PingOneGateway> gatewayMap;
    private String selectedLdapTypeDesc;
    private Tasklet advancedLdapGatewayOptionsTasklet;
    private StringPairPropertySelectionModel gatewayList;
    private String sourceName;
    private String connectionTestSuccessfulMessage = null;
    private String pingOneConnection;
    private String pingOneEnvironment;
    private String pingOneGateway;
    private String connectionSecurity;
    private transient Object componentState;
    private String testConnectionId;
    private List<FieldItem> targetParameters = new ArrayList<FieldItem>();
    private List<String> binaryAttributes = new ArrayList<String>();
    private List<PingOneGateway.Alert> currentAlerts;

    public LdapGatewayConfigState(Tasklet value) {
        super(value);
        this.setMenuName("LDAP Gateway Configuration");
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        String connectionAndEnvironment = this.targetParameters.get(0).getValue();
        if (StringUtils.isNotBlank((String)connectionAndEnvironment)) {
            String[] split = connectionAndEnvironment.split("\\|");
            String connection = split[0];
            String environment = split[1];
            if (!StringUtils.equals((String)this.pingOneConnection, (String)connection) || !StringUtils.equals((String)this.pingOneEnvironment, (String)environment)) {
                this.pingOneConnection = connection;
                this.pingOneEnvironment = environment;
                this.initializeGatewayList();
                this.pingOneGateway = "";
            }
            if (StringUtils.isEmpty((String)this.pingOneGateway)) {
                this.selectedLdapTypeDesc = null;
                this.connectionSecurity = null;
            }
        } else {
            this.clearPingOneFields();
        }
        if (StringUtils.isNotBlank((String)this.pingOneGateway) && MapUtils.isNotEmpty(this.ldapGatewayToLdapTypeMap)) {
            this.selectedLdapTypeDesc = this.ldapGatewayToLdapTypeMap.get(this.pingOneGateway);
            this.connectionSecurity = this.getConnectionSecurityFromPingOneGateway();
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.ldapDS = (LdapDataSource)dataFromDisk;
        this.pingOneConnection = this.ldapDS.getPingOneConnection();
        this.pingOneEnvironment = this.ldapDS.getPingOneEnvironment();
        this.pingOneGateway = this.ldapDS.getPingOneGateway();
        this.id = this.ldapDS.getId();
        this.maskAttributeValues = this.ldapDS.isMaskAttributeValues();
        this.sourceName = this.ldapDS.getDsName();
        this.binaryAttributes = this.ldapDS.getBinaryAttributes();
        this.connectionSecurity = this.ldapDS.getUseSSL() ? "ssl" : (this.ldapDS.getUseStartTLS() ? "startTls" : "none");
        this.selectedLdapTypeDesc = LdapInfo.LdapType.SunDirectoryServer.getDescription().equals(this.ldapDS.getLdapTypeDesc()) ? "Oracle Directory Server" : this.ldapDS.getLdapTypeDesc();
        SaaSLdapTemplateFileManager templateMgr = SaaSLdapTemplateFileManager.getInstance();
        this.ldapNameToTypeMap = templateMgr.getSaaSLdapTemplateNameToTypeMap();
        this.createAndPopulateAdvancedLdapOptionsTasklet();
    }

    private void initializePingOneEnvironment() {
        this.targetParameters = new ArrayList<FieldItem>();
        PingOneEnvironmentFieldDescriptor environmentFieldDescriptor = new PingOneEnvironmentFieldDescriptor("PingOne Environment", "PingOne Environment");
        environmentFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        FieldItem fieldItem = new FieldItem((FieldDescriptor)environmentFieldDescriptor);
        if (StringUtils.isNotBlank((String)this.pingOneConnection) && StringUtils.isNotBlank((String)this.pingOneEnvironment)) {
            fieldItem.setValue(this.pingOneConnection + "|" + this.pingOneEnvironment);
        }
        this.targetParameters.add(fieldItem);
    }

    @Override
    public void onStateActivated() {
        if (!this.isShowSourceName() && this.getParent() != null && this.getParent() instanceof DataSourceTasklet) {
            this.sourceName = ((DataSourceTasklet)this.getParent()).getSourceName();
        }
        if (!this.isShowMaskLogValues() && this.getParent() != null && this.getParent() instanceof DataSourceTasklet) {
            this.maskAttributeValues = ((DataSourceTasklet)this.getParent()).isMaskAttributeValues();
        }
        this.initializeLdapTypes();
        this.initializeGatewayList();
        this.initializePingOneEnvironment();
        this.validateInitialItems();
        if (StringUtils.isNotBlank((String)this.pingOneGateway)) {
            this.connectionSecurity = this.getConnectionSecurityFromPingOneGateway();
        }
        this.createAndPopulateAdvancedLdapOptionsTasklet();
    }

    private void initializeLdapTypes() {
        this.ldapNameToTypeMap = SaaSLdapTemplateFileManager.getInstance().getSaaSLdapTemplateNameToTypeMap();
    }

    private void initializeGatewayList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(false);
        model.add("-- Select One --", "");
        if (StringUtils.isNotBlank((String)this.pingOneConnection) && StringUtils.isNotBlank((String)this.pingOneEnvironment)) {
            try {
                List gateways = connectionsMgr.getConnection(this.pingOneConnection).getGateways(this.pingOneEnvironment, false);
                List<StringPairPropertySelectionModel.SPair> pairs = gateways.stream().filter(PingOneGateway::isLDAPGateway).map(g -> new StringPairPropertySelectionModel.SPair(g.getName(), g.getId())).collect(Collectors.toList());
                model.addAll(pairs);
                this.gatewayMap = gateways.stream().filter(PingOneGateway::isLDAPGateway).collect(Collectors.toMap(PingOneGateway::getId, Function.identity()));
                this.ldapGatewayToLdapTypeMap = gateways.stream().filter(PingOneGateway::isLDAPGateway).collect(Collectors.toMap(PingOneGateway::getId, g -> this.pingOneVendorToLdapTypeDescription(g.getVendor())));
            }
            catch (InvalidGatewayCredentialException | IOException e) {
                this.log.error((Object)e);
            }
            model.sort();
        }
        this.gatewayList = model;
    }

    private void validateInitialItems() {
        Collection connections = connectionsMgr.getAllConnections();
        try {
            if (CollectionUtils.isEmpty((Collection)connections)) {
                this.recordErrors(Collections.singletonList(ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.ldap_gateway_data_store_no_pingone_connections_configured, PingOneLdapGatewayDataStorePaths.getPingOneConnectionRef())), (IValidationDelegate)this.getParent().getDelegate(this.getParent().getCycle()));
            } else {
                for (PingOneConnection connection : connections) {
                    for (PingOneEnvironment environment : connection.getEnvironments(true)) {
                        for (PingOneGateway gateway : connection.getGateways(environment.getId(), true)) {
                            if (!gateway.isLDAPGateway()) continue;
                            return;
                        }
                    }
                }
                this.recordErrors(Collections.singletonList(ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.ldap_gateway_data_store_no_pingone_ldap_gateways_are_configured, PingOneLdapGatewayDataStorePaths.getPingOneConnectionRef())), (IValidationDelegate)this.getParent().getDelegate(this.getParent().getCycle()));
            }
        }
        catch (InvalidGatewayCredentialException | IOException ex) {
            this.log.error((Object)ex);
        }
    }

    private String pingOneVendorToLdapTypeDescription(String vendor) {
        String description = "Generic";
        if ("Oracle Directory Server Enterprise Edition".equals(vendor)) {
            description = "Oracle Directory Server";
        } else if ("Active Directory".equals(vendor)) {
            description = LdapInfo.LdapType.ActiveDirectory.getDescription();
        } else if ("Oracle Unified Directory".equals(vendor)) {
            description = LdapInfo.LdapType.OracleUnifiedDirectory.getDescription();
        } else if ("PingDirectory".equals(vendor)) {
            description = LdapInfo.LdapType.PingDirectory.getDescription();
        } else if ("OpenDJ Directory Server".equals(vendor)) {
            description = LdapInfo.LdapType.PingDS.getDescription();
        }
        return description;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        LdapGatewayDataStoreValidator validator = this.getValidator();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
        if (StringUtils.isBlank((String)this.sourceName)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
        }
        DataSourceTasklet dataSourceTasklet = this.getParent(DataSourceTasklet.class);
        if (this.isShowSourceName() && dataSourceTasklet.isDuplicate(this.sourceName, this.findParentState(ManageDataSourcesState.class), true)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Instance_name_in_use"), ValidationConstraint.REQUIRED);
        }
    }

    private LdapGatewayDataStoreValidator getValidator() {
        return new LdapGatewayDataStoreValidator.Builder().setId(this.id).setName(this.sourceName).setPingOneConnection(this.pingOneConnection).setPingOneEnvironment(this.pingOneEnvironment).setPingOneGateway(this.pingOneGateway).isAdminUI(true).setIsBypassExternalValidation(true).binaryAttributes(this.binaryAttributes).setCreate(Mode.create.equals((Object)this.getParent().getMode())).build();
    }

    @Override
    public boolean onStateExit() {
        return true;
    }

    private void fillLdapDataSource(LdapDataSource ldap) {
        ldap.setId(this.id);
        ldap.setPingOneConnection(this.pingOneConnection);
        ldap.setPingOneEnvironment(this.pingOneEnvironment);
        ldap.setPingOneGateway(this.pingOneGateway);
        ldap.setUseSSL(this.isUseSsl());
        ldap.setUseStartTLS(this.isUseStartTls());
        ldap.setMaskAttributeValues(this.maskAttributeValues);
        ldap.setDescription(this.sourceName);
        ldap.setDsName(this.sourceName);
        ldap.setLdapTypeDesc(this.selectedLdapTypeDesc);
        ldap.setLdapType(this.processLdapType(this.ldapNameToTypeMap.get(this.selectedLdapTypeDesc)));
        ldap.setBinaryAttributes(this.binaryAttributes);
        ldap.setHost(this.pingOneConnection + ":" + this.pingOneEnvironment + ":" + this.pingOneGateway);
    }

    private LdapInfo.LdapType processLdapType(String type) {
        if ("Oracle Directory Server".equals(type)) {
            return LdapInfo.LdapType.SunDirectoryServer;
        }
        try {
            return LdapInfo.LdapType.canonicalName((String)type);
        }
        catch (LdapTypeNotFoundException e) {
            return LdapInfo.LdapType.Undefined;
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LdapDataSource tempLdap = (LdapDataSource)dataToDisk;
        this.fillLdapDataSource(tempLdap);
        if (this.advancedLdapGatewayOptionsTasklet != null) {
            this.advancedLdapGatewayOptionsTasklet.save(tempLdap);
        }
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("InstanceName"), this.sourceName, this));
        if (this.targetParameters != null && !this.targetParameters.isEmpty()) {
            for (FieldItem parameter : this.targetParameters) {
                if (parameter.isEncrypted()) continue;
                summaryList.add(new SummaryInfo(parameter.getFieldDescriptor().getDescription(), parameter.toString(), this));
            }
        }
        summaryList.add(new SummaryInfo(this.getMessage("PingOneGateway"), this.gatewayList != null ? this.gatewayList.getDescription(this.pingOneGateway) : this.pingOneGateway, this));
        summaryList.add(new SummaryInfo(this.getMessage("Ldap_type"), this.selectedLdapTypeDesc, this));
        if (this.connectionSecurity != null) {
            summaryList.add(new SummaryInfo(this.getMessage("Connection_Security"), this.getConnectionSecurityForDisplay(), this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Mask_attribute_values"), Boolean.toString(this.maskAttributeValues), this));
        Optional.of(this.advancedLdapGatewayOptionsTasklet).map(Wizard::getSourceState).filter(state -> state instanceof AdvancedLdapOptionsBinaryAttrsState).ifPresent(state -> ((AdvancedLdapOptionsBinaryAttrsState)state).doSummary(summaryList));
    }

    public boolean showDataTypeList() {
        return LdapInfo.LdapType.Undefined.toString().equals(this.selectedLdapTypeDesc) || !this.isInUse();
    }

    @Override
    public void loadTaskletToEdit() {
        if (this.advancedLdapGatewayOptionsTasklet == null) {
            this.createAndPopulateAdvancedLdapOptionsTasklet();
        }
        this.advancedLdapGatewayOptionsTasklet.setCurrentState(this.advancedLdapGatewayOptionsTasklet.getInitialState());
        this.loadTasklet(this.advancedLdapGatewayOptionsTasklet);
    }

    private void createAndPopulateAdvancedLdapOptionsTasklet() {
        if (this.advancedLdapGatewayOptionsTasklet == null) {
            String taskletName = "AdvancedLdapGatewayOptionsTasklet";
            String menuName = "Advanced LDAP Gateway Options";
            AdvancedLdapGatewayOptionsTasklet tasklet = this.createTaskletToLoad(AdvancedLdapGatewayOptionsTasklet.class, taskletName, menuName);
            tasklet.setMode(Mode.edit);
            tasklet.populate(null);
            this.advancedLdapGatewayOptionsTasklet = tasklet;
        }
        this.advancedLdapGatewayOptionsTasklet.populate(this.ldapDS);
    }

    private boolean isInUse() {
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
        return dsMgr.isInUse((DataSource)this.getLdapDS()) || moduleSupport.isDataSourceInUse((DataSource)this.getLdapDS());
    }

    public LdapDataSource getLdapDS() {
        return this.ldapDS;
    }

    public void setLdapDS(LdapDataSource ldapDS) {
        this.ldapDS = ldapDS;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isMaskAttributeValues() {
        return this.maskAttributeValues;
    }

    public void setMaskAttributeValues(boolean maskAttributeValues) {
        this.maskAttributeValues = maskAttributeValues;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getSelectedLdapTypeDesc() {
        return this.selectedLdapTypeDesc;
    }

    public void setSelectedLdapTypeDesc(String selectedLdapTypeDesc) {
        this.selectedLdapTypeDesc = LdapInfo.LdapType.SunDirectoryServer.getDescription().equals(selectedLdapTypeDesc) ? "Oracle Directory Server" : selectedLdapTypeDesc;
    }

    public String getPingOneConnection() {
        return this.pingOneConnection;
    }

    public void setPingOneConnection(String pingOneConnection) {
        this.pingOneConnection = pingOneConnection;
    }

    public String getPingOneEnvironment() {
        return this.pingOneEnvironment;
    }

    public void setPingOneEnvironment(String pingOneEnvironment) {
        this.pingOneEnvironment = pingOneEnvironment;
    }

    public String getPingOneGateway() {
        return this.pingOneGateway;
    }

    public void setPingOneGateway(String pingOneGateway) {
        this.pingOneGateway = pingOneGateway;
    }

    public StringPairPropertySelectionModel getGatewayList() {
        return this.gatewayList;
    }

    public void setGatewayList(StringPairPropertySelectionModel gatewayList) {
        this.gatewayList = gatewayList;
    }

    public boolean isShowSourceName() {
        return this.getParent().getMode() == Mode.edit;
    }

    public boolean isShowMaskLogValues() {
        return this.getParent().getMode() == Mode.edit;
    }

    public String getConnectionSecurityForDisplay() {
        if (this.connectionSecurity == null) {
            return null;
        }
        if (this.isUseSsl()) {
            return "LDAPS";
        }
        if (this.isUseStartTls()) {
            return "StartTLS";
        }
        return "None";
    }

    public void setConnectionSecurityForDisplay(String connectionSecurityForDisplay) {
        this.connectionSecurity = connectionSecurityForDisplay == null ? null : ("LDAPS".equals(connectionSecurityForDisplay) ? "ssl" : ("StartTLS".equals(connectionSecurityForDisplay) ? "startTls" : "none"));
    }

    public void testLdapConnection() {
        LdapGatewayDataStoreValidator validator = this.getValidator();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), (IValidationDelegate)this.delegate);
        } else {
            PingOneConnectionsManager connectionsMgr = MgmtFactory.getPingOneConnectionsManager();
            String credential = connectionsMgr.getConnection(this.pingOneConnection).getCredential();
            UUID envID = UUID.fromString(this.pingOneEnvironment);
            UUID gatewayID = UUID.fromString(this.pingOneGateway);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            String host = this.pingOneConnection + ":" + this.pingOneEnvironment + ":" + this.pingOneGateway;
            try (DSEventTimer ignored = DSEventTimer.getLdapInstance((String)this.id, (String)host, (String)"test-connection", null);){
                PingOneTunneledLDAPInterface ldapInterface = new PingOneTunneledLDAPInterface((HttpClient)HttpConnectionPoolingManager.getInstance().getDefaultClient(), credential, envID, gatewayID);
                ldapInterface.getRootDSE();
                LDAPUtil.logGatewayAlerts((List)this.gatewayMap.get(this.pingOneGateway).getCurrentAlerts(), (String)this.pingOneGateway);
            }
            catch (InvalidCredentialException | LDAPException e) {
                ValidationError validationError = ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.data_store_communication_failed, null);
                errors.add(validationError);
                this.log.error((Object)e);
            }
            this.connectionTestSuccessfulMessage = null;
            if (CollectionUtils.isNotEmpty(errors)) {
                this.recordErrors(errors, (IValidationDelegate)this.delegate);
            } else {
                LDAPUtil.doAdminAuditLogging((String)host);
                List alerts = this.gatewayMap.get(this.pingOneGateway).getCurrentAlerts();
                this.setConnectionTestSuccessfulMessage("Connectivity test was successful.");
                this.setCurrentAlerts(alerts);
            }
        }
    }

    public String getConnectionTestSuccessfulMessage() {
        return this.connectionTestSuccessfulMessage;
    }

    public void setConnectionTestSuccessfulMessage(String message) {
        this.connectionTestSuccessfulMessage = message;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public String getTestConnectionId() {
        return this.testConnectionId;
    }

    public void setTestConnectionId(String testConnectionId) {
        this.testConnectionId = testConnectionId;
    }

    public List<PingOneGateway.Alert> getCurrentAlerts() {
        return this.currentAlerts;
    }

    public void setCurrentAlerts(List<PingOneGateway.Alert> currentAlerts) {
        this.currentAlerts = currentAlerts;
    }

    public boolean isDisableForAuditor() {
        return this.getCurrentUser().isAuditor();
    }

    @Override
    public void cancel(Object newData) {
        super.cancel(newData);
        this.setComponentState(null);
    }

    public List<FieldItem> getTargetParameters() {
        return this.targetParameters;
    }

    public void setTargetParameters(List<FieldItem> targetParameters) {
        this.targetParameters = targetParameters;
    }

    public void clearSelectionFilterValue() {
        this.clearPingOneFields();
        this.initializePingOneEnvironment();
        this.initializeGatewayList();
    }

    private void clearPingOneFields() {
        this.pingOneConnection = null;
        this.pingOneEnvironment = null;
        this.pingOneGateway = null;
        this.selectedLdapTypeDesc = null;
        this.connectionSecurity = null;
    }

    private boolean isUseSsl() {
        return "ssl".equals(this.connectionSecurity);
    }

    private boolean isUseStartTls() {
        return "startTls".equals(this.connectionSecurity);
    }

    private String getConnectionSecurityFromPingOneGateway() {
        PingOneGateway gateway = this.gatewayMap.get(this.pingOneGateway);
        if (gateway == null) {
            return null;
        }
        if ("TLS".equals(gateway.getConnectionSecurity())) {
            return "ssl";
        }
        if ("StartTLS".equals(gateway.getConnectionSecurity())) {
            return "startTls";
        }
        return "none";
    }
}

