/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AbstractPolicyContractMappingTasklet;
import com.pingidentity.fsm.state.impl.AbstractPolicyState;
import com.pingidentity.fsm.state.impl.AuthnPoliciesState;
import com.pingidentity.fsm.state.impl.BaseConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityAttributeSourceState;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityBranchUtil;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityInboundMappingState;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityIssuanceCriteriaState;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityOutboundContractMappingState;
import com.pingidentity.fsm.state.impl.localidentity.RegistrationConfigState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class LocalIdentityProfileMappingTasklet
extends AbstractPolicyContractMappingTasklet
implements AttributeNamesApi {
    private static final long serialVersionUID = 1828482L;
    private final LocalIdentityOutboundContractMappingState localIdentityOutboundContractMappingState;
    private final LocalIdentityInboundMappingState localIdentityInboundMappingState;
    private final LocalIdentityIssuanceCriteriaState localIdentityIssuanceCriteriaState;
    private final SummaryCardState summaryCardState;
    private List<String> contractsToFulfill;
    private List<String> localIdentityFields;
    private AbstractPolicyState state;
    private LocalIdentityMappingAction localIdentityMappingAction;
    private boolean isInboundMappingNeeded;
    private transient LocalIdentityBranchUtil branchUtil;

    public LocalIdentityProfileMappingTasklet(Visit visit) {
        super("LocalIdentityProfileMappingTasklet", "Mapping Configuration");
        this.setSystemVisit(visit);
        this.localIdentityInboundMappingState = new LocalIdentityInboundMappingState(this);
        this.localIdentityOutboundContractMappingState = new LocalIdentityOutboundContractMappingState(this);
        this.localIdentityIssuanceCriteriaState = new LocalIdentityIssuanceCriteriaState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.setCancelAvailable(true);
        this.reconfigureTransitions(visit.getCurrentState());
    }

    public void configureTasklet(LocalIdentityProfile profile) {
        if (profile.isRegistrationEnabled() || profile.isProfileEnabled()) {
            this.isInboundMappingNeeded = true;
            this.setMenuName("Inbound Mapping & Contract Fulfillment");
            this.setInitialState(this.localIdentityInboundMappingState);
        } else {
            this.isInboundMappingNeeded = false;
            this.setMenuName("Contract Fulfillment");
            this.setInitialState(this.configAttributeSourcesState);
        }
        this.reconfigureTransitions(this.getSystemVisit().getCurrentState());
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        if (!(curState instanceof AuthnPoliciesState) && !(curState instanceof RegistrationConfigState)) {
            this.clearAllStatesOutgoingTransitions(curState);
        }
        this.localIdentityInboundMappingState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configAttributeSourcesState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return LocalIdentityProfileMappingTasklet.this.isInboundMappingNeeded;
            }
        });
        this.configAttributeSourcesState.addOutgoingTransition(this, this.localIdentityOutboundContractMappingState);
        this.localIdentityOutboundContractMappingState.addOutgoingTransition(this, this.localIdentityIssuanceCriteriaState);
        this.localIdentityIssuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    public List<String> getContractToFulfill() {
        return this.contractsToFulfill;
    }

    public List<String> getLocalIdentityFields() {
        return this.localIdentityFields;
    }

    public void setLocalIdentityFields(List<String> localIdentityFields) {
        this.localIdentityFields = localIdentityFields;
    }

    public void setContractToFulfill(List<String> contracts) {
        this.contractsToFulfill = contracts;
    }

    public AsUiAction getSelectedUiAction() {
        return (AsUiAction)this.getSelectedNode().getData();
    }

    @Override
    public BaseConfigAttributeSourcesState constructConfigAttributeSourcesState() {
        return new LocalIdentityAttributeSourceState(this, "configAttributeSources");
    }

    @Override
    public Collection<String> getAdditionalInputAttributesForFilter() {
        DataMap.Sources sources = new DataMap.Sources();
        this.getUpstreamSources(sources);
        this.addLipToPropertySelectionSources(sources);
        this.addExtendedPropertiesToSelectionSources(sources);
        this.addContextToSelectionSources(sources);
        return sources.getValidSubstituterValues().keySet();
    }

    @Override
    public void cancel() {
        Object origData = this.getPopulateData();
        if (origData != null) {
            LocalIdentityMappingAction mappingAction = (LocalIdentityMappingAction)origData;
            super.cancel();
            this.setPopulateData(mappingAction);
        } else {
            super.cancel();
        }
    }

    @Override
    public void finish() {
        LocalIdentityMappingAction mappingAction = new LocalIdentityMappingAction();
        mappingAction.setInboundAttributeMapping(new AttributeMapping());
        mappingAction.setOutboundAttributeMapping(new AttributeMapping());
        this.save(mappingAction);
        this.setPopulateData(mappingAction);
        super.finish();
        this.state.getNodeIdsWithMappingErrors().remove(((AsUiAction)this.getSelectedNode().getData()).getNodeId());
    }

    public void setState(AbstractPolicyState state) {
        this.state = state;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    public LocalIdentityAttributeSourceState getLipAttributeSourceState() {
        return (LocalIdentityAttributeSourceState)this.configAttributeSourcesState;
    }

    public LocalIdentityOutboundContractMappingState getLocalIdentityOutboundContractMappingState() {
        return this.localIdentityOutboundContractMappingState;
    }

    public LocalIdentityInboundMappingState getLocalIdentityInboundMappingState() {
        return this.localIdentityInboundMappingState;
    }

    public LocalIdentityIssuanceCriteriaState getLocalIdentityIssuanceCriteriaState() {
        return this.localIdentityIssuanceCriteriaState;
    }

    public LocalIdentityMappingAction getLocalIdentityMappingAction() {
        return this.localIdentityMappingAction;
    }

    public void setLocalIdentityMappingAction(LocalIdentityMappingAction localIdentityMappingAction) {
        this.localIdentityMappingAction = localIdentityMappingAction;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.localIdentityMappingAction = (LocalIdentityMappingAction)dataFromDisk;
        super.populate(dataFromDisk);
    }

    public AttributeMapping getInboundAttributeMapping() {
        if (this.getLocalIdentityInboundMappingState() != null) {
            return this.getLocalIdentityInboundMappingState().getAttributeMapping();
        }
        return null;
    }

    public AttributeMapping getOutboundAttributeMapping() {
        if (this.getLocalIdentityOutboundContractMappingState() != null && this.getLocalIdentityOutboundContractMappingState().getModel() != null) {
            return this.getLocalIdentityOutboundContractMappingState().getModel().getMapping();
        }
        return null;
    }

    public void setBranchUtil(LocalIdentityBranchUtil branchUtil) {
        this.branchUtil = branchUtil;
        this.localIdentityInboundMappingState.setDescription();
    }

    public LocalIdentityBranchUtil getBranchUtil() {
        return this.branchUtil;
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return new HashSet<String>(this.contractsToFulfill);
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.contractsToFulfill;
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return null;
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return null;
    }

    public void addLipToPropertySelectionSources(DataMap.Sources sources) {
        String selectedLipId = this.getSelectedUiAction().getSelectedOption().getId();
        StringPairPropertySelectionModel propSelectionModel = new StringPairPropertySelectionModel(true);
        LocalIdentityManager localIdentityManager = MgmtFactory.getLocalIdentityProfileManager();
        LocalIdentityProfile lip = localIdentityManager.getProfile(selectedLipId);
        FieldConfig fieldConfig = lip.getFieldConfig();
        if (fieldConfig != null && !fieldConfig.getListOfAllFields().isEmpty()) {
            List<String> fieldIDs = this.getLipFieldIdLabels(fieldConfig);
            String[] arr = new String[fieldIDs.size()];
            propSelectionModel.addAllStrings(fieldIDs.toArray(arr));
            propSelectionModel.sort();
            String selectionLabel = this.getTypeLabel(AsActionOption.Type.LOCAL_IDENTITY_PROFILE) + this.getLabel(this.getSelectedUiAction().getSelectedOption());
            sources.addPropertySelectionSource("Local Account", selectedLipId, selectionLabel, propSelectionModel, "localidentity.");
        }
    }

    private List<String> getLipFieldIdLabels(FieldConfig fieldConfig) {
        List fields = fieldConfig.getListOfAllFields();
        return fields.stream().map(field -> field.getData().getId()).collect(Collectors.toList());
    }
}

