/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionExpirationData;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MetadataUpdateScheduleManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class MetadataLifetimeState
extends TaskletState {
    private static final long serialVersionUID = 20071023L;
    private String cacheDuration;
    private String metadataRefreshDelay;

    public MetadataLifetimeState(IWizard owner) {
        super(owner);
        this.setMenuName("Metadata Lifetime");
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        MetadataUpdateScheduleManager metadataScheduleMgr = MgmtFactory.getMetadataUpdateScheduleManager();
        if (localSettings != null) {
            Long refreshDelay;
            ConnectionExpirationData connExpirationData = localSettings.getConnectionExpirationData();
            if (connExpirationData != null) {
                this.cacheDuration = String.valueOf(connExpirationData.getCacheDuration());
            }
            if ((refreshDelay = metadataScheduleMgr.getMetadataRefreshDelay()) != null) {
                this.metadataRefreshDelay = refreshDelay.toString();
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalSettings localSettings = (LocalSettings)dataToDisk;
        MetadataUpdateScheduleManager metadataScheduleMgr = MgmtFactory.getMetadataUpdateScheduleManager();
        ConnectionExpirationData connExpirationData = new ConnectionExpirationData();
        Long convertedCacheDuration = Long.valueOf(this.cacheDuration);
        connExpirationData.setCacheDuration(convertedCacheDuration.intValue());
        Long existingRefreshDelay = metadataScheduleMgr.getMetadataRefreshDelay();
        Long updatedRefreshDelay = Long.valueOf(this.metadataRefreshDelay);
        if (existingRefreshDelay != null && updatedRefreshDelay != null && !existingRefreshDelay.equals(updatedRefreshDelay)) {
            metadataScheduleMgr.reload();
        }
        localSettings.setConnectionExpirationData(connExpirationData);
        metadataScheduleMgr.saveMetadataRefreshDelay(updatedRefreshDelay);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.appendRequiredError(delegate, this.cacheDuration, "Cache_duration_required");
        this.appendGreaterThanZeroError(delegate, this.cacheDuration, "Cache_duration_illegal_value");
        this.appendRequiredError(delegate, this.metadataRefreshDelay, "Metadata_refresh_delay_required");
        this.appendGreaterThanZeroError(delegate, this.metadataRefreshDelay, "Metadata_refresh_delay_illegal_value");
    }

    private void appendGreaterThanZeroError(IValidationDelegate delegate, String field, String validationErrorKey) {
        if (!MetadataLifetimeState.isValidIntFromStringGreaterThanZero(field)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage(validationErrorKey), ValidationConstraint.REQUIRED);
        }
    }

    private void appendRequiredError(IValidationDelegate delegate, String field, String validationErrorKey) {
        if (StringUtils.isEmpty((String)field)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage(validationErrorKey), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (!StringUtils.isEmpty((String)this.cacheDuration)) {
            summaryList.add(new SummaryInfo("Cache Duration", this.cacheDuration, this));
            summaryList.add(new SummaryInfo("Refresh Delay", this.metadataRefreshDelay, this));
        }
    }

    public static boolean isValidIntFromStringGreaterThanZero(String value) {
        if (!MetadataLifetimeState.isValidIntFromString(value)) {
            return false;
        }
        return Integer.parseInt(value) > 0;
    }

    public static boolean isValidIntFromString(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return false;
        }
        try {
            Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public String getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(String cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    public String getMetadataRefreshDelay() {
        return this.metadataRefreshDelay;
    }

    public void setMetadataRefreshDelay(String metadataRefreshDelay) {
        this.metadataRefreshDelay = metadataRefreshDelay;
    }

    @Override
    public void reset() {
        this.populate(null);
    }
}

