/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.SigningCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;

public class MetadataSigningState
extends SigningCertState {
    private static final long serialVersionUID = 1L;
    private boolean signMetadata;

    public MetadataSigningState(Tasklet owner) {
        super(owner);
        this.certType = CertificateTypes.ValidTypes.dsigSigningCert;
        this.setMenuName("Metadata Signing");
        this.setIncludeKeyInfoVisible(false);
        this.setCertRequired(false);
    }

    public boolean isSignMetadata() {
        return this.signMetadata;
    }

    public void setSignMetadata(boolean signMetadata) {
        this.signMetadata = signMetadata;
    }

    @Override
    public void setSelectedCert(Cert selectedCert) {
        super.setSelectedCert(selectedCert);
        this.setIncludeKeyInfoVisible(selectedCert != null);
    }

    @Override
    public boolean save(Object dataToDisk) {
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.getSelectedCert() == null) {
            summaryList.add(new SummaryInfo(this.getMessage("Signing_cert_label"), "None", this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Signing_cert_label"), this.getSelectedCert().getDescriptionForDisplay(), this));
            summaryList.add(new SummaryInfo(this.getMessage("Include_key_info"), new Boolean(this.isIncludeKeyInfo()).toString(), this));
            summaryList.add(new SummaryInfo(this.getMessage("Include_key_value"), new Boolean(this.isIncludeKeyValue()).toString(), this));
            summaryList.add(new SummaryInfo(this.getMessage("Signing_algorithm"), this.getSelectedSigningAlgTypeForSummary(), this));
        }
    }

    @Override
    public boolean isShowSecondaryCertDropDown() {
        return false;
    }

    @Override
    protected boolean isActivatable() {
        return false;
    }
}

