/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.MetadataSignatureValidator;
import com.pingidentity.admin.api.validator.MetadataValidator;
import com.pingidentity.fsm.state.impl.ImportCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.MetadataUrlCertTasklet;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.mgmt.impl.MetadataUpdateTaskHelper;

public class MetadataUrlImportCertState
extends ImportCertState {
    private static final long serialVersionUID = 1L;
    MetadataSignatureValidator mdSigValidator = null;

    public MetadataUrlImportCertState(Tasklet value) {
        super(value);
        this.setMenuName("Import Certificate");
        this.setCertType(CertificateTypes.ValidTypes.dsigVerificationCert);
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        super.formListener(cycle);
        String errorMessage = this.getErrorMessage();
        if (StringUtils.isBlank((String)errorMessage) && this.getFileName() != null && this.getFileName().length() > 0 && this.getCert() != null) {
            MetadataUrlCertTasklet metadataUrlCertTasklet = this.findParent(MetadataUrlCertTasklet.class);
            XmlObject metadataXml = metadataUrlCertTasklet.getMetadataXml();
            if (metadataXml == null) {
                metadataXml = this.getMetadataXml();
            }
            if (metadataXml != null) {
                this.mdSigValidator = new MetadataSignatureValidator(metadataXml, true, this.getCert(), null, null);
                if (!this.mdSigValidator.validate()) {
                    this.setRequired(this.mdSigValidator.getSigVerifier().hasSignature());
                    this.recordError(((ValidationError)this.mdSigValidator.getErrors().iterator().next()).getMessage());
                } else {
                    metadataUrlCertTasklet.updateSigningCert(this.getCert(), this.mdSigValidator.getSigVerifier().isCertChainValid(), false);
                }
            }
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    private XmlObject getMetadataXml() {
        MetadataUrlCertTasklet metadataUrlCertTasklet = this.findParent(MetadataUrlCertTasklet.class);
        String metadataUrl = metadataUrlCertTasklet.getUrl();
        InputStream metadataStream = null;
        try {
            metadataStream = MetadataUpdateTaskHelper.downloadMetadataFromUrl((String)metadataUrl);
        }
        catch (ValidationException e) {
            this.recordError(e.getMessage());
        }
        if (metadataStream != null) {
            MetadataValidator metadataValidator = new MetadataValidator(null, null, metadataStream, false, null, null, null);
            metadataValidator.setValidateAllConnection(false);
            metadataValidator.validate();
            if (metadataValidator.hasErrors()) {
                this.recordError(this.getMessage("Metadata_url_invalid", new Object[]{metadataUrl}));
            }
            return metadataValidator.getMetadataXml();
        }
        return null;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        MetadataUrlCertTasklet metadataUrlCertTasklet = this.findParent(MetadataUrlCertTasklet.class);
        if (metadataUrlCertTasklet.isCertUpdated()) {
            summaryList.add(new SummaryInfo("Trusted", String.valueOf(metadataUrlCertTasklet.isCertTrusted()), this));
            super.doSummary(summaryList);
        }
    }

    public MetadataSignatureValidator getMetadataSignatureValidator() {
        return this.mdSigValidator;
    }
}

