/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.MetadataSignatureValidator;
import com.pingidentity.admin.api.validator.MetadataUrlValidator;
import com.pingidentity.admin.api.validator.MetadataValidator;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.MetadataUrlCertsState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.MetadataUrlCertItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.MetadataUrlCertTasklet;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.saml20.domain.mgmt.impl.MetadataUpdateTaskHelper;

public class MetadataUrlState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "URL";
    private String id;
    private String url;
    private String name;
    private String originalUrl = null;
    private transient XmlSignatureVerifier signatureVerifier;
    private boolean validateSignature = true;
    private boolean oldValidateSignature = true;
    private boolean loaded = false;

    public MetadataUrlState(IWizard parent) {
        super(parent);
        this.setMenuName(TITLE);
        this.id = IDGenerator.rndAlphaNumeric((int)25);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = StringUtils.isNotBlank((String)url) ? url.trim() : url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isValidateSignature() {
        return this.validateSignature;
    }

    public void setValidateSignature(boolean validateSignature) {
        this.validateSignature = validateSignature;
    }

    @Override
    public void appendErrors(IValidationDelegate validationDelegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isEmpty((String)this.url)) {
            this.recordErrorMsg(this.getMessage("no_metadata_URL"));
        } else if (this.hasMetadataUrlChanged() && !this.loaded) {
            this.recordErrorMsg(this.getMessage("load_from_URL"));
        }
    }

    private boolean hasMetadataUrlChanged() {
        if (StringUtils.isEmpty((String)this.originalUrl)) {
            return this.url != null;
        }
        if (this.url != null) {
            return !this.originalUrl.equals(this.url);
        }
        return false;
    }

    @Override
    public void populate(Object dataFromDisk) {
        MetadataUrlCertItem metadataUrlCertItem = (MetadataUrlCertItem)dataFromDisk;
        this.id = metadataUrlCertItem.getId();
        this.name = metadataUrlCertItem.getName();
        this.url = metadataUrlCertItem.getUrl();
        this.validateSignature = metadataUrlCertItem.isValidateSignature();
        this.setCert(metadataUrlCertItem.getCert(), false);
        this.loaded = false;
        this.originalUrl = this.url;
        this.signatureVerifier = null;
        this.oldValidateSignature = this.validateSignature;
    }

    @Override
    public boolean save(Object dataToDisk) {
        MetadataUrlCertItem metadataUrlCertItem = (MetadataUrlCertItem)dataToDisk;
        metadataUrlCertItem.setId(this.id);
        metadataUrlCertItem.setName(this.name);
        metadataUrlCertItem.setUrl(this.url);
        metadataUrlCertItem.setCert(this.getCert());
        metadataUrlCertItem.setValidateSignature(this.validateSignature);
        this.originalUrl = this.url;
        this.signatureVerifier = null;
        this.oldValidateSignature = this.validateSignature;
        return true;
    }

    private boolean isNameInUse() {
        MetadataUrlCertsState state = this.findParentState(MetadataUrlCertsState.class);
        return state.isDuplicateMetadataName(this.name, this.id);
    }

    private boolean isUrlInUse() {
        if (this.url.equalsIgnoreCase(this.originalUrl)) {
            return false;
        }
        MetadataUrlCertsState state = this.findParentState(MetadataUrlCertsState.class);
        return state.isDuplicateUrl(this.url, this.id);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Name", this.name, this));
        summaryList.add(new SummaryInfo(TITLE, this.url, this));
        summaryList.add(new SummaryInfo("Validate Metadata Signature", String.valueOf(this.validateSignature), this));
        if (this.signatureVerifier != null) {
            boolean isSigned = this.isSigned();
            summaryList.add(new SummaryInfo("Signed", String.valueOf(isSigned), this));
        }
    }

    private boolean isSigned() {
        SignatureStatus signStatus;
        if (this.signatureVerifier != null && (signStatus = this.signatureVerifier.getSignatureStatus()) != null) {
            return !SignatureStatus.NOT_PRESENT.equals((Object)signStatus);
        }
        return false;
    }

    public XmlSignatureVerifier getSignatureVerifier() {
        return this.signatureVerifier;
    }

    public Cert getCert() {
        MetadataUrlCertTasklet tasklet = this.findParent(MetadataUrlCertTasklet.class);
        if (tasklet == null) {
            return null;
        }
        return tasklet.getSigningCert();
    }

    public void setCert(Cert cert, boolean fromMetadata) {
        MetadataUrlCertTasklet tasklet = this.findParent(MetadataUrlCertTasklet.class);
        if (tasklet == null) {
            return;
        }
        tasklet.setSigningCert(cert, fromMetadata);
    }

    public void updateCert(Cert cert, boolean trusted, boolean fromMetadata) {
        MetadataUrlCertTasklet tasklet = this.findParent(MetadataUrlCertTasklet.class);
        if (tasklet == null) {
            return;
        }
        tasklet.updateSigningCert(cert, trusted, fromMetadata);
    }

    public void resetCertSummaryPageState() {
        MetadataUrlCertTasklet tasklet = this.findParent(MetadataUrlCertTasklet.class);
        if (tasklet == null) {
            return;
        }
        tasklet.resetCertSummaryPageState();
    }

    public void loadMetadata() {
        if (this.delegate.getHasErrors()) {
            return;
        }
        if (this.isNameInUse()) {
            MetadataUrlState.recordErrorMsg(this.getMessage("duplicate_metadata_name"), (IValidationDelegate)this.delegate);
        }
        if (this.isUrlInUse()) {
            MetadataUrlState.recordErrorMsg(this.getMessage("duplicate_url", new Object[]{this.url}), (IValidationDelegate)this.delegate);
        }
        if (!this.delegate.getHasErrors()) {
            MetadataUrlValidator validator = new MetadataUrlValidator(this.name, this.url, false, this.validateSignature);
            if (validator.validate()) {
                this.downloadAndValidateMetadata();
            } else {
                this.recordErrors(validator.getErrors(), (IValidationDelegate)this.delegate);
            }
        }
        if (!this.delegate.getHasErrors() && StringUtils.isNotBlank((String)this.url)) {
            this.originalUrl = this.url;
        }
    }

    private boolean downloadAndValidateMetadata() {
        InputStream metadataStream = null;
        try {
            metadataStream = MetadataUpdateTaskHelper.downloadMetadataFromUrl((String)this.url);
        }
        catch (ValidationException e) {
            MetadataUrlState.recordErrorMsg(e.getMessage(), (IValidationDelegate)this.delegate);
            return true;
        }
        MetadataValidator metadataValidator = new MetadataValidator(null, null, metadataStream, false, null, null, null);
        metadataValidator.setValidateAllConnection(false);
        metadataValidator.validate();
        if (metadataValidator.hasErrors()) {
            this.recordErrors(metadataValidator.getErrors(), (IValidationDelegate)this.delegate);
            return false;
        }
        if (this.validateSignature) {
            this.signatureVerifier = metadataValidator.getSigVerifier();
            if (this.signatureVerifier.getEmbeddedX509Cert() != null) {
                this.updateCert(new Cert(null, this.signatureVerifier.getEmbeddedX509Cert()), this.signatureVerifier.isCertChainValid(), true);
            } else if (this.signatureVerifier.hasSignature()) {
                MetadataSignatureValidator sigValidator = new MetadataSignatureValidator(metadataValidator.getMetadataXml(), true, this.getCert(), null, null);
                sigValidator.validate();
                this.signatureVerifier = sigValidator.getSigVerifier();
            } else if (this.getCert() != null) {
                this.updateCert(null, false, true);
            }
        }
        this.resetCertSummaryPageState();
        this.oldValidateSignature = this.validateSignature;
        return false;
    }
}

