/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.NotificationSettingsValidator;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.fsm.state.impl.NotificationSenderManagementState;
import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import com.pingidentity.monitoring.ThreadPoolExhaustionService;
import com.pingidentity.sdk.notification.NotificationEventType;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.NotificationMode;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserManagerImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class NotificationOptionsState
extends SingleTaskletState {
    private static final String LOGGING_ONLY_LABEL = "Logging Only";
    private static final long serialVersionUID = 20050515L;
    private boolean notifyForLicenseEvents;
    private boolean notifyOfAccountChanges;
    private boolean notifyForCertificateExpirations;
    private boolean notifyForMetadataEvents;
    private boolean notifyForThreadPoolExhaustion;
    private String licenseEventsEmailAddress;
    private String certificateExpirationEmailAddress;
    private String certInitialWarningEvent;
    private String certFinalWarningEvent;
    private NotificationMode certExpirationNotificationMode;
    private String metadataUpdateEmailAddress;
    private String threadPoolExhaustionEmailAddress;
    private boolean threadPoolExhaustionThreadDump;
    private NotificationMode threadPoolExhaustionNotificationMode;
    private String selectedNotificationPublisherLicensing;
    private String selectedNotificationPublisherCertificate;
    private String selectedNotificationPublisherMetadata;
    private String selectedNotificationPublisherThreadPoolExhaustion;
    private boolean notifyForBulkheadAlertEvents;
    private boolean bulkheadThreadDump;
    private NotificationMode bulkheadAlertEventsNotificationMode;
    private String selectedBulkheadAlertNotificationPublisher;
    private String bulkheadAlertsEmailAddress;
    private String expiringCertUIWarning;
    private String expiredCertThresholdUIWarning;

    public NotificationOptionsState(Tasklet value) {
        super(value);
        this.setMenuName("Runtime Notifications");
    }

    @Override
    public void populate(Object dataFromDisk) {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        this.notifyForLicenseEvents = settings.isEnableEmailNotification();
        if (!this.displayEmailNotificationCheckbox()) {
            this.notifyForLicenseEvents = false;
        }
        this.notifyOfAccountChanges = settings.isEnableAccountChangesNotification();
        this.notifyForCertificateExpirations = settings.isEnableCertificateExpirationNotification();
        this.notifyForMetadataEvents = settings.isEnableMetadataEventNotification();
        this.notifyForThreadPoolExhaustion = settings.isEnableThreadPoolExhaustionNotification();
        this.licenseEventsEmailAddress = settings.getTo();
        this.certificateExpirationEmailAddress = settings.getCertificateExpirationTo();
        this.certInitialWarningEvent = settings.getCertInitialWarningEvent();
        this.certFinalWarningEvent = settings.getCertFinalWarningEvent();
        this.certExpirationNotificationMode = settings.getCertExpirationNotificationMode();
        this.metadataUpdateEmailAddress = settings.getMetadataEventTo();
        this.threadPoolExhaustionEmailAddress = settings.getThreadPoolExhaustionTo();
        this.threadPoolExhaustionThreadDump = settings.getThreadPoolExhaustionThreadDump();
        this.threadPoolExhaustionNotificationMode = settings.getThreadPoolExhaustionNotificationMode();
        this.selectedNotificationPublisherCertificate = settings.getNotificationPublisherCertificates();
        if (!this.displayCertificateEmailNotificationDetails()) {
            this.selectedNotificationPublisherCertificate = LOGGING_ONLY_LABEL;
        }
        this.selectedNotificationPublisherLicensing = settings.getNotificationPublisherLicensing();
        this.selectedNotificationPublisherMetadata = settings.getNotificationPublisherMetadata();
        this.expiredCertThresholdUIWarning = settings.getExpiredCertThresholdUIWarning();
        this.expiringCertUIWarning = settings.getExpiringCertUIWarning();
        this.selectedNotificationPublisherThreadPoolExhaustion = settings.getNotificationPublisherThreadPoolExhaustion();
        if (!this.displayThreadPoolExhaustionEmailNotificationDetails()) {
            this.selectedNotificationPublisherThreadPoolExhaustion = LOGGING_ONLY_LABEL;
        }
        this.notifyForBulkheadAlertEvents = settings.isEnableBulkheadAlertNotification();
        this.bulkheadAlertEventsNotificationMode = settings.getBulkheadAlertsNotificationMode();
        this.bulkheadAlertsEmailAddress = settings.getBulkheadAlertsTo();
        this.bulkheadThreadDump = settings.getBulkheadThreadDump();
        this.selectedBulkheadAlertNotificationPublisher = settings.getNotificationPublisherBulkheadAlerts();
        if (!this.displayBulkheadAlertEmailNotificationDetails()) {
            this.selectedBulkheadAlertNotificationPublisher = LOGGING_ONLY_LABEL;
        }
    }

    @Override
    public void reset() {
        this.populate(null);
    }

    @Override
    public boolean save(Object dataFromDisk) {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        settings.setEnableCertificateExpirationNotification(this.notifyForCertificateExpirations);
        settings.setEnableEmailNotification(this.notifyForLicenseEvents);
        settings.setEnableMetadataEventNotification(this.notifyForMetadataEvents);
        settings.setEnableThreadPoolExhaustionNotification(this.notifyForThreadPoolExhaustion);
        settings.setTo(this.licenseEventsEmailAddress);
        settings.setLicensingEventTo(this.licenseEventsEmailAddress);
        settings.setCertificateExpirationTo(this.certificateExpirationEmailAddress);
        settings.setCertInitialWarningEvent(this.certInitialWarningEvent);
        settings.setCertFinalWarningEvent(this.certFinalWarningEvent);
        settings.setCertExpirationNotificationMode(this.certExpirationNotificationMode);
        settings.setMetadataEventTo(this.metadataUpdateEmailAddress);
        settings.setThreadPoolExhaustionTo(this.threadPoolExhaustionEmailAddress);
        settings.setThreadPoolExhaustionThreadDump(this.threadPoolExhaustionThreadDump);
        settings.setThreadPoolExhaustionNotificationMode(this.threadPoolExhaustionNotificationMode);
        settings.setEnableBulkheadAlertNotification(this.notifyForBulkheadAlertEvents);
        settings.setBulkheadAlertNotificationMode(this.bulkheadAlertEventsNotificationMode);
        settings.setBulkheadAlertsTo(this.bulkheadAlertsEmailAddress);
        settings.setBulkheadThreadDump(this.bulkheadThreadDump);
        switch (this.certExpirationNotificationMode) {
            case NOTIFICATION_PUBLISHER: {
                settings.setNotificationPublisherCertificates(this.selectedNotificationPublisherCertificate);
                break;
            }
            case LOGGING_ONLY: {
                settings.setNotificationPublisherCertificates("");
                settings.setCertificateExpirationTo("");
                break;
            }
        }
        switch (this.threadPoolExhaustionNotificationMode) {
            case NOTIFICATION_PUBLISHER: {
                settings.setNotificationPublisherThreadPoolExhaustion(this.selectedNotificationPublisherThreadPoolExhaustion);
                break;
            }
            case LOGGING_ONLY: {
                settings.setNotificationPublisherThreadPoolExhaustion("");
                settings.setThreadPoolExhaustionTo("");
                break;
            }
        }
        switch (this.bulkheadAlertEventsNotificationMode) {
            case NOTIFICATION_PUBLISHER: {
                settings.setNotificationPublisherBulkheadAlerts(this.selectedBulkheadAlertNotificationPublisher);
                break;
            }
            case LOGGING_ONLY: {
                settings.setNotificationPublisherBulkheadAlerts("");
                settings.setBulkheadAlertsTo("");
            }
        }
        settings.setNotificationPublisherLicensing(this.selectedNotificationPublisherLicensing);
        settings.setNotificationPublisherMetadata(this.selectedNotificationPublisherMetadata);
        boolean originalNotifyOfAccountChanges = settings.isEnableAccountChangesNotification();
        settings.setEnableAccountChangesNotification(this.notifyOfAccountChanges);
        settings.setExpiredCertThresholdUIWarning(this.expiredCertThresholdUIWarning);
        settings.setExpiringCertUIWarning(this.expiringCertUIWarning);
        notificationMgr.saveNotificationSettings(settings);
        AdministrativeUser currentUser = this.getParent().getSystemVisit().getCurrentUser();
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        if (notificationSupportHelper.isNotifyFlagSwitchingOff(originalNotifyOfAccountChanges, settings.isEnableAccountChangesNotification())) {
            AdminUserManagerImpl adminUserMgr = AdminUserManagerImpl.getInstance();
            notificationSupportHelper.sendNotificationsChangeEmail(settings, currentUser, adminUserMgr.getUsersMap(), adminUserMgr.getUsersMap(), settings.getNotificationPublisherAccountChanges(), NotificationEventType.ADMIN_ACCOUNT_CHANGE_NOTIFICATION_OFF, new String[]{"Notify administrator of account changes"});
        }
        return true;
    }

    public Tasklet createNotificationSenderTaskletToEdit() {
        SingleStateTasklet notificationTasklet;
        notificationTasklet.setFinishAvailable(!(notificationTasklet = this.createTaskletToLoad(SingleStateTasklet.class, "NotificationSenderTasklet", "Notification Publishers")).showFinishButtonIfAuditor());
        NotificationSenderManagementState notificationPublisherState = new NotificationSenderManagementState(notificationTasklet);
        notificationTasklet.setInitialState(notificationPublisherState);
        notificationTasklet.setMode(Mode.edit);
        notificationTasklet.populate(null);
        this.setTaskletToEdit(notificationTasklet);
        return notificationTasklet;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMenuName(), "", this, true));
        this.doSummary(summaryList);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Certificate_expirations"), Boolean.toString(this.notifyForCertificateExpirations), this));
        if (this.notifyForCertificateExpirations) {
            if (this.displayCertificateEmailNotificationDetails()) {
                summaryList.add(new SummaryInfo(this.getMessage("Certificate_expirations_notification_email_address"), this.certificateExpirationEmailAddress, this));
            }
            summaryList.add(new SummaryInfo(this.getMessage("Cert_initial_warning_event"), this.certInitialWarningEvent, this));
            summaryList.add(new SummaryInfo(this.getMessage("Cert_final_warning_event"), this.certFinalWarningEvent, this));
            if (StringUtils.isNotBlank((String)this.selectedNotificationPublisherCertificate)) {
                summaryList.add(new SummaryInfo(this.getMessage("Notification_Publisher"), this.selectedNotificationPublisherCertificate, this));
            }
        }
        summaryList.add(new SummaryInfo(this.getMessage("License_events"), Boolean.toString(this.notifyForLicenseEvents), this));
        if (this.notifyForLicenseEvents) {
            summaryList.add(new SummaryInfo(this.getMessage("License_events_notification_email_address"), this.licenseEventsEmailAddress, this));
            if (StringUtils.isNotBlank((String)this.selectedNotificationPublisherLicensing)) {
                summaryList.add(new SummaryInfo(this.getMessage("Notification_Publisher"), this.selectedNotificationPublisherLicensing, this));
            }
        }
        summaryList.add(new SummaryInfo(this.getMessage("Metadata_events"), Boolean.toString(this.notifyForMetadataEvents), this));
        if (this.notifyForMetadataEvents) {
            summaryList.add(new SummaryInfo(this.getMessage("Metadata_events_notification_email_address"), this.metadataUpdateEmailAddress, this));
            if (StringUtils.isNotBlank((String)this.selectedNotificationPublisherMetadata)) {
                summaryList.add(new SummaryInfo(this.getMessage("Notification_Publisher"), this.selectedNotificationPublisherMetadata, this));
            }
        }
        summaryList.add(new SummaryInfo(this.getMessage("Thread_pool_exhaustion"), Boolean.toString(this.notifyForThreadPoolExhaustion), this));
        if (this.notifyForThreadPoolExhaustion) {
            if (this.displayThreadPoolExhaustionEmailNotificationDetails()) {
                summaryList.add(new SummaryInfo(this.getMessage("Thread_pool_exhaustion_notification_email_address"), this.threadPoolExhaustionEmailAddress, this));
            }
            summaryList.add(new SummaryInfo(this.getMessage("Thread_pool_exhaustion_thread_dump"), Boolean.toString(this.threadPoolExhaustionThreadDump), this));
            if (StringUtils.isNotBlank((String)this.selectedNotificationPublisherThreadPoolExhaustion)) {
                summaryList.add(new SummaryInfo(this.getMessage("Notification_Publisher"), this.selectedNotificationPublisherThreadPoolExhaustion, this));
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        NotificationSettingsValidator validator = new NotificationSettingsValidator(this.notifyForLicenseEvents, this.licenseEventsEmailAddress, this.notifyForCertificateExpirations, this.certificateExpirationEmailAddress, this.certInitialWarningEvent, this.certFinalWarningEvent, this.notifyForMetadataEvents, this.metadataUpdateEmailAddress, this.certExpirationNotificationMode, this.expiringCertUIWarning, this.expiredCertThresholdUIWarning, true, this.notifyForThreadPoolExhaustion, this.threadPoolExhaustionEmailAddress, this.threadPoolExhaustionNotificationMode, this.notifyForBulkheadAlertEvents, this.bulkheadAlertsEmailAddress, this.bulkheadAlertEventsNotificationMode);
        validator.validate();
        this.recordErrors(validator.getErrors(), delegate);
        if (this.notifyForLicenseEvents || this.notifyForCertificateExpirations || this.notifyForMetadataEvents || this.notifyForThreadPoolExhaustion || this.notifyForBulkheadAlertEvents) {
            delegate.setFormComponent(null);
            NotificationSenderPluginInstance defaultNotificationPublisher = (NotificationSenderPluginInstance)MgmtFactory.getNotificationPublisherPluginManager().getDefaultInstance();
            if (this.notifyForCertificateExpirations && StringUtils.isBlank((String)this.selectedNotificationPublisherCertificate) && defaultNotificationPublisher == null) {
                delegate.record(this.getMessage("Notification_Publisher_required_or_logging_only", new String[]{"Certificate Events"}), ValidationConstraint.REQUIRED);
            }
            if (this.notifyForLicenseEvents && StringUtils.isBlank((String)this.selectedNotificationPublisherLicensing) && defaultNotificationPublisher == null) {
                delegate.record(this.getMessage("Notification_Publisher_required", new String[]{"Licensing Events"}), ValidationConstraint.REQUIRED);
            }
            if (this.notifyForMetadataEvents && StringUtils.isBlank((String)this.selectedNotificationPublisherMetadata) && defaultNotificationPublisher == null) {
                delegate.record(this.getMessage("Notification_Publisher_required", new String[]{"SAML Metadata Update Events"}), ValidationConstraint.REQUIRED);
            }
            if (this.notifyForThreadPoolExhaustion && StringUtils.isBlank((String)this.selectedNotificationPublisherThreadPoolExhaustion) && defaultNotificationPublisher == null) {
                delegate.record(this.getMessage("Notification_Publisher_required_or_logging_only", new String[]{"Thread Pool Exhaustion"}), ValidationConstraint.REQUIRED);
            }
            if (this.notifyForBulkheadAlertEvents && StringUtils.isBlank((String)this.selectedBulkheadAlertNotificationPublisher) && defaultNotificationPublisher == null) {
                delegate.record(this.getMessage("Notification_Publisher_required_or_logging_only", new String[]{"Bulkhead Alerts"}), ValidationConstraint.REQUIRED);
            }
        }
    }

    private boolean isEmailServerConfigurationRequired() {
        return this.notifyForCertificateExpirations && StringUtils.isBlank((String)this.selectedNotificationPublisherCertificate) || this.notifyForLicenseEvents && StringUtils.isBlank((String)this.selectedNotificationPublisherLicensing) || this.notifyForMetadataEvents && StringUtils.isBlank((String)this.selectedNotificationPublisherMetadata);
    }

    public StringPairPropertySelectionModel getNotificationPublishers() {
        StringPairPropertySelectionModel notificationPublisherModel = new StringPairPropertySelectionModel("Default");
        List<StringPairPropertySelectionModel.SPair> items = MgmtFactory.getNotificationPublisherPluginManager().getInstances().stream().map(sender -> new StringPairPropertySelectionModel.SPair(sender.getName(), sender.getId())).collect(Collectors.toList());
        notificationPublisherModel.addAll(items);
        notificationPublisherModel.sort();
        return notificationPublisherModel;
    }

    public StringPairPropertySelectionModel getNotificationPublishersWithLoggingOption() {
        StringPairPropertySelectionModel notificationPublisherModel = this.getNotificationPublishers();
        notificationPublisherModel.add(new StringPairPropertySelectionModel.SPair(LOGGING_ONLY_LABEL, LOGGING_ONLY_LABEL));
        notificationPublisherModel.sort();
        return notificationPublisherModel;
    }

    public String getCertificateExpirationEmailAddress() {
        return this.certificateExpirationEmailAddress;
    }

    public void setCertificateExpirationEmailAddress(String certificateExpirationEmailAddress) {
        this.certificateExpirationEmailAddress = certificateExpirationEmailAddress;
    }

    public String getLicenseEventsEmailAddress() {
        return this.licenseEventsEmailAddress;
    }

    public void setLicenseEventsEmailAddress(String licenseEventsEmailAddress) {
        this.licenseEventsEmailAddress = licenseEventsEmailAddress;
    }

    public boolean getNotifyForCertificateExpirations() {
        return this.notifyForCertificateExpirations;
    }

    public void setNotifyForCertificateExpirations(boolean notifyForCertificateExpirations) {
        this.notifyForCertificateExpirations = notifyForCertificateExpirations;
    }

    public boolean displayCertificateExpirationDetails() {
        return this.notifyForCertificateExpirations;
    }

    public boolean displayCertificateEmailNotificationDetails() {
        return this.notifyForCertificateExpirations && !StringUtils.equals((String)this.selectedNotificationPublisherCertificate, (String)LOGGING_ONLY_LABEL) && this.certExpirationNotificationMode.equals((Object)NotificationMode.NOTIFICATION_PUBLISHER);
    }

    public boolean displayEmailNotificationDetails() {
        return this.displayEmailNotificationCheckbox() && this.notifyForLicenseEvents;
    }

    public boolean displayEmailNotificationCheckbox() {
        return NotificationSettingsValidator.licenseSupportsNotifications();
    }

    public boolean displayMetadataEventDetails() {
        return this.notifyForMetadataEvents;
    }

    public boolean isNotifyForThreadPoolExhaustion() {
        return this.notifyForThreadPoolExhaustion;
    }

    public void setNotifyForThreadPoolExhaustion(boolean notifyForThreadPoolExhaustion) {
        this.notifyForThreadPoolExhaustion = notifyForThreadPoolExhaustion;
    }

    public boolean displayThreadPoolExhaustionDetails() {
        return this.notifyForThreadPoolExhaustion;
    }

    public boolean displayThreadPoolExhaustionEmailNotificationDetails() {
        return this.notifyForThreadPoolExhaustion && !StringUtils.equals((String)this.selectedNotificationPublisherThreadPoolExhaustion, (String)LOGGING_ONLY_LABEL) && this.threadPoolExhaustionNotificationMode.equals((Object)NotificationMode.NOTIFICATION_PUBLISHER);
    }

    public String getCertInitialWarningEvent() {
        return this.certInitialWarningEvent;
    }

    public void setCertInitialWarningEvent(String certInitialWarningEvent) {
        this.certInitialWarningEvent = certInitialWarningEvent;
    }

    public String getCertFinalWarningEvent() {
        return this.certFinalWarningEvent;
    }

    public void setCertFinalWarningEvent(String certFinalWarningEvent) {
        this.certFinalWarningEvent = certFinalWarningEvent;
    }

    public boolean getNotifyForLicenseEvents() {
        return this.notifyForLicenseEvents;
    }

    public void setNotifyForLicenseEvents(boolean notifyForLicenseEvents) {
        this.notifyForLicenseEvents = notifyForLicenseEvents;
    }

    @Override
    public String getNoteKey() {
        AdministrativeUser currentUser = this.getParent().getSystemVisit().getCurrentUser();
        if (!currentUser.isAdminManager()) {
            return this.getTaskletStateId() + "_licenseonly";
        }
        return this.getTaskletStateId();
    }

    public boolean isNotifyForMetadataEvents() {
        return this.notifyForMetadataEvents;
    }

    public void setNotifyForMetadataEvents(boolean notifyForMetadataEvents) {
        this.notifyForMetadataEvents = notifyForMetadataEvents;
    }

    public String getMetadataUpdateEmailAddress() {
        return this.metadataUpdateEmailAddress;
    }

    public void setMetadataUpdateEmailAddress(String metadataUpdateEmailAddress) {
        this.metadataUpdateEmailAddress = metadataUpdateEmailAddress;
    }

    public String getThreadPoolExhaustionEmailAddress() {
        return this.threadPoolExhaustionEmailAddress;
    }

    public void setThreadPoolExhaustionEmailAddress(String threadPoolExhaustionEmailAddress) {
        this.threadPoolExhaustionEmailAddress = threadPoolExhaustionEmailAddress;
    }

    public boolean getThreadPoolExhaustionThreadDump() {
        return this.threadPoolExhaustionThreadDump;
    }

    public void setThreadPoolExhaustionThreadDump(boolean threadPoolExhaustionThreadDump) {
        this.threadPoolExhaustionThreadDump = threadPoolExhaustionThreadDump;
    }

    public String getSelectedNotificationPublisherLicensing() {
        return this.selectedNotificationPublisherLicensing;
    }

    public void setSelectedNotificationPublisherLicensing(String selectedNotificationPublisherLicensing) {
        this.selectedNotificationPublisherLicensing = selectedNotificationPublisherLicensing;
    }

    public String getSelectedNotificationPublisherCertificate() {
        return this.selectedNotificationPublisherCertificate;
    }

    public void setSelectedNotificationPublisherCertificate(String selectedNotificationPublisherCertificate) {
        if (StringUtils.equals((String)selectedNotificationPublisherCertificate, (String)LOGGING_ONLY_LABEL)) {
            this.certificateExpirationEmailAddress = "";
            this.certExpirationNotificationMode = NotificationMode.LOGGING_ONLY;
        } else {
            this.certExpirationNotificationMode = NotificationMode.NOTIFICATION_PUBLISHER;
        }
        this.selectedNotificationPublisherCertificate = selectedNotificationPublisherCertificate;
    }

    public String getSelectedNotificationPublisherMetadata() {
        return this.selectedNotificationPublisherMetadata;
    }

    public void setSelectedNotificationPublisherMetadata(String selectedNotificationPublisherMetadata) {
        this.selectedNotificationPublisherMetadata = selectedNotificationPublisherMetadata;
    }

    public String getExpiringCertUIWarning() {
        return this.expiringCertUIWarning;
    }

    public void setExpiringCertUIWarning(String expiringCertUIWarning) {
        this.expiringCertUIWarning = expiringCertUIWarning;
    }

    public String getExpiredCertThresholdUIWarning() {
        return this.expiredCertThresholdUIWarning;
    }

    public void setExpiredCertThresholdUIWarning(String expiredCertThresholdUIWarning) {
        this.expiredCertThresholdUIWarning = expiredCertThresholdUIWarning;
    }

    public String getSelectedNotificationPublisherThreadPoolExhaustion() {
        return this.selectedNotificationPublisherThreadPoolExhaustion;
    }

    public void setSelectedNotificationPublisherThreadPoolExhaustion(String selectedNotificationPublisherThreadPoolExhaustion) {
        if (StringUtils.equals((String)selectedNotificationPublisherThreadPoolExhaustion, (String)LOGGING_ONLY_LABEL)) {
            this.threadPoolExhaustionEmailAddress = "";
            this.threadPoolExhaustionNotificationMode = NotificationMode.LOGGING_ONLY;
        } else {
            this.threadPoolExhaustionNotificationMode = NotificationMode.NOTIFICATION_PUBLISHER;
        }
        this.selectedNotificationPublisherThreadPoolExhaustion = selectedNotificationPublisherThreadPoolExhaustion;
    }

    public boolean displayLog4j2UpgradeWarning() {
        if (this.notifyForThreadPoolExhaustion && this.threadPoolExhaustionThreadDump) {
            return !ThreadPoolExhaustionService.getInstance().isLog4j2Upgraded();
        }
        return false;
    }

    public boolean isNotifyForBulkheadAlertEvents() {
        return this.notifyForBulkheadAlertEvents;
    }

    public void setNotifyForBulkheadAlertEvents(boolean notifyForBulkheadAlertEvents) {
        this.notifyForBulkheadAlertEvents = notifyForBulkheadAlertEvents;
    }

    public boolean displayBulkheadAlertDetails() {
        return this.notifyForBulkheadAlertEvents;
    }

    public boolean displayBulkheadAlertEmailNotificationDetails() {
        return this.notifyForBulkheadAlertEvents && !StringUtils.equals((String)this.selectedBulkheadAlertNotificationPublisher, (String)LOGGING_ONLY_LABEL) && this.bulkheadAlertEventsNotificationMode.equals((Object)NotificationMode.NOTIFICATION_PUBLISHER);
    }

    public String getBulkheadAlertsEmailAddress() {
        return this.bulkheadAlertsEmailAddress;
    }

    public void setBulkheadAlertsEmailAddress(String bulkheadAlertsEmailAddress) {
        this.bulkheadAlertsEmailAddress = bulkheadAlertsEmailAddress;
    }

    public boolean getBulkheadThreadDump() {
        return this.bulkheadThreadDump;
    }

    public void setBulkheadThreadDump(boolean bulkheadThreadDump) {
        this.bulkheadThreadDump = bulkheadThreadDump;
    }

    public String getSelectedBulkheadAlertNotificationPublisher() {
        return this.selectedBulkheadAlertNotificationPublisher;
    }

    public void setSelectedBulkheadAlertNotificationPublisher(String selectedBulkheadAlertNotificationPublisher) {
        if (StringUtils.equals((String)selectedBulkheadAlertNotificationPublisher, (String)LOGGING_ONLY_LABEL)) {
            this.bulkheadAlertsEmailAddress = "";
            this.bulkheadAlertEventsNotificationMode = NotificationMode.LOGGING_ONLY;
        } else {
            this.bulkheadAlertEventsNotificationMode = NotificationMode.NOTIFICATION_PUBLISHER;
        }
        this.selectedBulkheadAlertNotificationPublisher = selectedBulkheadAlertNotificationPublisher;
    }
}

