/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.state.impl.OAuthApc2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Predicate;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthApc2TargetMappingsState
extends OAuthSource2TargetMappingsState<ApcToUserKeyAttrMapping> {
    private static final long serialVersionUID = 1L;
    private final transient AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();

    public OAuthApc2TargetMappingsState(Tasklet owner) {
        super(owner);
    }

    @Override
    public Collection<ApcToUserKeyAttrMapping> getMappings() {
        return MgmtFactory.getAuthzServerManager().getApcToUserKeyMappings();
    }

    @Override
    public String getDropDownText() {
        return "Policy Contract";
    }

    @Override
    protected Collection<StringPairPropertySelectionModel.SPair> getSourceIdNamePairs() {
        LinkedList<StringPairPropertySelectionModel.SPair> pairs = new LinkedList<StringPairPropertySelectionModel.SPair>();
        for (C2cContract apc : MgmtFactory.getC2cContractManager().getContracts()) {
            StringPairPropertySelectionModel.SPair pair = new StringPairPropertySelectionModel.SPair();
            pair.setId(apc.getId());
            pair.setDesc(apc.getName());
            pairs.add(pair);
        }
        return pairs;
    }

    @Override
    public ApcToUserKeyAttrMapping newEmptyMapping(String sourceId) {
        return new ApcToUserKeyAttrMapping(this.authzServerManager.getKeyNameContract());
    }

    @Override
    protected void saveMappings(Collection<ApcToUserKeyAttrMapping> mappings) {
        this.authzServerMgr.saveApcToUserKeyMappings(mappings, false);
        DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl((Tasklet)this.getWizard());
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)mappings, DependencyType.OAUTH_CLIENT_SETTINGS);
    }

    @Override
    public Class<? extends OAuthSource2TargetMappingTasklet<ApcToUserKeyAttrMapping>> getTaskletClass() {
        return OAuthApc2TargetMappingTasklet.class;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        for (Tasklet t : this.getTasklets()) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            OAuthApc2TargetMappingTasklet tasklet = (OAuthApc2TargetMappingTasklet)t;
            if (tasklet.isItDeleted()) continue;
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            delegate.record("The mapping " + tasklet.getDescription() + " has error(s), please review and fix", ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void delete(String mappingToDelete) {
        super.markTaskletAsDeleted(mappingToDelete);
        OAuthApc2TargetMappingTasklet mappingTasklet = (OAuthApc2TargetMappingTasklet)this.findTaskletByMappingId(mappingToDelete);
        this.authzServerManager.deleteApcToUserKeyMapping(mappingTasklet.getSelectedId());
    }

    @Override
    public Predicate<ApcToUserKeyAttrMapping> getIdMapping(OAuthSource2TargetMappingTasklet<?> targetMappingTasklet) {
        return mapping -> !mapping.getApcId().equals(targetMappingTasklet.getSelectedId());
    }

    @Override
    public AdminAuditLogger.Component getAuditLogComponent() {
        return AdminAuditLogger.Component.OAUTH_APC_TO_PERS_GRANT_MAPPING;
    }
}

