/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.model.fieldpaths.oauth.AuthorizationServerSettingsPaths;
import com.pingidentity.admin.api.validator.AuthorizationServerSettingsValidator;
import com.pingidentity.admin.api.validator.PersistentGrantContractValidator;
import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.helper.ScopeFilterableSelectionHelper;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.common.api.model.oauth.GrantType;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.util.PersistentGrantSettingTimeUnitSelectionModel;
import com.pingidentity.util.RefreshTokenRollingIntervalTimeUnitSelectionModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.ActivationCodeCheckMode;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.AuthzServerSettings;
import org.sourceid.oauth20.domain.ParServerPolicy;
import org.sourceid.oauth20.domain.UserAuthorizationConsentPageSetting;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.domain.ConfigAbstract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpAdapter;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.PersistentGrantAttribute;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;

public class OAuthAuthorizationServerSettingsState
extends TaskletState
implements TableEditor.TableEditorListener {
    private static final long serialVersionUID = 1L;
    private String authzCodeTimeout;
    private String authzCodeLength;
    private boolean restrictPlainPkce;
    private boolean includeIssuerInAuthzResponse;
    private String refreshTokenLength;
    private boolean rollRefreshTokensByDefault;
    private String refreshTokenRollingGracePeriod;
    private String refreshRollingInterval;
    private String selectedRefreshRollingIntervalTimeUnit = "h";
    private StringPairPropertySelectionModel refreshRollingIntervalTimeUnitList;
    private boolean reusePersistentGrantsForImplicit;
    private boolean reusePersistentGrantsForAuthzCode;
    private boolean reusePersistentGrantsForROCreds;
    private boolean allowAutoAuthzForCode;
    private boolean allowUnidentifiedClientROCreds;
    private boolean allowUnidentifiedClientExtensionGrants;
    private String persistentGrantExpirationType = "NONE";
    private String persistentGrantExpirationTime;
    private String selectedPersistentGrantExpirationTimeUnit = "d";
    private StringPairPropertySelectionModel persistentGrantExpirationTimeUnitList;
    private String persistentGrantIdleTimeoutType = "NONE";
    private String persistentGrantIdleTimeout;
    private String selectedPersistentGrantIdleTimeoutTimeUnit = "d";
    private StringPairPropertySelectionModel persistentGrantIdleTimeoutTimeUnitList;
    private ConfigurablePluginInstance adminWebServicePcv;
    private String atmIdForOAuthGrantManagement;
    private String scopeForOAuthGrantManagement;
    private FilterableSelectionFieldDescriptor.SearchableType scopeSearchableType;
    private String scopeForOAuthGrantManagementDisplayName;
    private String scopeForOAuthGrantManagementTypeAndId;
    private boolean trackUserSessionsForLogout = false;
    private Object persistentGrantAttributeState;
    private List<TableRow> persistentGrantAttributes;
    private static final SimpleFieldDescriptor ATTRIBUTE_DESCRIPTOR = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Attribute", 300);
    private static final List<SimpleFieldDescriptor> PERSISTENT_GRANT_ATTRIBUTE_COLUMN_DESCRIPTORS = Arrays.asList(ATTRIBUTE_DESCRIPTOR);
    private Object allowedOriginsState;
    private List<TableRow> allowedOrigins;
    private static final SimpleFieldDescriptor ALLOWED_ORIGINS_DESCRIPTOR = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Allowed Origin", 300);
    private static final List<SimpleFieldDescriptor> ALLOWED_ORIGINS_DESCRIPTORS = Arrays.asList(ALLOWED_ORIGINS_DESCRIPTOR);
    private String tokenEndpointBaseUrl;
    private String userAuthzUrl;
    private String registeredAuthzPath;
    private String pendingAuthzTimeout;
    private String devicePollingInterval;
    private boolean bypassActivationCodeConfirmation;
    private String activationCodeCheckMode;
    private boolean enableCookielessUserAuthzAuthnApi;
    private boolean returnIdTokenOnOpenIdWithDeviceAuthzGrant;
    private String authoriztionConsentPageSetting;
    private String selectedAuthzAdapterId;
    private StringPairPropertySelectionModel authzAdapterList;
    private String selectedAuthzAttributeContract;
    private StringPairPropertySelectionModel authzAttributeContractList;
    private String selectedAuthorizationDetailsAttributeContract;
    private StringPairPropertySelectionModel authorizationDetailsAttributeContractList;
    private String parTimeout;
    private String parReferenceLength;
    private String parStatus;
    private String clientSecretRetentionPeriod;
    private String jwtSecuredAuthorizationResponseModeLifetime;
    private boolean dpopProofRequireNonce;
    private String dpopProofLifetimeSeconds;
    private boolean dpopProofEnforceReplayPrevention;
    private boolean bypassAuthorizationForApprovedConsents;
    private boolean consentsDoNotExpire;
    private String consentLifetimeDays;
    private boolean requireOfflineAccessScopeToIssueRefreshTokens;
    private boolean offlineAccessRequireConsentPrompt;

    public OAuthAuthorizationServerSettingsState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Settings");
        boolean supportMilli = Boolean.parseBoolean(System.getProperty("enablePersistentGrantExpirationTimeUnitMilli", "false"));
        this.persistentGrantExpirationTimeUnitList = new PersistentGrantSettingTimeUnitSelectionModel(supportMilli);
        this.persistentGrantIdleTimeoutTimeUnitList = new PersistentGrantSettingTimeUnitSelectionModel(supportMilli);
        this.refreshRollingIntervalTimeUnitList = new RefreshTokenRollingIntervalTimeUnitSelectionModel();
        this.createAuthzConsentLists();
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        this.getParent().gotoSummaryState(this.getParent().getCycle());
    }

    private void createAuthzConsentLists() {
        this.authzAdapterList = new StringPairPropertySelectionModel(true);
        List<IdpAuthnAdapterInstance> v2Adapters = this.getExternalConsentPageAdapters();
        v2Adapters.forEach(adapter -> this.authzAdapterList.add(adapter.getName(), adapter.getId()));
        this.authzAttributeContractList = new StringPairPropertySelectionModel(true);
    }

    private List<IdpAuthnAdapterInstance> getExternalConsentPageAdapters() {
        AdapterManager adapterMgr = MgmtFactory.getAdapterManager();
        Collection adapterInstances = adapterMgr.getIdpAuthnAdapterInstances();
        Map<String, IdpAuthenticationAdapter> adapterMap = adapterInstances.stream().collect(Collectors.toMap(ConfigAbstract::getId, instance -> adapterMgr.getIdpAuthnAdapter(instance.getId())));
        return adapterMap.entrySet().stream().filter(entry -> AuthorizationServerSettingsValidator.IS_V2_ADAPTER.test((IdpAuthenticationAdapter)entry.getValue())).filter(entry -> AuthorizationServerSettingsValidator.EXTERNAL_CONSENT_PAGE_ADAPTER_FILTER.test((IdpAuthenticationAdapter)entry.getValue())).map(entry -> this.findAdapterInstanceById((String)entry.getKey(), adapterInstances)).collect(Collectors.toList());
    }

    private IdpAuthnAdapterInstance findAdapterInstanceById(String id, Collection<IdpAuthnAdapterInstance> adapterInstances) {
        return adapterInstances.stream().filter(adapter -> adapter.getId().equals(id)).findFirst().get();
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        this.populateSelectedAttributeContract(this.selectedAuthzAdapterId);
    }

    private void populateSelectedAttributeContract(String adapterId) {
        if (StringUtils.isNotBlank((String)adapterId)) {
            Optional<IdpAuthnAdapterInstance> adapterOptional = this.getExternalConsentPageAdapters().stream().filter(a -> a.getId().equals(adapterId)).findFirst();
            if (adapterOptional.isPresent()) {
                IdpAuthnAdapterInstance adapter = adapterOptional.get();
                this.authzAttributeContractList = new StringPairPropertySelectionModel(true);
                this.authorizationDetailsAttributeContractList = new StringPairPropertySelectionModel(true);
                adapter.getAttributeContract().getAllAttributeNames().forEach(attr -> {
                    this.authzAttributeContractList.add((String)attr, attr);
                    this.authorizationDetailsAttributeContractList.add((String)attr, attr);
                });
            } else {
                this.authzAttributeContractList = new StringPairPropertySelectionModel(true);
                this.authorizationDetailsAttributeContractList = new StringPairPropertySelectionModel(true);
            }
        } else {
            this.authzAttributeContractList = new StringPairPropertySelectionModel(true);
            this.authorizationDetailsAttributeContractList = new StringPairPropertySelectionModel(true);
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        TableEditor.State state;
        if (this.persistentGrantAttributeState instanceof TableEditor.State) {
            state = (TableEditor.State)this.persistentGrantAttributeState;
            state.clear();
        }
        if (this.allowedOriginsState instanceof TableEditor.State) {
            state = (TableEditor.State)this.allowedOriginsState;
            state.clear();
        }
        AuthzServerManager mgr = MgmtFactory.getAuthzServerManager();
        this.authzCodeLength = String.valueOf(mgr.getAuthzCodeLength());
        this.authzCodeTimeout = String.valueOf(mgr.getAuthzCodeTimeout());
        this.restrictPlainPkce = mgr.isRestrictPlainPKCE();
        this.includeIssuerInAuthzResponse = mgr.isIncludeIssuerInAuthzResponse();
        this.rollRefreshTokensByDefault = mgr.defaultRefreshTokenRollingPolicy();
        this.refreshTokenRollingGracePeriod = String.valueOf(mgr.getRefreshTokenRollingGracePeriod());
        this.refreshRollingInterval = String.valueOf(mgr.getRefreshRollingInterval());
        this.selectedRefreshRollingIntervalTimeUnit = mgr.getRefreshRollingIntervalTimeUnit();
        this.refreshTokenLength = String.valueOf(mgr.getRefreshTokenLength());
        this.reusePersistentGrantsForAuthzCode = mgr.reuseExistingPersistentGrant("authorization_code");
        this.reusePersistentGrantsForImplicit = mgr.reuseExistingPersistentGrant("implicit");
        this.reusePersistentGrantsForROCreds = mgr.reuseExistingPersistentGrant("password");
        this.allowAutoAuthzForCode = mgr.allowAutoAuthz("authorization_code");
        this.allowUnidentifiedClientROCreds = mgr.allowUnidentifiedClientROCreds();
        this.allowUnidentifiedClientExtensionGrants = mgr.allowUnidentifiedClientExtensionGrants();
        this.adminWebServicePcv = mgr.getAdminWebServicePcv();
        this.atmIdForOAuthGrantManagement = mgr.getAtmIdForOAuthGrantManagement();
        this.scopeForOAuthGrantManagement = mgr.getScopeForOAuthGrantManagement();
        if (this.scopeForOAuthGrantManagement != null) {
            this.scopeSearchableType = ScopeFilterableSelectionHelper.getSearchableType(this.scopeForOAuthGrantManagement);
            this.scopeForOAuthGrantManagementDisplayName = ScopeFilterableSelectionHelper.getScopeDisplayName(this.scopeForOAuthGrantManagement, this.scopeSearchableType);
        }
        this.persistentGrantExpirationTime = mgr.getGlobalPersistentGrantExpirationTime() == null || mgr.getGlobalPersistentGrantExpirationTime() <= 0L ? null : mgr.getGlobalPersistentGrantExpirationTime().toString();
        this.persistentGrantExpirationType = this.persistentGrantExpirationTime == null ? "NONE" : "SERVER_DEFAULT";
        this.selectedPersistentGrantExpirationTimeUnit = mgr.getGlobalPersistentGrantExpirationTimeUnit();
        this.persistentGrantIdleTimeout = mgr.getGlobalPersistentGrantIdleTimeout() == null || mgr.getGlobalPersistentGrantIdleTimeout() <= 0L ? null : mgr.getGlobalPersistentGrantIdleTimeout().toString();
        this.persistentGrantIdleTimeoutType = this.persistentGrantIdleTimeout == null ? "NONE" : "SERVER_DEFAULT";
        this.selectedPersistentGrantIdleTimeoutTimeUnit = mgr.getGlobalPersistentGrantIdleTimeoutTimeUnit();
        this.trackUserSessionsForLogout = ((OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class)).getPolicy().isTrackUserSessionsForLogout();
        this.persistentGrantAttributes = new ArrayList<TableRow>();
        for (PersistentGrantAttribute attr : mgr.getPersistentGrantExtendedAttributes()) {
            this.persistentGrantAttributes.add(this.makeRowFromAttribute(attr));
        }
        this.allowedOrigins = new ArrayList<TableRow>();
        for (String allowedOrigin : mgr.getAllowedOrigins()) {
            this.allowedOrigins.add(this.makeRowFromAllowedOrigin(allowedOrigin));
        }
        this.tokenEndpointBaseUrl = mgr.getTokenEndpointBaseUrl();
        this.userAuthzUrl = mgr.getUserAuthzUrl();
        this.registeredAuthzPath = mgr.getRegisteredAuthzPath();
        this.pendingAuthzTimeout = String.valueOf(mgr.getPendingAuthzTimeout());
        this.devicePollingInterval = String.valueOf(mgr.getDevicePollingInterval());
        this.bypassActivationCodeConfirmation = mgr.isBypassActivationCodeConfirmation();
        this.activationCodeCheckMode = mgr.getActivationCodeCheckMode().name();
        this.enableCookielessUserAuthzAuthnApi = mgr.isEnableCookielessUserAuthzAuthnApi();
        this.returnIdTokenOnOpenIdWithDeviceAuthzGrant = mgr.isReturnIdTokenOnOpenIdWithDeviceAuthorizationGrant();
        this.authoriztionConsentPageSetting = StringUtils.isNotBlank((String)mgr.getAuthzConsentSetting()) ? mgr.getAuthzConsentSetting() : UserAuthorizationConsentPageSetting.INTERNAL.getValue();
        this.selectedAuthzAdapterId = mgr.getExternalConsentAdapterId();
        if (StringUtils.isNotBlank((String)this.selectedAuthzAdapterId)) {
            this.populateSelectedAttributeContract(this.selectedAuthzAdapterId);
            this.selectedAuthzAttributeContract = mgr.getReturnedScopeAttributeName();
            this.selectedAuthorizationDetailsAttributeContract = mgr.getReturnedAuthorizationDetailsAttributeName();
        }
        ParServerPolicy parServerPolicy = mgr.getParServerPolicy();
        this.setParTimeout(String.valueOf(parServerPolicy.getTimeoutSeconds()));
        this.setParReferenceLength(String.valueOf(parServerPolicy.getReferenceLength()));
        this.setParStatus(parServerPolicy.getStatus().toString());
        this.clientSecretRetentionPeriod = String.valueOf(mgr.getClientSecretRetentionPeriod());
        this.jwtSecuredAuthorizationResponseModeLifetime = String.valueOf(mgr.getJwtSecuredAuthorizationResponseModeLifetime());
        this.dpopProofRequireNonce = mgr.isDpopProofRequireNonce();
        this.dpopProofLifetimeSeconds = String.valueOf(mgr.getDpopProofLifetimeSeconds());
        this.dpopProofEnforceReplayPrevention = mgr.isDpopProofEnforceReplayPrevention();
        this.bypassAuthorizationForApprovedConsents = mgr.isBypassAuthorizationForApprovedConsents();
        this.consentLifetimeDays = String.valueOf(mgr.getConsentLifetimeDays());
        boolean bl = this.consentsDoNotExpire = mgr.getConsentLifetimeDays() == -1;
        if (this.consentsDoNotExpire) {
            this.consentLifetimeDays = "";
        }
        this.requireOfflineAccessScopeToIssueRefreshTokens = mgr.isRequireOfflineAccessScopeToIssueRefreshTokens();
        this.offlineAccessRequireConsentPrompt = mgr.isOfflineAccessRequireConsentPrompt();
    }

    @Override
    public boolean save(Object dataToDisk) {
        String[] stringArray;
        AuthzServerManager mgr = MgmtFactory.getAuthzServerManager();
        AuthzServerSettings authzServerSettings = mgr.getAuthzServerSettings();
        authzServerSettings.setAuthzCodeLength(Integer.parseInt(this.authzCodeLength));
        authzServerSettings.setAuthzCodeTimeout(Integer.parseInt(this.authzCodeTimeout));
        authzServerSettings.setRestrictPlainPkce(this.restrictPlainPkce);
        authzServerSettings.setIncludeIssuerInAuthzResponse(this.includeIssuerInAuthzResponse);
        authzServerSettings.setDefaultRefreshTokenRollingPolicy(this.rollRefreshTokensByDefault);
        authzServerSettings.setRefreshTokenRollingGracePeriod(Integer.parseInt(this.refreshTokenRollingGracePeriod));
        authzServerSettings.setRefreshRollingInterval(Long.parseLong(this.refreshRollingInterval));
        authzServerSettings.setRefreshTokenRollingIntervalTimeUnit(this.selectedRefreshRollingIntervalTimeUnit);
        authzServerSettings.setRefreshTokenLength(Integer.parseInt(this.refreshTokenLength));
        HashSet<String> reuseGrantsFor = new HashSet<String>();
        this.checkAdd(this.reusePersistentGrantsForAuthzCode, "authorization_code", reuseGrantsFor);
        this.checkAdd(this.reusePersistentGrantsForImplicit, "implicit", reuseGrantsFor);
        this.checkAdd(this.reusePersistentGrantsForROCreds, "password", reuseGrantsFor);
        authzServerSettings.setGrantTypesToReusePersistentGrants(reuseGrantsFor);
        if (this.allowAutoAuthzForCode) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "authorization_code";
        } else {
            stringArray = new String[]{};
        }
        String[] autoGrants = stringArray;
        authzServerSettings.setGrantTypesToAllowAutoAuthzForExistingPersistentGrants(new HashSet<String>(Arrays.asList(autoGrants)));
        authzServerSettings.setAllowUnidentifiedClientROCreds(this.allowUnidentifiedClientROCreds);
        authzServerSettings.setAllowUnidentifiedClientExtensionGrants(this.allowUnidentifiedClientExtensionGrants);
        authzServerSettings.setAdminWsPcv(this.adminWebServicePcv);
        authzServerSettings.setAtmIdForOAuthGrantManagement(this.atmIdForOAuthGrantManagement);
        authzServerSettings.setScopeForOAuthGrantManagement(this.scopeForOAuthGrantManagement);
        authzServerSettings.setGlobalPersistentGrantExpirationTime(Long.valueOf(StringUtils.isEmpty((String)this.persistentGrantExpirationTime) ? -1L : Long.parseLong(this.persistentGrantExpirationTime)));
        authzServerSettings.setGlobalPersistentGrantExpirationTimeUnit(this.selectedPersistentGrantExpirationTimeUnit);
        authzServerSettings.setGlobalPersistentGrantIdleTimeout(Long.valueOf(StringUtils.isEmpty((String)this.persistentGrantIdleTimeout) ? -1L : Long.parseLong(this.persistentGrantIdleTimeout)));
        authzServerSettings.setGlobalPersistentGrantIdleTimeoutTimeUnit(StringUtils.isEmpty((String)this.persistentGrantIdleTimeout) ? "d" : this.selectedPersistentGrantIdleTimeoutTimeUnit);
        authzServerSettings.setPersistentGrantExtendedAttributes(this.getPersistentAttrsFromTable(this.persistentGrantAttributes));
        authzServerSettings.setAllowedOrigins(this.getAllowedOriginsFromTable(this.allowedOrigins));
        authzServerSettings.setTokenEndpointBaseUrl(this.tokenEndpointBaseUrl);
        authzServerSettings.setUserAuthzUrl(this.userAuthzUrl);
        authzServerSettings.setRegisteredAuthzPath(this.registeredAuthzPath);
        authzServerSettings.setPendingAuthzTimeout(Integer.parseInt(this.pendingAuthzTimeout));
        authzServerSettings.setDevicePollingInterval(Integer.parseInt(this.devicePollingInterval));
        authzServerSettings.setBypassActivationCodeConfirmation(this.bypassActivationCodeConfirmation);
        authzServerSettings.setActivationCodeCheckMode(ActivationCodeCheckMode.valueOf((String)this.activationCodeCheckMode));
        authzServerSettings.setEnableCookielessUserAuthzAuthnApi(this.enableCookielessUserAuthzAuthnApi);
        authzServerSettings.setReturnIdTokenOnOpenIdWithDeviceAuthzGrant(this.returnIdTokenOnOpenIdWithDeviceAuthzGrant);
        if (StringUtils.isNotBlank((String)this.authoriztionConsentPageSetting)) {
            authzServerSettings.setAuthzConsentSetting(this.authoriztionConsentPageSetting);
        }
        if (UserAuthorizationConsentPageSetting.ADAPTER.getValue().equals(this.authoriztionConsentPageSetting)) {
            authzServerSettings.setExternalConsentAdapterId(this.selectedAuthzAdapterId);
            authzServerSettings.setReturnedScopeAttributeName(this.selectedAuthzAttributeContract);
            authzServerSettings.setReturnedAuthorizationDetailsAttributeName(this.selectedAuthorizationDetailsAttributeContract);
        } else {
            authzServerSettings.setAuthzConsentSetting("");
            authzServerSettings.setExternalConsentAdapterId("");
            authzServerSettings.setReturnedScopeAttributeName("");
            authzServerSettings.setReturnedAuthorizationDetailsAttributeName("");
        }
        ParServerPolicy parServerPolicy = new ParServerPolicy();
        parServerPolicy.setTimeoutSeconds(Integer.valueOf(Integer.parseInt(this.getParTimeout())));
        parServerPolicy.setReferenceLength(Integer.valueOf(Integer.parseInt(this.getParReferenceLength())));
        parServerPolicy.setStatus(this.getParStatus());
        authzServerSettings.setParServerPolicy(parServerPolicy);
        authzServerSettings.setClientSecretRetentionPeriod(Integer.parseInt(this.clientSecretRetentionPeriod));
        authzServerSettings.setJwtSecuredAuthorizationResponseModeLifetime(Integer.parseInt(this.jwtSecuredAuthorizationResponseModeLifetime));
        authzServerSettings.setDpopProofRequireNonce(this.dpopProofRequireNonce);
        authzServerSettings.setDpopProofLifetimeSeconds(Integer.parseInt(this.dpopProofLifetimeSeconds));
        authzServerSettings.setDpopProofEnforceReplayPrevention(this.dpopProofEnforceReplayPrevention);
        authzServerSettings.setBypassAuthorizationForApprovedConsents(this.bypassAuthorizationForApprovedConsents);
        if (this.consentsDoNotExpire) {
            authzServerSettings.setConsentLifetimeDays(-1);
        } else {
            authzServerSettings.setConsentLifetimeDays(Integer.parseInt(this.consentLifetimeDays));
        }
        authzServerSettings.setRequireOfflineAccessScopeToIssueRefreshTokens(this.requireOfflineAccessScopeToIssueRefreshTokens);
        boolean offlineAccessRequireConsentPromptSaveValue = this.requireOfflineAccessScopeToIssueRefreshTokens && this.offlineAccessRequireConsentPrompt;
        authzServerSettings.setOfflineAccessRequireConsentPrompt(offlineAccessRequireConsentPromptSaveValue);
        mgr.save(authzServerSettings);
        OpenIdConnectProviderPolicyManager connectProviderPolicyManager = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        OpenIdConnectProviderPolicy policy = connectProviderPolicyManager.getPolicy();
        policy.setTrackUserSessionsForLogout(this.trackUserSessionsForLogout);
        connectProviderPolicyManager.savePolicy(policy, false);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl((Tasklet)this.getWizard());
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)policy, DependencyType.OAUTH_CLIENT_SETTINGS);
        IdpAdapter adapter = null;
        if (StringUtils.isNotBlank((String)this.selectedAuthzAdapterId)) {
            adapter = (IdpAdapter)MgmtFactory.getIdpAdapterManager().getInstance(this.selectedAuthzAdapterId);
        }
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)adapter, DependencyType.IDP_ADAPTER);
        DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this.getParent());
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)null, DependencyType.SCOPE_MANAGEMENT);
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)DependencyType.AUTH_SERVER_SETTINGS, DependencyType.OOB_AUTH_PLUGIN);
        return true;
    }

    private List<PersistentGrantAttribute> getPersistentAttrsFromTable(List<TableRow> rows) {
        ArrayList<PersistentGrantAttribute> attributes = new ArrayList<PersistentGrantAttribute>(this.persistentGrantAttributes.size());
        for (TableRow row : rows) {
            if (row.isMarkedForDelete()) continue;
            PersistentGrantAttribute attr = new PersistentGrantAttribute(this.getRowFieldName(row));
            attributes.add(attr);
        }
        return attributes;
    }

    private List<String> getAllowedOriginsFromTable(List<TableRow> rows) {
        ArrayList<String> origins = new ArrayList<String>(this.allowedOrigins.size());
        for (TableRow row : rows) {
            if (row.isMarkedForDelete()) continue;
            String allowedOrigin = this.getRowFieldName(row);
            origins.add(allowedOrigin);
        }
        return origins;
    }

    private String getRowFieldName(TableRow row) {
        return row.getFields().get(0).getValue().trim();
    }

    private void checkAdd(boolean condition, String value, Set<String> reuseGrantsFor) {
        if (condition) {
            reuseGrantsFor.add(value);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        AuthorizationServerSettingsValidator validator = new AuthorizationServerSettingsValidator(this.getAuthzCodeTimeout(), this.getAuthzCodeLength(), this.getRefreshTokenRollingGracePeriod(), this.getRefreshRollingInterval(), this.getSelectedRefreshRollingIntervalTimeUnit(), this.getRefreshTokenLength(), this.getPersistentGrantExpirationTime(), this.getSelectedPersistentGrantExpirationTimeUnit(), this.getPersistentGrantExpirationType(), this.getPersistentGrantIdleTimeout(), this.getSelectedPersistentGrantIdleTimeoutTimeUnit(), this.getPersistentGrantIdleTimeoutType(), this.isAllowAutoAuthzForCode(), this.getPersistentGrantReuseGrantTypes(), null, null, this.getApiPersistentGrantCoreAttributes(), this.getApiPersistentGrantExtendedAttributes(), null, null, this.getAllowedOriginsFromTable(this.allowedOrigins), this.getTokenEndpointBaseUrl(), this.getUserAuthzUrl(), this.getRegisteredAuthzPath(), this.getPendingAuthzTimeout(), this.getDevicePollingInterval(), false, this.getAtmIdForOAuthGrantManagement(), this.getScopeForOAuthGrantManagement(), this.getAuthoriztionConsentPageSetting(), this.getSelectedAuthzAdapterId(), this.getSelectedAuthzAttributeContract(), this.getSelectedAuthorizationDetailsAttributeContract(), this.getParTimeout(), this.getParReferenceLength(), this.getClientSecretRetentionPeriod(), this.getJwtSecuredAuthorizationResponseModeLifetime(), this.getDpopProofLifetimeSeconds(), this.isBypassAuthorizationForApprovedConsents(), this.isConsentsDoNotExpire(), this.getConsentLifetimeDays());
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    private List<com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute> getApiPersistentGrantCoreAttributes() {
        ArrayList<com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute> attributes = new ArrayList<com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute>(this.persistentGrantAttributes.size());
        for (String attribute : MgmtFactory.getAuthzServerManager().getDefaultPersistentGrantAttributes()) {
            attributes.add(this.convertPersistentGrantToApi(new PersistentGrantAttribute(attribute)));
        }
        return attributes;
    }

    private List<com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute> getApiPersistentGrantExtendedAttributes() {
        ArrayList<com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute> attributes = new ArrayList<com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute>(this.persistentGrantAttributes.size());
        for (PersistentGrantAttribute attribute : this.getPersistentAttrsFromTable(this.persistentGrantAttributes)) {
            attributes.add(this.convertPersistentGrantToApi(attribute));
        }
        return attributes;
    }

    private com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute convertPersistentGrantToApi(PersistentGrantAttribute domain) {
        com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute apiAttr = new com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute();
        apiAttr.setName(domain.getName());
        return apiAttr;
    }

    public String getAuthzCodeTimeout() {
        return this.authzCodeTimeout;
    }

    public void setAuthzCodeTimeout(String authzCodeTimeout) {
        this.authzCodeTimeout = authzCodeTimeout;
    }

    public boolean isRestrictPlainPkce() {
        return this.restrictPlainPkce;
    }

    public void setRestrictPlainPkce(boolean restrictPlainPkce) {
        this.restrictPlainPkce = restrictPlainPkce;
    }

    public boolean isIncludeIssuerInAuthzResponse() {
        return this.includeIssuerInAuthzResponse;
    }

    public void setIncludeIssuerInAuthzResponse(boolean includeIssuerInAuthzResponse) {
        this.includeIssuerInAuthzResponse = includeIssuerInAuthzResponse;
    }

    public boolean isRollRefreshTokensByDefault() {
        return this.rollRefreshTokensByDefault;
    }

    public void setRollRefreshTokensByDefault(boolean rollRefreshTokensByDefault) {
        this.rollRefreshTokensByDefault = rollRefreshTokensByDefault;
    }

    public String getAuthzCodeLength() {
        return this.authzCodeLength;
    }

    public void setAuthzCodeLength(String authzCodeLength) {
        this.authzCodeLength = authzCodeLength;
    }

    public String getRefreshTokenLength() {
        return this.refreshTokenLength;
    }

    public void setRefreshTokenLength(String refreshTokenLength) {
        this.refreshTokenLength = refreshTokenLength;
    }

    public String getRefreshTokenRollingGracePeriod() {
        return this.refreshTokenRollingGracePeriod;
    }

    public void setRefreshTokenRollingGracePeriod(String refreshTokenRollingGracePeriod) {
        this.refreshTokenRollingGracePeriod = refreshTokenRollingGracePeriod;
    }

    public String getRefreshRollingInterval() {
        return this.refreshRollingInterval;
    }

    public void setRefreshRollingInterval(String refreshRollingInterval) {
        this.refreshRollingInterval = refreshRollingInterval;
    }

    public String getSelectedRefreshRollingIntervalTimeUnit() {
        return this.selectedRefreshRollingIntervalTimeUnit;
    }

    public void setSelectedRefreshRollingIntervalTimeUnit(String selectedRefreshRollingIntervalTimeUnit) {
        this.selectedRefreshRollingIntervalTimeUnit = selectedRefreshRollingIntervalTimeUnit;
    }

    public IPropertySelectionModel getRefreshRollingIntervalTimeUnitList() {
        return this.refreshRollingIntervalTimeUnitList;
    }

    public void setRefreshRollingIntervalTimeUnitList(StringPairPropertySelectionModel refreshRollingIntervalTimeUnitList) {
        this.refreshRollingIntervalTimeUnitList = refreshRollingIntervalTimeUnitList;
    }

    public boolean isReusePersistentGrantsForImplicit() {
        return this.reusePersistentGrantsForImplicit;
    }

    public void setReusePersistentGrantsForImplicit(boolean reusePersistentGrantsForImplicit) {
        this.reusePersistentGrantsForImplicit = reusePersistentGrantsForImplicit;
    }

    public boolean isReusePersistentGrantsForAuthzCode() {
        return this.reusePersistentGrantsForAuthzCode;
    }

    public void setReusePersistentGrantsForAuthzCode(boolean reusePersistentGrantsForAuthzCode) {
        this.reusePersistentGrantsForAuthzCode = reusePersistentGrantsForAuthzCode;
    }

    public boolean isReusePersistentGrantsForROCreds() {
        return this.reusePersistentGrantsForROCreds;
    }

    public void setReusePersistentGrantsForROCreds(boolean reusePersistentGrantsForROCreds) {
        this.reusePersistentGrantsForROCreds = reusePersistentGrantsForROCreds;
    }

    public boolean isAllowAutoAuthzForCode() {
        return this.allowAutoAuthzForCode;
    }

    public void setAllowAutoAuthzForCode(boolean allowAutoAuthzForCode) {
        this.allowAutoAuthzForCode = allowAutoAuthzForCode;
    }

    public boolean isAllowUnidentifiedClientExtensionGrants() {
        return this.allowUnidentifiedClientExtensionGrants;
    }

    public void setAllowUnidentifiedClientExtensionGrants(boolean allowUnidentifiedClientExtensionGrants) {
        this.allowUnidentifiedClientExtensionGrants = allowUnidentifiedClientExtensionGrants;
    }

    public boolean isAllowUnidentifiedClientROCreds() {
        return this.allowUnidentifiedClientROCreds;
    }

    public void setAllowUnidentifiedClientROCreds(boolean allowUnidentifiedClientROCreds) {
        this.allowUnidentifiedClientROCreds = allowUnidentifiedClientROCreds;
    }

    public IPropertySelectionModel getPcvInstances() {
        PasswordCredentialValidatorManager pcvMgr = MgmtFactory.getCredentialValidatorManager();
        ArrayList instanceList = new ArrayList();
        instanceList.addAll(pcvMgr.getInstances());
        return this.getSelectionModel(instanceList);
    }

    private IPropertySelectionModel getSelectionModel(Collection<? extends ConfigurablePluginInstance> instances) {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (ConfigurablePluginInstance configurablePluginInstance : instances) {
            model.add(configurablePluginInstance.getName(), configurablePluginInstance);
        }
        return model;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        return List.of(ScopeFilterableSelectionHelper.OAUTH_COMMON_SCOPE_GROUP_WITH_DEFAULT_OIDC, FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_COMMON_SCOPE_GROUP, FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_EXCLUSIVE_SCOPE, FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_EXCLUSIVE_SCOPE_GROUP);
    }

    public ConfigurablePluginInstance getAdminWebServicePcv() {
        return this.adminWebServicePcv;
    }

    public void setAdminWebServicePcv(ConfigurablePluginInstance selectedPcv) {
        this.adminWebServicePcv = selectedPcv;
    }

    public String getAtmIdForOAuthGrantManagement() {
        return this.atmIdForOAuthGrantManagement;
    }

    public void setAtmIdForOAuthGrantManagement(String atmIdForOAuthGrantManagement) {
        this.atmIdForOAuthGrantManagement = atmIdForOAuthGrantManagement;
    }

    public String getScopeForOAuthGrantManagement() {
        return this.scopeForOAuthGrantManagement;
    }

    public void setScopeForOAuthGrantManagement(String scopeForOAuthGrantManagement) {
        this.scopeForOAuthGrantManagement = scopeForOAuthGrantManagement;
    }

    public void setScopeSearchableType(FilterableSelectionFieldDescriptor.SearchableType scopeSearchableType) {
        this.scopeSearchableType = scopeSearchableType;
    }

    public String getScopeForOAuthGrantManagementDisplayName() {
        return this.scopeForOAuthGrantManagementDisplayName;
    }

    public void setScopeForOAuthGrantManagementDisplayName(String scopeForOAuthGrantManagementDisplayName) {
        this.scopeForOAuthGrantManagementDisplayName = scopeForOAuthGrantManagementDisplayName;
    }

    public String getScopeForOAuthGrantManagementTypeAndId() {
        return this.scopeForOAuthGrantManagementTypeAndId;
    }

    public void setScopeForOAuthGrantManagementTypeAndId(String scopeForOAuthGrantManagementTypeAndId) {
        this.scopeForOAuthGrantManagementTypeAndId = scopeForOAuthGrantManagementTypeAndId;
        if (StringUtils.isNotEmpty((String)scopeForOAuthGrantManagementTypeAndId)) {
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(scopeForOAuthGrantManagementTypeAndId);
            this.setScopeForOAuthGrantManagement(option.getId());
            this.setScopeSearchableType(option.getType());
            this.setScopeForOAuthGrantManagementDisplayName(ScopeFilterableSelectionHelper.getScopeDisplayName(option.getId(), option.getType()));
        }
    }

    public void clearScopeSelectionFilter() {
        this.scopeForOAuthGrantManagementTypeAndId = null;
        this.setScopeForOAuthGrantManagement(null);
        this.setScopeSearchableType(null);
        this.setScopeForOAuthGrantManagementDisplayName(null);
    }

    public boolean isTrackUserSessionsForLogout() {
        return this.trackUserSessionsForLogout;
    }

    public void setTrackUserSessionsForLogout(boolean trackUserSessionsForLogout) {
        this.trackUserSessionsForLogout = trackUserSessionsForLogout;
    }

    public boolean isNoExpiration() {
        return this.persistentGrantExpirationType != null && this.persistentGrantExpirationType.equals("NONE");
    }

    public String getPersistentGrantExpirationType() {
        return this.persistentGrantExpirationType;
    }

    public void setPersistentGrantExpirationType(String persistentGrantExpirationType) {
        if (persistentGrantExpirationType.equals("NONE")) {
            this.persistentGrantExpirationTime = null;
        }
        this.persistentGrantExpirationType = persistentGrantExpirationType;
    }

    public String getPersistentGrantExpirationTime() {
        return this.persistentGrantExpirationTime;
    }

    public void setPersistentGrantExpirationTime(String persistentGrantExpirationTime) {
        this.persistentGrantExpirationTime = persistentGrantExpirationTime;
    }

    public String getSelectedPersistentGrantExpirationTimeUnit() {
        return this.selectedPersistentGrantExpirationTimeUnit;
    }

    public void setSelectedPersistentGrantExpirationTimeUnit(String selectedPersistentGrantExpirationTimeUnit) {
        this.selectedPersistentGrantExpirationTimeUnit = selectedPersistentGrantExpirationTimeUnit;
    }

    public IPropertySelectionModel getPersistentGrantExpirationTimeUnitList() {
        return this.persistentGrantExpirationTimeUnitList;
    }

    public void setPersistentGrantExpirationTimeUnitList(StringPairPropertySelectionModel persistentGrantExpirationTimeUnitList) {
        this.persistentGrantExpirationTimeUnitList = persistentGrantExpirationTimeUnitList;
    }

    public boolean isNoIdleTimeout() {
        return this.persistentGrantIdleTimeoutType != null && this.persistentGrantIdleTimeoutType.equals("NONE");
    }

    public String getPersistentGrantIdleTimeoutType() {
        return this.persistentGrantIdleTimeoutType;
    }

    public void setPersistentGrantIdleTimeoutType(String persistentGrantIdleTimeoutType) {
        if (persistentGrantIdleTimeoutType.equals("NONE")) {
            this.persistentGrantIdleTimeout = null;
        }
        this.persistentGrantIdleTimeoutType = persistentGrantIdleTimeoutType;
    }

    public String getPersistentGrantIdleTimeout() {
        return this.persistentGrantIdleTimeout;
    }

    public void setPersistentGrantIdleTimeout(String persistentGrantIdleTimeout) {
        this.persistentGrantIdleTimeout = persistentGrantIdleTimeout;
    }

    public String getSelectedPersistentGrantIdleTimeoutTimeUnit() {
        return this.selectedPersistentGrantIdleTimeoutTimeUnit;
    }

    public void setSelectedPersistentGrantIdleTimeoutTimeUnit(String selectedPersistentGrantIdleTimeoutTimeUnit) {
        this.selectedPersistentGrantIdleTimeoutTimeUnit = selectedPersistentGrantIdleTimeoutTimeUnit;
    }

    public IPropertySelectionModel getPersistentGrantIdleTimeoutTimeUnitList() {
        return this.persistentGrantIdleTimeoutTimeUnitList;
    }

    public void setPersistentGrantIdleTimeoutTimeUnitList(StringPairPropertySelectionModel persistentGrantIdleTimeoutTimeUnitList) {
        this.persistentGrantIdleTimeoutTimeUnitList = persistentGrantIdleTimeoutTimeUnitList;
    }

    public boolean isEnableOpenIdConnectIdp() {
        return ((OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class)).getPolicy().isEnabled();
    }

    private List<GrantType> getPersistentGrantReuseGrantTypes() {
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        if (this.isReusePersistentGrantsForImplicit()) {
            grantTypes.add(GrantType.IMPLICIT);
        }
        if (this.isReusePersistentGrantsForAuthzCode()) {
            grantTypes.add(GrantType.AUTHORIZATION_CODE);
        }
        if (this.isReusePersistentGrantsForROCreds()) {
            grantTypes.add(GrantType.RESOURCE_OWNER_CREDENTIALS);
        }
        return grantTypes;
    }

    public String getParTimeout() {
        return this.parTimeout;
    }

    public void setParTimeout(String parTimeout) {
        this.parTimeout = parTimeout;
    }

    public String getParReferenceLength() {
        return this.parReferenceLength;
    }

    public void setParReferenceLength(String parReferenceLength) {
        this.parReferenceLength = parReferenceLength;
    }

    public String getParStatus() {
        return this.parStatus;
    }

    public void setParStatus(String parStatus) {
        this.parStatus = parStatus;
    }

    public List<TableRow> getPersistentGrantAttributes() {
        return this.persistentGrantAttributes;
    }

    public void setPersistentGrantAttributes(List<TableRow> attributes) {
        this.persistentGrantAttributes = attributes;
    }

    public List<TableRow> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List<TableRow> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    protected TableRow makeRowFromAttribute(PersistentGrantAttribute attribute) {
        ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
        fields.add(new FieldItem(ATTRIBUTE_DESCRIPTOR, attribute.getName()));
        return new TableRow(fields);
    }

    private TableRow makeRowFromAllowedOrigin(String allowedOrigin) {
        ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
        fields.add(new FieldItem(ALLOWED_ORIGINS_DESCRIPTOR, allowedOrigin));
        return new TableRow(fields);
    }

    public static List<SimpleFieldDescriptor> getPersistentGrantAttributeColumnDescriptors() {
        return PERSISTENT_GRANT_ATTRIBUTE_COLUMN_DESCRIPTORS;
    }

    public static List<SimpleFieldDescriptor> getAllowedOriginsDescriptors() {
        return ALLOWED_ORIGINS_DESCRIPTORS;
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        if (owner.getId().equals("attributeEditor")) {
            PersistentGrantContractValidator validator;
            List<com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute> extendedAttributes = this.getApiPersistentGrantExtendedAttributes();
            if (originalRow != null) {
                extendedAttributes.removeIf(attribute -> attribute.getName().equals(this.getRowFieldName(originalRow)));
            }
            extendedAttributes.add(this.convertPersistentGrantToApi(new PersistentGrantAttribute(this.getRowFieldName(row))));
            if (extendedAttributes.size() > 0 && !(validator = new PersistentGrantContractValidator(this.getApiPersistentGrantCoreAttributes(), extendedAttributes, AuthorizationServerSettingsPaths.getPersistentGrantAttribute())).validate()) {
                return this.getValidatorErrors((Validator)validator);
            }
        } else if (owner.getId().equals("allowedOriginsEditor")) {
            List<String> origins = this.getAllowedOriginsFromTable(this.allowedOrigins);
            if (originalRow != null) {
                origins.removeIf(origin -> origin.equals(this.getRowFieldName(originalRow)));
            }
            origins.add(this.getRowFieldName(row));
            if (origins.size() > 0) {
                AuthorizationServerSettingsValidator validator = AuthorizationServerSettingsValidator.createInstanceForCrossOriginResourceSettingsValidation(origins);
                validator.validateCrossOriginResourceSettings();
                return this.getValidatorErrors((Validator)validator);
            }
        }
        return Collections.emptyList();
    }

    private List<String> getValidatorErrors(Validator validator) {
        if (validator.hasErrors()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationError error : validator.getErrors()) {
                errors.add(error.getMessage());
            }
            return errors;
        }
        return Collections.emptyList();
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
    }

    public IPropertySelectionModel getAccessTokenManagerModel() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (ConfigurablePluginInstance instance : MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances()) {
            model.add(instance.getName(), instance.getId());
        }
        model.sort();
        return model;
    }

    public Object getPersistentGrantAttributeState() {
        return this.persistentGrantAttributeState;
    }

    public void setPersistentGrantAttributeState(Object grantAttributeState) {
        this.persistentGrantAttributeState = grantAttributeState;
    }

    public Object getAllowedOriginsState() {
        return this.allowedOriginsState;
    }

    public void setAllowedOriginsState(Object allowedOriginsState) {
        this.allowedOriginsState = allowedOriginsState;
    }

    public String getTokenEndpointBaseUrl() {
        return this.tokenEndpointBaseUrl;
    }

    public void setTokenEndpointBaseUrl(String tokenEndpointBaseUrl) {
        this.tokenEndpointBaseUrl = tokenEndpointBaseUrl;
    }

    public String getUserAuthzUrl() {
        return this.userAuthzUrl;
    }

    public void setUserAuthzUrl(String userAuthzUrl) {
        this.userAuthzUrl = userAuthzUrl;
    }

    public String getRegisteredAuthzPath() {
        return this.registeredAuthzPath;
    }

    public void setRegisteredAuthzPath(String registeredAuthzPath) {
        this.registeredAuthzPath = registeredAuthzPath;
    }

    public String getPendingAuthzTimeout() {
        return this.pendingAuthzTimeout;
    }

    public void setPendingAuthzTimeout(String pendingAuthzTimeout) {
        this.pendingAuthzTimeout = pendingAuthzTimeout;
    }

    public String getDevicePollingInterval() {
        return this.devicePollingInterval;
    }

    public void setDevicePollingInterval(String devicePollingInterval) {
        this.devicePollingInterval = devicePollingInterval;
    }

    public boolean isBypassActivationCodeConfirmation() {
        return this.bypassActivationCodeConfirmation;
    }

    public void setBypassActivationCodeConfirmation(boolean bypassActivationCodeConfirmation) {
        this.bypassActivationCodeConfirmation = bypassActivationCodeConfirmation;
    }

    public String getActivationCodeCheckMode() {
        return this.activationCodeCheckMode;
    }

    public void setActivationCodeCheckMode(String mode) {
        this.activationCodeCheckMode = mode;
    }

    public boolean isEnableCookielessUserAuthzAuthnApi() {
        return this.enableCookielessUserAuthzAuthnApi;
    }

    public void setEnableCookielessUserAuthzAuthnApi(boolean enableCookielessUserAuthzAuthnApi) {
        this.enableCookielessUserAuthzAuthnApi = enableCookielessUserAuthzAuthnApi;
    }

    public boolean isReturnIdTokenOnOpenIdWithDeviceAuthzGrant() {
        return this.returnIdTokenOnOpenIdWithDeviceAuthzGrant;
    }

    public void setReturnIdTokenOnOpenIdWithDeviceAuthzGrant(boolean returnIdTokenOnOpenIdWithDeviceAuthzGrant) {
        this.returnIdTokenOnOpenIdWithDeviceAuthzGrant = returnIdTokenOnOpenIdWithDeviceAuthzGrant;
    }

    public String getAuthoriztionConsentPageSetting() {
        return this.authoriztionConsentPageSetting;
    }

    public void setAuthoriztionConsentPageSetting(String authoriztionConsentPageSetting) {
        this.authoriztionConsentPageSetting = authoriztionConsentPageSetting;
    }

    public boolean isOverridingConsentPage() {
        return UserAuthorizationConsentPageSetting.ADAPTER.getValue().equals(this.getAuthoriztionConsentPageSetting());
    }

    public String getSelectedAuthzAdapterId() {
        return this.selectedAuthzAdapterId;
    }

    public void setSelectedAuthzAdapterId(String selectedAuthzAdapterId) {
        this.selectedAuthzAdapterId = selectedAuthzAdapterId;
    }

    public StringPairPropertySelectionModel getAuthzAdapterList() {
        return this.authzAdapterList;
    }

    public void setAuthzAdapterList(StringPairPropertySelectionModel authzAdapterList) {
        this.authzAdapterList = authzAdapterList;
    }

    public String getSelectedAuthzAttributeContract() {
        return this.selectedAuthzAttributeContract;
    }

    public void setSelectedAuthzAttributeContract(String selectedAuthzAttributeContract) {
        this.selectedAuthzAttributeContract = selectedAuthzAttributeContract;
    }

    public StringPairPropertySelectionModel getAuthzAttributeContractList() {
        return this.authzAttributeContractList;
    }

    public void setAuthzAttributeContractList(StringPairPropertySelectionModel authzAttributeContractList) {
        this.authzAttributeContractList = authzAttributeContractList;
    }

    public String getSelectedAuthorizationDetailsAttributeContract() {
        return this.selectedAuthorizationDetailsAttributeContract;
    }

    public void setSelectedAuthorizationDetailsAttributeContract(String selectedAuthorizationDetailsAttributeContract) {
        this.selectedAuthorizationDetailsAttributeContract = selectedAuthorizationDetailsAttributeContract;
    }

    public StringPairPropertySelectionModel getAuthorizationDetailsAttributeContractList() {
        return this.authorizationDetailsAttributeContractList;
    }

    public void setAuthorizationDetailsAttributeContractList(StringPairPropertySelectionModel authorizationDetailsAttributeContractList) {
        this.authorizationDetailsAttributeContractList = authorizationDetailsAttributeContractList;
    }

    public void setClientSecretRetentionPeriod(String clientSecretRetentionPeriod) {
        this.clientSecretRetentionPeriod = clientSecretRetentionPeriod;
    }

    public String getClientSecretRetentionPeriod() {
        return this.clientSecretRetentionPeriod;
    }

    public String getJwtSecuredAuthorizationResponseModeLifetime() {
        return this.jwtSecuredAuthorizationResponseModeLifetime;
    }

    public void setJwtSecuredAuthorizationResponseModeLifetime(String jwtSecuredAuthorizationResponseModeLifetime) {
        this.jwtSecuredAuthorizationResponseModeLifetime = jwtSecuredAuthorizationResponseModeLifetime;
    }

    public boolean isDpopProofRequireNonce() {
        return this.dpopProofRequireNonce;
    }

    public void setDpopProofRequireNonce(boolean dpopProofRequireNonce) {
        this.dpopProofRequireNonce = dpopProofRequireNonce;
    }

    public String getDpopProofLifetimeSeconds() {
        return this.dpopProofLifetimeSeconds;
    }

    public void setDpopProofLifetimeSeconds(String dpopProofLifetimeSeconds) {
        this.dpopProofLifetimeSeconds = dpopProofLifetimeSeconds;
    }

    public boolean isDpopProofEnforceReplayPrevention() {
        return this.dpopProofEnforceReplayPrevention;
    }

    public void setDpopProofEnforceReplayPrevention(boolean dpopProofEnforceReplayPrevention) {
        this.dpopProofEnforceReplayPrevention = dpopProofEnforceReplayPrevention;
    }

    public boolean isBypassAuthorizationForApprovedConsents() {
        return this.bypassAuthorizationForApprovedConsents;
    }

    public void setBypassAuthorizationForApprovedConsents(boolean bypassAuthorizationForApprovedConsents) {
        this.bypassAuthorizationForApprovedConsents = bypassAuthorizationForApprovedConsents;
        if (!bypassAuthorizationForApprovedConsents) {
            this.consentsDoNotExpire = true;
            this.consentLifetimeDays = null;
        }
    }

    public String getConsentLifetimeDays() {
        return this.consentLifetimeDays;
    }

    public void setConsentLifetimeDays(String consentLifetimeDays) {
        this.consentLifetimeDays = consentLifetimeDays;
    }

    public void setConsentsDoNotExpire(boolean consentsDoNotExpire) {
        this.consentsDoNotExpire = consentsDoNotExpire;
        if (consentsDoNotExpire) {
            this.consentLifetimeDays = null;
        }
    }

    public boolean isConsentsDoNotExpire() {
        return this.consentsDoNotExpire;
    }

    public boolean isRequireOfflineAccessScopeToIssueRefreshTokens() {
        return this.requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public void setRequireOfflineAccessScopeToIssueRefreshTokens(boolean requireOfflineAccessScopeToIssueRefreshTokens) {
        this.requireOfflineAccessScopeToIssueRefreshTokens = requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public boolean isOfflineAccessRequireConsentPrompt() {
        return this.offlineAccessRequireConsentPrompt;
    }

    public void setOfflineAccessRequireConsentPrompt(boolean offlineAccessRequireConsentPrompt) {
        this.offlineAccessRequireConsentPrompt = offlineAccessRequireConsentPrompt;
    }
}

