/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.OAuthClientValidator;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.HashedPassword;
import com.pingidentity.crypto.X500Util;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AbstractOAuthClientRefreshRollingIntervalTaskletState;
import com.pingidentity.fsm.state.impl.OAuthClientManagementTasklet;
import com.pingidentity.fsm.state.impl.OAuthClientsManagementState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CheckboxItem;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.util.PersistentGrantSettingTimeUnitSelectionModel;
import com.pingidentity.util.RefreshTokenRollingIntervalTimeUnitSelectionModel;
import com.pingidentity.util.ScopeSelectionModalUtil;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientLogoutMode;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientSecondarySecretSet;
import org.sourceid.oauth20.domain.ClientSecretRetentionHelper;
import org.sourceid.oauth20.domain.ClientUtil;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicies;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.openid.ciba.CibaDeliveryMode;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class OAuthClientManagementState
extends AbstractOAuthClientRefreshRollingIntervalTaskletState {
    private static final long serialVersionUID = 5L;
    public static final String DEFAULT = "default";
    public static final String DEFAULT_LABEL = "Default";
    private static final String ALLOW_ANY_LABEL = "Allow Any";
    public static final String NO_ENCRYPTION_LABEL = "No Encryption";
    private static final String INACTIVE_LABEL = " (inactive)";
    private String id;
    private String name;
    private String description;
    private Calendar creationTime;
    private String logoUrl;
    private List<String> redirectUris = new ArrayList<String>();
    private boolean allowAuthzCode;
    private boolean allowROCreds;
    private boolean allowRefresh;
    private boolean allowImplict;
    private boolean allowClientCreds;
    private boolean allowValidate;
    private boolean allowExtension;
    private boolean allowDeviceCode;
    private boolean allowCiba;
    private boolean allowTokenExchange;
    private String rolling = "default";
    private String secret;
    private boolean changeSecret = false;
    private String clientSecretChangedTime;
    private String secondarySecretRetentionPeriod;
    private String secondarySecretRetentionPeriodType = "SERVER_DEFAULT";
    private boolean allowAuthenticationApiInit = false;
    private boolean enableCookielessAuthenticationApi = false;
    private boolean bypassApprovalPage;
    private String registrationToken;
    private boolean restrictScopes;
    private boolean restrictResponseTypes;
    private List<String> restrictedScopes = new ArrayList<String>();
    private List<String> restrictedResponseTypes = new ArrayList<String>();
    private final CheckboxModel restrictResponseTypesCheckboxModel = new CheckboxModel();
    private boolean excludedScopes;
    private List<String> exclusiveScopes = new ArrayList<String>();
    private boolean allowAuthorizationDetails;
    private List<String> authorizationDetailTypes = new ArrayList<String>();
    private final CheckboxModel authorizationDetailTypesCheckboxModel = new CheckboxModel();
    private StringPairPropertySelectionModel logoutModeList;
    private String selectedLogoutMode = ClientLogoutMode.NONE.name();
    private String backChannelLogoutUri;
    private List<String> logoutUris = new ArrayList<String>();
    private List<String> postLogoutRedirectUris = new ArrayList<String>();
    private String jwksUrl = null;
    private String jwks = null;
    private boolean enforceReplayPrevention = false;
    private boolean clientSecretJwtReplayPrevention = false;
    private String selectedTokenEndpointAuthSigningAlgorithm;
    private StringPairPropertySelectionModel tokenEndpointAuthSigningAlgorithmList;
    private StringPairPropertySelectionModel tokenEndpointAuthSymmetricSigningAlgorithmList;
    private String selectedTokenEndpointAuthSymmetricSigningAlgorithm;
    private boolean enabled = true;
    private String originalEncodedSecret;
    private ClientSecondarySecretSet originalSecondarySecrets;
    private boolean secondarySecretPresent = false;
    private String originalObfuscatedReversableSecret;
    private String persistentGrantExpirationType = "SERVER_DEFAULT";
    private String persistentGrantExpirationTime;
    private String selectedPersistentGrantExpirationTimeUnit;
    private StringPairPropertySelectionModel persistentGrantExpirationTimeUnitList;
    private String persistentGrantIdleTimeoutType = "SERVER_DEFAULT";
    private String persistentGrantIdleTimeout;
    private String selectedPersistentGrantIdleTimeoutTimeUnit;
    private StringPairPropertySelectionModel persistentGrantIdleTimeoutTimeUnitList;
    private String grantTypesToReusePersistentGrantsType = "SERVER_DEFAULT";
    private boolean reusePersistentGrantAuthzCode = false;
    private boolean reusePersistentGrantROPC = false;
    private boolean reusePersistentGrantImplicit = false;
    private String selectedIdTokenSigningAlgorithm;
    private String selectedIdTokenEncryptionAlgorithm;
    private String selectedIdTokenContentEncryptionAlgorithm;
    private StringPairPropertySelectionModel idTokenSigningAlgorithmList;
    private StringPairPropertySelectionModel idTokenEncryptionAlgorithmList;
    private StringPairPropertySelectionModel idTokenContentEncryptionAlgorithmList;
    private String selectedUserInfoResponseSigningAlgorithm;
    private String selectedUserInfoResponseEncryptionAlgorithm;
    private String selectedUserInfoResponseContentEncryptionAlgorithm;
    private StringPairPropertySelectionModel userInfoResponseSigningAlgorithmList;
    private StringPairPropertySelectionModel userInfoResponseEncryptionAlgorithmList;
    private StringPairPropertySelectionModel userInfoResponseContentEncryptionAlgorithmList;
    private boolean displayUserInfoResponseAlgorithmWarning;
    private String selectedPolicyGroupId;
    private StringPairPropertySelectionModel policyIdList;
    private String selectedTokenManagerId;
    private StringPairPropertySelectionModel tokenManagerIdList;
    private boolean restrictToDefaultAccessTokenManager = false;
    private Cert trustAllDummyCert;
    private Cert clientCertIssuer;
    private String subjectDn;
    private Set<Cert> trustedCAs = new HashSet<Cert>();
    private transient IUploadFile certFile;
    private Cert cert;
    private String errorMessage;
    private ClientAuthenticationType clientAuthenticationType = ClientAuthenticationType.NONE;
    private boolean grantAccessSessionRevocationApi;
    private boolean grantAccessSessionManagementApi;
    private boolean pingAccessLogoutCapable;
    private boolean validateUsingAllEligibleAtms;
    private boolean pairwiseUserType;
    private String sectorIdentifierUri;
    private boolean requireSignedRequest;
    private String selectedRequestObjectSigningAlgorithm;
    private StringPairPropertySelectionModel requestObjectSigningAlgorithmList;
    private String deviceFlowSettingType = "SERVER_DEFAULT";
    private String userAuthzUrlOverride;
    private String pendingAuthzTimeoutOverride;
    private String devicePollingIntervalOverride;
    private Boolean bypassActivationCodeConfirmationOverride;
    private CibaDeliveryMode cibaMode = CibaDeliveryMode.poll;
    private String cibaNotificationEndpoint;
    private boolean cibaRequireSignedRequests;
    private boolean cibaUserCodeSupported;
    private String cibaPolicyId;
    private StringPairPropertySelectionModel cibaPolicyIdList;
    private String cibaPollingInterval = String.valueOf(3);
    private String selectedCibaRequestObjectSigningAlgorithm;
    private StringPairPropertySelectionModel cibaRequestObjectSigningAlgorithmList;
    private boolean requirePar;
    private String tokenExchangeProcessorPolicyId;
    private StringPairPropertySelectionModel tokenExchangeProcessorPolicyIdList;
    private boolean requireProofKeyForCodeExchange;
    private transient Object redirectUrisComponentState;
    private transient Object logoutUrisComponentState;
    private transient Object postLogoutRedirectUrisComponentState;
    private String refreshTokenRollingGracePeriod = null;
    private String refreshTokenRollingGracePeriodType = "SERVER_DEFAULT";
    private String selectedIntrospectionSigningAlgorithm;
    private String selectedIntrospectionEncryptionAlgorithm;
    private String selectedIntrospectionContentEncryptionAlgorithm;
    private StringPairPropertySelectionModel introspectionSigningAlgorithmList;
    private StringPairPropertySelectionModel introspectionEncryptionAlgorithmList;
    private StringPairPropertySelectionModel introspectionContentEncryptionAlgorithmList;
    private boolean displayIntrospectionAlgorithmWarning;
    private boolean requireJarm;
    private String selectedAuthorizationResponseSigningAlgorithm;
    private String selectedAuthorizationResponseEncryptionAlgorithm;
    private String selectedAuthorizationResponseContentEncryptionAlgorithm;
    private StringPairPropertySelectionModel authorizationResponseSigningAlgorithmList;
    private StringPairPropertySelectionModel authorizationResponseEncryptionAlgorithmList;
    private StringPairPropertySelectionModel authorizationResponseContentEncryptionAlgorithmList;
    private boolean displayAuthorizationResponseAlgorithmWarning;
    private boolean requireDpop;
    private String requireOfflineAccessScopeToIssueRefreshTokens = "SERVER_DEFAULT";
    private String offlineAccessRequireConsentPrompt = "SERVER_DEFAULT";
    private String lockoutMaxMaliciousActionsType = "SERVER_DEFAULT";
    private String lockoutMaxMaliciousActions;
    private boolean displayAlgorithmWarning;

    public OAuthClientManagementState(IWizard owner, String cardName) {
        super(owner, cardName);
        this.init();
    }

    private void init() {
        this.setMenuName("Manage Client");
        boolean supportMilli = Boolean.parseBoolean(System.getProperty("enablePersistentGrantExpirationTimeUnitMilli", "false"));
        this.persistentGrantExpirationTimeUnitList = new PersistentGrantSettingTimeUnitSelectionModel(supportMilli);
        this.persistentGrantIdleTimeoutTimeUnitList = new PersistentGrantSettingTimeUnitSelectionModel(supportMilli);
        this.setRefreshRollingIntervalTimeUnitList(new RefreshTokenRollingIntervalTimeUnitSelectionModel());
        this.createLogoutModeList();
        this.tokenEndpointAuthSymmetricSigningAlgorithmList = this.createTokenEndpointAuthSigningAlgorithmList(OpenIdConnectProviderInfo.getSupportedSymmetricSignatureVerificationAlgorithms());
        this.tokenEndpointAuthSigningAlgorithmList = this.createTokenEndpointAuthSigningAlgorithmList(OpenIdConnectProviderInfo.getSupportedAsymmetricSignatureVerificationAlgorithms());
        this.createRequestObjectSigningAlgorithmList();
        this.createCibaRequestObjectSigningAlgorithmList();
        this.createIdTokenSigningAlgorithmList();
        this.createIdTokenEncryptionAlgorithmList();
        this.createIdTokenContentEncryptionAlgorithmList();
        this.createPolicyGroupIdList();
        this.createTokenManagerIdList();
        this.createCibaPolicyIdList();
        this.loadAuthorizationDetailTypesCheckboxModel();
        this.loadRestrictResponseTypesCheckboxModel();
        this.loadTrustedCAs();
        this.createTokenExchangeProcessorPolicyIdList();
        this.createIntrospectionJwtResponseAlgorithmLists();
        this.createJwtSecuredAuthorizationResponseModeAlgorithmLists();
        this.createUserInfoResponseAlgorithmLists();
    }

    public OAuthClientManagementState(IWizard owner) {
        super(owner);
        this.init();
    }

    private void createLogoutModeList() {
        this.logoutModeList = new StringPairPropertySelectionModel();
        for (ClientLogoutMode logoutMode : ClientLogoutMode.values()) {
            this.logoutModeList.add(new StringPairPropertySelectionModel.SPair(logoutMode.getDisplayName(), logoutMode.name()));
        }
    }

    private void createRequestObjectSigningAlgorithmList() {
        this.requestObjectSigningAlgorithmList = new StringPairPropertySelectionModel(ALLOW_ANY_LABEL);
        List<StringPairPropertySelectionModel.SPair> availableAlgorithms = OpenIdConnectProviderInfo.getSupportedAsymmetricSignatureVerificationAlgorithms().entrySet().stream().map(entry -> new StringPairPropertySelectionModel.SPair((String)entry.getValue(), entry.getKey())).collect(Collectors.toList());
        this.requestObjectSigningAlgorithmList.addAll(availableAlgorithms);
    }

    private StringPairPropertySelectionModel createTokenEndpointAuthSigningAlgorithmList(Map<String, String> algDescMap) {
        StringPairPropertySelectionModel tokenEndpointAuthSigningAlgorithms = new StringPairPropertySelectionModel(ALLOW_ANY_LABEL);
        List<StringPairPropertySelectionModel.SPair> availableAlgorithms = algDescMap.entrySet().stream().map(entry -> new StringPairPropertySelectionModel.SPair((String)entry.getValue(), entry.getKey())).collect(Collectors.toList());
        tokenEndpointAuthSigningAlgorithms.addAll(availableAlgorithms);
        return tokenEndpointAuthSigningAlgorithms;
    }

    private void createCibaRequestObjectSigningAlgorithmList() {
        this.cibaRequestObjectSigningAlgorithmList = new StringPairPropertySelectionModel(ALLOW_ANY_LABEL);
        List<StringPairPropertySelectionModel.SPair> availableAlgorithms = OpenIdConnectProviderInfo.getSupportedAsymmetricSignatureVerificationAlgorithms().entrySet().stream().map(entry -> new StringPairPropertySelectionModel.SPair((String)entry.getValue(), entry.getKey())).collect(Collectors.toList());
        this.cibaRequestObjectSigningAlgorithmList.addAll(availableAlgorithms);
    }

    private void createIdTokenSigningAlgorithmList() {
        this.idTokenSigningAlgorithmList = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        Map signingAlgos = OpenIdConnectProviderInfo.idTokenSigningAlgMapSupportedWithNoneHmac();
        for (Map.Entry entry : signingAlgos.entrySet()) {
            this.idTokenSigningAlgorithmList.add((String)entry.getValue(), entry.getKey());
        }
        this.idTokenSigningAlgorithmList.sort();
    }

    private void createIdTokenEncryptionAlgorithmList() {
        this.idTokenEncryptionAlgorithmList = new StringPairPropertySelectionModel(NO_ENCRYPTION_LABEL);
        OpenIdConnectProviderInfo.getEncryptionAlgorithms().forEach(alg -> this.idTokenEncryptionAlgorithmList.add(OpenIdConnectProviderInfo.getEncryptionAlgName((String)alg), alg));
    }

    private void createIdTokenContentEncryptionAlgorithmList() {
        this.idTokenContentEncryptionAlgorithmList = new StringPairPropertySelectionModel();
        OpenIdConnectProviderInfo.getContentEncryptionAlgorithms().forEach(alg -> this.idTokenContentEncryptionAlgorithmList.add(OpenIdConnectProviderInfo.getContentEncryptionAlgName((String)alg), alg));
    }

    private void createPolicyGroupIdList() {
        this.policyIdList = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        OpenIdConnectProviderPolicyManager connectProviderPolicyManager = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        OpenIdConnectProviderPolicy policy = connectProviderPolicyManager.getPolicy();
        for (OpenIdConnectProviderPolicy.PolicyGroup policyGroup : policy.getPolicyGroups().values()) {
            String description = String.format("%s (%s)", policyGroup.getName(), policyGroup.getPolicyId());
            this.policyIdList.add(description, policyGroup.getPolicyId());
        }
    }

    private void createTokenManagerIdList() {
        this.tokenManagerIdList = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        Collection instances = MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances();
        for (BearerAccessTokenMgmtPluginInstance instance : instances) {
            this.tokenManagerIdList.add(instance.getName(), instance.getId());
        }
        this.tokenManagerIdList.sort();
    }

    private void createTokenExchangeProcessorPolicyIdList() {
        this.tokenExchangeProcessorPolicyIdList = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        TokenExchangeProcessorPolicies instances = MgmtFactory.getTokenExchangeProcessorPolicyManager().getTokenExchangeProcessorPolicies();
        for (TokenExchangeProcessorPolicy policy : instances.getPolicies().values()) {
            this.tokenExchangeProcessorPolicyIdList.add(policy.getName(), policy.getId());
        }
    }

    private void createIntrospectionJwtResponseAlgorithmLists() {
        StringPairPropertySelectionModel signingAlgorithms = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        List<StringPairPropertySelectionModel.SPair> availableSigningAlgorithms = OpenIdConnectProviderInfo.jwtSigningAlgorithmMap((boolean)true, (boolean)false).entrySet().stream().map(entry -> new StringPairPropertySelectionModel.SPair((String)entry.getValue(), entry.getKey())).collect(Collectors.toList());
        signingAlgorithms.addAll(availableSigningAlgorithms);
        this.introspectionSigningAlgorithmList = signingAlgorithms;
        StringPairPropertySelectionModel encryptionAlgorithms = new StringPairPropertySelectionModel(NO_ENCRYPTION_LABEL);
        List<StringPairPropertySelectionModel.SPair> availableEncryptionAlgorithms = OpenIdConnectProviderInfo.getEncryptionAlgorithms().stream().map(entry -> new StringPairPropertySelectionModel.SPair(OpenIdConnectProviderInfo.getEncryptionAlgName((String)entry), entry)).collect(Collectors.toList());
        encryptionAlgorithms.addAll(availableEncryptionAlgorithms);
        this.introspectionEncryptionAlgorithmList = encryptionAlgorithms;
        StringPairPropertySelectionModel contentEncryptionAlgorithms = new StringPairPropertySelectionModel();
        List<StringPairPropertySelectionModel.SPair> availableContentEncryptionAlgorithms = OpenIdConnectProviderInfo.getContentEncryptionAlgorithms().stream().map(entry -> new StringPairPropertySelectionModel.SPair(OpenIdConnectProviderInfo.getContentEncryptionAlgName((String)entry), entry)).collect(Collectors.toList());
        contentEncryptionAlgorithms.addAll(availableContentEncryptionAlgorithms);
        this.introspectionContentEncryptionAlgorithmList = contentEncryptionAlgorithms;
    }

    private void createJwtSecuredAuthorizationResponseModeAlgorithmLists() {
        StringPairPropertySelectionModel signingAlgorithms = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        List<StringPairPropertySelectionModel.SPair> availableSigningAlgorithms = OpenIdConnectProviderInfo.jwtSigningAlgorithmMap((boolean)true, (boolean)false).entrySet().stream().map(entry -> new StringPairPropertySelectionModel.SPair((String)entry.getValue(), entry.getKey())).collect(Collectors.toList());
        signingAlgorithms.addAll(availableSigningAlgorithms);
        this.authorizationResponseSigningAlgorithmList = signingAlgorithms;
        StringPairPropertySelectionModel encryptionAlgorithms = new StringPairPropertySelectionModel(NO_ENCRYPTION_LABEL);
        List<StringPairPropertySelectionModel.SPair> availableEncryptionAlgorithms = OpenIdConnectProviderInfo.getEncryptionAlgorithms().stream().map(entry -> new StringPairPropertySelectionModel.SPair(OpenIdConnectProviderInfo.getEncryptionAlgName((String)entry), entry)).collect(Collectors.toList());
        encryptionAlgorithms.addAll(availableEncryptionAlgorithms);
        this.authorizationResponseEncryptionAlgorithmList = encryptionAlgorithms;
        StringPairPropertySelectionModel contentEncryptionAlgorithms = new StringPairPropertySelectionModel();
        List<StringPairPropertySelectionModel.SPair> availableContentEncryptionAlgorithms = OpenIdConnectProviderInfo.getContentEncryptionAlgorithms().stream().map(entry -> new StringPairPropertySelectionModel.SPair(OpenIdConnectProviderInfo.getContentEncryptionAlgName((String)entry), entry)).collect(Collectors.toList());
        contentEncryptionAlgorithms.addAll(availableContentEncryptionAlgorithms);
        this.authorizationResponseContentEncryptionAlgorithmList = contentEncryptionAlgorithms;
    }

    private void createUserInfoResponseAlgorithmLists() {
        StringPairPropertySelectionModel signingAlgorithms = new StringPairPropertySelectionModel("- Select -");
        List<StringPairPropertySelectionModel.SPair> availableSigningAlgorithms = OpenIdConnectProviderInfo.jwtSigningAlgorithmMapWithHmacWithoutNone().entrySet().stream().map(entry -> new StringPairPropertySelectionModel.SPair((String)entry.getValue(), entry.getKey())).collect(Collectors.toList());
        signingAlgorithms.addAll(availableSigningAlgorithms);
        this.userInfoResponseSigningAlgorithmList = signingAlgorithms;
        StringPairPropertySelectionModel encryptionAlgorithms = new StringPairPropertySelectionModel(NO_ENCRYPTION_LABEL);
        List<StringPairPropertySelectionModel.SPair> availableEncryptionAlgorithms = OpenIdConnectProviderInfo.getEncryptionAlgorithms().stream().map(entry -> new StringPairPropertySelectionModel.SPair(OpenIdConnectProviderInfo.getEncryptionAlgName((String)entry), entry)).collect(Collectors.toList());
        encryptionAlgorithms.addAll(availableEncryptionAlgorithms);
        this.userInfoResponseEncryptionAlgorithmList = encryptionAlgorithms;
        StringPairPropertySelectionModel contentEncryptionAlgorithms = new StringPairPropertySelectionModel();
        List<StringPairPropertySelectionModel.SPair> availableContentEncryptionAlgorithms = OpenIdConnectProviderInfo.getContentEncryptionAlgorithms().stream().map(entry -> new StringPairPropertySelectionModel.SPair(OpenIdConnectProviderInfo.getContentEncryptionAlgName((String)entry), entry)).collect(Collectors.toList());
        contentEncryptionAlgorithms.addAll(availableContentEncryptionAlgorithms);
        this.userInfoResponseContentEncryptionAlgorithmList = contentEncryptionAlgorithms;
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk != null) {
            this.redirectUrisComponentState = null;
            this.logoutUrisComponentState = null;
            this.postLogoutRedirectUrisComponentState = null;
            Client client = (Client)dataFromDisk;
            this.originalEncodedSecret = client.getEncodedSecret();
            this.originalSecondarySecrets = client.getSecondarySecrets();
            this.secondarySecretPresent = this.originalSecondarySecrets != null && this.originalSecondarySecrets.getSecondarySecrets() != null && !this.originalSecondarySecrets.getSecondarySecrets().isEmpty();
            this.originalObfuscatedReversableSecret = client.getObfuscatedReversableSecret();
            this.secondarySecretRetentionPeriodType = client.getSecondarySecretRetentionPeriodType() == null ? this.secondarySecretRetentionPeriodType : client.getSecondarySecretRetentionPeriodType();
            this.secondarySecretRetentionPeriod = client.getSecondarySecretRetentionPeriod() == null ? this.secondarySecretRetentionPeriod : client.getSecondarySecretRetentionPeriod();
            this.clientSecretChangedTime = client.getClientSecretChangedTime();
            this.changeSecret = false;
            if (StringUtils.isNotBlank((String)client.getClientCertIssuerDn())) {
                if ("Trust Any".equals(client.getClientCertIssuerDn())) {
                    this.clientCertIssuer = this.trustAllDummyCert;
                } else {
                    for (Cert cert : this.trustedCAs) {
                        X500Principal configuredIssuerDn = new X500Principal(client.getClientCertIssuerDn());
                        if (!X500Util.equals((X500Principal)cert.getX509Certificate().getSubjectX500Principal(), (X500Principal)configuredIssuerDn)) continue;
                        this.clientCertIssuer = cert;
                        break;
                    }
                }
            }
            this.subjectDn = client.getClientCertSubjectDn();
            this.jwksUrl = client.getJwksUrl();
            this.jwks = client.getJwks();
            this.enforceReplayPrevention = client.isJwtAuthn() && Boolean.TRUE.equals(client.isEnforceReplayPrevention());
            this.clientSecretJwtReplayPrevention = client.isClientSecretJwtAuthn() && Boolean.TRUE.equals(client.isEnforceReplayPrevention());
            this.selectedTokenEndpointAuthSigningAlgorithm = client.isJwtAuthn() ? client.getTokenEndpointAuthSigningAlgorithm() : null;
            this.selectedTokenEndpointAuthSymmetricSigningAlgorithm = client.isClientSecretJwtAuthn() ? client.getTokenEndpointAuthSigningAlgorithm() : null;
            this.enabled = client.isEnabled();
            this.populateClientAuthnType(client);
            this.id = client.getClientId();
            this.name = client.getName();
            this.description = client.getDescription();
            if (client.getCreationTime() != null && !new Date(0L).equals(client.getCreationTime().getTime())) {
                this.creationTime = client.getCreationTime();
            }
            this.logoUrl = client.getLogoUrl();
            this.redirectUris = new ArrayList<String>(client.getRedirectUris());
            this.allowAuthzCode = client.isGrantTypeAllowed("authorization_code");
            this.allowROCreds = client.isGrantTypeAllowed("password");
            this.allowRefresh = client.isGrantTypeAllowed("refresh_token");
            this.allowImplict = client.isGrantTypeAllowed("implicit");
            this.allowClientCreds = client.isGrantTypeAllowed("client_credentials");
            this.allowExtension = client.isGrantTypeAllowed("extension");
            this.allowDeviceCode = client.isGrantTypeAllowed("urn:ietf:params:oauth:grant-type:device_code");
            this.allowCiba = client.isGrantTypeAllowed("urn:openid:params:grant-type:ciba");
            this.allowTokenExchange = client.isGrantTypeAllowed("urn:ietf:params:oauth:grant-type:token-exchange");
            this.allowValidate = client.isGrantTypeAllowed("urn:pingidentity.com:oauth2:grant_type:validate_bearer");
            this.rolling = client.getRefreshRolling() == null ? DEFAULT : client.getRefreshRolling();
            this.persistentGrantExpirationType = client.getPersistentGrantExpirationType() == null ? this.persistentGrantExpirationType : client.getPersistentGrantExpirationType();
            this.persistentGrantExpirationTime = client.getPersistentGrantExpirationTime() == null || client.getPersistentGrantExpirationTime() <= 0L ? this.persistentGrantExpirationTime : client.getPersistentGrantExpirationTime().toString();
            this.selectedPersistentGrantExpirationTimeUnit = client.getPersistentGrantExpirationTimeUnit();
            this.persistentGrantIdleTimeoutType = client.getPersistentGrantIdleTimeoutType() == null ? this.persistentGrantIdleTimeoutType : client.getPersistentGrantIdleTimeoutType();
            this.persistentGrantIdleTimeout = client.getPersistentGrantIdleTimeout() == null || client.getPersistentGrantIdleTimeout() <= 0L ? this.persistentGrantIdleTimeout : client.getPersistentGrantIdleTimeout().toString();
            this.selectedPersistentGrantIdleTimeoutTimeUnit = client.getPersistentGrantIdleTimeoutTimeUnit();
            this.grantTypesToReusePersistentGrantsType = client.getPersistentGrantReuseType() == null ? "SERVER_DEFAULT" : client.getPersistentGrantReuseType();
            this.reusePersistentGrantAuthzCode = client.isReusePersistentGrantTypeAllowed("authorization_code");
            this.reusePersistentGrantROPC = client.isReusePersistentGrantTypeAllowed("password");
            this.reusePersistentGrantImplicit = client.isReusePersistentGrantTypeAllowed("implicit");
            this.setSelectedIdTokenSigningAlgorithm(client.getIdTokenSigningAlgorithm());
            this.setSelectedIdTokenEncryptionAlgorithm(client.getIdTokenEncryptionAlgorithm());
            this.setSelectedIdTokenContentEncryptionAlgorithm(client.getIdTokenContentEncryptionAlgorithm());
            this.setSelectedUserInfoResponseSigningAlgorithm(client.getUserInfoResponseSigningAlgorithm());
            this.setSelectedUserInfoResponseEncryptionAlgorithm(client.getUserInfoResponseEncryptionAlgorithm());
            this.setSelectedUserInfoResponseContentEncryptionAlgorithm(client.getUserInfoResponseContentEncryptionAlgorithm());
            this.selectedPolicyGroupId = client.getPolicyGroupId();
            this.allowAuthenticationApiInit = client.getAllowAuthenticationApiInit();
            this.enableCookielessAuthenticationApi = client.getEnableCookielessAuthenticationApi();
            this.bypassApprovalPage = client.isBypassApprovalPage();
            this.restrictedScopes = new ArrayList<String>(client.getRestrictedScopes());
            this.restrictScopes = client.isRestrictScopes();
            this.restrictedResponseTypes = new ArrayList<String>(client.getRestrictedResponseTypes());
            this.restrictResponseTypes = client.isRestrictResponseTypes();
            this.registrationToken = client.getRegistrationAccessToken() != null ? client.getRegistrationAccessToken().toEncodedText() : null;
            this.exclusiveScopes = client.getExclusiveScopes();
            this.excludedScopes = client.isAllowedExclusiveScopes();
            this.authorizationDetailTypes = client.getAuthorizationDetailTypes();
            this.allowAuthorizationDetails = client.isAllowedAuthorizationDetailTypes();
            this.logoutUris = new ArrayList<String>(client.getLogoutUris());
            this.backChannelLogoutUri = client.getBackChannelLogoutUri();
            this.postLogoutRedirectUris = new ArrayList<String>(client.getPostLogoutRedirectUris());
            this.grantAccessSessionRevocationApi = client.isGrantAccessSessionRevocationApi();
            this.grantAccessSessionManagementApi = client.isGrantAccessSessionManagementApi();
            this.requireSignedRequest = client.isRequireSignedRequests();
            this.selectedRequestObjectSigningAlgorithm = client.getRequestObjectSigningAlgorithm();
            this.selectedLogoutMode = client.getLogoutMode().name();
            this.pingAccessLogoutCapable = client.isPingAccessLogoutCapable();
            this.selectedTokenManagerId = client.getDefaultAccessTokenManagerId();
            this.restrictToDefaultAccessTokenManager = client.isRestrictToDefaultAccessTokenManager();
            this.validateUsingAllEligibleAtms = client.isValidateUsingAllEligibleAtms();
            this.requireProofKeyForCodeExchange = client.isRequireProofKeyForCodeExchange();
            this.pairwiseUserType = client.isPairwiseUserType();
            this.sectorIdentifierUri = client.getSectorIdentifierUri();
            this.deviceFlowSettingType = client.getDeviceFlowSettingType();
            this.userAuthzUrlOverride = client.getUserAuthzUrlOverride();
            this.pendingAuthzTimeoutOverride = client.getPendingAuthzTimeoutOverride();
            this.devicePollingIntervalOverride = client.getDevicePollingIntervalOverride();
            this.bypassActivationCodeConfirmationOverride = client.getBypassActivationCodeConfirmationOverride();
            if (this.isAllowCiba()) {
                this.cibaMode = client.getCibaTokenDeliveryMode();
                this.cibaNotificationEndpoint = client.getCibaNotificationEndpoint();
                this.cibaRequireSignedRequests = client.isCibaRequireSignedRequests();
                this.cibaUserCodeSupported = client.isCibaUserCodeSupported();
                this.cibaPolicyId = client.getCibaPolicyId();
                this.cibaPollingInterval = String.valueOf(client.getCibaPollingInterval());
                this.selectedCibaRequestObjectSigningAlgorithm = client.getCibaRequestObjectSigningAlgorithm();
            }
            this.requirePar = client.isRequirePushedAuthorizationRequests();
            this.requireJarm = client.isRequireJwtSecuredAuthorizationResponseMode();
            if (this.isAllowTokenExchange()) {
                this.tokenExchangeProcessorPolicyId = client.getTokenExchangeProcessorPolicyId();
            }
            this.refreshTokenRollingGracePeriodType = client.getRefreshTokenRollingGracePeriodType();
            this.refreshTokenRollingGracePeriod = client.getRefreshTokenRollingGracePeriod() != null ? String.valueOf(client.getRefreshTokenRollingGracePeriod()) : null;
            this.selectedIntrospectionSigningAlgorithm = client.getIntrospectionSigningAlgorithm();
            this.selectedIntrospectionEncryptionAlgorithm = client.getIntrospectionEncryptionAlgorithm();
            this.selectedIntrospectionContentEncryptionAlgorithm = client.getIntrospectionContentEncryptionAlgorithm();
            this.selectedAuthorizationResponseSigningAlgorithm = client.getAuthorizationResponseSigningAlgorithm();
            this.selectedAuthorizationResponseEncryptionAlgorithm = client.getAuthorizationResponseEncryptionAlgorithm();
            this.selectedAuthorizationResponseContentEncryptionAlgorithm = client.getAuthorizationResponseContentEncryptionAlgorithm();
            this.requireDpop = client.isRequireDpop();
            this.requireOfflineAccessScopeToIssueRefreshTokens = client.getRequireOfflineAccessScopeToIssueRefreshTokens();
            this.offlineAccessRequireConsentPrompt = client.getOfflineAccessRequireConsentPrompt();
            this.lockoutMaxMaliciousActionsType = client.getLockoutMaxMaliciousActionsType();
            this.lockoutMaxMaliciousActions = client.getLockoutMaxMaliciousActions() != null ? String.valueOf(client.getLockoutMaxMaliciousActions()) : null;
            this.populateRefreshTokenRollingInterval(client.getRefreshTokenRollingInterval(), client.getRefreshTokenRollingIntervalTimeUnit());
        }
        this.loadAuthorizationDetailTypesCheckboxModel();
        this.loadRestrictResponseTypesCheckboxModel();
    }

    private void populateClientAuthnType(Client client) {
        this.clientAuthenticationType = client.getClientAuthnType();
    }

    @Override
    public boolean save(Object dataToDisk) {
        Client c = (Client)dataToDisk;
        this.fillDomain(c, true);
        if (this.changeSecret) {
            this.log.info((Object)String.format("%s updated the secret for client: %s", this.getCurrentUser().getUserName(), this.id));
        }
        this.redirectUrisComponentState = null;
        this.logoutUrisComponentState = null;
        this.postLogoutRedirectUrisComponentState = null;
        return true;
    }

    @Override
    protected void fillDomainRefreshTokenRolling(Object clientObject) {
        Client client = (Client)clientObject;
        String rollingIntervalType = this.getRefreshRollingIntervalType();
        if (rollingIntervalType == null || "SERVER_DEFAULT".equals(rollingIntervalType)) {
            client.setRefreshTokenRollingIntervalType("SERVER_DEFAULT");
            client.setRefreshTokenRollingInterval(null);
            client.setRefreshTokenRollingIntervalTimeUnit(null);
        } else if ("OVERRIDE_SERVER_DEFAULT".equals(rollingIntervalType)) {
            client.setRefreshTokenRollingIntervalType("OVERRIDE_SERVER_DEFAULT");
            if (this.getRefreshRollingInterval() != null) {
                client.setRefreshTokenRollingInterval(Long.valueOf(Long.parseLong(this.getRefreshRollingInterval())));
                client.setRefreshTokenRollingIntervalTimeUnit(this.getSelectedRefreshRollingIntervalTimeUnit());
            }
        }
    }

    private void fillDomain(Client client, boolean validNumberRefreshTokenInterval) {
        List authorizationDetailTypesList;
        client.setClientId(this.id);
        client.setName(this.name);
        client.setEnabled(this.enabled);
        client.setDescription(this.description);
        client.setLogoUrl(this.logoUrl);
        client.setCreationTime(this.creationTime);
        client.setRedirectUris(this.redirectUris);
        client.setLogoutUris(this.logoutUris.stream().map(StringUtils::trim).collect(Collectors.toList()));
        if (StringUtils.isNotBlank((String)this.backChannelLogoutUri)) {
            client.setBackChannelLogoutUri(StringUtils.trim((String)this.backChannelLogoutUri));
        }
        client.setPostLogoutRedirectUris(this.postLogoutRedirectUris.stream().map(StringUtils::trim).collect(Collectors.toList()));
        HashSet<String> grants = new HashSet<String>();
        this.checkAdd(this.allowAuthzCode, "authorization_code", grants);
        this.checkAdd(this.allowROCreds, "password", grants);
        this.checkAdd(this.allowRefresh, "refresh_token", grants);
        this.checkAdd(this.allowImplict, "implicit", grants);
        this.checkAdd(this.allowClientCreds, "client_credentials", grants);
        this.checkAdd(this.allowValidate, "urn:pingidentity.com:oauth2:grant_type:validate_bearer", grants);
        this.checkAdd(this.allowExtension, "extension", grants);
        this.checkAdd(this.allowDeviceCode, "urn:ietf:params:oauth:grant-type:device_code", grants);
        this.checkAdd(this.allowCiba, "urn:openid:params:grant-type:ciba", grants);
        this.checkAdd(this.allowTokenExchange, "urn:ietf:params:oauth:grant-type:token-exchange", grants);
        client.setGrantTypes(grants);
        if (!DEFAULT.equals(this.rolling)) {
            client.setRefreshRolling(this.rolling);
        }
        if (validNumberRefreshTokenInterval) {
            this.fillDomainRefreshTokenRolling(client);
        }
        client.setClientAuthnType(this.clientAuthenticationType);
        client.setEnforceReplayPrevention(Boolean.valueOf(this.enforceReplayPrevention || this.clientSecretJwtReplayPrevention));
        if (this.clientAuthenticationType == ClientAuthenticationType.PRIVATE_KEY_JWT) {
            client.setTokenEndpointAuthSigningAlgorithm(this.selectedTokenEndpointAuthSigningAlgorithm);
        } else if (this.clientAuthenticationType == ClientAuthenticationType.CLIENT_SECRET_JWT) {
            client.setTokenEndpointAuthSigningAlgorithm(this.selectedTokenEndpointAuthSymmetricSigningAlgorithm);
        }
        client.setSecondarySecretRetentionPeriodType(this.secondarySecretRetentionPeriodType);
        if ("SERVER_DEFAULT".equals(client.getSecondarySecretRetentionPeriodType())) {
            client.setSecondarySecretRetentionPeriod(null);
        } else {
            client.setSecondarySecretRetentionPeriod(this.secondarySecretRetentionPeriod);
        }
        client.setEncodedSecret(this.originalEncodedSecret);
        client.setObfuscatedReversableSecret(this.originalObfuscatedReversableSecret);
        client.setClientSecretChangedTime(this.clientSecretChangedTime);
        client.setSecondarySecrets(this.originalSecondarySecrets);
        if (this.changeSecret) {
            client.setSecret(this.secret);
            client.setForceSecretChange(Boolean.valueOf(true));
            if (StringUtils.isNotBlank((String)this.originalEncodedSecret)) {
                HashedPassword originalSecret = HashedPassword.fromEncodedText((String)this.originalEncodedSecret);
                client.setSecondarySecrets(this.originalSecondarySecrets);
                if (!originalSecret.checkSecret(this.secret) && ClientSecretRetentionHelper.isRetainClientSecret((Client)client)) {
                    Instant expiry = ClientSecretRetentionHelper.getExpiryTimeForSecondarySecret((Client)client);
                    client.addEncodedSecondarySecret(this.originalEncodedSecret, this.originalObfuscatedReversableSecret, Date.from(expiry));
                }
            }
        }
        switch (this.clientAuthenticationType) {
            case CLIENT_CERT: {
                if (this.clientCertIssuer != null) {
                    if ("Trust Any".equals(this.clientCertIssuer.getAlias())) {
                        client.setClientCertIssuerDn("Trust Any");
                    } else {
                        client.setClientCertIssuerDn(this.clientCertIssuer.getX509Certificate().getSubjectDN().getName());
                    }
                }
                if (!StringUtils.isNotBlank((String)this.subjectDn)) break;
                client.setClientCertSubjectDn(this.subjectDn);
                break;
            }
        }
        if (this.selectedPersistentGrantExpirationTimeUnit == null) {
            this.selectedPersistentGrantExpirationTimeUnit = "d";
        }
        client.setPersistentGrantExpirationType(this.persistentGrantExpirationType);
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.persistentGrantExpirationType)) {
            long expTime = StringUtils.isEmpty((String)this.persistentGrantExpirationTime) || !ValidationUtil.isValidLong((String)this.persistentGrantExpirationTime) ? -1L : Long.parseLong(this.persistentGrantExpirationTime);
            client.setPersistentGrantExpirationTime(Long.valueOf(expTime));
            client.setPersistentGrantExpirationTimeUnit(this.selectedPersistentGrantExpirationTimeUnit);
        }
        client.setPersistentGrantIdleTimeoutType(this.persistentGrantIdleTimeoutType);
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.persistentGrantIdleTimeoutType)) {
            long idleTimeout = StringUtils.isEmpty((String)this.persistentGrantIdleTimeout) || !ValidationUtil.isValidLong((String)this.persistentGrantIdleTimeout) ? -1L : Long.parseLong(this.persistentGrantIdleTimeout);
            client.setPersistentGrantIdleTimeout(Long.valueOf(idleTimeout));
            client.setPersistentGrantIdleTimeoutTimeUnit(this.selectedPersistentGrantIdleTimeoutTimeUnit);
        }
        client.setPersistentGrantReuseType(this.grantTypesToReusePersistentGrantsType);
        if (!this.grantTypesToReusePersistentGrantsType.equals("SERVER_DEFAULT")) {
            HashSet<String> grantTypesToReuse = new HashSet<String>();
            if (this.reusePersistentGrantAuthzCode) {
                grantTypesToReuse.add("authorization_code");
            }
            if (this.reusePersistentGrantROPC) {
                grantTypesToReuse.add("password");
            }
            if (this.reusePersistentGrantImplicit) {
                grantTypesToReuse.add("implicit");
            }
            client.setPersistentGrantReuseGrantTypes(grantTypesToReuse);
        }
        client.setIdTokenSigningAlgorithm(this.selectedIdTokenSigningAlgorithm);
        client.setIdTokenEncryptionAlgorithm(this.selectedIdTokenEncryptionAlgorithm);
        if (StringUtils.isNotBlank((String)this.selectedIdTokenEncryptionAlgorithm)) {
            client.setIdTokenContentEncryptionAlgorithm(this.selectedIdTokenContentEncryptionAlgorithm);
        } else {
            client.setIdTokenContentEncryptionAlgorithm(null);
        }
        client.setUserInfoResponseSigningAlgorithm(this.selectedUserInfoResponseSigningAlgorithm);
        if (StringUtils.isNotBlank((String)this.selectedUserInfoResponseSigningAlgorithm)) {
            client.setUserInfoResponseEncryptionAlgorithm(this.selectedUserInfoResponseEncryptionAlgorithm);
        } else {
            client.setUserInfoResponseEncryptionAlgorithm(null);
        }
        if (StringUtils.isNotBlank((String)this.selectedUserInfoResponseSigningAlgorithm) && StringUtils.isNotBlank((String)this.selectedUserInfoResponseEncryptionAlgorithm)) {
            client.setUserInfoResponseContentEncryptionAlgorithm(this.selectedUserInfoResponseContentEncryptionAlgorithm);
        } else {
            client.setUserInfoResponseContentEncryptionAlgorithm(null);
        }
        client.setPolicyGroupId(this.selectedPolicyGroupId);
        client.setAllowAuthenticationApiInit(this.allowAuthenticationApiInit);
        client.setEnableCookielessAuthenticationApi(this.enableCookielessAuthenticationApi);
        client.setBypassApprovalPage(this.bypassApprovalPage);
        client.setRestrictScopes(this.restrictScopes);
        client.setRestrictedScopes(this.restrictedScopes);
        client.setAllowedExcludedScopes(this.excludedScopes);
        if (!this.exclusiveScopes.isEmpty() && client.isAllowedExclusiveScopes()) {
            client.setExclusiveScopes(this.exclusiveScopes);
        } else {
            client.setExclusiveScopes(null);
        }
        client.setRestrictResponseTypes(this.restrictResponseTypes);
        client.setAllowedAuthorizationDetailTypes(this.allowAuthorizationDetails);
        client.setDefaultAccessTokenManagerId(this.selectedTokenManagerId);
        client.setRestrictToDefaultAccessTokenManager(this.restrictToDefaultAccessTokenManager);
        if (StringUtils.isNotBlank((String)this.registrationToken)) {
            client.setRegistrationAccessToken(HashedPassword.fromEncodedText((String)this.registrationToken));
        }
        ArrayList<String> responseTypesList = new ArrayList<String>();
        for (CheckboxItem responseType : this.getRestrictResponseTypesCheckboxModel().getCheckboxItems()) {
            if (!responseType.getChecked()) continue;
            responseTypesList.add(responseType.getName());
        }
        if (this.restrictResponseTypes && !responseTypesList.isEmpty()) {
            client.setRestrictedResponseTypes(responseTypesList);
        }
        if (!(authorizationDetailTypesList = this.getAuthorizationDetailTypesCheckboxModel().getCheckboxItems().stream().filter(CheckboxItem::isChecked).map(typeCheckBoxItem -> StringUtils.removeEnd((String)typeCheckBoxItem.getName(), (String)INACTIVE_LABEL)).collect(Collectors.toList())).isEmpty() && client.isAllowedAuthorizationDetailTypes()) {
            client.setAuthorizationDetailTypes(authorizationDetailTypesList);
        } else {
            client.setAuthorizationDetailTypes(null);
        }
        client.setGrantAccessSessionRevocationApi(this.grantAccessSessionRevocationApi);
        client.setGrantAccessSessionManagementApi(this.grantAccessSessionManagementApi);
        client.setLogoutMode(ClientLogoutMode.valueOf((String)this.selectedLogoutMode));
        client.setPingAccessLogoutCapable(this.pingAccessLogoutCapable);
        client.setValidateUsingAllEligibleAtms(this.validateUsingAllEligibleAtms);
        client.setRequireProofKeyForCodeExchange(this.requireProofKeyForCodeExchange);
        if (this.pairwiseUserType) {
            client.setPairwiseUserType(this.pairwiseUserType);
            client.setSectorIdentifierUri(this.sectorIdentifierUri);
        }
        client.setRequireSignedRequests(this.requireSignedRequest);
        client.setRequestObjectSigningAlgorithm(this.selectedRequestObjectSigningAlgorithm);
        client.setJwksUrl(this.jwksUrl);
        client.setJwks(this.jwks);
        client.setDeviceFlowSettingType(this.deviceFlowSettingType);
        client.setUserAuthzUrlOverride(this.userAuthzUrlOverride);
        client.setPendingAuthzTimeoutOverride(this.pendingAuthzTimeoutOverride);
        client.setDevicePollingIntervalOverride(this.devicePollingIntervalOverride);
        client.setBypassActivationCodeConfirmationOverride(this.bypassActivationCodeConfirmationOverride);
        if (this.isAllowCiba()) {
            client.setCibaTokenDeliveryMode(this.cibaMode);
            if (CibaDeliveryMode.poll == this.cibaMode) {
                this.cibaNotificationEndpoint = null;
            }
            client.setCibaNotificationEndpoint(this.cibaNotificationEndpoint);
            client.setCibaRequireSignedRequests(Boolean.valueOf(this.cibaRequireSignedRequests));
            client.setCibaUserCodeSupported(Boolean.valueOf(this.cibaUserCodeSupported));
            client.setCibaPolicyId(this.cibaPolicyId);
            boolean isPollingIntervalValid = ValidationUtil.isValidInt((String)this.cibaPollingInterval);
            client.setCibaPollingInterval(Integer.valueOf(isPollingIntervalValid ? Integer.parseInt(this.cibaPollingInterval) : -1));
            client.setCibaRequestObjectSigningAlgorithm(this.selectedCibaRequestObjectSigningAlgorithm);
        }
        client.setRequirePushedAuthorizationRequests(this.requirePar);
        client.setRequireJwtSecuredAuthorizationResponseMode(this.requireJarm);
        if (this.isAllowTokenExchange()) {
            client.setTokenExchangeProcessorPolicyId(this.tokenExchangeProcessorPolicyId);
        }
        client.setRefreshTokenRollingGracePeriodType(this.refreshTokenRollingGracePeriodType);
        if ("SERVER_DEFAULT".equals(this.refreshTokenRollingGracePeriodType)) {
            client.setRefreshTokenRollingGracePeriod(null);
        } else if (StringUtils.isNotBlank((String)this.refreshTokenRollingGracePeriod)) {
            if (ValidationUtil.isValidInt((String)this.refreshTokenRollingGracePeriod)) {
                client.setRefreshTokenRollingGracePeriod(Integer.valueOf(Integer.parseInt(this.refreshTokenRollingGracePeriod)));
            } else {
                client.setRefreshTokenRollingGracePeriod(Integer.valueOf(-1));
            }
        }
        if (this.allowValidate) {
            client.setIntrospectionSigningAlgorithm(this.selectedIntrospectionSigningAlgorithm);
            client.setIntrospectionEncryptionAlgorithm(this.selectedIntrospectionEncryptionAlgorithm);
            if (StringUtils.isNotBlank((String)this.selectedIntrospectionEncryptionAlgorithm)) {
                client.setIntrospectionContentEncryptionAlgorithm(this.selectedIntrospectionContentEncryptionAlgorithm);
            } else {
                client.setIntrospectionContentEncryptionAlgorithm(null);
            }
        } else {
            client.setIntrospectionSigningAlgorithm(null);
            client.setIntrospectionEncryptionAlgorithm(null);
            client.setIntrospectionContentEncryptionAlgorithm(null);
        }
        if (this.allowImplict || this.allowAuthzCode) {
            client.setAuthorizationResponseSigningAlgorithm(this.selectedAuthorizationResponseSigningAlgorithm);
            client.setAuthorizationResponseEncryptionAlgorithm(this.selectedAuthorizationResponseEncryptionAlgorithm);
            if (StringUtils.isNotBlank((String)this.selectedAuthorizationResponseEncryptionAlgorithm)) {
                client.setAuthorizationResponseContentEncryptionAlgorithm(this.selectedAuthorizationResponseContentEncryptionAlgorithm);
            } else {
                client.setAuthorizationResponseContentEncryptionAlgorithm(null);
            }
        } else {
            client.setAuthorizationResponseSigningAlgorithm(null);
            client.setAuthorizationResponseEncryptionAlgorithm(null);
            client.setAuthorizationResponseContentEncryptionAlgorithm(null);
        }
        client.setRequireDpop(this.requireDpop);
        client.setRequireOfflineAccessScopeToIssueRefreshTokens(this.requireOfflineAccessScopeToIssueRefreshTokens);
        if (this.isRequireOfflineAccessScopeToIssueRefreshTokensValueYes()) {
            client.setOfflineAccessRequireConsentPrompt(this.offlineAccessRequireConsentPrompt);
        } else {
            client.setOfflineAccessRequireConsentPrompt(null);
        }
        client.setLockoutMaxMaliciousActionsType(this.lockoutMaxMaliciousActionsType);
        if ("SERVER_DEFAULT".equals(this.lockoutMaxMaliciousActionsType)) {
            client.setLockoutMaxMaliciousActions(null);
        } else if (StringUtils.isNotBlank((String)this.lockoutMaxMaliciousActions)) {
            if (ValidationUtil.isValidInt((String)this.lockoutMaxMaliciousActions)) {
                client.setLockoutMaxMaliciousActions(Integer.valueOf(Integer.parseInt(this.lockoutMaxMaliciousActions)));
            } else {
                client.setLockoutMaxMaliciousActions(Integer.valueOf(-1));
            }
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        switch (this.clientAuthenticationType) {
            case SECRET: 
            case CLIENT_SECRET_JWT: 
            case PRIVATE_KEY_JWT: {
                this.clientCertIssuer = null;
                this.subjectDn = null;
                break;
            }
        }
        ScopeSelectionModalUtil.setScopesForModal(cycle.getRequestContext(), this::setRestrictedScopes, this::setExclusiveScopes);
    }

    private void checkAdd(boolean condition, String value, Set<String> grants) {
        if (condition) {
            grants.add(value);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Client temp = new Client();
        boolean validLong = this.validateRefreshTokenIntervalNumber(delegate);
        this.fillDomain(temp, validLong);
        OAuthClientValidator validator = new OAuthClientValidator(temp, id -> {
            OAuthClientsManagementState clientsState = this.findParentState(OAuthClientsManagementState.class);
            OAuthClientManagementTasklet thisClientManagementTasklet = this.findParent(OAuthClientManagementTasklet.class);
            if (clientsState != null) {
                ArrayList<OAuthClientManagementTasklet> tasklets = new ArrayList<OAuthClientManagementTasklet>(clientsState.getCurrentOpenTasklets());
                for (Tasklet tasklet : tasklets) {
                    OAuthClientManagementTasklet clientTasklet = (OAuthClientManagementTasklet)tasklet;
                    if (!StringUtils.equals((String)id, (String)clientTasklet.getClientId()) || thisClientManagementTasklet == clientTasklet) continue;
                    return false;
                }
            } else {
                OAuthClientManagementTasklet clientTasklet = (OAuthClientManagementTasklet)this.getParent();
                if (clientTasklet.isUpdate()) {
                    return true;
                }
                try {
                    Client client = MgmtFactory.getClientManager().getClient(id);
                    return client == null;
                }
                catch (ClientManager.ClientManagementException clientManagementException) {
                    delegate.record("An error occurred while saving the client.", ValidationConstraint.REQUIRED);
                }
            }
            return true;
        });
        validator.setStateUIValidation(true);
        validator.validate();
        this.recordErrors(validator.getErrors(), delegate);
    }

    private void toggleDisplayAlgorithmWarning() {
        this.displayAlgorithmWarning = StringUtils.isNotBlank((String)this.selectedIdTokenSigningAlgorithm) && OpenIdConnectProviderInfo.idTokenSigningAlgMapSupportedWithNoneHmac().get(this.selectedIdTokenSigningAlgorithm) == null;
    }

    private void toggleDisplayIntrospectionAlgorithmWarning() {
        this.displayIntrospectionAlgorithmWarning = StringUtils.isNotBlank((String)this.selectedIntrospectionSigningAlgorithm) && OpenIdConnectProviderInfo.jwtSigningAlgorithmMap((boolean)true, (boolean)false).get(this.selectedIntrospectionSigningAlgorithm) == null;
    }

    private void toggleDisplayAuthorizationResponseAlgorithmWarning() {
        this.displayAuthorizationResponseAlgorithmWarning = StringUtils.isNotBlank((String)this.selectedAuthorizationResponseSigningAlgorithm) && OpenIdConnectProviderInfo.jwtSigningAlgorithmMap((boolean)true, (boolean)false).get(this.selectedAuthorizationResponseSigningAlgorithm) == null;
    }

    private void toggleDisplayUserInfoResponseAlgorithmWarning() {
        this.displayUserInfoResponseAlgorithmWarning = StringUtils.isNotBlank((String)this.selectedUserInfoResponseSigningAlgorithm) && OpenIdConnectProviderInfo.jwtSigningAlgorithmMap((boolean)true, (boolean)false).get(this.selectedUserInfoResponseSigningAlgorithm) == null;
    }

    public void extractSubjectDn() {
        this.subjectDn = "";
        this.cert = null;
        this.importCertFile();
        if (this.getErrorMessage() == null && this.cert != null) {
            this.subjectDn = this.cert.getX509Certificate().getSubjectDN().getName();
        } else if (this.getErrorMessage() != null) {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getErrorMessage(), ValidationConstraint.REQUIRED);
        } else {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getMessage("Valid_path_required"), ValidationConstraint.REQUIRED);
        }
        this.certFile = null;
    }

    protected void importCertFile() {
        this.errorMessage = null;
        if (this.certFile != null && this.certFile.getSize() > 0L) {
            try (InputStream stream = this.certFile.getStream();){
                this.cert = Cert.importCert((InputStream)stream);
            }
            catch (CertificateParsingException certParsingEx) {
                this.log.error((Object)"Importing this file caused an exception: ", (Throwable)certParsingEx);
                this.errorMessage = this.getMessage("Certificate_parsing_exception");
            }
            catch (CertificateExpiredException certExpiredEx) {
                this.log.error((Object)"Importing this file caused an exception: ", (Throwable)certExpiredEx);
                this.errorMessage = this.getMessage("Certificate_expired");
            }
            catch (IOException | GeneralSecurityException e) {
                this.log.error((Object)"Importing this file caused an exception: ", (Throwable)e);
                this.errorMessage = this.getMessage("Error_importing_file_see_log");
            }
        }
    }

    public IPropertySelectionModel getClientCertIssuers() {
        StringPairPropertySelectionModel clientCertIssuerList = new StringPairPropertySelectionModel(true);
        if (!this.trustedCAs.isEmpty()) {
            clientCertIssuerList.add("Trust Any", this.trustAllDummyCert);
        }
        for (Cert cert : this.trustedCAs) {
            clientCertIssuerList.add(cert.getDescriptionForDisplay(35), cert);
        }
        return clientCertIssuerList;
    }

    public boolean disableClientCertComponents() {
        return this.clientAuthenticationType != ClientAuthenticationType.CLIENT_CERT;
    }

    public Cert getClientCertIssuer() {
        return this.clientCertIssuer;
    }

    public void setClientCertIssuer(Cert clientCertIssuer) {
        this.clientCertIssuer = clientCertIssuer;
    }

    public String getSubjectDn() {
        return this.subjectDn;
    }

    public void setSubjectDn(String subjectDn) {
        this.subjectDn = subjectDn;
    }

    public boolean isCreateMode() {
        Tasklet t = this.getParent();
        return t.getMode() == Mode.create;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUri(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public boolean isPingAccessLogoutCapable() {
        return this.pingAccessLogoutCapable;
    }

    public void setPingAccessLogoutCapable(boolean pingAccessLogoutCapable) {
        this.pingAccessLogoutCapable = pingAccessLogoutCapable;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl.trim();
    }

    public boolean isAllowAuthzCode() {
        return this.allowAuthzCode;
    }

    public void setAllowAuthzCode(boolean allowAuthzCode) {
        this.allowAuthzCode = allowAuthzCode;
    }

    public boolean isAllowROCreds() {
        return this.allowROCreds;
    }

    public void setAllowROCreds(boolean allowROCreds) {
        this.allowROCreds = allowROCreds;
    }

    public boolean isAllowRefresh() {
        return this.allowRefresh;
    }

    public void setAllowRefresh(boolean allowRefresh) {
        this.allowRefresh = allowRefresh;
    }

    public boolean isAllowImplict() {
        return this.allowImplict;
    }

    public void setAllowImplict(boolean allowImplict) {
        this.allowImplict = allowImplict;
    }

    public boolean isAllowClientCreds() {
        return this.allowClientCreds;
    }

    public void setAllowClientCreds(boolean allowClientCreds) {
        this.allowClientCreds = allowClientCreds;
    }

    public boolean isAllowValidate() {
        return this.allowValidate;
    }

    public void setAllowValidate(boolean allowValidate) {
        this.allowValidate = allowValidate;
    }

    public boolean isAllowExtension() {
        return this.allowExtension;
    }

    public void setAllowExtension(boolean allowExtension) {
        this.allowExtension = allowExtension;
    }

    public String getRolling() {
        return this.rolling;
    }

    public void setRolling(String rolling) {
        this.rolling = rolling;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean isChangeSecret() {
        return this.changeSecret;
    }

    public void setChangeSecret(boolean changeSecret) {
        this.changeSecret = changeSecret;
    }

    public String getOriginalEncodedSecret() {
        return this.originalEncodedSecret;
    }

    public String getOriginalObfuscatedReversableSecret() {
        return this.originalObfuscatedReversableSecret;
    }

    public String getPersistentGrantExpirationType() {
        return this.persistentGrantExpirationType;
    }

    public void setPersistentGrantExpirationType(String persistentGrantExpirationType) {
        this.persistentGrantExpirationType = persistentGrantExpirationType;
    }

    public String getPersistentGrantExpirationTime() {
        return this.persistentGrantExpirationTime;
    }

    public void setPersistentGrantExpirationTime(String persistentGrantExpirationTime) {
        this.persistentGrantExpirationTime = persistentGrantExpirationTime;
    }

    public String getSelectedPersistentGrantExpirationTimeUnit() {
        return this.selectedPersistentGrantExpirationTimeUnit;
    }

    public void setSelectedPersistentGrantExpirationTimeUnit(String selectedPersistentGrantExpirationTimeUnit) {
        this.selectedPersistentGrantExpirationTimeUnit = selectedPersistentGrantExpirationTimeUnit;
    }

    public StringPairPropertySelectionModel getPersistentGrantExpirationTimeUnitList() {
        return this.persistentGrantExpirationTimeUnitList;
    }

    public void setPersistentGrantExpirationTimeUnitList(StringPairPropertySelectionModel persistentGrantExpirationTimeUnitList) {
        this.persistentGrantExpirationTimeUnitList = persistentGrantExpirationTimeUnitList;
    }

    public String getPersistentGrantIdleTimeoutType() {
        return this.persistentGrantIdleTimeoutType;
    }

    public void setPersistentGrantIdleTimeoutType(String persistentGrantIdleTimeoutType) {
        this.persistentGrantIdleTimeoutType = persistentGrantIdleTimeoutType;
    }

    public String getPersistentGrantIdleTimeout() {
        return this.persistentGrantIdleTimeout;
    }

    public void setPersistentGrantIdleTimeout(String persistentGrantIdleTimeout) {
        this.persistentGrantIdleTimeout = persistentGrantIdleTimeout;
    }

    public String getSelectedPersistentGrantIdleTimeoutTimeUnit() {
        return this.selectedPersistentGrantIdleTimeoutTimeUnit;
    }

    public void setSelectedPersistentGrantIdleTimeoutTimeUnit(String selectedPersistentGrantIdleTimeoutTimeUnit) {
        this.selectedPersistentGrantIdleTimeoutTimeUnit = selectedPersistentGrantIdleTimeoutTimeUnit;
    }

    public StringPairPropertySelectionModel getPersistentGrantIdleTimeoutTimeUnitList() {
        return this.persistentGrantIdleTimeoutTimeUnitList;
    }

    public void setPersistentGrantIdleTimeoutTimeUnitList(StringPairPropertySelectionModel persistentGrantIdleTimeoutTimeUnitList) {
        this.persistentGrantIdleTimeoutTimeUnitList = persistentGrantIdleTimeoutTimeUnitList;
    }

    public String getSelectedIdTokenSigningAlgorithm() {
        return this.selectedIdTokenSigningAlgorithm;
    }

    public void setSelectedIdTokenSigningAlgorithm(String selectedIdTokenSigningAlgorithm) {
        this.selectedIdTokenSigningAlgorithm = selectedIdTokenSigningAlgorithm;
        this.toggleDisplayAlgorithmWarning();
    }

    public void setSelectedIdTokenEncryptionAlgorithm(String selectedIdTokenEncryptionAlgorithm) {
        this.selectedIdTokenEncryptionAlgorithm = selectedIdTokenEncryptionAlgorithm;
    }

    public void setSelectedIdTokenContentEncryptionAlgorithm(String selectedIdTokenContentEncryptionAlgorithm) {
        this.selectedIdTokenContentEncryptionAlgorithm = selectedIdTokenContentEncryptionAlgorithm;
    }

    public String getSelectedIdTokenEncryptionAlgorithm() {
        return this.selectedIdTokenEncryptionAlgorithm;
    }

    public String getSelectedIdTokenContentEncryptionAlgorithm() {
        return this.selectedIdTokenContentEncryptionAlgorithm;
    }

    public StringPairPropertySelectionModel getIdTokenEncryptionAlgorithmList() {
        return this.idTokenEncryptionAlgorithmList;
    }

    public void setIdTokenEncryptionAlgorithmList(StringPairPropertySelectionModel idTokenEncryptionAlgorithmList) {
        this.idTokenEncryptionAlgorithmList = idTokenEncryptionAlgorithmList;
    }

    public StringPairPropertySelectionModel getIdTokenContentEncryptionAlgorithmList() {
        return this.idTokenContentEncryptionAlgorithmList;
    }

    public void setIdTokenContentEncryptionAlgorithmList(StringPairPropertySelectionModel idTokenContentEncryptionAlgorithmList) {
        this.idTokenContentEncryptionAlgorithmList = idTokenContentEncryptionAlgorithmList;
    }

    public StringPairPropertySelectionModel getIdTokenSigningAlgorithmList() {
        return this.idTokenSigningAlgorithmList;
    }

    public void setIdTokenSigningAlgorithmList(StringPairPropertySelectionModel idTokenSigningAlgorithmList) {
        this.idTokenSigningAlgorithmList = idTokenSigningAlgorithmList;
    }

    public String getSelectedUserInfoResponseSigningAlgorithm() {
        return this.selectedUserInfoResponseSigningAlgorithm;
    }

    public void setSelectedUserInfoResponseSigningAlgorithm(String selectedUserInfoResponseSigningAlgorithm) {
        this.selectedUserInfoResponseSigningAlgorithm = selectedUserInfoResponseSigningAlgorithm;
        this.toggleDisplayUserInfoResponseAlgorithmWarning();
    }

    public String getSelectedUserInfoResponseEncryptionAlgorithm() {
        return this.selectedUserInfoResponseEncryptionAlgorithm;
    }

    public void setSelectedUserInfoResponseEncryptionAlgorithm(String selectedUserInfoResponseEncryptionAlgorithm) {
        this.selectedUserInfoResponseEncryptionAlgorithm = selectedUserInfoResponseEncryptionAlgorithm;
    }

    public String getSelectedUserInfoResponseContentEncryptionAlgorithm() {
        return this.selectedUserInfoResponseContentEncryptionAlgorithm;
    }

    public void setSelectedUserInfoResponseContentEncryptionAlgorithm(String selectedUserInfoResponseContentEncryptionAlgorithm) {
        this.selectedUserInfoResponseContentEncryptionAlgorithm = selectedUserInfoResponseContentEncryptionAlgorithm;
    }

    public StringPairPropertySelectionModel getUserInfoResponseSigningAlgorithmList() {
        return this.userInfoResponseSigningAlgorithmList;
    }

    public void setUserInfoResponseSigningAlgorithmList(StringPairPropertySelectionModel userInfoResponseSigningAlgorithmList) {
        this.userInfoResponseSigningAlgorithmList = userInfoResponseSigningAlgorithmList;
    }

    public StringPairPropertySelectionModel getUserInfoResponseEncryptionAlgorithmList() {
        return this.userInfoResponseEncryptionAlgorithmList;
    }

    public void setUserInfoResponseEncryptionAlgorithmList(StringPairPropertySelectionModel userInfoResponseEncryptionAlgorithmList) {
        this.userInfoResponseEncryptionAlgorithmList = userInfoResponseEncryptionAlgorithmList;
    }

    public StringPairPropertySelectionModel getUserInfoResponseContentEncryptionAlgorithmList() {
        return this.userInfoResponseContentEncryptionAlgorithmList;
    }

    public void setUserInfoResponseContentEncryptionAlgorithmList(StringPairPropertySelectionModel userInfoResponseContentEncryptionAlgorithmList) {
        this.userInfoResponseContentEncryptionAlgorithmList = userInfoResponseContentEncryptionAlgorithmList;
    }

    public boolean isDisplayUserInfoResponseAlgorithmWarning() {
        return this.displayUserInfoResponseAlgorithmWarning;
    }

    public String getSelectedPolicyGroupId() {
        return this.selectedPolicyGroupId;
    }

    public void setSelectedPolicyGroupId(String selectedPolicyGroupId) {
        this.selectedPolicyGroupId = selectedPolicyGroupId;
    }

    public StringPairPropertySelectionModel getPolicyGroupIdList() {
        return this.policyIdList;
    }

    public void setPolicyGroupIdList(StringPairPropertySelectionModel policyGroupIdList) {
        this.policyIdList = policyGroupIdList;
    }

    public String getSelectedTokenManagerId() {
        return this.selectedTokenManagerId;
    }

    public void setSelectedTokenManagerId(String selectedTokenManagerId) {
        this.selectedTokenManagerId = selectedTokenManagerId;
    }

    public boolean isRestrictToDefaultAccessTokenManager() {
        return this.restrictToDefaultAccessTokenManager;
    }

    public void setRestrictToDefaultAccessTokenManager(boolean restrict) {
        this.restrictToDefaultAccessTokenManager = restrict;
    }

    public StringPairPropertySelectionModel getTokenManagerIdList() {
        return this.tokenManagerIdList;
    }

    public boolean isEnableOpenIdConnectIdp() {
        OpenIdConnectProviderPolicyManager connectProviderPolicyMgr = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        return connectProviderPolicyMgr.getPolicy().isEnabled();
    }

    public boolean isTrackUserSessionsForLogout() {
        OpenIdConnectProviderPolicyManager connectProviderPolicyMgr = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        return connectProviderPolicyMgr.getPolicy().isTrackUserSessionsForLogout();
    }

    public boolean isOverridePersistentGrantExpirationServerDefault() {
        return "OVERRIDE_SERVER_DEFAULT".equals(this.persistentGrantExpirationType);
    }

    public boolean isOverridePersistentGrantIdleTimeoutServerDefault() {
        return "OVERRIDE_SERVER_DEFAULT".equals(this.persistentGrantIdleTimeoutType);
    }

    public boolean isOverrideReusePersistentGrantServerDefault() {
        return !this.grantTypesToReusePersistentGrantsType.equals("SERVER_DEFAULT");
    }

    public String getGrantTypesToReusePersistentGrantsType() {
        return this.grantTypesToReusePersistentGrantsType;
    }

    public void setGrantTypesToReusePersistentGrantsType(String grantTypesToReusePersistentGrantsType) {
        this.grantTypesToReusePersistentGrantsType = grantTypesToReusePersistentGrantsType;
    }

    public boolean isReusePersistentGrantAuthzCode() {
        return this.reusePersistentGrantAuthzCode;
    }

    public void setReusePersistentGrantAuthzCode(boolean reusePersistentGrantAuthzCode) {
        this.reusePersistentGrantAuthzCode = reusePersistentGrantAuthzCode;
    }

    public boolean isReusePersistentGrantROPC() {
        return this.reusePersistentGrantROPC;
    }

    public void setReusePersistentGrantROPC(boolean reusePersistentGrantROPC) {
        this.reusePersistentGrantROPC = reusePersistentGrantROPC;
    }

    public boolean isReusePersistentGrantImplicit() {
        return this.reusePersistentGrantImplicit;
    }

    public void setReusePersistentGrantImplicit(boolean reusePersistentGrantImplicit) {
        this.reusePersistentGrantImplicit = reusePersistentGrantImplicit;
    }

    public boolean isAllowAuthenticationApiInit() {
        return this.allowAuthenticationApiInit;
    }

    public void setAllowAuthenticationApiInit(boolean allowAuthenticationApiInit) {
        this.allowAuthenticationApiInit = allowAuthenticationApiInit;
    }

    public boolean isEnableCookielessAuthenticationApi() {
        return this.enableCookielessAuthenticationApi;
    }

    public void setEnableCookielessAuthenticationApi(boolean enableCookielessAuthenticationApi) {
        this.enableCookielessAuthenticationApi = enableCookielessAuthenticationApi;
    }

    public boolean isBypassApprovalPage() {
        return this.bypassApprovalPage || this.allowAuthenticationApiInit;
    }

    public void setBypassApprovalPage(boolean bypassApprovalPage) {
        this.bypassApprovalPage = bypassApprovalPage;
    }

    public boolean isRestrictScopes() {
        return this.restrictScopes || this.allowAuthenticationApiInit;
    }

    public void setRestrictScopes(boolean restrictScopes) {
        this.restrictScopes = restrictScopes;
    }

    public boolean isRestrictResponseTypes() {
        return this.restrictResponseTypes;
    }

    public void setRestrictResponseTypes(boolean restrictResponseTypes) {
        this.restrictResponseTypes = restrictResponseTypes;
    }

    public String getRestrictedScopesString() {
        return this.restrictedScopes.stream().map(scope -> "'" + scope + "'").collect(Collectors.joining(",", "[", "]"));
    }

    public String commonScopesModalJavascript() {
        return "javascript:\nvar data = {\n'eventType':'showScopesSelectionModal',\n'description':'Choose the common scope and scope groups that are intended for the client. The rest and any common scopes and scope groups created in the future become invalid for the client.',\n'scopeType':'commonScope',\n'isIncludeScopeGroups': true,\n'selectedScopes': " + this.restrictedScopes.stream().map(scope -> "'" + scope + "'").collect(Collectors.joining(",", "[", "]")) + "};\nvar origin = window.origin ? window.origin : window.location.origin;\nwindow.parent.postMessage(data, origin);\nvar idleTimerData = {'eventType': 'resetIdleTimer'};\nwindow.parent.postMessage(idleTimerData, origin);";
    }

    public List<String> getRestrictedScopes() {
        return this.restrictedScopes;
    }

    public void setRestrictedScopes(Set<String> restrictedScopes) {
        this.restrictedScopes = new ArrayList<String>(restrictedScopes);
    }

    public String getAllowedExclusiveScopesString() {
        return this.exclusiveScopes.stream().map(scope -> "'" + scope + "'").collect(Collectors.joining(",", "[", "]"));
    }

    public String exclusiveScopesModalJavascript() {
        return "javascript:\nvar data = {\n'eventType':'showScopesSelectionModal',\n'description':'Choose the exclusive scope and scope groups that are intended for the client. The rest and any exclusive scopes and scope groups created in the future become invalid for the client.',\n'scopeType':'exclusiveScope',\n'isIncludeScopeGroups': true,\n'selectedScopes':" + this.exclusiveScopes.stream().map(scope -> "'" + scope + "'").collect(Collectors.joining(",", "[", "]")) + "};\nvar origin = window.origin ? window.origin : window.location.origin;\nwindow.parent.postMessage(data, origin);\nvar idleTimerData = {'eventType': 'resetIdleTimer'};\nwindow.parent.postMessage(idleTimerData, origin);";
    }

    public List<String> getAllowedExclusiveScopes() {
        return this.exclusiveScopes;
    }

    public void setExclusiveScopes(Set<String> exclusiveScopes) {
        this.exclusiveScopes = new ArrayList<String>(exclusiveScopes);
    }

    public Object getRedirectUrisComponentState() {
        return this.redirectUrisComponentState;
    }

    public void setRedirectUrisComponentState(Object componentState) {
        this.redirectUrisComponentState = componentState;
    }

    public StringPairPropertySelectionModel getLogoutModeList() {
        return this.logoutModeList;
    }

    public String getSelectedLogoutMode() {
        return this.selectedLogoutMode;
    }

    public void setSelectedLogoutMode(String selectedLogoutMode) {
        this.selectedLogoutMode = selectedLogoutMode;
    }

    public String getBackChannelLogoutUri() {
        return this.backChannelLogoutUri;
    }

    public void setBackChannelLogoutUri(String backChannelLogoutUri) {
        this.backChannelLogoutUri = backChannelLogoutUri;
    }

    public Object getLogoutUrisComponentState() {
        return this.logoutUrisComponentState;
    }

    public void setLogoutUrisComponentState(Object componentState) {
        this.logoutUrisComponentState = componentState;
    }

    public Object getPostLogoutRedirectUrisComponentState() {
        return this.postLogoutRedirectUrisComponentState;
    }

    public void setPostLogoutRedirectUrisComponentState(Object componentState) {
        this.postLogoutRedirectUrisComponentState = componentState;
    }

    public Set<String> getScopes() {
        return ScopeUtil.getAllCommonScopeDescriptions().keySet();
    }

    public Set<String> getScopeGroups() {
        return ScopeUtil.getCommonScopeGroupDescriptions().keySet();
    }

    public Set<String> getExclusiveScopes() {
        return ScopeUtil.getAllExclusiveScopeDescriptions().keySet();
    }

    public Set<String> getExclusiveScopeGroups() {
        return ScopeUtil.getExclusiveScopeGroupDescriptions().keySet();
    }

    private void loadRestrictResponseTypesCheckboxModel() {
        this.restrictResponseTypesCheckboxModel.clear();
        ArrayList<CheckboxItem> list = new ArrayList<CheckboxItem>();
        for (String response_type : ClientUtil.RESPONSE_TYPES) {
            CheckboxItem item = new CheckboxItem(response_type);
            item.setChecked(this.containsAllResponseTypes(this.restrictedResponseTypes, item.getName()));
            list.add(item);
        }
        this.restrictResponseTypesCheckboxModel.setCheckboxItems(list);
    }

    private boolean containsAllResponseTypes(List<String> restrictedResponseTypes, String name) {
        Set requestedResponseTypesSet = ClientUtil.getResponseTypes((String)name);
        return restrictedResponseTypes.stream().map(ClientUtil::getResponseTypes).anyMatch(entry -> entry.equals(requestedResponseTypesSet));
    }

    public CheckboxModel getAuthorizationDetailTypesCheckboxModel() {
        return this.authorizationDetailTypesCheckboxModel;
    }

    private void loadAuthorizationDetailTypesCheckboxModel() {
        this.authorizationDetailTypesCheckboxModel.clear();
        ArrayList<CheckboxItem> list = new ArrayList<CheckboxItem>();
        MgmtFactory.getAuthorizationDetailTypesManager().getAllAuthorizationDetailTypes().forEach(authorizationDetailType -> {
            String type = authorizationDetailType.getType() + (authorizationDetailType.isActive() ? "" : INACTIVE_LABEL);
            CheckboxItem item = new CheckboxItem(type);
            item.setChecked(this.authorizationDetailTypes.contains(authorizationDetailType.getType()));
            list.add(item);
        });
        Collections.sort(list);
        this.authorizationDetailTypesCheckboxModel.setCheckboxItems(list);
    }

    public CheckboxModel getRestrictResponseTypesCheckboxModel() {
        return this.restrictResponseTypesCheckboxModel;
    }

    public List<String> getLogoutUris() {
        return this.logoutUris;
    }

    public void setLogoutUris(List<String> logoutUris) {
        this.logoutUris = logoutUris;
    }

    public List<String> getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    private void loadTrustedCAs() {
        try {
            Class<X509CertImpl> x509CertClazz = X509CertImpl.class;
            Constructor x509CertConstructor = x509CertClazz.getConstructor(X509CertInfo.class, AlgorithmId.class, byte[].class, byte[].class);
            this.trustAllDummyCert = new Cert("Trust Any", (X509Certificate)x509CertConstructor.newInstance(null, null, null, new byte[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.trustAllDummyCert = new Cert("Trust Any", (X509Certificate)new X509CertImpl());
        }
        this.trustedCAs.clear();
        TrustedCAsManager mgr = MgmtFactory.getTrustedCAsManager();
        this.trustedCAs = mgr.getTrustedCAs();
    }

    public boolean isScopesSet() {
        return !this.getScopes().isEmpty();
    }

    public boolean isExclusiveScopesSet() {
        return !this.getExclusiveScopes().isEmpty();
    }

    public boolean isExcludedScopes() {
        return this.excludedScopes;
    }

    public void setExcludedScopes(boolean excludedScopes) {
        this.excludedScopes = excludedScopes;
    }

    public boolean isAllowAuthorizationDetails() {
        return this.allowAuthorizationDetails;
    }

    public void setAllowAuthorizationDetails(boolean allowAuthorizationDetails) {
        this.allowAuthorizationDetails = allowAuthorizationDetails;
    }

    public boolean isAuthorizationDetailTypesSet() {
        return !MgmtFactory.getAuthorizationDetailTypesManager().getTypes().isEmpty();
    }

    public IUploadFile getCertFile() {
        return this.certFile;
    }

    public void setCertFile(IUploadFile certFile) {
        this.certFile = certFile;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Cert getCert() {
        return this.cert;
    }

    public ClientAuthenticationType getClientAuthenticationType() {
        return this.clientAuthenticationType;
    }

    public void setClientAuthenticationType(ClientAuthenticationType clientAuthenticationType) {
        this.clientAuthenticationType = clientAuthenticationType;
    }

    public boolean isGrantAccessSessionRevocationApi() {
        return this.grantAccessSessionRevocationApi;
    }

    public void setGrantAccessSessionRevocationApi(boolean canAccess) {
        this.grantAccessSessionRevocationApi = canAccess;
    }

    public boolean isGrantAccessSessionManagementApi() {
        return this.grantAccessSessionManagementApi;
    }

    public void setGrantAccessSessionManagementApi(boolean canAccess) {
        this.grantAccessSessionManagementApi = canAccess;
    }

    public boolean isValidateUsingAllEligibleAtms() {
        return this.validateUsingAllEligibleAtms;
    }

    public void setValidateUsingAllEligibleAtms(boolean validateUsingAllEligibleAtms) {
        this.validateUsingAllEligibleAtms = validateUsingAllEligibleAtms;
    }

    public String getJwksUrl() {
        return this.jwksUrl;
    }

    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    public boolean isRequireSignedRequest() {
        return this.requireSignedRequest;
    }

    public void setRequireSignedRequest(boolean requiredRequestObject) {
        this.requireSignedRequest = requiredRequestObject;
    }

    public String getSelectedRequestObjectSigningAlgorithm() {
        return this.selectedRequestObjectSigningAlgorithm;
    }

    public void setSelectedRequestObjectSigningAlgorithm(String selectedRequestObjectSigningAlgorithm) {
        this.selectedRequestObjectSigningAlgorithm = selectedRequestObjectSigningAlgorithm;
    }

    public StringPairPropertySelectionModel getRequestObjectSigningAlgorithmList() {
        return this.requestObjectSigningAlgorithmList;
    }

    public boolean isEnforceReplayPrevention() {
        return this.enforceReplayPrevention;
    }

    public void setEnforceReplayPrevention(boolean enforceReplayPrevention) {
        this.enforceReplayPrevention = enforceReplayPrevention;
    }

    public boolean isClientSecretJwtReplayPrevention() {
        return this.clientSecretJwtReplayPrevention;
    }

    public void setClientSecretJwtReplayPrevention(boolean clientSecretJwtReplayPrevention) {
        this.clientSecretJwtReplayPrevention = clientSecretJwtReplayPrevention;
    }

    public String getSelectedTokenEndpointAuthSigningAlgorithm() {
        return this.selectedTokenEndpointAuthSigningAlgorithm;
    }

    public void setSelectedTokenEndpointAuthSigningAlgorithm(String selectedTokenEndpointAuthSigningAlgorithm) {
        this.selectedTokenEndpointAuthSigningAlgorithm = selectedTokenEndpointAuthSigningAlgorithm;
    }

    public String getSelectedTokenEndpointAuthSymmetricSigningAlgorithm() {
        return this.selectedTokenEndpointAuthSymmetricSigningAlgorithm;
    }

    public void setSelectedTokenEndpointAuthSymmetricSigningAlgorithm(String selectedTokenEndpointAuthSymmetricSigningAlgorithm) {
        this.selectedTokenEndpointAuthSymmetricSigningAlgorithm = selectedTokenEndpointAuthSymmetricSigningAlgorithm;
    }

    public StringPairPropertySelectionModel getTokenEndpointAuthSigningAlgorithmList() {
        return this.tokenEndpointAuthSigningAlgorithmList;
    }

    public StringPairPropertySelectionModel getTokenEndpointAuthSymmetricSigningAlgorithmList() {
        return this.tokenEndpointAuthSymmetricSigningAlgorithmList;
    }

    public boolean isDisplayAlgorithmWarning() {
        return this.displayAlgorithmWarning;
    }

    public void setDisplayAlgorithmWarning(boolean displayAlgorithmWarning) {
        this.displayAlgorithmWarning = displayAlgorithmWarning;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAllowDeviceCode() {
        return this.allowDeviceCode;
    }

    public void setAllowDeviceCode(boolean allowDeviceCode) {
        this.allowDeviceCode = allowDeviceCode;
    }

    public boolean isAllowCiba() {
        return this.allowCiba;
    }

    public void setAllowCiba(boolean allowCiba) {
        this.allowCiba = allowCiba;
    }

    public boolean isAllowTokenExchange() {
        return this.allowTokenExchange;
    }

    public void setAllowTokenExchange(boolean allowTokenExchange) {
        this.allowTokenExchange = allowTokenExchange;
    }

    public boolean isDeviceFlowSettingsOverride() {
        return "OVERRIDE_SERVER_DEFAULT".equals(this.deviceFlowSettingType);
    }

    public String getDeviceFlowSettingType() {
        return this.deviceFlowSettingType;
    }

    public void setDeviceFlowSettingType(String deviceFlowSettingType) {
        this.deviceFlowSettingType = deviceFlowSettingType;
    }

    public String getUserAuthzUrlOverride() {
        return this.userAuthzUrlOverride;
    }

    public void setUserAuthzUrlOverride(String userAuthzUrlOverride) {
        this.userAuthzUrlOverride = userAuthzUrlOverride;
    }

    public String getPendingAuthzTimeoutOverride() {
        return this.pendingAuthzTimeoutOverride;
    }

    public void setPendingAuthzTimeoutOverride(String pendingAuthzTimeoutOverride) {
        this.pendingAuthzTimeoutOverride = pendingAuthzTimeoutOverride;
    }

    public String getDevicePollingIntervalOverride() {
        return this.devicePollingIntervalOverride;
    }

    public void setDevicePollingIntervalOverride(String devicePollingIntervalOverride) {
        this.devicePollingIntervalOverride = devicePollingIntervalOverride;
    }

    public Boolean getBypassActivationCodeConfirmationOverride() {
        return this.bypassActivationCodeConfirmationOverride;
    }

    public void setBypassActivationCodeConfirmationOverride(Boolean bypassActivationCodeConfirmationOverride) {
        this.bypassActivationCodeConfirmationOverride = bypassActivationCodeConfirmationOverride;
    }

    public boolean isRequireProofKeyForCodeExchange() {
        return this.requireProofKeyForCodeExchange;
    }

    public void setRequireProofKeyForCodeExchange(boolean requireProofKeyForCodeExchange) {
        this.requireProofKeyForCodeExchange = requireProofKeyForCodeExchange;
    }

    public CibaDeliveryMode getCibaMode() {
        return this.cibaMode;
    }

    public void setCibaMode(CibaDeliveryMode cibaMode) {
        this.cibaMode = cibaMode;
    }

    public String getCibaNotificationEndpoint() {
        return this.cibaNotificationEndpoint;
    }

    public void setCibaNotificationEndpoint(String cibaNotificationEndpoint) {
        this.cibaNotificationEndpoint = cibaNotificationEndpoint.trim();
    }

    public boolean isCibaRequireSignedRequests() {
        return this.cibaRequireSignedRequests;
    }

    public void setCibaRequireSignedRequests(boolean cibaRequireSignedRequests) {
        this.cibaRequireSignedRequests = cibaRequireSignedRequests;
    }

    public boolean isCibaUserCodeSupported() {
        return this.cibaUserCodeSupported;
    }

    public void setCibaUserCodeSupported(boolean cibaUserCodeSupported) {
        this.cibaUserCodeSupported = cibaUserCodeSupported;
    }

    private void createCibaPolicyIdList() {
        this.cibaPolicyIdList = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        CibaServerPolicy policy = MgmtFactory.getCibaServerPolicyManager().getCibaServerPolicy();
        for (CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy : policy.getRequestHandlingPolicies().values()) {
            this.cibaPolicyIdList.add(requestHandlingPolicy.getName(), requestHandlingPolicy.getId());
        }
    }

    public StringPairPropertySelectionModel getCibaPolicyIdList() {
        return this.cibaPolicyIdList;
    }

    public String getCibaPolicyId() {
        return this.cibaPolicyId;
    }

    public void setCibaPolicyId(String cibaPolicyId) {
        this.cibaPolicyId = cibaPolicyId;
    }

    public String getCibaPollingInterval() {
        return this.cibaPollingInterval;
    }

    public void setCibaPollingInterval(String cibaPollingInterval) {
        this.cibaPollingInterval = cibaPollingInterval;
    }

    public boolean isRequirePar() {
        return this.requirePar;
    }

    public void setRequirePar(boolean requirePar) {
        this.requirePar = requirePar;
    }

    public String getTokenExchangeProcessorPolicyId() {
        return this.tokenExchangeProcessorPolicyId;
    }

    public void setTokenExchangeProcessorPolicyId(String tokenExchangeProcessorPolicyId) {
        this.tokenExchangeProcessorPolicyId = tokenExchangeProcessorPolicyId;
    }

    public StringPairPropertySelectionModel getTokenExchangeProcessorPolicyIdList() {
        return this.tokenExchangeProcessorPolicyIdList;
    }

    public boolean isPairwiseUserType() {
        return this.pairwiseUserType;
    }

    public void setPairwiseUserType(boolean pairwiseUserType) {
        this.pairwiseUserType = pairwiseUserType;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public String getSelectedCibaRequestObjectSigningAlgorithm() {
        return this.selectedCibaRequestObjectSigningAlgorithm;
    }

    public void setSelectedCibaRequestObjectSigningAlgorithm(String selectedCibaRequestObjectSigningAlgorithm) {
        this.selectedCibaRequestObjectSigningAlgorithm = selectedCibaRequestObjectSigningAlgorithm;
    }

    public StringPairPropertySelectionModel getCibaRequestObjectSigningAlgorithmList() {
        return this.cibaRequestObjectSigningAlgorithmList;
    }

    public String getRefreshTokenRollingGracePeriod() {
        return this.refreshTokenRollingGracePeriod;
    }

    public void setRefreshTokenRollingGracePeriod(String refreshTokenRollingGracePeriod) {
        this.refreshTokenRollingGracePeriod = refreshTokenRollingGracePeriod;
    }

    public String getRefreshTokenRollingGracePeriodType() {
        return this.refreshTokenRollingGracePeriodType;
    }

    public void setRefreshTokenRollingGracePeriodType(String refreshTokenRollingGracePeriodType) {
        this.refreshTokenRollingGracePeriodType = refreshTokenRollingGracePeriodType;
    }

    public boolean isDefaultRefreshTokenRollingGracePeriod() {
        return "SERVER_DEFAULT".equals(this.refreshTokenRollingGracePeriodType);
    }

    public String getSecondarySecretRetentionPeriodType() {
        return this.secondarySecretRetentionPeriodType;
    }

    public void setSecondarySecretRetentionPeriodType(String secondarySecretRetentionPeriodType) {
        this.secondarySecretRetentionPeriodType = secondarySecretRetentionPeriodType;
    }

    public String getSecondarySecretRetentionPeriod() {
        return this.secondarySecretRetentionPeriod;
    }

    public void setSecondarySecretRetentionPeriod(String secondarySecretRetentionPeriod) {
        this.secondarySecretRetentionPeriod = secondarySecretRetentionPeriod;
    }

    public boolean isDefaultSecondarySecretRetentionPeriod() {
        return "SERVER_DEFAULT".equals(this.secondarySecretRetentionPeriodType);
    }

    public boolean hasClientSecretChangedTime() {
        return this.clientSecretChangedTime != null;
    }

    public String getClientSecretChangedTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy");
        return sdf.format(Date.from(Instant.ofEpochSecond(Long.parseLong(this.clientSecretChangedTime))));
    }

    public String getSelectedIntrospectionSigningAlgorithm() {
        return this.selectedIntrospectionSigningAlgorithm;
    }

    public void setSelectedIntrospectionSigningAlgorithm(String selectedIntrospectionSigningAlgorithm) {
        this.selectedIntrospectionSigningAlgorithm = selectedIntrospectionSigningAlgorithm;
        this.toggleDisplayIntrospectionAlgorithmWarning();
    }

    public String getSelectedIntrospectionEncryptionAlgorithm() {
        return this.selectedIntrospectionEncryptionAlgorithm;
    }

    public void setSelectedIntrospectionEncryptionAlgorithm(String selectedIntrospectionEncryptionAlgorithm) {
        this.selectedIntrospectionEncryptionAlgorithm = selectedIntrospectionEncryptionAlgorithm;
    }

    public String getSelectedIntrospectionContentEncryptionAlgorithm() {
        return this.selectedIntrospectionContentEncryptionAlgorithm;
    }

    public void setSelectedIntrospectionContentEncryptionAlgorithm(String selectedIntrospectionContentEncryptionAlgorithm) {
        this.selectedIntrospectionContentEncryptionAlgorithm = selectedIntrospectionContentEncryptionAlgorithm;
    }

    public StringPairPropertySelectionModel getIntrospectionSigningAlgorithmList() {
        return this.introspectionSigningAlgorithmList;
    }

    public StringPairPropertySelectionModel getIntrospectionEncryptionAlgorithmList() {
        return this.introspectionEncryptionAlgorithmList;
    }

    public StringPairPropertySelectionModel getIntrospectionContentEncryptionAlgorithmList() {
        return this.introspectionContentEncryptionAlgorithmList;
    }

    public boolean isDisplayIntrospectionAlgorithmWarning() {
        return this.displayIntrospectionAlgorithmWarning;
    }

    public boolean isRequireJarm() {
        return this.requireJarm;
    }

    public void setRequireJarm(boolean requireJarm) {
        this.requireJarm = requireJarm;
    }

    public String getSelectedAuthorizationResponseSigningAlgorithm() {
        return this.selectedAuthorizationResponseSigningAlgorithm;
    }

    public void setSelectedAuthorizationResponseSigningAlgorithm(String selectedAuthorizationResponseSigningAlgorithm) {
        this.selectedAuthorizationResponseSigningAlgorithm = selectedAuthorizationResponseSigningAlgorithm;
        this.toggleDisplayAuthorizationResponseAlgorithmWarning();
    }

    public String getSelectedAuthorizationResponseEncryptionAlgorithm() {
        return this.selectedAuthorizationResponseEncryptionAlgorithm;
    }

    public void setSelectedAuthorizationResponseEncryptionAlgorithm(String selectedAuthorizationResponseEncryptionAlgorithm) {
        this.selectedAuthorizationResponseEncryptionAlgorithm = selectedAuthorizationResponseEncryptionAlgorithm;
    }

    public String getSelectedAuthorizationResponseContentEncryptionAlgorithm() {
        return this.selectedAuthorizationResponseContentEncryptionAlgorithm;
    }

    public void setSelectedAuthorizationResponseContentEncryptionAlgorithm(String selectedAuthorizationResponseContentEncryptionAlgorithm) {
        this.selectedAuthorizationResponseContentEncryptionAlgorithm = selectedAuthorizationResponseContentEncryptionAlgorithm;
    }

    public StringPairPropertySelectionModel getAuthorizationResponseSigningAlgorithmList() {
        return this.authorizationResponseSigningAlgorithmList;
    }

    public StringPairPropertySelectionModel getAuthorizationResponseEncryptionAlgorithmList() {
        return this.authorizationResponseEncryptionAlgorithmList;
    }

    public StringPairPropertySelectionModel getAuthorizationResponseContentEncryptionAlgorithmList() {
        return this.authorizationResponseContentEncryptionAlgorithmList;
    }

    public boolean isDisplayAuthorizationResponseAlgorithmWarning() {
        return this.displayAuthorizationResponseAlgorithmWarning;
    }

    public boolean isRequireDpop() {
        return this.requireDpop;
    }

    public void setRequireDpop(boolean requireDpop) {
        this.requireDpop = requireDpop;
    }

    public String getRequireOfflineAccessScopeToIssueRefreshTokens() {
        return this.requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public void setRequireOfflineAccessScopeToIssueRefreshTokens(String requireOfflineAccessScopeToIssueRefreshTokens) {
        this.requireOfflineAccessScopeToIssueRefreshTokens = requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public boolean isRequireOfflineAccessScopeToIssueRefreshTokensValueYes() {
        return "Yes".equals(this.requireOfflineAccessScopeToIssueRefreshTokens);
    }

    public String getOfflineAccessRequireConsentPrompt() {
        return this.offlineAccessRequireConsentPrompt;
    }

    public void setOfflineAccessRequireConsentPrompt(String offlineAccessRequireConsentPrompt) {
        this.offlineAccessRequireConsentPrompt = offlineAccessRequireConsentPrompt;
    }

    public String getLockoutMaxMaliciousActionsType() {
        return this.lockoutMaxMaliciousActionsType;
    }

    public void setLockoutMaxMaliciousActionsType(String lockoutMaxMaliciousActionsType) {
        this.lockoutMaxMaliciousActionsType = lockoutMaxMaliciousActionsType;
    }

    public boolean isOverrideLockoutMaxMaliciousActionsServerDefault() {
        return "OVERRIDE_SERVER_DEFAULT".equals(this.lockoutMaxMaliciousActionsType);
    }

    public String getLockoutMaxMaliciousActions() {
        return this.lockoutMaxMaliciousActions;
    }

    public void setLockoutMaxMaliciousActions(String lockoutMaxMaliciousActions) {
        this.lockoutMaxMaliciousActions = lockoutMaxMaliciousActions;
    }

    public void setOriginalSecondarySecrets(ClientSecondarySecretSet originalSecondarySecrets) {
        this.originalSecondarySecrets = originalSecondarySecrets;
    }

    public boolean isSecondarySecretPresent() {
        return this.secondarySecretPresent;
    }

    public void setSecondarySecretPresent(boolean secondarySecretPresent) {
        this.secondarySecretPresent = secondarySecretPresent;
    }

    public void revokeSecondarySecrets() {
        this.setOriginalSecondarySecrets(new ClientSecondarySecretSet());
        this.setSecondarySecretPresent(false);
        this.log.info((Object)String.format("%s deleted all secondary secrets for client: %s", this.getCurrentUser().getUserName(), this.id));
    }
}

