/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.model.oauth.Client;
import com.pingidentity.admin.api.translator.OAuthClientManagementTranslator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ExtendedPropertyManagementState;
import com.pingidentity.fsm.state.impl.OAuthClientManagementState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientSecondarySecretSet;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.NotificationBanner;

public class OAuthClientManagementTasklet
extends Tasklet {
    private boolean isUpdate;
    private static final transient ClientManager CLIENT_MGR = MgmtFactory.getClientManager();
    private Operation operation = Operation.NONE;
    private long lastUpdated = 0L;
    private boolean warned;
    private static final long serialVersionUID = 6L;
    private OAuthClientManagementState oAuthClientManagementState;
    private ExtendedPropertyManagementState extendedPropertyManagementState;

    protected OAuthClientManagementTasklet() {
    }

    public OAuthClientManagementTasklet(Visit visit) {
        super("OAuthClientManagementTasklet", "Client");
        this.setSystemVisit(visit);
        this.oAuthClientManagementState = new OAuthClientManagementState(this);
        this.extendedPropertyManagementState = new ExtendedPropertyManagementState((IWizard)this, false);
        this.setInitialState(this.oAuthClientManagementState);
        if (MgmtFactory.getClientSettingManager().getExtendedProperties().size() > 0) {
            this.oAuthClientManagementState.addOutgoingTransition(this, this.extendedPropertyManagementState);
        }
        this.setCancelAvailable(true);
    }

    protected org.sourceid.oauth20.domain.Client getClient() {
        org.sourceid.oauth20.domain.Client client = new org.sourceid.oauth20.domain.Client();
        this.save(client);
        return client;
    }

    @Override
    public void setCurrentState(IWizardState currentState) {
        Visit v = this.getSystemVisit();
        v.setSkipForUIPerformanceFlag(true);
        super.setCurrentState(currentState);
        v.setSkipForUIPerformanceFlag(false);
    }

    @Override
    public void finish() {
        org.sourceid.oauth20.domain.Client client = new org.sourceid.oauth20.domain.Client();
        if (this.save(client)) {
            try {
                if (this.isUpdate()) {
                    CLIENT_MGR.updateClient(client);
                } else {
                    CLIENT_MGR.addClient(client);
                }
                this.lastUpdated = CLIENT_MGR.getClient(this.getClientId()).getLastModified().getTimeInMillis();
                this.showNotificationBanner(client);
                super.finish();
            }
            catch (ClientManager.ClientManagementException e) {
                this.oAuthClientManagementState.getDelegate().record("An error occurred saving Client ID '" + client.getClientId() + "'", ValidationConstraint.REQUIRED);
            }
        }
    }

    public void revokeSecondarySecrets() {
        try {
            org.sourceid.oauth20.domain.Client client = CLIENT_MGR.getClient(this.oAuthClientManagementState.getId());
            client.setSecondarySecrets(new ClientSecondarySecretSet());
            CLIENT_MGR.updateClient(client);
            this.oAuthClientManagementState.revokeSecondarySecrets();
            this.lastUpdated = CLIENT_MGR.getClient(this.getClientId()).getLastModified().getTimeInMillis();
            this.showNotificationBanner(client);
        }
        catch (ClientManager.ClientManagementException e) {
            this.oAuthClientManagementState.getDelegate().record("An error occurred updating Client ID '" + this.oAuthClientManagementState.getId() + "'", ValidationConstraint.REQUIRED);
        }
    }

    private void showNotificationBanner(org.sourceid.oauth20.domain.Client client) {
        NotificationBanner notificationBanner = NotificationBanner.getNotificationBannerForClient((org.sourceid.oauth20.domain.Client)client);
        this.getSystemVisit().setNotificationBannerContent(notificationBanner);
    }

    @Override
    public boolean onFinish(IRequestCycle cycle) {
        if (!this.isUpdate || this.warned || !this.hasChanged()) {
            this.warned = false;
            return super.onFinish(cycle);
        }
        this.getDelegate().record("This client has been modified after rendering this page. Saving will result in overwriting those changes. Click ''Save'' again to overwrite.", ValidationConstraint.REQUIRED);
        this.warned = true;
        return false;
    }

    public String getName() {
        return this.oAuthClientManagementState.getName();
    }

    public String getClientId() {
        return this.oAuthClientManagementState.getId();
    }

    public OAuthClientManagementState getoAuthClientManagementState() {
        return this.oAuthClientManagementState;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean update) {
        this.isUpdate = update;
    }

    public boolean isEnabled() {
        return this.oAuthClientManagementState.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        boolean update;
        boolean bl = update = enabled != this.oAuthClientManagementState.isEnabled();
        if (update) {
            this.oAuthClientManagementState.setEnabled(enabled);
            org.sourceid.oauth20.domain.Client domainClient = (org.sourceid.oauth20.domain.Client)this.getPopulateData();
            OAuthClientManagementTranslator translator = new OAuthClientManagementTranslator();
            Client apiClient = translator.domainToApi(domainClient);
            org.sourceid.oauth20.domain.Client client = new org.sourceid.oauth20.domain.Client();
            translator.apiToDomain(apiClient, client);
            client.setEnabled(enabled);
            client.setPersistentGrantExpirationTimeUnit(domainClient.getPersistentGrantExpirationTimeUnit());
            client.setPersistentGrantIdleTimeoutType(domainClient.getPersistentGrantIdleTimeoutType());
            this.setPopulateData(client);
        }
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        this.clearAllStatesOutgoingTransitions();
        this.setInitialState(this.oAuthClientManagementState);
        this.oAuthClientManagementState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.extendedPropertyManagementState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return MgmtFactory.getClientSettingManager().getExtendedProperties().size() > 0;
            }
        });
    }

    @Override
    public void onCancel(IRequestCycle cycle) {
        if (this.hasChanged()) {
            this.populate(CLIENT_MGR.getClient(this.getClientId()));
        }
        this.warned = false;
        super.onCancel(cycle);
    }

    private boolean hasChanged() {
        org.sourceid.oauth20.domain.Client client;
        if (this.getClientId() != null && (client = CLIENT_MGR.getClient(this.getClientId())) != null) {
            return this.lastUpdated != 0L && this.lastUpdated < CLIENT_MGR.getClient(this.getClientId()).getLastModified().getTimeInMillis();
        }
        return false;
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        this.setLastUpdated((org.sourceid.oauth20.domain.Client)dataFromDisk);
    }

    private void setLastUpdated(org.sourceid.oauth20.domain.Client client) {
        if (client != null) {
            this.lastUpdated = client.getLastModified().getTimeInMillis();
        }
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public static enum Operation {
        INSERT,
        UPDATE,
        NONE;

    }
}

