/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.Pagination;
import com.pingidentity.component.common.Search;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.state.impl.OAuthClientManagementState;
import com.pingidentity.fsm.state.impl.OAuthClientManagementTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.NotificationBanner;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;

@AutoSaveState
public class OAuthClientsManagementState
extends TaskletState {
    private static final int DEFAULT_REQUESTED_ITEMS = 101;
    private static final long serialVersionUID = 6L;
    private static final SearchResult<Client> DEFAULT_CLIENT_SEARCH_RESULT = new SearchResult(0, Collections.emptyList());
    public static final String NO_SEARCH_RESULTS = "No Search Results Found";
    private boolean showAdvancedSearch;
    private boolean hasClientStoreConnectionIssue = false;
    private int currentPage = 1;
    private SearchResult<Client> clientSearchResult = DEFAULT_CLIENT_SEARCH_RESULT;
    private Map<String, OAuthClientManagementTasklet> currentOpenTasklets = new HashMap<String, OAuthClientManagementTasklet>();
    private Map<String, OAuthClientManagementTasklet> editedTasklets = new HashMap<String, OAuthClientManagementTasklet>();
    private transient Object paginationState;
    private transient Object searchState;
    private boolean onStateActivated;
    private boolean sortClientIdUp;
    private boolean sortClientNameUp;
    private boolean sortModificationTimeUp = true;
    private boolean sortCreationTimeUp = true;
    private SORT_BY sortBy = SORT_BY.ModificationTime;
    private transient ClientManager clientManager = (ClientManager)GlobalRegistry.getService(ClientManager.class);

    public Client getClient(String clientId) {
        return this.clientManager.getClient(clientId);
    }

    public void addEditTasklet(OAuthClientManagementTasklet tasklet) {
        this.currentOpenTasklets.put(tasklet.getClientId(), tasklet);
    }

    public OAuthClientManagementTasklet getEditTasklet(String clientId) {
        return this.currentOpenTasklets.get(clientId);
    }

    public Map<String, OAuthClientManagementTasklet> getEditedTasklets() {
        return this.editedTasklets;
    }

    public void setEditedTasklets(Map<String, OAuthClientManagementTasklet> editedTasklets) {
        this.editedTasklets = editedTasklets;
    }

    public OAuthClientsManagementState(IWizard owner, String cardName) {
        super(owner, cardName);
        this.setMenuName("Manage Clients");
    }

    public OAuthClientsManagementState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Clients");
    }

    @Override
    public void populate(Object dataFromDisk) {
    }

    @Override
    public void reset() {
        if (this.getSearchState() != null) {
            ((Search.State)this.getSearchState()).reset();
        }
        if (this.getPaginationState() != null) {
            ((Pagination.State)this.getPaginationState()).reset();
        }
        this.currentOpenTasklets.clear();
        this.editedTasklets.clear();
        this.clientSearchResult = DEFAULT_CLIENT_SEARCH_RESULT;
    }

    @Override
    public String getNoteKey() {
        if (this.clientManager.isBackendDatabase()) {
            return this.getTaskletStateId() + "BackendDatabase";
        }
        return super.getNoteKey();
    }

    public Object getSearchState() {
        return this.searchState;
    }

    public void setSearchState(Object searchState) {
        this.searchState = searchState;
    }

    public void delete(String clientToDelete) {
        ClientManager clientMgr = this.getClientManager();
        try {
            clientMgr.deleteClient(clientToDelete);
            NotificationBanner notificationBanner = NotificationBanner.getBannerForClientDeleted();
            this.getVisit().setNotificationBannerContent(notificationBanner);
            this.currentOpenTasklets.remove(clientToDelete);
        }
        catch (ClientManager.ClientManagementException e) {
            this.log.debug((Object)("An error occurred for Client ID: " + clientToDelete), (Throwable)e);
            this.delegate.record("An error occurred for Client ID '" + clientToDelete + "'", ValidationConstraint.REQUIRED);
        }
    }

    public void toggle(String clientToToggle) {
        ClientManager clientMgr = this.getClientManager();
        try {
            Client client = this.getClient(clientToToggle);
            boolean newStatus = !client.isEnabled();
            client.setEnabled(newStatus);
            if (this.currentOpenTasklets.containsKey(clientToToggle)) {
                this.currentOpenTasklets.get(clientToToggle).setEnabled(newStatus);
            }
            clientMgr.updateClient(client);
            NotificationBanner notificationBanner = NotificationBanner.getNotificationBannerForClient((Client)client);
            this.getVisit().setNotificationBannerContent(notificationBanner);
        }
        catch (ClientManager.ClientManagementException e) {
            this.log.debug((Object)("An error occurred for Client ID: " + clientToToggle), (Throwable)e);
            this.delegate.record("An error occurred for Client ID '" + clientToToggle + "'", ValidationConstraint.REQUIRED);
        }
    }

    public Collection<OAuthClientManagementTasklet> getCurrentOpenTasklets() {
        return this.currentOpenTasklets.values();
    }

    public OAuthClientManagementState getOAuthClientManagementState(String clientId) {
        OAuthClientManagementState state;
        int toIndex = Math.min(this.clientSearchResult.getResults().size(), 20);
        List currentVisibleClients = this.clientSearchResult.getResults().subList(0, toIndex);
        if (this.currentOpenTasklets.containsKey(clientId)) {
            state = this.currentOpenTasklets.get(clientId).getoAuthClientManagementState();
        } else {
            Optional<Client> optionalClient = currentVisibleClients.stream().filter(c -> clientId.equals(c.getClientId())).findFirst();
            Client client = optionalClient.isPresent() ? optionalClient.get() : this.getClient(clientId);
            OAuthClientManagementTasklet tasklet = this.createTasklet(OAuthClientManagementTasklet.class);
            tasklet.setFinishLabel("Save");
            tasklet.populate(client);
            tasklet.setUpdate(true);
            tasklet.setMode(Mode.edit);
            OAuthClientManagementTasklet.Operation current = tasklet.getOperation();
            if (current != OAuthClientManagementTasklet.Operation.INSERT) {
                tasklet.setOperation(OAuthClientManagementTasklet.Operation.UPDATE);
            }
            this.addEditTasklet(tasklet);
            state = tasklet.getoAuthClientManagementState();
        }
        return state;
    }

    protected ClientManager getClientManager() {
        return this.clientManager;
    }

    protected void setClientManager(ClientManager clientManager) {
        this.clientManager = clientManager;
    }

    public Tasklet getTaskletFromList(String clientId) {
        for (Tasklet tasklet : this.getCurrentOpenTasklets()) {
            OAuthClientManagementTasklet t = (OAuthClientManagementTasklet)tasklet;
            if (!t.getClientId().equals(clientId)) continue;
            return tasklet;
        }
        return null;
    }

    public boolean isShowAdvancedSearch() {
        return false;
    }

    public void setShowAdvancedSearch(boolean showAdvancedSearch) {
        this.showAdvancedSearch = showAdvancedSearch;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public boolean isSortClientIdUp() {
        return this.sortClientIdUp;
    }

    public void setSortClientIdUp(boolean sortClientIdUp) {
        this.sortClientIdUp = sortClientIdUp;
    }

    public boolean isSortClientNameUp() {
        return this.sortClientNameUp;
    }

    public void setSortClientNameUp(boolean sortClientNameUp) {
        this.sortClientNameUp = sortClientNameUp;
    }

    public boolean isSortModificationTimeUp() {
        return this.sortModificationTimeUp;
    }

    public void setSortModificationTimeUp(boolean sortModificationTimeUp) {
        this.sortModificationTimeUp = sortModificationTimeUp;
    }

    public boolean isSortCreationTimeUp() {
        return this.sortCreationTimeUp;
    }

    public void setSortCreationTimeUp(boolean sortCreationTimeUp) {
        this.sortCreationTimeUp = sortCreationTimeUp;
    }

    public SORT_BY getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SORT_BY sortBy) {
        this.sortBy = sortBy;
        this.resetPaginationState();
    }

    private void resetPaginationState() {
        if (this.paginationState != null) {
            ((Pagination.State)this.paginationState).reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Client> sortAndFilter() {
        SearchCriteria.Builder searchCriteriaBuilder;
        if (this.paginationState != null) {
            int currentPage = ((Pagination.State)this.paginationState).getCurrentPage();
            int startIndex = (currentPage - 1) * 20;
            searchCriteriaBuilder = new SearchCriteria.Builder(startIndex, 101);
        } else {
            searchCriteriaBuilder = new SearchCriteria.Builder(0, 101);
        }
        searchCriteriaBuilder.query(this.getSearchString());
        if (this.sortBy == SORT_BY.Id && this.sortClientIdUp || this.sortBy == SORT_BY.Name && this.sortClientNameUp || this.sortBy == SORT_BY.ModificationTime && this.sortModificationTimeUp || this.sortBy == SORT_BY.CreationTime && this.sortCreationTimeUp) {
            searchCriteriaBuilder.orderByDesc(this.sortBy.getValue());
        } else {
            searchCriteriaBuilder.orderByAsc(this.sortBy.getValue());
        }
        OAuthClientsManagementState oAuthClientsManagementState = this;
        synchronized (oAuthClientsManagementState) {
            try {
                this.clientSearchResult = this.clientManager.search(searchCriteriaBuilder.build());
                this.hasClientStoreConnectionIssue = false;
            }
            catch (ClientManager.ClientManagementException e) {
                this.hasClientStoreConnectionIssue = true;
                this.log.error((Object)e.getMessage());
            }
        }
        return this.getClientsForList(this.clientSearchResult);
    }

    private List<Client> getClientsForList(SearchResult<Client> searchResult) {
        if (searchResult.getResults().size() == 0 && this.paginationState != null && ((Pagination.State)this.paginationState).getCurrentPage() > 1) {
            ((Pagination.State)this.paginationState).reset();
            return this.sortAndFilter();
        }
        int toIndex = searchResult.getResults().size() > 20 ? 20 : searchResult.getResults().size();
        return searchResult.getResults().subList(0, toIndex);
    }

    public List<Client> getClients() {
        return this.getClientsForList(this.clientSearchResult);
    }

    public Object getPaginationState() {
        return this.paginationState;
    }

    public void setPaginationState(Object paginationState) {
        this.paginationState = paginationState;
    }

    public Integer getLookAheadAvailableIndex() {
        if (this.paginationState != null && this.clientSearchResult.getResults().size() > 0) {
            int currentPage = ((Pagination.State)this.paginationState).getCurrentPage();
            int pagesPerBlock = ((Pagination.State)this.paginationState).MAX_PAGES_PER_BLOCK;
            return this.getLookAheadAvailableMaxIndexForPaginationBlock(currentPage, 20, pagesPerBlock);
        }
        return -1;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="this is a side effect of the look ahead algorithm")
    private Integer getLookAheadAvailableMaxIndexForPaginationBlock(int currentPage, int maxItemsPerPage, int pagesPerBlock) {
        int pageStartIndex = (currentPage - 1) * maxItemsPerPage;
        int availableItemIndex = currentPage == 1 || currentPage == 2 || currentPage == 3 ? maxItemsPerPage * pagesPerBlock - maxItemsPerPage : maxItemsPerPage * (currentPage + 2) - maxItemsPerPage;
        boolean indexNotFound = true;
        while (indexNotFound) {
            try {
                int availableItemRelativeIndex = availableItemIndex - pageStartIndex;
                this.clientSearchResult.getResults().get(availableItemRelativeIndex);
                indexNotFound = false;
            }
            catch (IndexOutOfBoundsException ex) {
                availableItemIndex -= maxItemsPerPage;
            }
        }
        return availableItemIndex;
    }

    public boolean isShowTitleBar() {
        return this.clientSearchResult.getResults().size() != 0;
    }

    @Override
    public void onStateActivated() {
        this.onStateActivated = true;
    }

    public boolean isOnStateActivated() {
        return this.onStateActivated;
    }

    public void setOnStateActivated(boolean onStateActivated) {
        this.onStateActivated = onStateActivated;
    }

    private String getSearchString() {
        return this.getSearchState() != null ? ((Search.State)this.getSearchState()).getSearch() : "";
    }

    public String getNoResultsMessage() {
        if (this.clientSearchResult.getResults().size() == 0 && StringUtils.isNotBlank((String)this.getSearchString())) {
            return NO_SEARCH_RESULTS;
        }
        return "";
    }

    public boolean getResetSearch() {
        this.resetPaginationState();
        return true;
    }

    public boolean getResetControls() {
        this.resetPaginationState();
        return true;
    }

    public boolean isHasClientStoreConnectionIssue() {
        return this.hasClientStoreConnectionIssue;
    }

    public boolean isClientInUse(String clientId) {
        return !InUseDetectionUtil.getInstance().getAuthnApiApplicationsUsingClient(clientId).isEmpty();
    }

    public boolean isSelectiveReplicationEnabled() {
        return MgmtFactory.getClusterSettingsManager().isEnableSelectiveReplicationForClients();
    }

    public static enum SORT_BY {
        Name("Name"),
        Id("Id"),
        ModificationTime("ModificationTime"),
        CreationTime("CreationTime");

        private String value;

        private SORT_BY(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

