/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CheckboxItem;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.OAuthClientTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20200505L;
    private final transient ClientSettingManager clientSettingManager;
    private Set<String> allowedAuthorizationDetailTypes = new HashSet<String>();
    private final CheckboxModel allowedAuthorizationDetailTypesCheckboxModel = new CheckboxModel();
    private static final String INACTIVE_LABEL = " (inactive)";

    public OAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsState(IWizard owner, ClientSettingManager clientSettingManager) {
        super(owner);
        this.clientSettingManager = clientSettingManager;
        this.setMenuName("Authorization Detail Types Constraints");
        this.loadAuthorizationDetailTypesCheckBoxModel();
    }

    private void loadAuthorizationDetailTypesCheckBoxModel() {
        this.allowedAuthorizationDetailTypesCheckboxModel.clear();
        ArrayList<CheckboxItem> list = new ArrayList<CheckboxItem>();
        MgmtFactory.getAuthorizationDetailTypesManager().getAllAuthorizationDetailTypes().forEach(authorizationDetailType -> {
            String type = authorizationDetailType.getType() + (authorizationDetailType.isActive() ? "" : INACTIVE_LABEL);
            CheckboxItem item = new CheckboxItem(type);
            item.setChecked(this.allowedAuthorizationDetailTypes.contains(authorizationDetailType.getType()));
            list.add(item);
        });
        Collections.sort(list);
        this.allowedAuthorizationDetailTypesCheckboxModel.setCheckboxItems(list);
    }

    @Override
    public boolean populateAllStates(Object data) {
        ClientSetting clientSetting = this.clientSettingManager.getClientSetting();
        this.allowedAuthorizationDetailTypes = clientSetting.getAllowedAuthorizationDetailTypes();
        this.loadAuthorizationDetailTypesCheckBoxModel();
        return true;
    }

    @Override
    public void reset() {
        this.populateAllStates(null);
    }

    @Override
    public boolean save(Object dataToDisk) {
        ClientSetting clientSetting = (ClientSetting)dataToDisk;
        if (this.getParentTasklet().getOAuthDynamicClientRegistrationState().isEnableDynamicClientRegistration()) {
            clientSetting.getAllowedAuthorizationDetailTypes().clear();
            if (!this.getAllowedAuthorizationDetailTypesCheckboxModel().getSelectedNames().isEmpty()) {
                this.getAllowedAuthorizationDetailTypesCheckboxModel().getCheckboxItems().stream().filter(CheckboxItem::isChecked).map(typeCheckBoxItem -> StringUtils.removeEnd((String)typeCheckBoxItem.getName(), (String)INACTIVE_LABEL)).forEach(type -> clientSetting.getAllowedAuthorizationDetailTypes().add(type));
            }
        } else {
            clientSetting.setAllowedAuthorizationDetailTypes(new HashSet());
        }
        return true;
    }

    private OAuthClientTasklet getParentTasklet() {
        return (OAuthClientTasklet)this.getParent();
    }

    public CheckboxModel getAllowedAuthorizationDetailTypesCheckboxModel() {
        return this.allowedAuthorizationDetailTypesCheckboxModel;
    }

    public boolean isAuthorizationDetailTypesSet() {
        return MgmtFactory.getAuthorizationDetailTypesManager().getTypes().size() > 0;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (!this.allowedAuthorizationDetailTypes.isEmpty()) {
            summaryList.add(new SummaryInfo("Allowed Authorization Detail Types", this.getAllowedAuthorizationDetailTypesCheckboxModel().getCheckboxItems().stream().filter(i -> i.isChecked()).map(i -> i.getName()).collect(Collectors.joining(", ")), this));
        }
    }
}

