/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.state.impl.OAuthIdpAdapter2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Predicate;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthIdpAdapter2TargetMappingsState
extends OAuthSource2TargetMappingsState<PluginToUserKeyAttrMapping> {
    private static final long serialVersionUID = 11L;
    private final transient IdpAdapterManager idpAdapterManager = MgmtFactory.getIdpAdapterManager();
    private final transient AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();

    public OAuthIdpAdapter2TargetMappingsState(Tasklet owner) {
        super(owner);
    }

    @Override
    public Collection<PluginToUserKeyAttrMapping> getMappings() {
        return this.authzServerMgr.getAdapterToUserKeyMappings();
    }

    @Override
    public String getDropDownText() {
        return "Source Adapter Instance";
    }

    @Override
    protected Collection<StringPairPropertySelectionModel.SPair> getSourceIdNamePairs() {
        LinkedList<StringPairPropertySelectionModel.SPair> idNamePairs = new LinkedList<StringPairPropertySelectionModel.SPair>();
        for (IdpAuthnAdapterInstance adapterInstance : this.idpAdapterManager.getNonConnectionBasedInstances()) {
            StringPairPropertySelectionModel.SPair pair = new StringPairPropertySelectionModel.SPair();
            pair.setId(adapterInstance.getId());
            pair.setDesc(adapterInstance.getName());
            idNamePairs.add(pair);
        }
        return idNamePairs;
    }

    @Override
    public PluginToUserKeyAttrMapping newEmptyMapping(String sourceId) {
        return new PluginToUserKeyAttrMapping(this.authzServerManager.getKeyNameContract());
    }

    @Override
    protected void saveMappings(Collection<PluginToUserKeyAttrMapping> mappings) {
        this.authzServerMgr.saveAdapterToUserKeyMappings(mappings, false);
        DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl((Tasklet)this.getWizard());
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)mappings, DependencyType.OAUTH_CLIENT_SETTINGS);
    }

    @Override
    public void delete(String mappingToDelete) {
        super.markTaskletAsDeleted(mappingToDelete);
        OAuthSource2TargetMappingTasklet mappingTasklet = (OAuthSource2TargetMappingTasklet)this.findTaskletByMappingId(mappingToDelete);
        this.authzServerManager.deleteAdapterToUserKeyMapping(mappingTasklet.getSelectedId());
    }

    @Override
    public Class<? extends OAuthSource2TargetMappingTasklet<PluginToUserKeyAttrMapping>> getTaskletClass() {
        return OAuthIdpAdapter2TargetMappingTasklet.class;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        for (Tasklet t : this.getTasklets()) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            OAuthIdpAdapter2TargetMappingTasklet tasklet = (OAuthIdpAdapter2TargetMappingTasklet)t;
            if (tasklet.isItDeleted()) continue;
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            delegate.record("The mapping " + tasklet.getDescription() + " has error(s), please review and fix", ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public AdminAuditLogger.Component getAuditLogComponent() {
        return AdminAuditLogger.Component.OAUTH_IDP_ADAPTER_MAPPING;
    }

    @Override
    public Predicate<PluginToUserKeyAttrMapping> getIdMapping(OAuthSource2TargetMappingTasklet<?> targetMappingTasklet) {
        return mapping -> !mapping.getContextId().equals(targetMappingTasklet.getSelectedId());
    }
}

