/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConfigDatabaseFilterState;
import com.pingidentity.fsm.state.impl.ConfigLdapDirSearchState;
import com.pingidentity.fsm.state.impl.ConfigLdapFilterState;
import com.pingidentity.fsm.state.impl.ConfigureCustomSourceFiltersState;
import com.pingidentity.fsm.state.impl.OAuthIdpConnection2TargetMappingState;
import com.pingidentity.fsm.state.impl.OAuthIdpConnectionConfigDatabaseFilterState;
import com.pingidentity.fsm.state.impl.OAuthIdpConnectionConfigLdapDirSearchState;
import com.pingidentity.fsm.state.impl.OAuthIdpConnectionDatabaseTableAndColumnState;
import com.pingidentity.fsm.state.impl.OAuthIdpConnectionSelectDataSourceData;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.SelectCustomSourceFieldsState;
import com.pingidentity.fsm.state.impl.SelectDataSourceState;
import com.pingidentity.fsm.state.impl.SelectDatabaseTableAndColumnsState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.UserSessionCreationState;
import com.pingidentity.fsm.state.issuancecriteria.impl.AbstractIssuanceCriteriaState;
import com.pingidentity.fsm.state.issuancecriteria.impl.OAuthIdpConnectionIssuanceCriteriaState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpBrowserSsoTasklet;
import com.pingidentity.fsm.tasklet.impl.UserSessionCreationTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractViewOnlyTasklet;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthIdpConnection2TargetMappingTasklet
extends AbstractViewOnlyTasklet
implements AttributeSourceApi {
    private static final long serialVersionUID = 1L;
    protected SelectDataSourceState selectDataSourceState;
    protected final SelectDatabaseTableAndColumnsState selectDatabaseTableAndColumnsState;
    protected final ConfigDatabaseFilterState configDatabaseFilterState;
    protected final ConfigLdapDirSearchState configLdapDirSearchState;
    protected final ConfigLdapFilterState configLdapFilterState;
    protected final ConfigureCustomSourceFiltersState customConfigFilterFieldsState;
    protected final SelectCustomSourceFieldsState selectCustomFieldsState;
    protected final OAuthIdpConnection2TargetMappingState mappingFullfillmentState;
    protected final AbstractIssuanceCriteriaState issuanceCriteriaState;
    protected final SummaryCardState summaryCardState;
    private ConfigurablePluginInstance sourceInstance;
    protected AttributeMapping attributeMapping;

    public OAuthIdpConnection2TargetMappingTasklet(Visit visit) {
        this.setMenuName("OAuth Attribute Mapping Configuration");
        this.setSystemVisit(visit);
        this.selectDataSourceState = this.getSelectDataSourceState();
        this.selectDatabaseTableAndColumnsState = this.getSelectDatabaseTableAndColumnsState();
        this.configDatabaseFilterState = this.getConfigDatabaseFilterState();
        this.configLdapDirSearchState = this.getConfigLdapDirSearchState();
        this.configLdapFilterState = this.getCfgLdapFilterState();
        this.customConfigFilterFieldsState = this.getOAuthSAMLConfigureCustomSourceFiltersState();
        this.selectCustomFieldsState = this.getOAuthSAMLSelectCustomSourceFieldsState();
        this.mappingFullfillmentState = this.getMappingState();
        this.issuanceCriteriaState = this.getIssuanceCriteriaState();
        this.mappingFullfillmentState.setMenuName("Contract Fulfillment");
        this.summaryCardState = new SummaryCardState(this);
        this.createNoDsTransitions();
        this.setInitialState(this.selectDataSourceState);
        this.setCancelAvailable(true);
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof IdpConnection) {
            this.loadMapping((AttributeMapping)((IdpConnection)dataFromDisk).getSsoToOAuthAttrMapping());
        }
        super.populate(dataFromDisk);
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        this.clearAllStatesOutgoingTransitions(curState);
        this.configureSelectDataSourceStateTransitions();
    }

    public void loadMapping(AttributeMapping mapping) {
        this.attributeMapping = mapping;
    }

    private void configureSelectDataSourceStateTransitions() {
        DataSource.DSType curType = this.selectDataSourceState.getDataSourceType();
        switch (curType) {
            case Other: {
                this.createCustomTransitions();
                break;
            }
            case JDBC: {
                this.createJdbcTransitions();
                break;
            }
            case LDAP: {
                this.createLdapTransitions();
                break;
            }
            case None: {
                this.createNoDsTransitions();
            }
        }
    }

    protected void createNoDsTransitions() {
        this.selectDataSourceState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.mappingFullfillmentState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createLdapTransitions() {
        this.selectDataSourceState.addOutgoingTransition(this, this.configLdapDirSearchState);
        this.configLdapDirSearchState.addOutgoingTransition(this, this.configLdapFilterState);
        this.configLdapFilterState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.mappingFullfillmentState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createJdbcTransitions() {
        this.selectDataSourceState.addOutgoingTransition(this, this.selectDatabaseTableAndColumnsState);
        this.selectDatabaseTableAndColumnsState.addOutgoingTransition(this, this.configDatabaseFilterState);
        this.configDatabaseFilterState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.mappingFullfillmentState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createCustomTransitions() {
        this.selectDataSourceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.customConfigFilterFieldsState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                CustomDataSource instance = OAuthIdpConnection2TargetMappingTasklet.this.getSelectedCustomDataSource();
                SourceDescriptor descriptor = null;
                if (instance != null && instance.getDriverClassName() != null) {
                    DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                    descriptor = dsMgr.getSourceDescriptor(instance.getDriverClassName());
                }
                return instance != null && descriptor != null && descriptor instanceof CustomDataSourceDriverDescriptor;
            }
        });
        this.selectDataSourceState.addOutgoingTransition(this, this.selectCustomFieldsState);
        this.customConfigFilterFieldsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectCustomFieldsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                CustomDataSource instance = OAuthIdpConnection2TargetMappingTasklet.this.getSelectedCustomDataSource();
                SourceDescriptor descriptor = null;
                if (instance != null && instance.getDriverClassName() != null) {
                    DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                    descriptor = dsMgr.getSourceDescriptor(instance.getDriverClassName());
                }
                if (instance == null || descriptor == null) {
                    return true;
                }
                if (descriptor instanceof CustomDataSourceDriverDescriptor) {
                    return ((CustomDataSourceDriverDescriptor)descriptor).isShowSelectCustomSourceFields();
                }
                return true;
            }
        });
        this.customConfigFilterFieldsState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.selectCustomFieldsState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.mappingFullfillmentState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    public AttributeMapping getSource2TargetMapping() {
        return this.attributeMapping;
    }

    @Override
    public boolean includeAdditionalValues() {
        DataSource.DSType dsType = this.selectDataSourceState.getDataSourceType();
        return dsType != null && dsType != DataSource.DSType.None;
    }

    @Override
    public AttributeSourceApi.ConnectionType getConnectionType() {
        return null;
    }

    @Override
    public String getType() {
        return this.getDataSourceType();
    }

    @Override
    public String getDataSourceType() {
        return this.selectDataSourceState.getDataSourceTypeString();
    }

    @Override
    public List<String> getSelectedColumns() {
        return this.selectDatabaseTableAndColumnsState.getSelectedColumns();
    }

    @Override
    public List<String> getSelectedAttributes() {
        return this.configLdapDirSearchState.getSelectedAttributes();
    }

    @Override
    public List<String> getSelectedFields() {
        return this.selectCustomFieldsState.getSelectedFields();
    }

    @Override
    public List<String> getAllFields() {
        return this.selectCustomFieldsState.getAllFields();
    }

    @Override
    public List<String> getAllColumns() {
        return this.selectDatabaseTableAndColumnsState.getAllColumns();
    }

    @Override
    public List<String> getAllAttributes() {
        return this.configLdapDirSearchState.getAllAttributes();
    }

    @Override
    public DataSource getSelectedDataSource() {
        return this.selectDataSourceState.getSelectedDataSource();
    }

    @Override
    public String getTableName() {
        return this.selectDatabaseTableAndColumnsState.getSelectedTable();
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return this.sourceInstance;
    }

    @Override
    public String getSelectedAdapterDataSource() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CustomDataSource getSelectedCustomDataSource() {
        return this.selectDataSourceState.getSelectedCustomAttributeSource();
    }

    @Override
    public boolean setStatesToVOMode(DataSource dataSource) {
        this.selectDataSourceState.setViewOnly(true, this.getTaskletName() + "_OAuthIdpConnectionSelectDataSourceDataVo");
        if (dataSource instanceof JdbcDataSource) {
            this.selectDatabaseTableAndColumnsState.setViewOnly(true, this.getTaskletName() + "_OAuthIdpConnectionDatabaseTableAndColumnStateVo");
            this.configDatabaseFilterState.setViewOnly(true, this.getTaskletName() + "_OAuthIdpConnectionConfigDatabaseFilterStateVo");
            this.mappingFullfillmentState.setViewOnly(true, this.getTaskletName() + "_OAuthIdpConnection2TargetMappingStateVo");
        } else if (dataSource instanceof LdapDataSource) {
            this.configLdapDirSearchState.setViewOnly(true, this.getTaskletName() + "_OAuthIdpConnectionConfigLdapDirSearchStateVo");
            this.configLdapFilterState.setViewOnly(true, this.getTaskletName() + "_CfgLdapFilterStateVo");
            this.mappingFullfillmentState.setViewOnly(true, this.getTaskletName() + "_OAuthIdpConnection2TargetMappingStateVo");
        }
        return false;
    }

    @Override
    public boolean setStatesToEditMode(DataSource dataSource) {
        this.selectDataSourceState.setViewOnly(false, this.getTaskletName() + "_OAuthIdpConnectionSelectDataSourceData");
        if (dataSource instanceof JdbcDataSource) {
            this.selectDatabaseTableAndColumnsState.setViewOnly(false, this.getTaskletName() + "_OAuthIdpConnectionDatabaseTableAndColumnState");
            this.configDatabaseFilterState.setViewOnly(false, this.getTaskletName() + "_OAuthIdpConnectionConfigDatabaseFilterState");
            this.mappingFullfillmentState.setViewOnly(false, this.getTaskletName() + "_OAuthIdpConnection2TargetMappingState");
        } else if (dataSource instanceof LdapDataSource) {
            this.configLdapDirSearchState.setViewOnly(false, this.getTaskletName() + "_OAuthIdpConnectionConfigLdapDirSearchState");
            this.configLdapFilterState.setViewOnly(false, this.getTaskletName() + "_CfgLdapFilterState");
            this.mappingFullfillmentState.setViewOnly(false, this.getTaskletName() + "_OAuthIdpConnection2TargetMappingState");
        }
        return false;
    }

    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    Object coerce(Object diskData) {
        if (diskData instanceof IdpConnection) {
            IdpConnection idp = (IdpConnection)diskData;
            return idp.getSsoToOAuthAttrMapping();
        }
        return diskData;
    }

    @Override
    public List<String> getContractToFulfill() {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        return authzServerManager.getKeyNameContract().getAllAttrNamesSorted();
    }

    @Override
    public String getDescription() {
        throw new UnsupportedOperationException("No description for this tasklet.");
    }

    OAuthIdpConnection2TargetMappingState getMappingState() {
        return new OAuthIdpConnection2TargetMappingState(this, "mapping");
    }

    AbstractIssuanceCriteriaState getIssuanceCriteriaState() {
        return new OAuthIdpConnectionIssuanceCriteriaState(this);
    }

    ConfigLdapDirSearchState getConfigLdapDirSearchState() {
        return new OAuthIdpConnectionConfigLdapDirSearchState(this, "configLdapDirSearch");
    }

    SelectDataSourceState getSelectDataSourceState() {
        return new OAuthIdpConnectionSelectDataSourceData(this, "idpSelectDataSource", false);
    }

    ConfigLdapFilterState getCfgLdapFilterState() {
        return new CfgLdapFilterState(this, "idpConfigLdapFilter");
    }

    SelectDatabaseTableAndColumnsState getSelectDatabaseTableAndColumnsState() {
        return new OAuthIdpConnectionDatabaseTableAndColumnState(this);
    }

    ConfigDatabaseFilterState getConfigDatabaseFilterState() {
        return new OAuthIdpConnectionConfigDatabaseFilterState(this, "idpConfigDatabaseFilter");
    }

    SelectCustomSourceFieldsState getOAuthSAMLSelectCustomSourceFieldsState() {
        return new OAuthSAMLSelectCustomSourceFieldsState(this);
    }

    ConfigureCustomSourceFiltersState getOAuthSAMLConfigureCustomSourceFiltersState() {
        return new OAuthSAMLConfigureCustomSourceFiltersState(this);
    }

    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        UserSessionCreationState userSessionCreationState;
        UserSessionCreationTasklet userSessionCreationTasklet;
        if (this.includeAdditionalValues()) {
            String dataSourceType = this.getDataSourceType();
            List<String> values = "JDBC".equals(dataSourceType) ? this.getSelectedColumns() : ("LDAP".equals(dataSourceType) ? this.getSelectedAttributes() : this.getSelectedFields());
            sources.addPropertySelectionSource(this.getDataSourceType(), new StringPairPropertySelectionModel(true, values));
        }
        if (this.getSelectedPlugin() != null) {
            ConfigurablePluginInstance sourceInstance = this.getSelectedPlugin();
            List srcNames = sourceInstance.getAttributeContract().getAllAttrNamesSorted();
            sources.addPropertySelectionSource(this.findParent(OAuthSource2TargetMappingTasklet.class).getSourceType(), new StringPairPropertySelectionModel(true, srcNames));
        }
        String assertionLabel = "Assertion";
        if (this.isSourceTypeClaims()) {
            assertionLabel = "Provider Claims";
        }
        sources.addPropertySelectionSource(assertionLabel, this.mappingFullfillmentState.getAssertionValues());
        Tasklet t = this.findParent(IdpBrowserSsoTasklet.class);
        if (t != null && (userSessionCreationTasklet = (UserSessionCreationTasklet)(userSessionCreationState = (UserSessionCreationState)t.findState("userSessionCreation")).getTasklet()).isAccountLinkingEnabled()) {
            String[] values = new String[]{IdpConnection.getLocalIdSubstitutionKey()};
            sources.addPropertySelectionSource("AccountLink", new StringPairPropertySelectionModel(true, values));
        }
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : this.getContextMappingTypes()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
        OAuthMetadataUtil.setExtendedMetadataParamsAsSource(sources, this.attributeMapping);
    }

    protected boolean isSourceTypeClaims() {
        ConnectionTasklet connectionTasklet = this.getParentTasklet().findParent(ConnectionTasklet.class);
        return connectionTasklet.isConnectionProtocolOIDC();
    }

    protected List<SourceContextType> getContextMappingTypes() {
        return SourceContextType.getContextTypesForOAuthWebRedirectFlowMapping();
    }

    public List<String> getTarget() {
        return this.mappingFullfillmentState.getTarget();
    }

    public String getLdapSearchScope() {
        return this.configLdapDirSearchState.getSelectedSearchScope();
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        return this.mappingFullfillmentState.getModel();
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return this.issuanceCriteriaState.getIssuanceCriteriaList();
    }

    private class OAuthSAMLSelectCustomSourceFieldsState
    extends SelectCustomSourceFieldsState {
        private static final long serialVersionUID = 1L;

        public OAuthSAMLSelectCustomSourceFieldsState(IWizard owner) {
            super(owner, "selectCustomSourceFields");
        }

        @Override
        public void populate(Object dataFromDisk) {
            super.populate(OAuthIdpConnection2TargetMappingTasklet.this.coerce(dataFromDisk));
        }

        @Override
        public boolean save(Object dataToDisk) {
            return super.save(OAuthIdpConnection2TargetMappingTasklet.this.coerce(dataToDisk));
        }
    }

    private class OAuthSAMLConfigureCustomSourceFiltersState
    extends ConfigureCustomSourceFiltersState {
        private static final long serialVersionUID = 1L;

        public OAuthSAMLConfigureCustomSourceFiltersState(IWizard owner) {
            super(owner);
        }

        @Override
        public void populate(Object dataFromDisk) {
            super.populate(OAuthIdpConnection2TargetMappingTasklet.this.coerce(dataFromDisk));
        }

        @Override
        public boolean save(Object dataToDisk) {
            return super.save(OAuthIdpConnection2TargetMappingTasklet.this.coerce(dataToDisk));
        }
    }

    private class CfgLdapFilterState
    extends ConfigLdapFilterState {
        private static final long serialVersionUID = 1L;

        @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"})
        public CfgLdapFilterState(Tasklet parent, String cardName) {
            super(parent, cardName);
        }

        @Override
        public List<String> getValues() {
            AttributeNamesApi ana = this.findParent(AttributeNamesApi.class);
            return ana.getAllAttrNamesSorted();
        }

        @Override
        public void populate(Object dataFromDisk) {
            super.populate(((IdpConnection)dataFromDisk).getSsoToOAuthAttrMapping());
        }

        @Override
        public boolean save(Object dataToDisk) {
            return super.save(((IdpConnection)dataToDisk).getSsoToOAuthAttrMapping());
        }

        @Override
        public String getValueText() {
            return super.getIsOidc() ? "Provider Claims" : "Assertion Values";
        }
    }
}

