/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.ConfigDatabaseFilterState;
import com.pingidentity.fsm.tasklet.Tasklet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.oauth20.domain.UserKeyAttrMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.impl.JdbcAttributeSource;

public class OAuthIdpConnectionConfigDatabaseFilterState
extends ConfigDatabaseFilterState {
    private static final long serialVersionUID = 20050515L;

    public OAuthIdpConnectionConfigDatabaseFilterState(Tasklet value, String name) {
        super(value, name);
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection idpConnection = (IdpConnection)dataToDisk;
        UserKeyAttrMapping userKeyMapping = idpConnection.getSsoToOAuthAttrMapping();
        if (userKeyMapping == null) {
            userKeyMapping = new UserKeyAttrMapping();
            userKeyMapping.setAttributeSource((AttributeSource)new JdbcAttributeSource());
        }
        return super.save(userKeyMapping);
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection idpConnection = (IdpConnection)dataFromDisk;
        UserKeyAttrMapping userKeyMapping = idpConnection.getSsoToOAuthAttrMapping();
        super.populate(userKeyMapping);
    }

    @Override
    protected ConfigurablePluginInstance getCurrentlySelectedPlugin() {
        return null;
    }

    @Override
    protected Set<String> getSubstitutionVariables() {
        HashSet<String> s = new HashSet<String>();
        Collection<String> allAttributesAvailableForFilter = this.getAssertionValues();
        if (allAttributesAvailableForFilter != null) {
            if (this.isShowPreviousAttributeSourceValues()) {
                allAttributesAvailableForFilter.addAll(this.getPreviousAttributeSourceValues());
            }
            for (String attr : allAttributesAvailableForFilter) {
                s.add(attr);
            }
        }
        return s;
    }

    @Override
    protected String getSubstitutionVariableSourceName() {
        return "adapter";
    }
}

