/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.SelectDatabaseTableAndColumnsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import org.sourceid.oauth20.domain.UserKeyAttrMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.impl.JdbcAttributeSource;

public class OAuthIdpConnectionDatabaseTableAndColumnState
extends SelectDatabaseTableAndColumnsState {
    private static final long serialVersionUID = 20050114L;

    public OAuthIdpConnectionDatabaseTableAndColumnState(Tasklet value) {
        super(value);
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection tempConnection = (IdpConnection)dataFromDisk;
        this.mapping = tempConnection.getSsoToOAuthAttrMapping();
        if (this.mapping != null) {
            super.populate(this.mapping);
        }
    }

    @Override
    public String getNoteKey() {
        return this.getIsOidc() ? super.getNoteKey() + "_Oidc" : super.getNoteKey();
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection tempConnection = (IdpConnection)dataToDisk;
        UserKeyAttrMapping userKeyAttrMapping = tempConnection.getSsoToOAuthAttrMapping();
        if (userKeyAttrMapping != null) {
            super.save(userKeyAttrMapping);
        } else {
            userKeyAttrMapping = new UserKeyAttrMapping();
            userKeyAttrMapping.setAttributeSource((AttributeSource)new JdbcAttributeSource());
            super.save(userKeyAttrMapping);
        }
        return true;
    }
}

