/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.DependencyErrorManagementTasklet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;

public class OAuthRoCreds2TargetMappingTasklet
extends OAuthSource2TargetMappingTasklet<PluginToUserKeyAttrMapping> {
    private static final long serialVersionUID = 1L;
    private final PasswordCredentialValidatorManager passwdCredMgr = MgmtFactory.getCredentialValidatorManager();
    private final AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
    private final AttributeContract attributeContract;

    public OAuthRoCreds2TargetMappingTasklet(Visit visit) {
        super("OAuthRoCreds2TargetMappingTasklet", "Resource Owner Credentials Mapping", visit);
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        this.attributeContract = authzServerManager.getKeyOnlyContract();
    }

    @Override
    public AttributeContract getMappingContract() {
        return this.attributeContract;
    }

    @Override
    public String getSourceType() {
        return "Password Credential Validator";
    }

    @Override
    public void saveSetSelectedId(String id, PluginToUserKeyAttrMapping mapping) {
        mapping.setSourcePluginId(id);
    }

    @Override
    public void finish() {
        this.setMode(Mode.edit);
        PluginToUserKeyAttrMapping mapping = new PluginToUserKeyAttrMapping(MgmtFactory.getAuthzServerManager().getKeyNameContract());
        boolean saved = this.save(mapping);
        Collection mappings = MgmtFactory.getAuthzServerManager().getPwdCredValidatorToUserKeyMappings();
        if (saved) {
            ArrayList<PluginToUserKeyAttrMapping> newMappings;
            if (MgmtFactory.getAuthzServerManager().getPwdCredValidatorToUserKeyMapping(mapping.getSourcePluginId()) == null) {
                newMappings = new ArrayList<PluginToUserKeyAttrMapping>(mappings);
                newMappings.add(mapping);
            } else {
                newMappings = new ArrayList(mappings.size());
                for (PluginToUserKeyAttrMapping existingMappings : mappings) {
                    if (existingMappings.getSourcePluginId().equals(mapping.getSourcePluginId())) {
                        newMappings.add(mapping);
                        continue;
                    }
                    newMappings.add(existingMappings);
                }
            }
            AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
            authzServerManager.savePwdCredValidatorToUserKeyMappings(newMappings, this.isNewMapping());
            MgmtFactory.getDependencyErrorManager().remove(mapping.getSourceId(), AffectedItemType.OAUTH_RESOURCE_OWNER_CREDENTIAL_MAPPING);
        }
        super.finish();
    }

    @Override
    public String loadGetSelectedId(PluginToUserKeyAttrMapping mapping) {
        return mapping.getSourcePluginId();
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return this.passwdCredMgr.getInstance(this.selectedId);
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    @Override
    public String getDescription() {
        return "'" + this.getSelectedPlugin().getName() + "' to Persistent Grant Contract";
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        this.setPopulateData(new PluginToUserKeyAttrMapping((PluginToUserKeyAttrMapping)this.attributeMapping));
    }

    @Override
    protected List<SourceContextType> getContextMappingTypes() {
        return SourceContextType.getContextTypesForROPCToGrantMapping();
    }

    @Override
    public boolean isSaveAllAvailable() {
        return this.getParentTasklet() instanceof DependencyErrorManagementTasklet ? false : this.isModeEdit();
    }

    @Override
    public AffectedItemType getAffectedItemType() {
        return AffectedItemType.OAUTH_RESOURCE_OWNER_CREDENTIAL_MAPPING;
    }

    private boolean isNewMapping() {
        return MgmtFactory.getAuthzServerManager().getPwdCredValidatorToUserKeyMapping(this.selectedId) == null;
    }
}

