/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.state.impl.OAuthRoCreds2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Predicate;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;

public class OAuthRoCreds2TargetMappingsState
extends OAuthSource2TargetMappingsState<PluginToUserKeyAttrMapping> {
    private static final long serialVersionUID = 1L;
    PasswordCredentialValidatorManager passwdCredMgr = MgmtFactory.getCredentialValidatorManager();
    AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();

    public OAuthRoCreds2TargetMappingsState(Tasklet owner) {
        super(owner);
    }

    @Override
    public Collection<PluginToUserKeyAttrMapping> getMappings() {
        return this.authzServerMgr.getPwdCredValidatorToUserKeyMappings();
    }

    @Override
    protected Collection<StringPairPropertySelectionModel.SPair> getSourceIdNamePairs() {
        LinkedList<StringPairPropertySelectionModel.SPair> idNamePairs = new LinkedList<StringPairPropertySelectionModel.SPair>();
        for (PasswordCredentialValidatorInstance pcv : this.passwdCredMgr.getInstances()) {
            StringPairPropertySelectionModel.SPair pair = new StringPairPropertySelectionModel.SPair();
            pair.setId(pcv.getId());
            pair.setDesc(pcv.getName());
            idNamePairs.add(pair);
        }
        return idNamePairs;
    }

    @Override
    public String getDropDownText() {
        return "Source Password Validator Instance";
    }

    @Override
    public PluginToUserKeyAttrMapping newEmptyMapping(String sourceId) {
        return new PluginToUserKeyAttrMapping(this.authzServerManager.getKeyNameContract());
    }

    @Override
    protected void saveMappings(Collection<PluginToUserKeyAttrMapping> mappings) {
        this.authzServerMgr.savePwdCredValidatorToUserKeyMappings(mappings, false);
        DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl((Tasklet)this.getWizard());
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)mappings, DependencyType.OAUTH_CLIENT_SETTINGS);
    }

    @Override
    public void delete(String mappingToDelete) {
        super.markTaskletAsDeleted(mappingToDelete);
        OAuthSource2TargetMappingTasklet mappingTasklet = (OAuthSource2TargetMappingTasklet)this.findTaskletByMappingId(mappingToDelete);
        this.authzServerManager.deletePwdCredValidatorToUserKeyMapping(mappingTasklet.getSelectedId());
    }

    @Override
    public Class<? extends OAuthSource2TargetMappingTasklet<PluginToUserKeyAttrMapping>> getTaskletClass() {
        return OAuthRoCreds2TargetMappingTasklet.class;
    }

    @Override
    public AdminAuditLogger.Component getAuditLogComponent() {
        return AdminAuditLogger.Component.OAUTH_RESOURCE_OWNER_CREDS_MAPPING;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        for (Tasklet tasklet : this.getTasklets()) {
            if (tasklet.isItDeleted()) continue;
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            OAuthRoCreds2TargetMappingTasklet mappingTasklet = (OAuthRoCreds2TargetMappingTasklet)tasklet;
            delegate.record(this.getMessage("mapping_has_errors", mappingTasklet.selectedId), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public Predicate<PluginToUserKeyAttrMapping> getIdMapping(OAuthSource2TargetMappingTasklet<?> targetMappingTasklet) {
        return mapping -> !mapping.getContextId().equals(targetMappingTasklet.getSelectedId());
    }
}

