/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.AttributeSourceApiTaskletListState;
import com.pingidentity.fsm.state.impl.OAuthSAML2TargetMappingTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.OAuthSettings;

public class OAuthSAML2TargetMappingListState
extends AttributeSourceApiTaskletListState {
    private static final long serialVersionUID = 20050532L;
    private List<OAuthAssertionGrantMapping> oAuthSAMLBearerMappings = new ArrayList<OAuthAssertionGrantMapping>();
    private final List<String> closedDataStoreConnections = new ArrayList<String>();

    public OAuthSAML2TargetMappingListState(Tasklet value) {
        super(value);
        this.setMenuName("Access Token Manager Mapping");
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection idp = (IdpConnection)dataFromDisk;
        this.oAuthSAMLBearerMappings = new ArrayList<OAuthAssertionGrantMapping>(idp.getOAuthSettings().getOAuthAssertionGrantMappingList());
        this.deleteAllTasklets();
        this.closedDataStoreConnections.clear();
        for (OAuthAssertionGrantMapping mapping : this.oAuthSAMLBearerMappings) {
            OAuthSAML2TargetMappingTasklet tasklet = this.createTasklet(OAuthSAML2TargetMappingTasklet.class);
            tasklet.setMode(Mode.edit);
            tasklet.populate(mapping);
            this.addTasklet(tasklet);
        }
        this.sort();
    }

    @Override
    public boolean save(Object dataToDisk) {
        ArrayList<OAuthAssertionGrantMapping> mappings = new ArrayList<OAuthAssertionGrantMapping>();
        for (Tasklet t : this.getTasklets()) {
            if (t.isItDeleted()) continue;
            OAuthAssertionGrantMapping mapping = new OAuthAssertionGrantMapping(((OAuthSAML2TargetMappingTasklet)t).getSelectedTokenManagerId());
            t.save(mapping);
            mappings.add(mapping);
        }
        IdpConnection conn = (IdpConnection)dataToDisk;
        if (conn.getOAuthSettings() == null) {
            conn.setOAuthSettings(new OAuthSettings());
        }
        conn.getOAuthSettings().setOAuthAssertionGrantMappingList(mappings);
        return true;
    }

    @Override
    public void reset() {
        this.deleteAllTasklets();
        this.oAuthSAMLBearerMappings = new ArrayList<OAuthAssertionGrantMapping>();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        ArrayList<SummaryInfo> sortedSummaryInfo = new ArrayList<SummaryInfo>();
        for (Tasklet tasklet : this.getTasklets()) {
            OAuthSAML2TargetMappingTasklet oAuthSAML2TargetMappingTasklet = (OAuthSAML2TargetMappingTasklet)tasklet;
            sortedSummaryInfo.add(new SummaryInfo("Access Token Manager", oAuthSAML2TargetMappingTasklet.getSelectedTokenManagerName(), this));
        }
        Collections.sort(sortedSummaryInfo);
        summaryList.addAll(sortedSummaryInfo);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.getTasklets() == null || this.getTasklets().isEmpty()) {
            super.appendErrors(delegate, null, fastFail);
        } else {
            boolean allDeleted = true;
            delegate.setFormComponent(null);
            for (Tasklet t : this.getTasklets()) {
                SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
                OAuthSAML2TargetMappingTasklet tasklet = (OAuthSAML2TargetMappingTasklet)t;
                if (tasklet.isItDeleted()) continue;
                allDeleted = false;
                tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
                if (!tempDelegate.getHasErrors()) continue;
                delegate.record(tasklet.getSelectedTokenManagerName() + " has error(s), please review and fix", ValidationConstraint.REQUIRED);
            }
            if (allDeleted) {
                super.appendErrors(delegate, null, fastFail);
            }
        }
    }
}

