/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.util.SAML2MappingModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;

public class OAuthSource2TargetMappingState
extends MappingState {
    private static final long serialVersionUID = 1L;

    public OAuthSource2TargetMappingState(Tasklet value, String name) {
        super(value, name);
        this.model = new SAML2MappingModel("Contract", null, this.getCurrentUser());
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        this.attributeMapping = (AttributeMapping)dataFromDisk;
        this.cullStaleMappings();
        this.model = new SAML2MappingModel("Contract", this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping mapping = (AttributeMapping)dataToDisk;
        mapping.setAttributeMap2(this.model.getMapping().getAttributeMapping());
        return true;
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        OAuthSource2TargetMappingTasklet tasklet = this.getOAuthSource2TargetMappingTasklet();
        tasklet.addStandardSourcesToPropertySelectionSources(this.sources);
        HashMap<String, String> additionalValidValues = new HashMap<String, String>();
        additionalValidValues.put("TargetResource", "TargetResource");
        this.sources.setAdditionalValidValues(additionalValidValues);
    }

    private OAuthSource2TargetMappingTasklet getOAuthSource2TargetMappingTasklet() {
        return this.findParent(OAuthSource2TargetMappingTasklet.class);
    }

    private AttributeSourceApi getAttributeSourceApi() {
        return this.findParent(AttributeSourceApi.class);
    }

    public List<String> getTarget() {
        return this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
    }

    public void cullStaleMappings() {
        ArrayList<String> staleMappings = new ArrayList<String>();
        Map attrs = this.attributeMapping.getAttributeMapping();
        for (Map.Entry e : attrs.entrySet()) {
            if (this.getTarget().contains(e.getKey())) continue;
            staleMappings.add((String)e.getKey());
        }
        for (String key : staleMappings) {
            attrs.remove(key);
        }
    }

    @Override
    public String getAttrValueForDisplay(AttrMappingValue attrMappingValue) {
        OAuthSource2TargetMappingTasklet tasklet = this.findParent(OAuthSource2TargetMappingTasklet.class);
        if (tasklet == null) {
            return attrMappingValue.getValue();
        }
        Object attrMapping = tasklet.getAttributeMapping();
        if (attrMapping == null) {
            return attrMappingValue.getValue();
        }
        return attrMapping.getAttrValueForDisplay(attrMappingValue);
    }
}

