/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.state.impl.IdentifiableTaskletListState;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.oauth20.domain.AbstractSourceToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

@AutoSaveState
public abstract class OAuthSource2TargetMappingsState<T extends AttributeMapping>
extends IdentifiableTaskletListState {
    private static final long serialVersionUID = 1L;
    protected AuthzServerManager authzServerMgr = MgmtFactory.getAuthzServerManager();
    private String selectedSourceId;
    private ConfigurablePluginInstance selectedTarget;

    public abstract Collection<T> getMappings();

    protected abstract Collection<StringPairPropertySelectionModel.SPair> getSourceIdNamePairs();

    protected Collection<? extends ConfigurablePluginInstance> getTargetInstances() {
        return Collections.emptyList();
    }

    protected abstract void saveMappings(Collection<T> var1);

    public abstract Class<? extends OAuthSource2TargetMappingTasklet<T>> getTaskletClass();

    public abstract T newEmptyMapping(String var1);

    public abstract AdminAuditLogger.Component getAuditLogComponent();

    public abstract Predicate<T> getIdMapping(OAuthSource2TargetMappingTasklet<?> var1);

    public OAuthSource2TargetMappingsState(Tasklet owner) {
        super(owner);
        this.setMenuName("Manage Mappings");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.deleteAllTasklets();
        Collection<T> mappings = this.getMappings();
        for (AttributeMapping mapping : mappings) {
            OAuthSource2TargetMappingTasklet<T> oAuthSource2TargetMappingTasklet = this.createTasklet(this.getTaskletClass());
            oAuthSource2TargetMappingTasklet.setFinishLabel("Save");
            oAuthSource2TargetMappingTasklet.setMode(Mode.edit);
            oAuthSource2TargetMappingTasklet.populate(mapping);
            this.addTasklet(oAuthSource2TargetMappingTasklet);
        }
        this.sort();
    }

    @Override
    public boolean save(Object nullData) {
        LinkedList<T> mappings = new LinkedList<T>();
        for (Tasklet tasklet : this.getTasklets()) {
            if (tasklet.isItDeleted()) continue;
            tasklet.setMode(Mode.edit);
            String selectedSourceId = null;
            if (tasklet instanceof OAuthSource2TargetMappingTasklet) {
                selectedSourceId = ((OAuthSource2TargetMappingTasklet)tasklet).getSelectedId();
            }
            T mapping = this.newEmptyMapping(selectedSourceId);
            tasklet.save(mapping);
            mappings.add(mapping);
            if (selectedSourceId == null) continue;
            MgmtFactory.getDependencyErrorManager().remove(selectedSourceId, AffectedItemType.OAUTH_RESOURCE_OWNER_CREDENTIAL_MAPPING);
        }
        this.saveMappings(mappings);
        return true;
    }

    @Override
    public void delete(String mappingToDelete) {
        super.delete(mappingToDelete);
        OAuthSource2TargetMappingTasklet mappingTasklet = (OAuthSource2TargetMappingTasklet)this.findTaskletByMappingId(mappingToDelete);
        List mappingsToSave = this.getMappings().stream().filter(this.getIdMapping(mappingTasklet)).collect(Collectors.toList());
        this.saveMappings(mappingsToSave);
    }

    public IPropertySelectionModel getSourceInstances() {
        HashSet<String> usedIds = new HashSet<String>();
        if (!this.hasConfigurableTarget()) {
            for (Tasklet tasklet : this.getTasklets()) {
                OAuthSource2TargetMappingTasklet mappingTsklt = (OAuthSource2TargetMappingTasklet)tasklet;
                String id = mappingTsklt.getSelectedPlugin().getId();
                usedIds.add(id);
            }
        }
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (StringPairPropertySelectionModel.SPair sourceIdNamePair : this.getSourceIdNamePairs()) {
            if (usedIds.contains(sourceIdNamePair.getId())) continue;
            model.add(sourceIdNamePair);
        }
        model.sort();
        return model;
    }

    public IPropertySelectionModel getTargetInstancesSelectionModel() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (ConfigurablePluginInstance instance : this.getTargetInstances()) {
            model.add(instance.getName(), instance);
        }
        model.sort();
        return model;
    }

    public abstract String getDropDownText();

    public String getTargetDropDownText() {
        return null;
    }

    public String getMissingTargetErrorMessage() {
        return null;
    }

    public String getSelectedSourceId() {
        return this.selectedSourceId;
    }

    public void setSelectedSourceId(String selectedSourceId) {
        this.selectedSourceId = selectedSourceId;
    }

    public ConfigurablePluginInstance getSelectedTarget() {
        return this.selectedTarget;
    }

    public void setSelectedTarget(ConfigurablePluginInstance selectedTarget) {
        this.selectedTarget = selectedTarget;
    }

    public String getSourceColumnTitle() {
        return "Mappings";
    }

    public boolean hasConfigurableTarget() {
        return false;
    }

    public String getTargetColumnTitle() {
        return null;
    }

    public int getTableColumns() {
        return this.hasConfigurableTarget() ? 3 : 2;
    }

    public void removeDependencyError(AttributeMapping mapping, AffectedItemType type) {
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        if (mapping instanceof UserKeyToAccessTokenMapping) {
            dependencyErrorHandler.removeDependencyError(((UserKeyToAccessTokenMapping)mapping).getId(), type);
        } else if (mapping instanceof AbstractSourceToUserKeyAttrMapping) {
            dependencyErrorHandler.removeDependencyError(((AbstractSourceToUserKeyAttrMapping)mapping).getSourceId(), type);
        } else {
            this.log.warn((Object)"An unexpected item type was encountered while removing the deleted OAuth mapping. The mapping was not checked for removal from dependency errors.");
        }
    }
}

