/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthTepp2TargetMappingsState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.List;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.TeppToUserKeyAttrMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthTepp2TargetMappingTasklet
extends OAuthSource2TargetMappingTasklet<TeppToUserKeyAttrMapping> {
    private final AuthzServerManager authzServerManager;
    private final TokenExchangeProcessorPolicyManager tokenExchangeProcessorPolicyManager;

    public OAuthTepp2TargetMappingTasklet(Visit visit) {
        this(visit, MgmtFactory.getAuthzServerManager(), MgmtFactory.getTokenExchangeProcessorPolicyManager());
    }

    public OAuthTepp2TargetMappingTasklet(Visit visit, AuthzServerManager authzServerManager, TokenExchangeProcessorPolicyManager tokenExchangeProcessorPolicyManager) {
        super("OAuthTepp2TargetMappingTasklet", "Token Exchange Processor Policy Grant Mapping", visit);
        this.authzServerManager = authzServerManager;
        this.tokenExchangeProcessorPolicyManager = tokenExchangeProcessorPolicyManager;
    }

    @Override
    public AttributeContract getMappingContract() {
        return this.authzServerManager.getKeyNameContract();
    }

    @Override
    public String getSourceType() {
        return "Processor Policy";
    }

    @Override
    protected List<SourceContextType> getContextMappingTypes() {
        return SourceContextType.getContextTypesForAccessTokenMapping();
    }

    @Override
    public void saveSetSelectedId(String id, TeppToUserKeyAttrMapping mapping) {
        mapping.setTeppId(id);
    }

    @Override
    public String loadGetSelectedId(TeppToUserKeyAttrMapping mapping) {
        return mapping.getTeppId();
    }

    @Override
    public String getDescription() {
        return "'" + this.getSelectedPlugin().getName() + "' to Persistent Grant Contract";
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        TokenExchangeProcessorPolicy selectedPolicy = this.tokenExchangeProcessorPolicyManager.getPolicyById(this.selectedId);
        return this.getFakeInstance(selectedPolicy);
    }

    private ConfigurablePluginInstance getFakeInstance(TokenExchangeProcessorPolicy tokenExchangeProcessorPolicy) {
        if (tokenExchangeProcessorPolicy == null) {
            return null;
        }
        BasePluginInstance bpi = new BasePluginInstance();
        bpi.setId(tokenExchangeProcessorPolicy.getId());
        bpi.setName(tokenExchangeProcessorPolicy.getName());
        bpi.setImmutableAttributeContract(tokenExchangeProcessorPolicy.getContract().getImmutableAttributeNames());
        bpi.setExtendedContractAttributes(tokenExchangeProcessorPolicy.getContract().getMutableAttributeNames());
        return bpi;
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    @Override
    public void finish() {
        OAuthTepp2TargetMappingsState oAuthTepp2TargetMappingsState = new OAuthTepp2TargetMappingsState(this.getParentTasklet(), this.authzServerManager, this.tokenExchangeProcessorPolicyManager);
        TeppToUserKeyAttrMapping mappingToSave = oAuthTepp2TargetMappingsState.newEmptyMapping(this.getSelectedId());
        if (this.save(mappingToSave)) {
            this.authzServerManager.saveTeppToUserKeyMapping(mappingToSave, this.isNewMapping());
            DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this);
            DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)mappingToSave, DependencyType.OAUTH_CLIENT_SETTINGS);
        }
        super.finish();
    }

    @Override
    public AffectedItemType getAffectedItemType() {
        return AffectedItemType.TEPP_TO_PERSISTENT_GRANT_MAPPING;
    }

    private boolean isNewMapping() {
        return this.authzServerManager.getTeppToUserKeyMapping(this.selectedId) == null;
    }
}

