/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingsState;
import com.pingidentity.fsm.state.impl.OAuthTepp2TargetMappingTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.TeppToUserKeyAttrMapping;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.log.AdminAuditLogger;

public class OAuthTepp2TargetMappingsState
extends OAuthSource2TargetMappingsState<TeppToUserKeyAttrMapping> {
    private final AuthzServerManager authzServerManager;
    private final TokenExchangeProcessorPolicyManager tokenExchangeProcessorPolicyManager;

    public OAuthTepp2TargetMappingsState(Tasklet owner, AuthzServerManager authzServerManager, TokenExchangeProcessorPolicyManager tokenExchangeProcessorPolicyManager) {
        super(owner);
        this.authzServerManager = authzServerManager;
        this.tokenExchangeProcessorPolicyManager = tokenExchangeProcessorPolicyManager;
    }

    @Override
    public Collection<TeppToUserKeyAttrMapping> getMappings() {
        return this.authzServerManager.getTeppToUserKeyMappings();
    }

    @Override
    protected Collection<StringPairPropertySelectionModel.SPair> getSourceIdNamePairs() {
        return this.tokenExchangeProcessorPolicyManager.getTokenExchangeProcessorPolicies().getPolicies().values().stream().map(policy -> {
            StringPairPropertySelectionModel.SPair pair = new StringPairPropertySelectionModel.SPair();
            pair.setId(policy.getId());
            pair.setDesc(policy.getName());
            return pair;
        }).collect(Collectors.toList());
    }

    @Override
    protected void saveMappings(Collection<TeppToUserKeyAttrMapping> mappings) {
        this.authzServerMgr.saveTeppToUserKeyMappings(mappings, false);
        DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl((Tasklet)this.getWizard());
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)mappings, DependencyType.OAUTH_CLIENT_SETTINGS);
    }

    @Override
    public Class<? extends OAuthSource2TargetMappingTasklet<TeppToUserKeyAttrMapping>> getTaskletClass() {
        return OAuthTepp2TargetMappingTasklet.class;
    }

    @Override
    public TeppToUserKeyAttrMapping newEmptyMapping(String sourceId) {
        return new TeppToUserKeyAttrMapping(this.authzServerManager.getKeyNameContract());
    }

    @Override
    public AdminAuditLogger.Component getAuditLogComponent() {
        return AdminAuditLogger.Component.OAUTH_TEPP_TO_PRES_GRANT_MAPPING;
    }

    @Override
    public Predicate<TeppToUserKeyAttrMapping> getIdMapping(OAuthSource2TargetMappingTasklet<?> targetMappingTasklet) {
        return mapping -> !mapping.getTeppId().equals(targetMappingTasklet.getSelectedId());
    }

    @Override
    public String getDropDownText() {
        return "Processor Policy";
    }

    @Override
    public void delete(String mappingToDelete) {
        super.markTaskletAsDeleted(mappingToDelete);
        OAuthTepp2TargetMappingTasklet mappingTasklet = (OAuthTepp2TargetMappingTasklet)this.findTaskletByMappingId(mappingToDelete);
        this.authzServerMgr.deleteTeppToUserKeyMapping(mappingTasklet.getSelectedId());
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        for (Tasklet t : this.getTasklets()) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            OAuthTepp2TargetMappingTasklet tasklet = (OAuthTepp2TargetMappingTasklet)t;
            if (tasklet.isItDeleted()) continue;
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            delegate.record("The mapping " + tasklet.getDescription() + " has error(s), please review and fix", ValidationConstraint.REQUIRED);
        }
    }
}

