/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.model.JwtSecuredAuthorizationResponseModeType;
import com.pingidentity.admin.api.validator.OpenIdMetadataValidator;
import com.pingidentity.admin.api.validator.OpenIdRequestParamEntryValidator;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.crypto.SignatureAlgorithm;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.TestDataItem;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.util.StringPairPropertySelectionModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.openid.connect.bindings.OIDCBindingGroup;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OIDCAuthScheme;
import org.sourceid.saml20.domain.OIDCProfile;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SourceTypeString;
import org.sourceid.saml20.domain.TrackedHttpParamsSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OpenIdProviderMetadataState
extends TaskletState
implements TableEditor.TableEditorListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private IdpConnection connection;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String userinfoEndpoint;
    private String logoutEndpoint;
    private String jwksUrl;
    private String scopes;
    private String type;
    private String lifetime = "5";
    private String audience;
    private boolean includeNotBeforeClaim = false;
    private OIDCProfile profile = OIDCProfile.BASIC;
    private String jwtSecuredAuthorizationResponseModeType = "disabled";
    private OIDCAuthScheme authScheme = OIDCAuthScheme.BASIC;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Does not need to be serialized as it is opulated when necessary but needed for using TableEditor class.")
    private transient List<TableRow> paramList = new ArrayList<TableRow>();
    private boolean enableProofKeyForCodeExchange = false;
    private boolean trackUserSessionsForLogout = false;
    private transient Object expressionTestState;
    private String pushedAuthorizationRequestEndpoint;
    private static final Map<SourceType, String> sourceTypeToPrefixMap = new HashMap<SourceType, String>(){
        {
            this.put(SourceType.EXTENDED_PROPERTIES, "extproperties.");
            this.put(SourceType.CONTEXT, "context.");
        }
    };
    private StringPairPropertySelectionModel signingAlgorithmList;
    private StringPairPropertySelectionModel symmetricSigningAlgorithmList;
    private StringPairPropertySelectionModel requestObjectSigningAlgorithmList;
    private String expressionToTest;
    private boolean testingExpression;
    private List<TestDataItem> testDataList = new ArrayList<TestDataItem>();
    private static final ExpressionManager expressionManager = ExpressionManager.getInstance();
    private List<OIDCRequestParamSetting> requestParams = new ArrayList<OIDCRequestParamSetting>();
    private final SimpleFieldDescriptor OVERRIDE = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "Application Endpoint Override", 100, false, true);
    private final SimpleFieldDescriptor PARAM_NAME = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Name", 200);
    private final SimpleFieldDescriptor PARAM_VALUE = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Value", 200);
    private static final int SOURCE_TYPE_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private static final int IS_OVERRIDE_INDEX = 3;
    private String previousNewItemSource = "";
    private String previousEditItemSource = "";
    private transient Object componentState;
    private static final String NONE_SUMMARY = "(None)";
    private String selectedSigningAlgorithm;
    private String selectedSymmetricSigningAlgorithm;
    private String requestObjectSigningAlgorithm;
    private boolean requestObjectSelected;
    private boolean displaySigningAlgorithmWarning;
    private boolean displayRequestObjectAlgorithmWarning;

    public OpenIdProviderMetadataState(IWizard owner) {
        super(owner);
        this.setMenuName("OpenID Provider Info");
        this.PARAM_NAME.setEnabled(true);
        this.PARAM_VALUE.setEnabled(true);
        this.OVERRIDE.setEnabled(true);
        this.symmetricSigningAlgorithmList = this.populateSigningAlgorithmList(OpenIdConnectProviderInfo.getSupportedSymmetricSignatureVerificationAlgorithms());
        this.signingAlgorithmList = this.populateSigningAlgorithmList(OpenIdConnectProviderInfo.idTokenSigningAlgMapSupported());
    }

    public List<String> getAllowedAlgorithms() {
        ArrayList<String> algs = new ArrayList<String>();
        algs.add("RS256");
        algs.add("RS384");
        algs.add("RS512");
        algs.add("ES256");
        algs.add("ES384");
        algs.add("ES512");
        if (SignatureAlgorithm.isRSAPSSAvailable()) {
            algs.add("PS256");
            algs.add("PS384");
            algs.add("PS512");
        }
        algs.add("HS256");
        algs.add("HS384");
        algs.add("HS512");
        return algs;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public void setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

    public String getLogoutEndpoint() {
        return this.logoutEndpoint;
    }

    public void setLogoutEndpoint(String logoutEndpoint) {
        this.logoutEndpoint = logoutEndpoint;
    }

    public String getJwksUrl() {
        return this.jwksUrl;
    }

    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String typ) {
        this.type = typ;
    }

    public String getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(String lifetime) {
        this.lifetime = lifetime;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public boolean isIncludeNotBeforeClaim() {
        return this.includeNotBeforeClaim;
    }

    public void setIncludeNotBeforeClaim(boolean includeNotBeforeClaim) {
        this.includeNotBeforeClaim = includeNotBeforeClaim;
    }

    public boolean isEnableProofKeyForCodeExchange() {
        return this.enableProofKeyForCodeExchange;
    }

    public void setEnableProofKeyForCodeExchange(boolean enableProofKeyForCodeExchange) {
        this.enableProofKeyForCodeExchange = enableProofKeyForCodeExchange;
    }

    public String getPushedAuthorizationRequestEndpoint() {
        return this.pushedAuthorizationRequestEndpoint;
    }

    public void setPushedAuthorizationRequestEndpoint(String pushedAuthorizationRequestEndpoint) {
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.connection = (IdpConnection)dataFromDisk;
        if (this.connection != null) {
            Endpoint endpoint;
            OIDCSettings settings;
            if (!this.connection.doesOIDCRPSettingsExist()) {
                this.connection.setOidcSettings(new OIDCSettings());
            }
            if ((settings = this.connection.getOidcSettings()).getTokenEndpoint() != null) {
                this.tokenEndpoint = settings.getTokenEndpoint().getLocation();
            }
            if (settings.getUserInfoEndpoint() != null) {
                this.userinfoEndpoint = settings.getUserInfoEndpoint().getLocation();
            }
            if (settings.getJwksUri() != null) {
                this.jwksUrl = settings.getJwksUri().getLocation();
            }
            this.scopes = settings.getScopes().getScopeStr();
            this.profile = settings.getProfile();
            this.jwtSecuredAuthorizationResponseModeType = settings.getJwtSecuredAuthorizationResponseModeType() != null ? settings.getJwtSecuredAuthorizationResponseModeType() : "disabled";
            this.authScheme = OpenIdProviderMetadataState.getAuthnScheme(settings);
            if (settings.isPrivateKeyJwtAuth()) {
                this.setSelectedSigningAlgorithm(settings.getSigningAlgorithm());
                this.type = settings.getType();
                this.lifetime = settings.getLifetime();
                this.audience = settings.getAudience();
                this.includeNotBeforeClaim = settings.isIncludeNotBeforeClaim();
            } else if (settings.isClientSecretJwtAuth()) {
                this.setSelectedSymmetricSigningAlgorithm(settings.getSigningAlgorithm());
                this.type = settings.getType();
                this.lifetime = settings.getLifetime();
                this.audience = settings.getAudience();
                this.includeNotBeforeClaim = settings.isIncludeNotBeforeClaim();
            }
            this.setRequestSigningAlgorithm(settings.getRequestSigningAlgorithm());
            this.requestObjectSelected = StringUtils.isNotBlank((String)settings.getRequestSigningAlgorithm());
            EndpointGroup ssoServices = this.connection.getSingleSignOnServices();
            if (ssoServices != null && (endpoint = ssoServices.getEndpointByBinding("oauth:authz")) != null) {
                this.authorizationEndpoint = endpoint.getLocation();
            }
            this.requestParams = settings.getRequestParams();
            DataMap.Sources sources = this.getSources();
            this.populateParamList(sources);
            this.enableProofKeyForCodeExchange = settings.isEnableProofKeyForCodeExchange();
            this.trackUserSessionsForLogout = settings.isTrackUserSessionsForLogout();
            if (settings.getPushedAuthorizationRequestEndpoint() != null) {
                this.pushedAuthorizationRequestEndpoint = settings.getPushedAuthorizationRequestEndpoint().getLocation();
            }
            if (settings.getLogoutEndpoint() != null) {
                this.logoutEndpoint = settings.getLogoutEndpoint().getLocation();
            }
        }
    }

    private static OIDCAuthScheme getAuthnScheme(OIDCSettings settings) {
        if (settings.isBasicAuth()) {
            return OIDCAuthScheme.BASIC;
        }
        if (settings.isPrivateKeyJwtAuth()) {
            return OIDCAuthScheme.PRIVATE_KEY_JWT;
        }
        if (settings.isClientSecretJwtAuth()) {
            return OIDCAuthScheme.CLIENT_SECRET_JWT;
        }
        return OIDCAuthScheme.POST;
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection conn = (IdpConnection)dataToDisk;
        OIDCSettings settings = conn.getOidcSettings();
        if (settings == null) {
            settings = new OIDCSettings();
            conn.setOidcSettings(settings);
        }
        settings.setProfile(this.profile);
        settings.setJwtSecuredAuthorizationResponseModeType(this.jwtSecuredAuthorizationResponseModeType);
        settings.setTokenEndpoint(new Endpoint(null, this.tokenEndpoint));
        settings.setUserInfoEndpoint(new Endpoint(null, this.userinfoEndpoint));
        settings.setJwksUri(new Endpoint(null, this.jwksUrl));
        settings.setScopes(Scope.getScope((String)this.scopes));
        settings.setBasicAuth(OIDCAuthScheme.BASIC == this.authScheme);
        settings.setPrivateKeyJwtAuth(OIDCAuthScheme.PRIVATE_KEY_JWT == this.authScheme);
        settings.setClientSecretJwtAuth(OIDCAuthScheme.CLIENT_SECRET_JWT == this.authScheme);
        settings.setEnableProofKeyForCodeExchange(this.enableProofKeyForCodeExchange);
        settings.setTrackUserSessionsForLogout(this.trackUserSessionsForLogout);
        if (StringUtils.isNotBlank((String)this.pushedAuthorizationRequestEndpoint)) {
            settings.setPushedAuthorizationRequestEndpoint(new Endpoint(null, this.pushedAuthorizationRequestEndpoint));
        }
        if (this.trackUserSessionsForLogout && StringUtils.isNotBlank((String)this.logoutEndpoint)) {
            settings.setLogoutEndpoint(new Endpoint(null, this.logoutEndpoint));
        }
        if (this.profile == OIDCProfile.BASIC) {
            if (this.authScheme == OIDCAuthScheme.PRIVATE_KEY_JWT) {
                settings.setSigningAlgorithm(this.selectedSigningAlgorithm);
                settings.setType(this.type);
                settings.setLifetime(this.lifetime);
                settings.setAudience(this.audience);
                settings.setIncludeNotBeforeClaim(this.includeNotBeforeClaim);
            } else if (this.authScheme == OIDCAuthScheme.CLIENT_SECRET_JWT) {
                settings.setSigningAlgorithm(this.selectedSymmetricSigningAlgorithm);
                settings.setType(this.type);
                settings.setLifetime(this.lifetime);
                settings.setAudience(this.audience);
                settings.setIncludeNotBeforeClaim(this.includeNotBeforeClaim);
            }
        } else {
            settings.setSigningAlgorithm(null);
            settings.setPrivateKeyJwtAuth(false);
            settings.setClientSecretJwtAuth(false);
            settings.setBasicAuth(true);
            settings.setEnableProofKeyForCodeExchange(false);
        }
        if (this.requestObjectSelected) {
            settings.setRequestSigningAlgorithm(this.requestObjectSigningAlgorithm);
        } else {
            settings.setRequestSigningAlgorithm(null);
        }
        settings.setRequestParams(this.requestParams);
        ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>();
        Endpoint endpoint = new Endpoint("oauth:authz", this.authorizationEndpoint);
        allEndpoints.add(endpoint);
        EndpointGroup ssoServices = new EndpointGroup();
        ssoServices.setEndpoints(allEndpoints);
        conn.setSingleSignOnServices(ssoServices);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        List<OIDCRequestParamSetting> requestParamsNoPrefix = this.makeReqParamsFromRowEntry(false);
        boolean allowExpUpdates = expressionManager.isEvaluateExpressionsOn();
        String selectedSigningAlg = this.authScheme == OIDCAuthScheme.CLIENT_SECRET_JWT ? this.selectedSymmetricSigningAlgorithm : this.selectedSigningAlgorithm;
        OpenIdMetadataValidator validator = new OpenIdMetadataValidator(this.authorizationEndpoint, this.pushedAuthorizationRequestEndpoint, this.tokenEndpoint, this.userinfoEndpoint, this.trackUserSessionsForLogout, this.trackUserSessionsForLogout ? this.logoutEndpoint : null, this.jwksUrl, this.scopes, this.profile, this.authScheme, this.lifetime, selectedSigningAlg, this.requestObjectSelected, this.requestObjectSigningAlgorithm, this.isBaseUrlConfigured(), requestParamsNoPrefix, new ValidatorContext(false, allowExpUpdates, true));
        validator.validate();
        this.recordErrors(validator.getErrors(), delegate);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        JwtSecuredAuthorizationResponseModeType jarmType;
        summaryList.add(new SummaryInfo("Scopes", this.scopes, this));
        summaryList.add(new SummaryInfo("Authorization Endpoint", this.authorizationEndpoint, this));
        if (StringUtils.isNotBlank((String)this.pushedAuthorizationRequestEndpoint)) {
            summaryList.add(new SummaryInfo("Pushed Authorization Request Endpoint", this.pushedAuthorizationRequestEndpoint, this));
        }
        summaryList.add(new SummaryInfo("OpenID Connect Login Type", this.profile.getName(), this));
        if (this.profile == OIDCProfile.BASIC) {
            summaryList.add(new SummaryInfo("Authentication Scheme", this.authScheme.getName(), this));
            if (this.authScheme == OIDCAuthScheme.PRIVATE_KEY_JWT) {
                summaryList.add(new SummaryInfo("Authentication Signing Algorithm", this.signingAlgorithmList.getDescription(this.selectedSigningAlgorithm), this));
                summaryList.add(new SummaryInfo("Type", this.type, this));
                summaryList.add(new SummaryInfo("Lifetime (minutes)", this.lifetime, this));
                summaryList.add(new SummaryInfo("Audience", this.audience, this));
                summaryList.add(new SummaryInfo("Include Not Before (NBF) Claim", Boolean.toString(this.includeNotBeforeClaim), this));
            } else if (this.authScheme == OIDCAuthScheme.CLIENT_SECRET_JWT) {
                summaryList.add(new SummaryInfo("Authentication Signing Algorithm", this.symmetricSigningAlgorithmList.getDescription(this.selectedSymmetricSigningAlgorithm), this));
                summaryList.add(new SummaryInfo("Type", this.type, this));
                summaryList.add(new SummaryInfo("Lifetime (minutes)", this.lifetime, this));
                summaryList.add(new SummaryInfo("Audience", this.audience, this));
                summaryList.add(new SummaryInfo("Include Not Before (NBF) Claim", Boolean.toString(this.includeNotBeforeClaim), this));
            }
            summaryList.add(new SummaryInfo("Proof Key For Code Exchange (PKCE) enabled", Boolean.toString(this.enableProofKeyForCodeExchange), this));
            if (StringUtils.isNotBlank((String)this.tokenEndpoint)) {
                summaryList.add(new SummaryInfo("Token Endpoint", this.tokenEndpoint, this));
            }
        }
        if ((jarmType = JwtSecuredAuthorizationResponseModeType.getJwtSecuredAuthorizationResponseModeType((String)this.jwtSecuredAuthorizationResponseModeType)) != null) {
            summaryList.add(new SummaryInfo("Jwt Secured Authorization Response Mode Type", jarmType.name().replaceAll("_", " "), this));
        }
        if (StringUtils.isNotBlank((String)this.userinfoEndpoint)) {
            summaryList.add(new SummaryInfo("UserInfo Endpoint", this.userinfoEndpoint, this));
        }
        summaryList.add(new SummaryInfo("JWKS URL", this.jwksUrl, this));
        if (this.requestObjectSelected) {
            summaryList.add(new SummaryInfo("Request Signing Algorithm", this.requestObjectSigningAlgorithmList.getDescription(this.requestObjectSigningAlgorithm), this));
        }
        summaryList.add(new SummaryInfo("Track User Sessions for Logout", Boolean.toString(this.trackUserSessionsForLogout), this));
        if (this.trackUserSessionsForLogout && StringUtils.isNotBlank((String)this.logoutEndpoint)) {
            summaryList.add(new SummaryInfo("Logout Endpoint", this.logoutEndpoint, this));
        }
        for (TableRow row : this.getParamList()) {
            String name = this.getName(row);
            String rowValue = this.getValue(row);
            String value = StringUtils.isBlank((String)rowValue) ? NONE_SUMMARY : rowValue;
            String isOverride = Boolean.toString(this.isOverride(row));
            summaryList.add(new SummaryInfo("Request Parameter", "Name: " + name, this));
            summaryList.add(new SummaryInfo("", "Source Type: " + this.getType(row), this));
            summaryList.add(new SummaryInfo("", "Value: " + value, this));
            summaryList.add(new SummaryInfo("", "Application Endpoint Override: " + isOverride, this));
        }
    }

    @Override
    public void onStateActivated() {
        this.setTestingExpression(false);
        DataMap.Sources sources = this.getSources();
        if (expressionManager.isEvaluateExpressionsOn()) {
            this.setupTestDataList(sources);
        }
        if (StringUtils.isBlank((String)this.scopes)) {
            this.scopes = OIDCBindingGroup.REQUIRED_SCOPES.getScopeStr();
        }
        if (this.getConnectionTasklet() instanceof IdpConnectionConfigTasklet && this.getConnectionTasklet().isModeCreate()) {
            this.audience = this.getConnectionTasklet().getConnId();
        }
    }

    private void populateParamList(DataMap.Sources sources) {
        this.getParamList().clear();
        for (OIDCRequestParamSetting param : this.requestParams) {
            TableRow rowEntry = this.makeRowsFromEntry(param, sources);
            this.getParamList().add(rowEntry);
        }
    }

    public OIDCProfile getProfile() {
        return this.profile;
    }

    public void setProfile(OIDCProfile profile) {
        this.profile = profile;
    }

    public String getJwtSecuredAuthorizationResponseModeType() {
        return this.jwtSecuredAuthorizationResponseModeType;
    }

    public void setJwtSecuredAuthorizationResponseModeType(String jwtSecuredAuthorizationResponseModeType) {
        this.jwtSecuredAuthorizationResponseModeType = jwtSecuredAuthorizationResponseModeType;
    }

    public OIDCAuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public void setAuthScheme(OIDCAuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    private boolean isBaseUrlConfigured() {
        ConnectionTasklet c = this.getConnectionTasklet();
        return c != null ? c.isBaseUrlConfigured() : false;
    }

    private ConnectionTasklet getConnectionTasklet() {
        Tasklet t = this.findParent(ConnectionTasklet.class);
        return t != null && t instanceof ConnectionTasklet ? (ConnectionTasklet)t : null;
    }

    public boolean isClientSecretRequired() {
        String clientSecret = null;
        if (this.getConnectionTasklet() instanceof IdpConnectionConfigTasklet) {
            IdpConnectionConfigTasklet idpConnectionConfigTasklet = (IdpConnectionConfigTasklet)this.getConnectionTasklet();
            clientSecret = idpConnectionConfigTasklet.getClientSecret();
        }
        return this.profile == OIDCProfile.BASIC && StringUtils.isBlank(clientSecret) && this.authScheme != OIDCAuthScheme.PRIVATE_KEY_JWT;
    }

    public boolean isQueryJwtAndFormPostOrFormPostWithAccessToken() {
        return OIDCSettings.JARM_QUERY_JWT.equals(this.jwtSecuredAuthorizationResponseModeType) && (this.profile == OIDCProfile.IMPLICIT || this.profile == OIDCProfile.IMPLICIT_ACCESS);
    }

    public List<TableRow> getParamList() {
        if (this.paramList == null) {
            this.paramList = new ArrayList<TableRow>();
        }
        return this.paramList;
    }

    public void setParamList(List<TableRow> paramlist) {
        this.paramList = paramlist;
    }

    public List<SimpleFieldDescriptor> getParamDescriptors() {
        ArrayList<SimpleFieldDescriptor> tableList = new ArrayList<SimpleFieldDescriptor>();
        tableList.add(this.PARAM_NAME);
        tableList.add(this.getParamMappingType(this.getSources()));
        tableList.add(this.PARAM_VALUE);
        tableList.add(this.OVERRIDE);
        return tableList;
    }

    private TableRow makeRowsFromEntry(OIDCRequestParamSetting paramSettings, DataMap.Sources sources) {
        SimpleFieldDescriptor descriptor;
        ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
        fields.add(new FieldItem(this.PARAM_NAME, paramSettings.getName()));
        AttrMappingValue attrMappingValue = paramSettings.getValue();
        String sourceKey = SourceTypeString.getTypeString((SourceType)attrMappingValue.getType());
        fields.add(new FieldItem(this.getParamMappingType(sources), sourceKey));
        if (SourceType.CONTEXT.equals((Object)attrMappingValue.getType()) || SourceType.EXTENDED_PROPERTIES.equals((Object)attrMappingValue.getType()) || SourceType.TRACKED_HTTP_PARAMS.equals((Object)attrMappingValue.getType())) {
            descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Value", 200, false, "", "--INVALID VALUE--");
            descriptor.setModelValues(this.getValuesModel(sourceKey, sources));
        } else {
            descriptor = SourceType.EXPRESSION.equals((Object)attrMappingValue.getType()) ? new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXTAREA, "Value", 200, false, "") : new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Value", 200);
        }
        String value = null;
        if (!SourceType.NO_MAPPING.equals((Object)attrMappingValue.getType())) {
            value = sourceTypeToPrefixMap.containsKey(attrMappingValue.getType()) && attrMappingValue.getValue().startsWith(sourceTypeToPrefixMap.get(attrMappingValue.getType())) ? attrMappingValue.getValue().substring(sourceTypeToPrefixMap.get(attrMappingValue.getType()).length()) : attrMappingValue.getValue();
        }
        fields.add(new FieldItem(descriptor, value));
        fields.add(new FieldItem(this.OVERRIDE, Boolean.toString(paramSettings.isOverride())));
        TableRow row = new TableRow(fields);
        row.setExpression(SourceType.EXPRESSION.equals((Object)attrMappingValue.getType()));
        return row;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    protected String getName(TableRow row) {
        return row.getFields().get(0).getValue();
    }

    protected String getType(TableRow row) {
        return row.getFields().get(1).getValue();
    }

    protected String getValue(TableRow row) {
        return row.getFields().get(2).getValue();
    }

    protected boolean isOverride(TableRow row) {
        return Boolean.valueOf(row.getFields().get(3).getValue());
    }

    private List<OIDCRequestParamSetting> makeReqParamsFromRowEntry(boolean isSave) {
        ArrayList<OIDCRequestParamSetting> reqParams = new ArrayList<OIDCRequestParamSetting>();
        for (TableRow row : this.getParamList()) {
            if (row.isMarkedForDelete()) continue;
            OIDCRequestParamSetting param = this.makeReqParamsFromRowEntry(isSave, row);
            reqParams.add(param);
        }
        return reqParams;
    }

    private OIDCRequestParamSetting makeReqParamsFromRowEntry(boolean isSave, TableRow row) {
        SourceType sourceType = SourceTypeString.strToType((String)DataMap.Sources.getSourceTypeFromKey(this.getType(row)));
        String prefix = isSave && sourceTypeToPrefixMap.containsKey(sourceType) ? sourceTypeToPrefixMap.get(sourceType) : "";
        String attributeSourceId = null;
        String delimiter = null;
        if (SourceType.TRACKED_HTTP_PARAMS.equals((Object)sourceType)) {
            attributeSourceId = "trackedparams";
            delimiter = ".";
        }
        return new OIDCRequestParamSetting(this.getName(row), new AttrMappingValue(sourceType, prefix + this.getValue(row), delimiter, attributeSourceId), Boolean.valueOf(this.isOverride(row)));
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        String source = this.getType(row);
        OpenIdRequestParamEntryValidator validator = new OpenIdRequestParamEntryValidator(this.getName(row), source == null ? null : SourceTypeString.strToType((String)DataMap.Sources.getSourceTypeFromKey(this.getType(row))), this.getValue(row), this.isOverride(row));
        validator.validate();
        return validator.getErrors().stream().map(ValidationError::getMessage).collect(Collectors.toList());
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
        this.requestParams = this.makeReqParamsFromRowEntry(true);
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
        this.requestParams = this.makeReqParamsFromRowEntry(true);
    }

    @Override
    public void onDeleteItem(TableEditor owner, TableRow deletedRow) {
        this.requestParams = this.makeReqParamsFromRowEntry(true);
    }

    @Override
    public void onUndeleteItem(TableEditor owner, TableRow undeletedRow) {
        this.requestParams = this.makeReqParamsFromRowEntry(true);
    }

    private StringPairPropertySelectionModel populateSigningAlgorithmList(Map<String, String> signingAlgos) {
        if (signingAlgos == null) {
            return null;
        }
        StringPairPropertySelectionModel signingAlgorithms = new StringPairPropertySelectionModel(true);
        List<String> allowedAlgs = this.getAllowedAlgorithms();
        signingAlgos.entrySet().stream().filter(entry -> allowedAlgs.contains(entry.getKey())).forEach(e -> signingAlgorithms.add((String)e.getValue(), e.getKey()));
        this.requestObjectSigningAlgorithmList = new StringPairPropertySelectionModel(true);
        signingAlgos.entrySet().stream().filter(entry -> allowedAlgs.contains(entry.getKey())).forEach(e -> this.requestObjectSigningAlgorithmList.add((String)e.getValue(), e.getKey()));
        this.requestObjectSigningAlgorithmList.sort();
        signingAlgorithms.sort();
        return signingAlgorithms;
    }

    public StringPairPropertySelectionModel getSigningAlgorithmList() {
        return this.signingAlgorithmList;
    }

    public void setSigningAlgorithmList(StringPairPropertySelectionModel signingAlgorithmList) {
        this.signingAlgorithmList = signingAlgorithmList;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public StringPairPropertySelectionModel getSymmetricSigningAlgorithmList() {
        return this.symmetricSigningAlgorithmList;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setSymmetricSigningAlgorithmList(StringPairPropertySelectionModel symmetricSigningAlgorithmList) {
        this.symmetricSigningAlgorithmList = symmetricSigningAlgorithmList;
    }

    public String getSelectedSymmetricSigningAlgorithm() {
        return this.selectedSymmetricSigningAlgorithm;
    }

    public void setSelectedSymmetricSigningAlgorithm(String selectedSymmetricSigningAlgorithm) {
        this.selectedSymmetricSigningAlgorithm = selectedSymmetricSigningAlgorithm;
        this.toggleDisplaySigningAlgorithmWarning();
    }

    public String getSelectedSigningAlgorithm() {
        return this.selectedSigningAlgorithm;
    }

    public void setSelectedSigningAlgorithm(String selectedSigningAlgorithm) {
        this.selectedSigningAlgorithm = selectedSigningAlgorithm;
        this.toggleDisplaySigningAlgorithmWarning();
    }

    public String getRequestSigningAlgorithm() {
        return this.requestObjectSigningAlgorithm;
    }

    public void setRequestSigningAlgorithm(String requestObjectSigningAlgorithm) {
        this.requestObjectSigningAlgorithm = requestObjectSigningAlgorithm;
        this.toggleDisplayRequestObjectAlgorithmWarning();
    }

    public boolean isRequestObjectSelected() {
        return this.requestObjectSelected;
    }

    public void setRequestObjectSelected(boolean requestObjectSelected) {
        this.requestObjectSelected = requestObjectSelected;
    }

    public boolean isTrackUserSessionsForLogout() {
        return this.trackUserSessionsForLogout;
    }

    public void setTrackUserSessionsForLogout(boolean trackUserSessionsForLogout) {
        this.trackUserSessionsForLogout = trackUserSessionsForLogout;
    }

    public StringPairPropertySelectionModel getRequestObjectSigningAlgorithmList() {
        return this.requestObjectSigningAlgorithmList;
    }

    public void setRequestObjectSigningAlgorithmList(StringPairPropertySelectionModel requestObjectSigningAlgorithmList) {
        this.requestObjectSigningAlgorithmList = requestObjectSigningAlgorithmList;
    }

    public boolean isDisplaySigningAlgorithmWarning() {
        return this.displaySigningAlgorithmWarning;
    }

    public boolean isDisplayRequestObjectAlgorithmWarning() {
        return this.displayRequestObjectAlgorithmWarning;
    }

    private void toggleDisplaySigningAlgorithmWarning() {
        this.displaySigningAlgorithmWarning = OIDCAuthScheme.PRIVATE_KEY_JWT == this.authScheme && StringUtils.isNotBlank((String)this.selectedSigningAlgorithm) && OpenIdConnectProviderInfo.idTokenSigningAlgMapSupportedWithNoneHmac().get(this.selectedSigningAlgorithm) == null || OIDCAuthScheme.CLIENT_SECRET_JWT == this.authScheme && StringUtils.isNotBlank((String)this.selectedSymmetricSigningAlgorithm) && OpenIdConnectProviderInfo.getSupportedSymmetricSignatureVerificationAlgorithms().get(this.selectedSymmetricSigningAlgorithm) == null;
    }

    private void toggleDisplayRequestObjectAlgorithmWarning() {
        this.displayRequestObjectAlgorithmWarning = StringUtils.isNotBlank((String)this.requestObjectSigningAlgorithm) && OpenIdConnectProviderInfo.idTokenSigningAlgMapSupportedWithNoneHmac().get(this.requestObjectSigningAlgorithm) == null;
    }

    public DataMap.Sources getSources() {
        DataMap.Sources sources = new DataMap.Sources();
        sources.addTextSource("Text");
        sources.addNoMappingSource("No Mapping");
        if (expressionManager.isEvaluateExpressionsOn()) {
            sources.addExpressionSource("Expression");
        }
        this.addContextToSelectionSources(sources);
        this.addTrackedParamsToSelectionSources(sources);
        this.addExtendedParamsToSelectionSources(sources);
        return sources;
    }

    private void addExtendedParamsToSelectionSources(DataMap.Sources existingSources) {
        Map extProperties = MgmtFactory.getClientSettingManager().getExtendedProperties();
        if (extProperties != null && !extProperties.isEmpty()) {
            StringPairPropertySelectionModel propSelectionModel = new StringPairPropertySelectionModel(true);
            propSelectionModel.addAllStrings(extProperties.keySet().toArray(new String[0]));
            propSelectionModel.sort();
            existingSources.addPropertySelectionSource("Extended Properties", propSelectionModel, "extproperties.");
        }
    }

    private void addContextToSelectionSources(DataMap.Sources existingSources) {
        StringPairPropertySelectionModel propSelectionModel = new StringPairPropertySelectionModel(true);
        propSelectionModel.add(SourceContextType.OAUTH_CLIENT.getDescription(), SourceContextType.OAUTH_CLIENT.getId().substring(sourceTypeToPrefixMap.get(SourceType.CONTEXT).length()));
        propSelectionModel.add(SourceContextType.CLIENT_IP.getDescription(), SourceContextType.CLIENT_IP.getId().substring(sourceTypeToPrefixMap.get(SourceType.CONTEXT).length()));
        propSelectionModel.add(SourceContextType.SRI.getDescription(), SourceContextType.SRI.getId().substring(sourceTypeToPrefixMap.get(SourceType.CONTEXT).length()));
        propSelectionModel.add(SourceContextType.OAUTH_SCOPES.getDescription(), SourceContextType.OAUTH_SCOPES.getId().substring(sourceTypeToPrefixMap.get(SourceType.CONTEXT).length()));
        propSelectionModel.add(SourceContextType.CHAINED_ATTRIBUTES.getDescription(), SourceContextType.CHAINED_ATTRIBUTES.getId().substring(sourceTypeToPrefixMap.get(SourceType.CONTEXT).length()));
        propSelectionModel.add(SourceContextType.SIGNED_REQUEST_OBJECT_CLAIMS.getDescription(), SourceContextType.SIGNED_REQUEST_OBJECT_CLAIMS.getId().substring(sourceTypeToPrefixMap.get(SourceType.CONTEXT).length()));
        propSelectionModel.add(SourceContextType.SAML_AUTHN_REQUEST.getDescription(), SourceContextType.SAML_AUTHN_REQUEST.getId().substring(sourceTypeToPrefixMap.get(SourceType.CONTEXT).length()));
        propSelectionModel.add(SourceContextType.SP_CONN_ENTITY_ID.getDescription(), SourceContextType.SP_CONN_ENTITY_ID.getId().substring(sourceTypeToPrefixMap.get(SourceType.CONTEXT).length()));
        propSelectionModel.add(SourceContextType.REQUEST.getDescription(), SourceContextType.REQUEST.getId().substring(sourceTypeToPrefixMap.get(SourceType.CONTEXT).length()));
        propSelectionModel.add(SourceContextType.OAUTH_AUTHORIZATION_DETAILS.getDescription(), SourceContextType.OAUTH_AUTHORIZATION_DETAILS.getId().substring(sourceTypeToPrefixMap.get(SourceType.CONTEXT).length()));
        propSelectionModel.sort();
        existingSources.addPropertySelectionSource("Context", propSelectionModel, "context.");
    }

    private void addTrackedParamsToSelectionSources(DataMap.Sources existingSources) {
        TrackedHttpParamsSettings trackedParamsSettings = MgmtFactory.getTrackedHttpParamManager().getTrackedParamSettings();
        if (trackedParamsSettings.isTrackingEnabled()) {
            StringPairPropertySelectionModel propSelectionModel = new StringPairPropertySelectionModel(true);
            propSelectionModel.addAllStrings(trackedParamsSettings.getTrackedParamNames().toArray(new String[0]));
            propSelectionModel.sort();
            existingSources.addPropertySelectionSource("Tracked HTTP Parameters", propSelectionModel);
        }
    }

    private IPropertySelectionModel getValuesModel(String attrSourceKey, DataMap.Sources sources) {
        IPropertySelectionModel valuesModel;
        if (sources == null) {
            sources = this.getSources();
        }
        if ((valuesModel = (IPropertySelectionModel)sources.get(attrSourceKey)) == null) {
            valuesModel = new StringPairPropertySelectionModel(true);
        }
        return valuesModel;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        TableRow updateItem = ((TableEditor.State)this.componentState).getUpdateItem();
        TableRow newItem = ((TableEditor.State)this.componentState).getNewItem();
        TableRow editItem = ((TableEditor.State)this.componentState).getEditItem();
        boolean isEditMode = ((TableEditor.State)this.componentState).isEditMode();
        if (isEditMode) {
            FieldItem updatedSourceItem = updateItem.getFields().get(1);
            String sourceType = DataMap.Sources.getSourceTypeFromKey(updatedSourceItem.getValue());
            SimpleFieldDescriptor descriptor = null;
            editItem.setExpression(false);
            updateItem.setExpression(false);
            if ("Tracked HTTP Parameters".equalsIgnoreCase(sourceType) || "Extended Properties".equalsIgnoreCase(sourceType) || "Context".equalsIgnoreCase(sourceType)) {
                descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Value", 200);
                descriptor.setModelValues(this.getValuesModel(updatedSourceItem.getValue(), null));
            } else {
                if ("Expression".equalsIgnoreCase(sourceType)) {
                    descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXTAREA, "Value", 200);
                    editItem.setExpression(true);
                    updateItem.setExpression(true);
                } else {
                    descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Value", 200);
                }
                descriptor.setModelValues(null);
            }
            updateItem.getFields().get(2).setDescriptor(descriptor);
            updateItem.getFields().get(2).setEnabled(!"No Mapping".equalsIgnoreCase(sourceType));
            if (updatedSourceItem.getValue() != null) {
                if (!this.previousEditItemSource.equals(updatedSourceItem.getValue())) {
                    updateItem.getFields().get(2).setValue(null);
                }
                this.previousEditItemSource = updatedSourceItem.getValue();
            }
        } else if (newItem != null) {
            String newItemSourceValue = newItem.getFields().get(1).getValue();
            newItem.setExpression(false);
            if (newItemSourceValue != null && StringUtils.isNotEmpty((String)newItemSourceValue)) {
                SimpleFieldDescriptor descriptor;
                String sourceType = DataMap.Sources.getSourceTypeFromKey(newItemSourceValue);
                if ("Tracked HTTP Parameters".equalsIgnoreCase(sourceType) || "Context".equalsIgnoreCase(sourceType) || "Extended Properties".equalsIgnoreCase(sourceType)) {
                    descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Value", 200);
                    descriptor.setModelValues(this.getValuesModel(newItemSourceValue, null));
                } else if ("Expression".equalsIgnoreCase(sourceType)) {
                    descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXTAREA, "Value", 200);
                    newItem.setExpression(true);
                    descriptor.setModelValues(null);
                } else {
                    descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Value", 200, false, "");
                    descriptor.setModelValues(null);
                }
                newItem.getFields().get(2).setDescriptor(descriptor);
                newItem.getFields().get(2).setEnabled(!"No Mapping".equalsIgnoreCase(sourceType));
            }
            if (this.previousNewItemSource != null && !this.previousNewItemSource.equals(newItemSourceValue)) {
                newItem.getFields().get(2).setValue(null);
            }
            this.previousNewItemSource = newItemSourceValue;
        }
    }

    @Override
    public void onEditItem(TableEditor owner, TableRow originalRow, TableRow newRow) {
        this.previousEditItemSource = originalRow.getFields().get(1).getValue();
    }

    public IPropertySelectionModel getSourcesModel(DataMap.Sources sources) {
        ArrayList<String> l = new ArrayList<String>(sources.getSourceMap().keySet());
        Collections.sort(l, String.CASE_INSENSITIVE_ORDER);
        StringPairPropertySelectionModel sourcesModel = new StringPairPropertySelectionModel(true);
        for (String sourceKey : l) {
            String sourceLabel = sources.getSourceKeysToLabels().get(sourceKey);
            if (sourceLabel == null) {
                sourceLabel = sourceKey;
            }
            sourcesModel.add(sourceLabel, sourceKey);
        }
        return sourcesModel;
    }

    @Override
    public void onTestExpressionItem(TableEditor owner, TableRow currentRow, TableRow newRow) {
        this.setTestingExpression(true);
        if (newRow != null) {
            this.setExpressionToTest(newRow.getFields().get(2).getValue());
        } else {
            this.setExpressionToTest(currentRow.getFields().get(2).getValue());
        }
    }

    public boolean isTestingExpression() {
        return this.testingExpression;
    }

    public void setTestingExpression(boolean testingExpression) {
        this.testingExpression = testingExpression;
    }

    public String getExpressionToTest() {
        return this.expressionToTest;
    }

    public void setExpressionToTest(String expression) {
        this.expressionToTest = expression;
        TableRow updateItem = ((TableEditor.State)this.componentState).getUpdateItem();
        if (updateItem != null) {
            updateItem.getFields().get(2).setValue(expression);
        }
    }

    private void setupTestDataList(DataMap.Sources sources) {
        ArrayList<TestDataItem> refreshedTestDataList = new ArrayList<TestDataItem>();
        for (Map.Entry<String, String> validSubstituterEntry : sources.getValidSubstituterValues().entrySet()) {
            String validSubstitutorKey = validSubstituterEntry.getKey();
            boolean foundIt = false;
            for (TestDataItem testDataItem : this.testDataList) {
                if (!validSubstitutorKey.equals(testDataItem.getFieldName())) continue;
                refreshedTestDataList.add(testDataItem);
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            refreshedTestDataList.add(new TestDataItem(validSubstitutorKey, ""));
        }
        this.testDataList = refreshedTestDataList;
    }

    public List<TestDataItem> getTestDataList() {
        return this.testDataList;
    }

    public void setTestDataList(List<TestDataItem> testDataList) {
        this.testDataList = testDataList;
    }

    public Object getExpressionTestState() {
        return this.expressionTestState;
    }

    public void setExpressionTestState(Object state) {
        this.expressionTestState = state;
    }

    private SimpleFieldDescriptor getParamMappingType(DataMap.Sources sources) {
        SimpleFieldDescriptor descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Type", 200, false, true);
        descriptor.setEnabled(true);
        descriptor.setModelValues(this.getSourcesModel(sources));
        return descriptor;
    }

    @Override
    public void onResumeDraft() {
        super.onResumeDraft();
        this.populateParamList(this.getSources());
    }
}

