/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.OutboundBackChannelAuthTypeValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.api.XaspApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.metadata.Role;

public class OutboundConfigSoapAuthState
extends TaskletState {
    private static final long serialVersionUID = 69L;
    private boolean cert;
    private boolean basic;
    private boolean none;
    private boolean requireValidCertChain = true;

    public OutboundConfigSoapAuthState(Tasklet parent) {
        super(parent);
        this.setMenuName("Outbound SOAP Authentication Type");
    }

    @Override
    public void onStateActivated() {
        if (this.isXaspOnly() && !this.isXaspEndpointHttps()) {
            this.cert = false;
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase conn = (ConnectionBase)dataFromDisk;
        SoapAuthInfo soapAuthOut = conn.getSoapAuthOut();
        this.basic = soapAuthOut.isHasBasicEntry();
        this.cert = soapAuthOut.isHasCertEntry();
        this.none = soapAuthOut.isHasNoneEntry();
        this.requireValidCertChain = !soapAuthOut.isDisableCertChainValidation();
    }

    @Override
    public void reset() {
        this.none = false;
        this.cert = false;
        this.basic = false;
        this.requireValidCertChain = true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase conn = (ConnectionBase)dataToDisk;
        SoapAuthInfo soapAuthOut = conn.getSoapAuthOut();
        soapAuthOut.setHasNoneEntry(this.none);
        soapAuthOut.setDisableCertChainValidation(!this.requireValidCertChain);
        return true;
    }

    @Override
    public String getNoteKey() {
        if (this.findParent(ConnectionTasklet.class).isConnectionProtocol1x()) {
            return super.getNoteKey() + "_1x";
        }
        if (this.isXaspOnly()) {
            return super.getNoteKey() + "_Xasp";
        }
        return super.getNoteKey();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Role role = this.isPartOfIdpFlow() ? Role.IDP : Role.SP;
        boolean isAttributeQuerySelected = this.isPartOfIdpFlow() ? this.isAttributeQuerySelected() : false;
        OutboundBackChannelAuthTypeValidator validator = new OutboundBackChannelAuthTypeValidator(this.cert, this.basic, this.none, this.needAtLeastBasicOrCert(), this.getSslDisabled(), isAttributeQuerySelected, this.isXaspEndpointHttps(), role);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.basic) {
            summaryList.add(new SummaryInfo(this.getMessage("Soap_auth_type"), this.getMessage("Basic_desc"), this));
        }
        if (this.cert) {
            summaryList.add(new SummaryInfo(this.getMessage("Soap_auth_type"), this.getMessage("Cert_desc"), this));
        }
        if (this.none) {
            summaryList.add(new SummaryInfo(this.getMessage("Soap_auth_type"), this.isXaspOnly() ? this.getMessage("Dsig_desc_none") : this.getMessage("Dsig_desc"), this));
        }
        if (this.isXaspOnly() && this.isXaspEndpointHttps() || !this.isXaspOnly()) {
            summaryList.add(new SummaryInfo(this.getMessage("Require_cert_chain"), Boolean.toString(this.requireValidCertChain), this));
        }
    }

    public boolean getRequiresValidCertChain() {
        return this.requireValidCertChain;
    }

    public void setRequiresValidCertChain(boolean requireValidCertChain) {
        this.requireValidCertChain = requireValidCertChain;
    }

    public boolean getSslDisabled() {
        return this.findParent(WebSsoApi.class).isAnyOutboundSoapNotUsingHttps();
    }

    public boolean usesDsigAuth() {
        return this.none;
    }

    public boolean showDsigAuth() {
        return true;
    }

    public boolean needAtLeastBasicOrCert() {
        ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
        return connectionTasklet.isConnectionProtocol1x();
    }

    public boolean isXaspOnly() {
        SamlProfilesApi spa = this.findParent(SamlProfilesApi.class);
        return spa.isAttributeQuerySelected() && !spa.isAnySsoSelected();
    }

    public boolean isXaspEndpointHttps() {
        XaspApi xa = this.findParent(XaspApi.class);
        if (xa != null) {
            return xa.isXaspEndpointHttps();
        }
        return false;
    }

    private boolean isAttributeQuerySelected() {
        return this.findParent(IdpConnectionConfigTasklet.class).isAttributeQuerySelected();
    }

    public boolean isCert() {
        return this.cert;
    }

    public void setCert(boolean cert) {
        this.cert = cert;
    }

    public boolean isBasic() {
        return this.basic;
    }

    public void setBasic(boolean basic) {
        this.basic = basic;
    }

    public boolean isNone() {
        return this.none;
    }

    public void setNone(boolean none) {
        this.none = none;
    }

    public boolean isPartOfIdpFlow() {
        Tasklet t = this.findParent(IdpConnectionConfigTasklet.class);
        return t != null;
    }
}

