/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.PluginMappingApi;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.AuthnAdapterInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.SessionCreationAdapterForConnectionOverrideTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenProcessorMappingTasklet;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class OverrideInstanceState
extends SingleTaskletState {
    private static final long serialVersionUID = 1L;
    private Object populateAllStatesData;
    private ConfigurablePluginInstance instanceFromDisk;

    public OverrideInstanceState(Tasklet value) {
        super(value);
        this.setMenuName("Override Instance");
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.getTaskletToEdit() != null) {
            PluginMappingApi parentTasklet = (PluginMappingApi)((Object)this.getParent());
            parentTasklet.refreshAttributeOverrides();
        }
    }

    @Override
    public void onStateActivated() {
        this.createAndLoadInstanceTasklet();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.instanceFromDisk = dataFromDisk instanceof AdapterToAssertionMapping ? ((AdapterToAssertionMapping)dataFromDisk).getConnectionOverrideInstance() : (dataFromDisk instanceof TargetAttributeMapping ? ((TargetAttributeMapping)dataFromDisk).getConnectionOverrideInstance() : ((TokenPluginAttributeMapping)dataFromDisk).getConnectionOverrideInstance());
        this.createAndLoadInstanceTasklet();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = data;
        this.createAndLoadInstanceTasklet();
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.createAndLoadInstanceTasklet();
        Tasklet tasklet = this.getTaskletToEdit();
        PluginMappingApi mappingTasklet = (PluginMappingApi)((Object)this.getParent());
        if (mappingTasklet.isOverridePluginConnectionSettings() && (tasklet != null && tasklet.getPopulateData() == null || tasklet == null)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("You_must_override_instance"), ValidationConstraint.REQUIRED);
            return;
        }
        if (tasklet != null && tasklet.getPopulateData() != null) {
            tasklet.appendErrors(delegate, component, fastFail);
        }
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet != null && tasklet.getPopulateData() != null) {
            tasklet.getSummary(summaryList);
        }
    }

    public void createAndLoadInstanceTasklet() {
        PluginInstanceTasklet tasklet = (PluginInstanceTasklet)this.getTaskletToEdit();
        if (tasklet == null) {
            tasklet = this.createInstanceTasklet(this.getParent());
            if (this.instanceFromDisk == null) {
                PluginMappingApi adapterMappingTasklet = (PluginMappingApi)((Object)this.getParent());
                ConnectionTasklet connectionConfigTasklet = this.findParent(ConnectionTasklet.class);
                ConfigurablePluginInstance selectedPlugin = adapterMappingTasklet.getSelectedPlugin();
                tasklet.initPluginConnectionOverride(selectedPlugin, connectionConfigTasklet.getConnId(), selectedPlugin.getDescriptor());
                tasklet.setNewTasklet(true);
            } else {
                tasklet.setConnectionOverrideMode(true);
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.instanceFromDisk);
            }
            tasklet.addSuffixToStateHelpId("ConnectionBasedOverride");
        }
        if (this.populateAllStatesData != null) {
            tasklet.populateAllStates(this.populateAllStatesData);
        }
        this.setTasklet(tasklet);
    }

    private PluginInstanceTasklet createInstanceTasklet(Tasklet mappingTasklet) {
        if (mappingTasklet instanceof SpConfigAdapterMappingTasklet) {
            Class<AuthnAdapterInstanceTasklet> clazz = AuthnAdapterInstanceTasklet.class;
            AuthnAdapterInstanceTasklet tasklet = this.initTasklet((Class)clazz, clazz.getSimpleName(), (PluginManager<?, ?>)MgmtFactory.getIdpAdapterManager(), false);
            tasklet.setPluginType(PluginManagementSupport.PluginManagementType.SP_ADAPTER);
            tasklet.setAuditLoggerComponent(AdminAuditLogger.Component.SP_ADAPTER);
            tasklet.setOverrideAutoSave(true);
            return tasklet;
        }
        if (mappingTasklet instanceof IdpConfigAdapterMappingTasklet) {
            Class<SessionCreationAdapterForConnectionOverrideTasklet> clazz = SessionCreationAdapterForConnectionOverrideTasklet.class;
            SessionCreationAdapterForConnectionOverrideTasklet tasklet = this.initTasklet((Class)clazz, clazz.getSimpleName(), (PluginManager<?, ?>)MgmtFactory.getSpAdapterManager(), false);
            tasklet.setTaskletName("SessionCreationAdapterTasklet");
            tasklet.setMessageSimpleName("SessionCreationAdapterTasklet");
            tasklet.setHelpName("SessionCreationAdapterTasklet");
            tasklet.setPluginType(PluginManagementSupport.PluginManagementType.IDP_ADAPTER);
            tasklet.setAuditLoggerComponent(AdminAuditLogger.Component.IDP_ADAPTER);
            tasklet.setOverrideAutoSave(true);
            return tasklet;
        }
        if (mappingTasklet instanceof WsTrustTokenProcessorMappingTasklet) {
            Class<PluginInstanceTasklet> clazz = PluginInstanceTasklet.class;
            PluginInstanceTasklet tasklet = this.initTasklet(clazz, "TokenProcessorInstanceTasklet", (PluginManager)GlobalRegistry.getService(TokenProcessorManager.class), true);
            tasklet.setPluginType(PluginManagementSupport.PluginManagementType.TOKEN_PROCESSOR);
            tasklet.setAuditLoggerComponent(AdminAuditLogger.Component.TOKEN_PROCESSOR);
            tasklet.setOverrideAutoSave(true);
            return tasklet;
        }
        Class<PluginInstanceTasklet> clazz = PluginInstanceTasklet.class;
        PluginInstanceTasklet tasklet = this.initTasklet(clazz, "TokenGeneratorInstanceTasklet", (PluginManager)GlobalRegistry.getService(TokenGeneratorManager.class), false);
        tasklet.setPluginType(PluginManagementSupport.PluginManagementType.TOKEN_GENERATOR);
        tasklet.setAuditLoggerComponent(AdminAuditLogger.Component.TOKEN_GENERATOR);
        tasklet.setOverrideAutoSave(true);
        return tasklet;
    }

    private <T extends PluginInstanceTasklet> T initTasklet(Class<T> clazz, String className, PluginManager<?, ?> pluginManager, boolean tokenProcessorTasklet) {
        PluginInstanceTasklet tasklet = (PluginInstanceTasklet)this.createTaskletToLoad(clazz, className, "Override Instance Settings");
        tasklet.setTokenProcessorInstanceTasklet(tokenProcessorTasklet);
        tasklet.setPluginManager(pluginManager);
        tasklet.initDescriptorTypeList(pluginManager.getInstalledDescriptors());
        return (T)tasklet;
    }

    @Override
    public boolean save(Object dataFromDisk) {
        ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
        PluginInstanceTasklet tasklet = (PluginInstanceTasklet)this.getTaskletToEdit();
        if (this.instanceFromDisk != null && this.instanceFromDisk.isConnectionBasedPlugin() && !connectionTasklet.getConnId().equals(this.instanceFromDisk.getConnectionId())) {
            if (tasklet == null) {
                this.createAndLoadInstanceTasklet();
                tasklet = (PluginInstanceTasklet)this.getTaskletToEdit();
            }
            tasklet.setGeneratedPluginConnectionId(this.instanceFromDisk.getParentId(), connectionTasklet.getConnId());
        }
        if (tasklet != null && tasklet.getPopulateData() != null) {
            PluginManager<?, ?> taskletPluginManager = tasklet.getPluginManager();
            ConfigurablePluginInstance instance = taskletPluginManager.newInstance();
            tasklet.save(instance);
            if (dataFromDisk instanceof AdapterToAssertionMapping) {
                AdapterToAssertionMapping mapping = (AdapterToAssertionMapping)dataFromDisk;
                mapping.setAdapterInstanceId(instance.getId());
                mapping.setConnectionOverrideInstance((IdpAuthnAdapterInstance)instance);
                mapping.setSavedConnectionOverride(true);
            } else if (dataFromDisk instanceof TargetAttributeMapping) {
                TargetAttributeMapping mapping = (TargetAttributeMapping)dataFromDisk;
                mapping.setAdapterInstanceId(instance.getId());
                mapping.setConnectionOverrideInstance((AuthnAdapterInstance)instance);
                mapping.setSavedConnectionOverride(true);
            } else {
                TokenPluginAttributeMapping mapping = (TokenPluginAttributeMapping)dataFromDisk;
                mapping.setPluginId(instance.getId());
                mapping.setConnectionOverrideInstance((TokenPluginInstance)instance);
                mapping.setSavedConnectionOverride(true);
            }
        }
        return true;
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (taskletToEdit.isCancelled() && taskletToEdit.getPopulateData() == null && this.instanceFromDisk == null) {
            super.setTaskletToEditToNull();
        } else {
            super.setTaskletToEdit(taskletToEdit);
        }
    }
}

