/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.comparator.PluginHierarchyComparator;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.oauth20.domain.UserAuthorizationConsentPageSetting;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.impl.AdapterUser;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginSupport;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

@AutoSaveState
public abstract class PluginMgmtState<D extends PluginDescriptor, I extends ConfigurablePluginInstance>
extends TaskletListState
implements PluginManager<D, I> {
    private static final long serialVersionUID = 20050515L;
    protected PluginManager<D, I> pluginManager;
    private Map<String, I> pluginId2Instance = new CaseInsensitiveMap(new HashMap());
    protected Map<String, I> deletedPluginId2Instance = new HashMap<String, I>();
    private Map<String, I> nonConnectionBasedPluginCache = new HashMap<String, I>();
    public boolean activated;
    private PluginSupport pluginSupport = new PluginSupport();

    public abstract AdminAuditLogger.Component getAuditLoggerComponent();

    public PluginMgmtState(Tasklet value) {
        this(value, "adapterManagement");
    }

    public PluginMgmtState(Tasklet value, String cardName) {
        super(value, cardName);
    }

    @Override
    public void onStateActivated() {
        this.activated = true;
    }

    public void setPluginManager(PluginManager<D, I> pluginManager) {
        this.pluginManager = pluginManager;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.deleteAllTasklets();
        this.buildTaskletList();
    }

    public abstract PluginManagementSupport.PluginManagementType getPluginType();

    protected void buildTaskletList() {
        for (ConfigurablePluginInstance instance : this.pluginManager.getInstances()) {
            if (!instance.isConnectionBasedPlugin()) {
                PluginInstanceTasklet tasklet = this.createTaskletToLoad(this.getTaskletClass(), this.getTaskletClassName(), this.getTaskletMenuName());
                tasklet.setPluginType(this.getPluginType());
                tasklet.setAuditLoggerComponent(this.getAuditLoggerComponent());
                tasklet.setPluginManager(this.pluginManager);
                if (this.pluginManager instanceof TokenProcessorManager) {
                    tasklet.setTokenProcessorInstanceTasklet(true);
                }
                tasklet.setMode(Mode.edit);
                tasklet.populate(instance);
                tasklet.setFinishLabel("Save");
                if (this.getParent().showFinishButtonIfAuditor()) {
                    tasklet.setDisabled(true);
                }
                this.addTasklet(tasklet);
            }
            this.addToPlugin2Instance(instance.getId(), instance);
        }
        for (Tasklet t : this.getTasklets()) {
            PluginInstanceTasklet pit = (PluginInstanceTasklet)t;
            pit.setPluginManager(this);
        }
        this.sort();
    }

    protected void addToPlugin2Instance(String instanceId, I instance) {
        this.pluginId2Instance.put(instanceId, instance);
        if (!instance.isConnectionBasedPlugin()) {
            this.nonConnectionBasedPluginCache.put(instanceId, instance);
        }
    }

    protected void removeFromPlugin2Instance(String instanceId) {
        this.pluginId2Instance.remove(instanceId);
        this.nonConnectionBasedPluginCache.remove(instanceId);
    }

    private void clearPlugin2Instance() {
        this.pluginId2Instance.clear();
        this.nonConnectionBasedPluginCache.clear();
    }

    @Override
    protected void sort() {
        this.sort(new PluginHierarchyComparator(this));
        for (Tasklet tasklet : this.getTasklets()) {
            PluginInstanceTasklet instanceTasklet = (PluginInstanceTasklet)tasklet;
            int pluginDepth = 0;
            String parentId = instanceTasklet.getParentPluginInstanceId();
            while (parentId != null) {
                ++pluginDepth;
                ConfigurablePluginInstance parentInstance = (ConfigurablePluginInstance)this.pluginId2Instance.get(parentId);
                if (parentInstance == null) {
                    parentInstance = (ConfigurablePluginInstance)this.deletedPluginId2Instance.get(parentId);
                }
                if (parentInstance == null) break;
                parentId = parentInstance.getParentId();
            }
            instanceTasklet.setPluginDepth(pluginDepth);
        }
    }

    protected Class<? extends PluginInstanceTasklet> getTaskletClass() {
        return PluginInstanceTasklet.class;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        boolean hasDefaultInstance = false;
        int numberNotDeleted = 0;
        for (Tasklet tasklet : this.getTasklets()) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            if (tasklet.isItDeleted()) continue;
            ++numberNotDeleted;
            if (tasklet instanceof PluginInstanceTasklet && ((PluginInstanceTasklet)tasklet).isDefaultInstance()) {
                hasDefaultInstance = true;
            }
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            Object[] objects = new Object[]{((PluginInstanceApi)((Object)tasklet)).getPluginId()};
            delegate.record(this.getMessage("Adapter_has_errors", objects), ValidationConstraint.REQUIRED);
        }
        if (this.supportsDefaultInstance() && numberNotDeleted > 0 && !hasDefaultInstance) {
            delegate.record(this.getMessage("Default_instance_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (!taskletToEdit.isCancelled() && taskletToEdit instanceof PluginInstanceApi) {
            PluginInstanceTasklet pit = (PluginInstanceTasklet)taskletToEdit;
            if (this.pluginId2Instance.containsKey(pit.getPluginId())) {
                this.addToPlugin2Instance(pit.getPluginId(), (ConfigurablePluginInstance)pit.getPopulateData());
            } else if (!taskletToEdit.isItDeleted()) {
                this.addTasklet(taskletToEdit);
            } else {
                this.deletedPluginId2Instance.put(pit.getPluginId(), (ConfigurablePluginInstance)pit.getPopulateData());
            }
            this.sort();
        }
    }

    public boolean isDuplicatePluginName(String pluginName) {
        Predicate<ConfigurablePluginInstance> nameEqualPredicate = i -> pluginName.equals(i.getName());
        boolean nameExists = this.getInstances().stream().anyMatch(nameEqualPredicate);
        return nameExists || this.getVirtualInstances() != null && this.getVirtualInstances().stream().anyMatch(nameEqualPredicate);
    }

    public void createNewTasklet() {
        Class<PluginInstanceTasklet> taskletClass = this.getTaskletClass();
        PluginInstanceTasklet tasklet = this.createTaskletToLoad(taskletClass, this.getTaskletClassName(), this.getTaskletMenuName());
        if (this.supportsDefaultInstance() && this.getTasklets().size() == 0) {
            tasklet.setDefaultInstance(true);
        }
        tasklet.setNewTasklet(true);
        tasklet.setPluginManager(this);
        tasklet.setPluginType(this.getPluginType());
        tasklet.setAuditLoggerComponent(this.getAuditLoggerComponent());
        if (this.pluginManager instanceof TokenProcessorManager) {
            tasklet.setTokenProcessorInstanceTasklet(true);
        }
        tasklet.initDescriptorTypeList(this.getInstalledDescriptors());
        tasklet.markProtocolImgAvailable(this.getParent().isProtocolImgAvailable());
        tasklet.initialize();
        tasklet.setFinishLabel("Save");
        this.loadTasklet(tasklet);
    }

    public void edit(Integer indexToEdit, IRequestCycle cycle) {
        List<Tasklet> taskletList = this.getTasklets();
        Tasklet tasklet = taskletList.get(indexToEdit);
        ((PluginInstanceTasklet)tasklet).refreshPlugin();
        tasklet.resetCurrentStateToSourceState();
        tasklet.markProtocolImgAvailable(this.getParent().isProtocolImgAvailable());
        this.loadTasklet(tasklet);
        tasklet.gotoSummaryState(cycle);
    }

    public String getTaskletClassName() {
        return this.getTaskletClass().getSimpleName();
    }

    public String getTaskletMenuName() {
        return this.getTaskletClassName();
    }

    public void resetSaveCalledForAll() {
        for (Tasklet t : this.getTasklets()) {
            PluginInstanceTasklet tasklet = (PluginInstanceTasklet)t;
            tasklet.setSaveCalled(false);
        }
    }

    public boolean isDisableAutomaticConnectionValidation() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isDisableAutomaticConnectionValidation();
    }

    @Override
    public List<Tasklet> getTasklets() {
        return Collections.unmodifiableList(super.getTasklets());
    }

    @Override
    public void setTasklets(ArrayList<Tasklet> tasklets) {
        super.setTasklets(tasklets);
        this.buildPluginIdInstanceMap();
    }

    @Override
    public void addTasklet(Tasklet tasklet) {
        super.addTasklet(tasklet);
        PluginInstanceTasklet pit = (PluginInstanceTasklet)tasklet;
        this.addToPlugin2Instance(pit.getPluginId(), (ConfigurablePluginInstance)pit.getPopulateData());
    }

    @Override
    public void deleteTasklet(Integer taskletToDelete) {
        super.deleteTasklet(taskletToDelete);
        Tasklet tasklet = this.getTasklet(taskletToDelete);
        PluginInstanceApi pluginInstanceApi = (PluginInstanceApi)((Object)tasklet);
        ConfigurablePluginInstance tmpInstance = this.pluginManager.newInstance();
        tasklet.setMode(Mode.edit);
        tasklet.save(tmpInstance);
        tasklet.setItDeleted(true);
        if (pluginInstanceApi.performDeleteEvent(this.delegate)) {
            this.pluginManager.deleteInstance(tmpInstance);
        }
    }

    @Override
    public void deleteTasklet(Tasklet tasklet) {
        HashMap<String, PluginInstanceTasklet> taskletMap = new HashMap<String, PluginInstanceTasklet>();
        for (Tasklet t : this.getTasklets()) {
            PluginInstanceTasklet pit = (PluginInstanceTasklet)t;
            taskletMap.put(pit.getPluginId(), pit);
        }
        PluginInstanceTasklet pit = (PluginInstanceTasklet)tasklet;
        if (taskletMap.containsKey(pit.getPluginId())) {
            if (tasklet.isItDeleted()) {
                PluginInstanceTasklet currentTasklet = pit;
                String currentId = pit.getPluginId();
                while (currentId != null) {
                    currentTasklet.setItDeleted(false);
                    this.addToPlugin2Instance(currentId, (ConfigurablePluginInstance)currentTasklet.getPopulateData());
                    this.deletedPluginId2Instance.remove(currentId);
                    currentId = currentTasklet.getParentPluginInstanceId();
                    if (currentId == null) continue;
                    currentTasklet = (PluginInstanceTasklet)taskletMap.get(currentId);
                }
            } else {
                tasklet.setItDeleted(true);
                this.removeFromPlugin2Instance(pit.getPluginId());
                this.deletedPluginId2Instance.put(pit.getPluginId(), (ConfigurablePluginInstance)pit.getPopulateData());
            }
        }
    }

    @Override
    public void deleteAllTasklets() {
        super.deleteAllTasklets();
        this.clearPlugin2Instance();
    }

    @Override
    public void cancel(Object newData) {
        super.cancel(newData);
        this.buildPluginIdInstanceMap();
    }

    @Override
    public void reset() {
        super.reset();
        this.buildPluginIdInstanceMap();
    }

    private void buildPluginIdInstanceMap() {
        this.clearPlugin2Instance();
        this.deletedPluginId2Instance.clear();
        for (Tasklet t : this.getTasklets()) {
            PluginInstanceTasklet pit = (PluginInstanceTasklet)t;
            ConfigurablePluginInstance instance = this.pluginManager.newInstance();
            pit.save(instance);
            this.addToPlugin2Instance(pit.getPluginId(), instance);
        }
    }

    public String getPluginInstanceName(String instanceId) {
        ConfigurablePluginInstance instance = (ConfigurablePluginInstance)this.pluginId2Instance.get(instanceId);
        if (instance == null) {
            return null;
        }
        return instance.getName();
    }

    public Collection<D> getInstalledDescriptors() {
        return this.pluginManager.getInstalledDescriptors();
    }

    public boolean isDuplicateId(String instanceId) {
        return this.pluginId2Instance.containsKey(instanceId) || this.getVirtualInstances() != null && this.getVirtualInstances().stream().anyMatch(i -> instanceId.equals(i.getId()));
    }

    public Collection<I> getInstances() {
        return this.pluginId2Instance.values();
    }

    public Collection<I> getNonConnectionBasedInstances() {
        return Collections.unmodifiableCollection(this.nonConnectionBasedPluginCache.values());
    }

    public I getInstance(String instanceId) {
        ConfigurablePluginInstance instance = (ConfigurablePluginInstance)this.pluginId2Instance.get(instanceId);
        if (instance == null) {
            instance = (ConfigurablePluginInstance)this.deletedPluginId2Instance.get(instanceId);
        }
        return (I)instance;
    }

    public void saveInstance(ConfigurablePluginInstance instance) {
        this.pluginManager.saveInstance(instance);
    }

    public void deleteInstance(ConfigurablePluginInstance instance) {
        throw new UnsupportedOperationException();
    }

    public boolean isPluginInUse(String pluginId) {
        return this.isPluginInUseInternally(pluginId) || this.isPluginInUseExternally(pluginId);
    }

    public boolean isPluginInUseInternally(String pluginId) {
        for (ConfigurablePluginInstance instance : this.getInstances()) {
            String parentId = instance.getParentId();
            if (instance.getParentId() != null && parentId.equals(pluginId)) {
                return true;
            }
            if (this.getPluginType() != PluginManagementSupport.PluginManagementType.IDP_ADAPTER) continue;
            if (this.isAdapterInUseByAdapter(pluginId, instance)) {
                return true;
            }
            if (!UserAuthorizationConsentPageSetting.ADAPTER.getValue().equals(MgmtFactory.getAuthzServerManager().getAuthzConsentSetting()) || !MgmtFactory.getAuthzServerManager().getExternalConsentAdapterId().equals(pluginId)) continue;
            return true;
        }
        if (this.getPluginType() == PluginManagementSupport.PluginManagementType.IDP_ADAPTER) {
            for (ConfigurablePluginInstance instance : this.deletedPluginId2Instance.values()) {
                if (!this.isAdapterInUseByAdapter(pluginId, instance)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAdapterInUseByAdapter(String adapterId, ConfigurablePluginInstance pluginInstance) {
        String pluginClassName = pluginInstance.getDescriptor().getPluginClassName();
        ConfigurablePlugin adapter = (ConfigurablePlugin)this.pluginSupport.createInstance(pluginClassName, ConfigurablePlugin.class);
        if (adapter != null && adapter instanceof AdapterUser) {
            adapter.configure(ConfigurationUtil.createAdminCompositeConfiguration((ConfigurablePluginInstance)pluginInstance, (PluginManager)this));
            if (((AdapterUser)adapter).isInUse(adapterId)) {
                return true;
            }
        }
        return false;
    }

    public boolean isPluginInUseExternally(String pluginId) {
        return this.pluginManager.isPluginInUseExternally(pluginId);
    }

    public I newInstance() {
        return (I)this.pluginManager.newInstance();
    }

    public void loadConfigurations() {
        throw new UnsupportedOperationException();
    }

    public Collection<I> getVirtualInstances() {
        return this.pluginManager.getVirtualInstances();
    }

    public boolean supportsPluginHierarchies() {
        return this.pluginManager.supportsPluginHierarchies();
    }

    public boolean showCheckUsageLink() {
        return true;
    }

    public List<ConfigurablePluginInstance> getInstancesInUseInternally(String pluginId) {
        LinkedList<ConfigurablePluginInstance> instances = new LinkedList<ConfigurablePluginInstance>();
        for (ConfigurablePluginInstance instance : this.getInstances()) {
            String parentId = instance.getParentId();
            if (instance.getParentId() != null && parentId.equals(pluginId)) {
                instances.add(instance);
                continue;
            }
            if (this.getPluginType() != PluginManagementSupport.PluginManagementType.IDP_ADAPTER || !this.isAdapterInUseByAdapter(pluginId, instance)) continue;
            instances.add(instance);
        }
        if (this.getPluginType() == PluginManagementSupport.PluginManagementType.IDP_ADAPTER) {
            for (ConfigurablePluginInstance instance : this.deletedPluginId2Instance.values()) {
                if (!this.isAdapterInUseByAdapter(pluginId, instance)) continue;
                instances.add(instance);
            }
        }
        return instances;
    }

    public boolean isInstanceDeleted(String pluginId) {
        return this.deletedPluginId2Instance.containsKey(pluginId);
    }

    public boolean supportsDefaultInstance() {
        return this.pluginManager.supportsDefaultInstance();
    }

    public I getDefaultInstance() {
        return (I)this.pluginManager.getDefaultInstance();
    }

    public void setAsDefaultInstance(int taskletIndex) {
        int index = -1;
        for (Tasklet tasklet : this.getTasklets()) {
            PluginInstanceTasklet pluginTasklet = (PluginInstanceTasklet)tasklet;
            if (++index == taskletIndex) {
                pluginTasklet.setDefaultInstance(true);
                this.setDefaultInstance(pluginTasklet.getPluginId());
                pluginTasklet.setSaveCalled(true);
                continue;
            }
            pluginTasklet.setDefaultInstance(false);
        }
    }

    public void setDefaultInstance(String pluginId) {
        this.pluginManager.setDefaultInstance(pluginId);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }
}

